/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.migemo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.migemo.CharUtil;
import org.monazilla.migemo.Dictionary;

public class Migemo {
    static final List lstDictionaries = new ArrayList();
    static final Pattern pAltPair = Pattern.compile("(?<!\\\\)\\(\\?\\:([^(|)]+)(?<!\\\\)\\|([^(|)]+)(?<!\\\\)\\)");

    private Migemo() {
    }

    public static void clearDictionary() {
        lstDictionaries.clear();
    }

    public static boolean loadDictionary(File fd) {
        return Migemo.loadDictionary(fd, null);
    }

    public static boolean loadDictionary(File fd, String sc) {
        Dictionary dict = Dictionary.create(fd, sc);
        if (dict != null) {
            lstDictionaries.add(dict);
            return true;
        }
        return false;
    }

    static String flushStringBuffer(StringBuffer sb) {
        if (sb.length() == 0) {
            return null;
        }
        String sq = sb.toString();
        sb.setLength(0);
        return sq;
    }

    static void lookupDictionary(String sk0, boolean be, Set set) {
        int nd = lstDictionaries.size();
        for (int i = 0; i < nd; ++i) {
            ((Dictionary)lstDictionaries.get(i)).lookup(sk0, be, set);
        }
    }

    public static String lookup(String si) {
        String sr;
        int ns;
        int nc;
        if (si == null || (nc = si.length()) == 0) {
            return "";
        }
        ArrayList<String> al = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean bl = true;
        boolean bn = false;
        boolean bd = true;
        for (int i = 0; i < nc; ++i) {
            char c = si.charAt(i);
            String sq = null;
            boolean bd0 = bd;
            boolean bl0 = bl;
            if (c >= 'a' && c <= 'z' || c == '-' || c == '\'') {
                if (!bl) {
                    sq = Migemo.flushStringBuffer(sb);
                    bl = true;
                    bn = false;
                }
            } else if (c >= 'A' && c <= 'Z') {
                sq = Migemo.flushStringBuffer(sb);
                bd = c != 'Q';
                c = bd ? (char)(c + 32) : (char)'\u0000';
                bl = true;
                bn = false;
            } else if (c >= '0' && c <= '9') {
                if (!bn) {
                    sq = Migemo.flushStringBuffer(sb);
                    bl = false;
                    bn = true;
                }
            } else if (bl || bn) {
                sq = Migemo.flushStringBuffer(sb);
                bl = false;
                bn = false;
            }
            if (c != '\u0000') {
                sb.append(c);
            }
            if (sq == null) continue;
            al.add(Migemo.singleLookup(sq, bl0, bd0, false));
        }
        if (sb.length() > 0) {
            al.add(Migemo.singleLookup(sb.toString(), bl, bd, true));
        }
        if ((ns = al.size()) == 1) {
            sr = (String)al.get(0);
        } else {
            StringBuffer sbr = new StringBuffer();
            for (int i = 0; i < ns; ++i) {
                boolean bg;
                String sri = (String)al.get(i);
                boolean bl2 = bg = sri.indexOf(124) >= 0;
                if (bg) {
                    sbr.append("(?:");
                }
                sbr.append(sri);
                if (!bg) continue;
                sbr.append(')');
            }
            sr = sbr.toString();
        }
        Matcher m = pAltPair.matcher(sr);
        int im = 0;
        while (m.find(im)) {
            String s2;
            int ns2;
            im = m.end();
            String s1 = m.group(1);
            int ns1 = s1.length();
            if (ns1 == (ns2 = (s2 = m.group(2)).length())) continue;
            if (ns1 > ns2) {
                String st = s2;
                s2 = s1;
                s1 = st;
                ns1 = s1.length();
                ns2 = s2.length();
            }
            boolean b2 = ns2 > ns1 + 1;
            boolean be = false;
            String sq = null;
            if (s2.endsWith(s1)) {
                be = true;
                sq = s2.substring(0, ns2 - ns1);
            } else {
                if (!s2.startsWith(s1)) continue;
                sq = s2.substring(ns1, ns2);
            }
            sb.setLength(0);
            CharUtil.appendSubstring(sb, sr, 0, m.start());
            if (!be) {
                sb.append(s1);
            }
            if (b2) {
                sb.append("(?:");
            }
            sb.append(sq);
            if (b2) {
                sb.append(')');
            }
            sb.append('?');
            if (be) {
                sb.append(s1);
            }
            im = sb.length();
            CharUtil.appendSubstring(sb, sr, m.end(), sr.length());
            sr = sb.toString();
            m.reset(sr);
        }
        return sr;
    }

    static String singleLookup(String si, boolean bh, boolean bd, boolean be) {
        Object sv;
        int i;
        HashSet<String> hs = new HashSet<String>();
        hs.add(si);
        if (bd) {
            Migemo.lookupDictionary(si, be, hs);
        }
        hs.add(CharUtil.toFullWidth(si));
        if (bh) {
            String[] slh = CharUtil.toHiragana(si, be);
            for (int i2 = 0; i2 < slh.length; ++i2) {
                String shi = slh[i2];
                if (shi.length() == 0) continue;
                hs.add(shi);
                hs.add(CharUtil.toKatakana(shi));
                hs.add(CharUtil.toHWKana(shi));
                if (!bd) continue;
                Migemo.lookupDictionary(shi, be, hs);
            }
        }
        int ns = hs.size();
        Object[] sl = hs.toArray(new String[ns]);
        Arrays.sort(sl);
        Object svp = null;
        int nvp = Integer.MAX_VALUE;
        int ip = 0;
        for (int i3 = 0; i3 < ns; ++i3) {
            Object sv2 = sl[i3];
            int nv = ((String)sv2).length();
            if (nv >= nvp && ((String)sv2).startsWith((String)svp)) continue;
            svp = sv2;
            nvp = nv;
            if (ip < i3) {
                sl[ip] = sv2;
            }
            ++ip;
        }
        ns = ip;
        ArrayList al = new ArrayList();
        StringBuffer sb = new StringBuffer();
        Migemo.constructQuery((String[])sl, 0, ns, 0, false, sb, al);
        StringBuffer sbt = new StringBuffer();
        int ne = 0;
        for (i = 0; i < ns; ++i) {
            sv = sl[i];
            if (sv == null) continue;
            sbt.append((String)sv);
            sbt.reverse();
            sl[ne++] = sbt.toString();
            sbt.setLength(0);
        }
        if (ne > 0) {
            Arrays.sort(sl, 0, ne);
            Migemo.constructQuery((String[])sl, 0, ne, 0, true, sbt, al);
            if (sbt.length() > 0) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sbt.reverse();
                sb.append(sbt);
                sbt.setLength(0);
            }
            for (i = 0; i < ne; ++i) {
                sv = sl[i];
                if (sv == null) continue;
                CharUtil.escapeAndAppend((String)sv, true, sbt);
                sbt.append('|');
            }
            if (sbt.length() > 0) {
                if (sb.length() == 0) {
                    sbt.setLength(sbt.length() - 1);
                }
                sbt.reverse();
                sb.append(sbt);
            }
        }
        return sb.toString();
    }

    static void constructQuery(String[] sl, int i0, int i1, int nh, boolean br, StringBuffer sb, List lst) {
        int nh1 = nh + 1;
        int isl0 = sb.length();
        int ne = 0;
        lst.clear();
        for (int i = i0; i < i1; ++i) {
            String si = sl[i];
            if (si == null || si.length() != nh1) continue;
            lst.add(si);
            sl[i] = null;
        }
        int n1 = lst.size();
        if (n1 > 0) {
            if (n1 > 1) {
                sb.append(br ? (char)']' : '[');
                for (int i = 0; i < n1; ++i) {
                    CharUtil.escapeAndAppend((String)lst.get(i), nh, nh1, br, sb);
                }
                sb.append(br ? (char)'[' : ']');
            } else {
                CharUtil.escapeAndAppend((String)lst.get(0), nh, nh1, br, sb);
            }
            sb.append('|');
            ne = 1;
        }
        int ipc0 = i0;
        int nsc = 0;
        char c0 = '\u0000';
        String sp = null;
        boolean bq = false;
        for (int i = i0; i <= i1; ++i) {
            char c;
            boolean bs;
            String si = i < i1 ? sl[i] : null;
            boolean bl = bs = si != null;
            if (bs) {
                if (si.length() == nh) {
                    bq = true;
                    sl[i] = null;
                    continue;
                }
                c = si.charAt(nh);
            } else {
                if (c0 == '\u0000') continue;
                c = '\u0000';
            }
            if (c != c0) {
                if (nsc > 0) {
                    boolean bor = true;
                    if (nsc > 1) {
                        CharUtil.escapeAndAppend(c0, br, sb);
                        int ic = nh1;
                        block3: while (true) {
                            char cs = '\u0000';
                            for (int j = ipc0; j < i; ++j) {
                                String sj = sl[j];
                                if (sj == null) continue;
                                if (sj.length() <= ic) break block3;
                                char cj = sj.charAt(ic);
                                if (cs == '\u0000') {
                                    cs = cj;
                                    continue;
                                }
                                if (cs != cj) break block3;
                            }
                            CharUtil.escapeAndAppend(cs, br, sb);
                            ++ic;
                        }
                        Migemo.constructQuery(sl, ipc0, i, ic, br, sb, lst);
                    } else if (nh > 0) {
                        CharUtil.escapeAndAppend(sp, nh, sp.length(), br, sb);
                        sl[ipc0] = null;
                    } else {
                        bor = false;
                    }
                    if (bor) {
                        sb.append('|');
                        ne += nsc;
                    }
                }
                c0 = c;
                if (bs) {
                    ipc0 = i;
                    nsc = 1;
                    sp = si;
                    continue;
                }
                nsc = 0;
                sp = null;
                continue;
            }
            ++nsc;
        }
        if (ne == 0) {
            return;
        }
        sb.setLength(sb.length() - 1);
        if (nh > 0 && ne > 1 || bq && sb.length() - isl0 > 1) {
            if (br) {
                sb.insert(isl0, ')');
                if (bq) {
                    sb.insert(isl0, '?');
                }
                sb.append(":?(");
            } else {
                sb.insert(isl0, "(?:");
                sb.append(')');
            }
        } else if (bq && br) {
            sb.insert(isl0, '?');
        }
    }
}

