/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCountHighlightItem;
import org.monazilla.v2c.V2CCountHighlightSP;
import org.monazilla.v2c.V2CHighlightSelectionPanel;
import org.monazilla.v2c.V2CHighlightStyle;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CCountHighlight
implements Comparator {
    private static final int THREADSPEED = 0;
    private static final int REFCOUNT = 1;
    private static final int IDCOUNT = 2;
    private static final int CACHE_SIZE = 10;
    private static V2CCountHighlight vThreadSpeedHighlight;
    private static V2CCountHighlight vRefCountHighlight;
    private static V2CCountHighlight vIDCountHighlight;
    private final String sSaveKey;
    V2CCountHighlightItem[] vlItems;
    boolean bCached;
    boolean bChanged;
    final int nMinimumThreshold;
    final V2CHighlightStyle[] vlStyleCache = new V2CHighlightStyle[10];

    static V2CCountHighlight duplicate(int n) {
        V2CCountHighlight v2CCountHighlight;
        switch (n) {
            case 0: {
                v2CCountHighlight = V2CCountHighlight.getThreadSpeedHighlight();
                break;
            }
            case 1: {
                v2CCountHighlight = V2CCountHighlight.getRefCountHighlight();
                break;
            }
            case 2: {
                v2CCountHighlight = V2CCountHighlight.getIDCountHighlight();
                break;
            }
            default: {
                return null;
            }
        }
        return new V2CCountHighlight(v2CCountHighlight);
    }

    private static V2CCountHighlight getThreadSpeedHighlight() {
        if (vThreadSpeedHighlight == null) {
            vThreadSpeedHighlight = new V2CCountHighlight("ThreadList.ThreadSpeedHighlight", 0);
        }
        return vThreadSpeedHighlight;
    }

    private static V2CCountHighlight getRefCountHighlight() {
        if (vRefCountHighlight == null) {
            vRefCountHighlight = new V2CCountHighlight("ThreadView.RefCountHighlight", 0);
        }
        return vRefCountHighlight;
    }

    private static V2CCountHighlight getIDCountHighlight() {
        if (vIDCountHighlight == null) {
            vIDCountHighlight = new V2CCountHighlight("ThreadView.IDCountHighlight", 1);
        }
        return vIDCountHighlight;
    }

    static V2CCountHighlightSP createThreadSpeedHighlightSP() {
        return new V2CCountHighlightSP(0, "123456789.0", "\u30b9\u30ec\u901f\u5ea6\uff08\u52e2\u3044\uff09\u306e\u30ab\u30e9\u30e0\u3092\u5024\u306b\u3088\u308a\u30cf\u30a4\u30e9\u30a4\u30c8\u8868\u793a\u3057\u307e\u3059", false, null, false, null, false, null);
    }

    static V2CCountHighlightSP createRefCountHighlightSP() {
        return new V2CCountHighlightSP(1, "0123456789", "\u30ec\u30b9\u304c\u53c2\u7167\u3055\u308c\u3066\u3044\u308b\u6570\u306b\u3088\u3063\u3066\u30ec\u30b9\u756a\u53f7\u3092\u30cf\u30a4\u30e9\u30a4\u30c8\u8868\u793a\u3057\u307e\u3059", V2CThreadStyle.getShowRefCount(), "\u30ec\u30b9\u8868\u793a\u6b04\u306b\u88ab\u53c2\u7167\u56de\u6570\u3092\u8868\u793a", V2CAbstractThreadPanel.bHighlightReferredRes, "\u53c2\u7167\u3055\u308c\u305f\u30ec\u30b9\u756a\u53f7\u306b\u4e0b\u7dda", V2CAbstractThreadPanel.bHighlightResRef, "\u53c2\u7167\u5143\u306e\u30ec\u30b9\u30a2\u30f3\u30ab\u30fc\u3082\u30cf\u30a4\u30e9\u30a4\u30c8");
    }

    static V2CCountHighlightSP createIDCountHighlightSP() {
        return new V2CCountHighlightSP(2, "abc+XYZ/012", "\u30b9\u30ec\u5185\u306eID\u51fa\u73fe\u6570\u306b\u3088\u3063\u3066\"ID:\"\u3092\u30cf\u30a4\u30e9\u30a4\u30c8\u8868\u793a\u3057\u307e\u3059", V2CThreadStyle.getShowIDNum(), "\u30ec\u30b9\u8868\u793a\u6b04\u306bID\u51fa\u73fe\u56de\u6570\u3092\u8868\u793a", V2CAbstractThreadPanel.bHighlightRepeatedID, "\u8907\u6570\u51fa\u73fe\u3057\u305fID\u30fb\u88dc\u52a9\u60c5\u5831\u306b\u4e0b\u7dda", V2CAbstractThreadPanel.bHighlightIDInRes, "\u30ec\u30b9\u672c\u6587\u4e2d\u306eID\u3082\u30cf\u30a4\u30e9\u30a4\u30c8");
    }

    static void setThreadSpeedHighlight() {
        V2CCountHighlight.setCountHighlight(0, "123456789.0", false, null, false, null, false, null);
    }

    static void setRefCountHighlight() {
        V2CCountHighlight.setCountHighlight(1, "0123456789", V2CThreadStyle.getShowRefCount(), "\u30ec\u30b9\u8868\u793a\u6b04\u306b\u88ab\u53c2\u7167\u56de\u6570\u3092\u8868\u793a", V2CAbstractThreadPanel.bHighlightReferredRes, "\u53c2\u7167\u3055\u308c\u305f\u30ec\u30b9\u756a\u53f7\u306b\u4e0b\u7dda", V2CAbstractThreadPanel.bHighlightResRef, "\u53c2\u7167\u5143\u306e\u30ec\u30b9\u30a2\u30f3\u30ab\u30fc\u3082\u30cf\u30a4\u30e9\u30a4\u30c8");
    }

    static void setIDCountHighlight() {
        V2CCountHighlight.setCountHighlight(2, "abc+XYZ/012", V2CThreadStyle.getShowIDNum(), "\u30ec\u30b9\u8868\u793a\u6b04\u306bID\u51fa\u73fe\u56de\u6570\u3092\u8868\u793a", V2CAbstractThreadPanel.bHighlightRepeatedID, "\u8907\u6570\u51fa\u73fe\u3057\u305fID\u30fb\u88dc\u52a9\u60c5\u5831\u306b\u4e0b\u7dda", V2CAbstractThreadPanel.bHighlightIDInRes, "\u30ec\u30b9\u672c\u6587\u4e2d\u306eID\u3082\u30cf\u30a4\u30e9\u30a4\u30c8");
    }

    static void setCountHighlight(int n, String string, boolean bl, String string2, boolean bl2, String string3, boolean bl3, String string4) {
        V2CCountHighlightSP v2CCountHighlightSP = new V2CCountHighlightSP(n, string, null, bl, string2, bl2, string3, bl3, string4);
        if (!v2CCountHighlightSP.showDialog()) {
            return;
        }
        V2CCountHighlight.postConfig(v2CCountHighlightSP, true);
    }

    static int postConfig(V2CCountHighlightSP v2CCountHighlightSP, boolean bl) {
        V2CCountHighlight v2CCountHighlight = v2CCountHighlightSP.getCountHighlight();
        int n = v2CCountHighlightSP.getCountHighlightIndex();
        int n2 = 0;
        if (v2CCountHighlight.bChanged) {
            v2CCountHighlight.saveItems();
            switch (n) {
                case 0: {
                    vThreadSpeedHighlight = v2CCountHighlight;
                    break;
                }
                case 1: {
                    vRefCountHighlight = v2CCountHighlight;
                    break;
                }
                case 2: {
                    vIDCountHighlight = v2CCountHighlight;
                }
            }
            n2 |= 1;
        }
        if (n == 1) {
            n2 |= V2CThreadStyle.setShowRefCount(v2CCountHighlightSP.getShowCount(), false);
            n2 |= V2CAbstractThreadPanel.setHighlightReferredRes(v2CCountHighlightSP.getUnderline(), v2CCountHighlightSP.getHighlightInRes());
        } else if (n == 2) {
            n2 |= V2CThreadStyle.setShowIDNum(v2CCountHighlightSP.getShowCount(), false);
            n2 |= V2CAbstractThreadPanel.setHighlightRepeatedID(v2CCountHighlightSP.getUnderline(), v2CCountHighlightSP.getHighlightInRes());
        }
        if (bl) {
            if (n == 0) {
                if (n2 > 0) {
                    V2CMain.getTablePane().repaintActivePanel();
                }
            } else {
                V2CThreadPanel.requestChange(n2);
            }
        }
        return n2;
    }

    static V2CHighlightStyle getThreadSpeedHilightStyle(float f) {
        return V2CCountHighlight.getThreadSpeedHighlight().getStyle((int)f);
    }

    static V2CHighlightStyle getRefHilightStyle(int n) {
        return V2CCountHighlight.getRefCountHighlight().getStyle(n);
    }

    static V2CHighlightStyle getIDHilightStyle(int n) {
        return V2CCountHighlight.getIDCountHighlight().getStyle(n);
    }

    public V2CCountHighlight(String string, int n) {
        int n2;
        this.nMinimumThreshold = n;
        this.sSaveKey = string;
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(this.sSaveKey);
        if (v2CPackedPropValueArray == null) {
            this.vlItems = new V2CCountHighlightItem[0];
            return;
        }
        ArrayList<V2CCountHighlightItem> arrayList = new ArrayList<V2CCountHighlightItem>();
        int n3 = -1;
        for (n2 = 0; n2 < v2CPackedPropValueArray.length; ++n2) {
            V2CCountHighlightItem v2CCountHighlightItem = new V2CCountHighlightItem(v2CPackedPropValueArray[n2]);
            int n4 = v2CCountHighlightItem.nThreshold;
            if (n4 < 0 || n4 <= n3) continue;
            n3 = n4;
            arrayList.add(v2CCountHighlightItem);
        }
        n2 = arrayList.size();
        this.vlItems = n2 > 0 ? arrayList.toArray(new V2CCountHighlightItem[n2]) : new V2CCountHighlightItem[0];
    }

    public V2CCountHighlight(V2CCountHighlight v2CCountHighlight) {
        this.sSaveKey = v2CCountHighlight.sSaveKey;
        this.nMinimumThreshold = v2CCountHighlight.nMinimumThreshold;
        V2CCountHighlightItem[] v2CCountHighlightItemArray = v2CCountHighlight.vlItems;
        int n = v2CCountHighlightItemArray.length;
        V2CCountHighlightItem[] v2CCountHighlightItemArray2 = new V2CCountHighlightItem[n];
        for (int i = 0; i < n; ++i) {
            v2CCountHighlightItemArray2[i] = new V2CCountHighlightItem(v2CCountHighlightItemArray[i]);
        }
        this.vlItems = v2CCountHighlightItemArray;
    }

    V2CHighlightStyle getStyle(int n) {
        if (n < 10) {
            if (!this.bCached) {
                this.bCached = true;
                for (int i = 0; i < 10; ++i) {
                    this.vlStyleCache[i] = this.getStyle0(i);
                }
            }
            return this.vlStyleCache[n];
        }
        return this.getStyle0(n);
    }

    private V2CHighlightStyle getStyle0(int n) {
        V2CCountHighlightItem[] v2CCountHighlightItemArray = this.vlItems;
        for (int i = v2CCountHighlightItemArray.length - 1; i >= 0; --i) {
            V2CCountHighlightItem v2CCountHighlightItem = v2CCountHighlightItemArray[i];
            if (n < v2CCountHighlightItem.nThreshold) continue;
            return v2CCountHighlightItem.getStyle();
        }
        return null;
    }

    int size() {
        return this.vlItems.length;
    }

    V2CCountHighlightItem get(int n) {
        return n < this.vlItems.length ? this.vlItems[n] : null;
    }

    int add(int n, V2CHighlightSelectionPanel v2CHighlightSelectionPanel) {
        int n2;
        if (n < 0) {
            return -1;
        }
        int n3 = n2 = this.vlItems.length;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.vlItems[i].nThreshold;
            if (n == n4) {
                V2CSwingUtil.showErrorMessage("\u3057\u304d\u3044\u5024\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                return -1;
            }
            if (n >= n4) continue;
            n3 = i;
            break;
        }
        V2CCountHighlightItem[] v2CCountHighlightItemArray = new V2CCountHighlightItem[n2 + 1];
        if (n3 > 0) {
            System.arraycopy(this.vlItems, 0, v2CCountHighlightItemArray, 0, n3);
        }
        v2CCountHighlightItemArray[n3] = new V2CCountHighlightItem(n, v2CHighlightSelectionPanel);
        if (n3 < n2) {
            System.arraycopy(this.vlItems, n3, v2CCountHighlightItemArray, n3 + 1, n2 - n3);
        }
        this.vlItems = v2CCountHighlightItemArray;
        this.bChanged = true;
        return n3;
    }

    boolean remove(int n) {
        int n2 = this.vlItems.length;
        if (n < 0 || n >= n2) {
            return false;
        }
        V2CCountHighlightItem[] v2CCountHighlightItemArray = new V2CCountHighlightItem[n2 - 1];
        if (n > 0) {
            System.arraycopy(this.vlItems, 0, v2CCountHighlightItemArray, 0, n);
        }
        if (n + 1 < n2) {
            System.arraycopy(this.vlItems, n + 1, v2CCountHighlightItemArray, n, n2 - n - 1);
        }
        this.vlItems = v2CCountHighlightItemArray;
        this.bChanged = true;
        return true;
    }

    boolean change(int n, int n2, V2CHighlightSelectionPanel v2CHighlightSelectionPanel) {
        int n3 = this.vlItems.length;
        if (n < 0 || n >= n3) {
            return false;
        }
        if (n2 >= 0) {
            for (int i = 0; i < n3; ++i) {
                if (i == n || n2 != this.vlItems[i].nThreshold) continue;
                V2CSwingUtil.showErrorMessage("\u3057\u304d\u3044\u5024\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                return false;
            }
        } else {
            n2 = this.vlItems[n].nThreshold;
        }
        this.vlItems[n].change(n2, v2CHighlightSelectionPanel);
        Arrays.sort(this.vlItems, this);
        this.bChanged = true;
        return true;
    }

    void saveItems() {
        this.bCached = false;
        if (!this.bChanged) {
            return;
        }
        this.bChanged = false;
        ArrayList<V2CPackedPropValue> arrayList = new ArrayList<V2CPackedPropValue>();
        for (int i = 0; i < this.vlItems.length; ++i) {
            V2CPackedPropValue v2CPackedPropValue = this.vlItems[i].getSaveValue();
            if (v2CPackedPropValue == null) continue;
            arrayList.add(v2CPackedPropValue);
        }
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (arrayList.size() > 0) {
            v2CProperty.putPackedValueArray(this.sSaveKey, arrayList.toArray(new V2CPackedPropValue[arrayList.size()]));
        } else {
            v2CProperty.remove(this.sSaveKey);
        }
    }

    int getMinimumThreshold() {
        return this.nMinimumThreshold;
    }

    public int compare(Object object, Object object2) {
        return ((V2CCountHighlightItem)object).nThreshold - ((V2CCountHighlightItem)object2).nThreshold;
    }

    static {
        if (V2CApp.isFirstTime()) {
            V2CProperty v2CProperty = V2CApp.getUserProperty();
            v2CProperty.put("ThreadView.RefCountHighlight", "d:F#ff0000\tT3");
            v2CProperty.put("ThreadView.IDCountHighlight", "d:F#ff0000\tT5");
        }
    }
}

