/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBaseFont;
import org.monazilla.v2c.V2CEvalScript;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CParseLinkResult;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CScriptUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTCPopupListener;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CHTMLPane
extends JEditorPane
implements HyperlinkListener {
    private static final Insets insMargin = new Insets(10, 10, 10, 10);
    private static Timer vPopupTimer;
    private static V2CThreadPanel vPopupThreadPanel;
    private static int[] ilPopupRes;
    private static Point vPopupPoint;
    boolean bAntiAliasing;
    boolean bAllowIntBrowser;
    boolean bLinkEntered;
    boolean bAlreadyPainted;
    final V2CEvalScript vEvalScript;

    private static void stopPopupTimer() {
        Timer timer = vPopupTimer;
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
    }

    public V2CHTMLPane() {
        this(null, false, null);
    }

    public V2CHTMLPane(String string) {
        this(string, false, null);
    }

    public V2CHTMLPane(URL uRL) {
        this(uRL != null ? uRL.toExternalForm() : null, true, null);
    }

    public V2CHTMLPane(String string, V2CEvalScript v2CEvalScript) {
        this(string, false, v2CEvalScript);
    }

    public V2CHTMLPane(String string, boolean bl, V2CEvalScript v2CEvalScript) {
        this.vEvalScript = v2CEvalScript;
        MyEditorKit myEditorKit = new MyEditorKit();
        if (v2CEvalScript != null && v2CEvalScript.getTrapFormSubmission()) {
            V2CJ2SE5Util.setAutoFormSubmission(myEditorKit, false);
        }
        this.setEditorKit(myEditorKit);
        if (!bl && V2CApp.hasInitialized()) {
            this.setHonorDisplayProperties(true);
        }
        if (!bl) {
            this.setMargin(insMargin);
            this.setContentType("text/html");
        }
        this.setEditable(false);
        this.addMouseListener(new V2CTCPopupListener(this));
        if (string != null) {
            if (bl) {
                try {
                    this.setPage(string);
                }
                catch (Exception exception) {}
            } else {
                this.doSetText(string);
            }
        }
    }

    void setHonorDisplayProperties(boolean bl) {
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
            return;
        }
        if (bl) {
            this.setForeground(V2CThreadStyle.getDefaultForeground());
            this.setBackground(V2CThreadStyle.getDefaultBackground());
            this.setFont(V2CSSFont.getDefaultFont().getAwtFont());
        } else {
            this.setForeground(null);
            this.setBackground(null);
        }
        V2CJ2SE5Util.setHonorDisplayProperties(this, bl);
    }

    void listenToHyperlinkEvent(boolean bl) {
        this.addHyperlinkListener(this);
        this.bAllowIntBrowser = bl;
    }

    void doSetText(String string) {
        this.setText(string);
    }

    void copyText() {
        String string = this.getSelectedText();
        if (string == null) {
            this.selectAll();
            string = this.getSelectedText();
            this.select(0, 0);
        }
        V2CMain.copyString(string);
    }

    void setAntiAliasing(boolean bl) {
        this.bAntiAliasing = bl;
    }

    public void paintComponent(Graphics graphics) {
        if (!this.bAlreadyPainted) {
            this.bAlreadyPainted = true;
            JScrollPane jScrollPane = V2CSwingUtil.getParentScrollPane(this);
            if (jScrollPane != null) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        V2CHTMLPane.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                    }
                });
                this.repaint();
                return;
            }
        }
        if (this.bAntiAliasing) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(graphics);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        URL uRL = hyperlinkEvent.getURL();
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 5) && V2CJ2SE5Util.isFormSubmittedEvent(hyperlinkEvent)) {
            V2CEvalScript v2CEvalScript = this.vEvalScript;
            if (v2CEvalScript != null) {
                try {
                    v2CEvalScript = (V2CEvalScript)v2CEvalScript.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                v2CEvalScript.setOriginalPopup(this);
                V2CScriptUtil.formSubmitted(v2CEvalScript, uRL, V2CJ2SE5Util.getFormMethod(hyperlinkEvent), V2CJ2SE5Util.getFormData(hyperlinkEvent));
            }
            return;
        }
        if (uRL == null) {
            return;
        }
        String string = uRL.toString();
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            V2CThreadPanel v2CThreadPanel;
            int[] nArray;
            this.bLinkEntered = true;
            String string2 = V2CMiscUtil.maybeGetURLDecodedString(string);
            if (string2 != null) {
                int n = string2.indexOf(10);
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
            } else {
                string2 = string;
            }
            V2CMain.setTempMessage(string2, this);
            V2CParseLinkResult v2CParseLinkResult = new V2CParseLinkResult(uRL);
            if (v2CParseLinkResult.parse(true) && (nArray = v2CParseLinkResult.getResNumbers()) != null && nArray.length > 0 && (v2CThreadPanel = V2CThreadPanel.loadThreadIfNotLoaded(v2CParseLinkResult.getThreadItem())) != null) {
                Point point = V2CSwingUtil.getMouseLocationOnScreen(null);
                point.x -= 15;
                point.y -= 15;
                vPopupThreadPanel = v2CThreadPanel;
                ilPopupRes = nArray;
                vPopupPoint = point;
                Timer timer = vPopupTimer;
                int n = V2CAbstractThreadPanel.nPopupDelay;
                if (timer != null) {
                    if (timer.isRunning()) {
                        timer.stop();
                    }
                    if (timer.getDelay() != n) {
                        timer.setDelay(n);
                    }
                } else {
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            vPopupTimer.stop();
                            V2CThreadPanel v2CThreadPanel = vPopupThreadPanel;
                            int[] nArray = ilPopupRes;
                            Point point = vPopupPoint;
                            if (v2CThreadPanel != null && nArray != null && point != null) {
                                v2CThreadPanel.popupRes(nArray, point, -1);
                            }
                        }
                    };
                    vPopupTimer = timer = new Timer(n, actionListener);
                }
                timer.start();
            }
        } else if (eventType == HyperlinkEvent.EventType.EXITED) {
            this.bLinkEntered = false;
            V2CMain.endTempMessage(this);
            V2CHTMLPane.stopPopupTimer();
        } else if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            V2CHTMLPane.stopPopupTimer();
            if (!this.bLinkEntered) {
                return;
            }
            V2CEvalScript v2CEvalScript = this.vEvalScript;
            if (v2CEvalScript != null && v2CEvalScript.getRedirectURL()) {
                try {
                    v2CEvalScript = (V2CEvalScript)v2CEvalScript.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                v2CEvalScript.setOriginalPopup(this);
                V2CScriptUtil.redirectURL(v2CEvalScript, uRL);
            } else {
                V2CMiscUtil.openUnknownLink(string, true, false, this.bAllowIntBrowser, true);
            }
        }
    }

    boolean isLinkEntered() {
        return this.bLinkEntered;
    }

    private static class MyStyleSheet
    extends StyleSheet {
        static boolean bUNIX = V2CApp.isUNIX();
        String sJapaneseFontName;
        boolean bJapaneseFontExists = true;

        private MyStyleSheet() {
        }

        public Font getFont(AttributeSet attributeSet) {
            if (!bUNIX) {
                return super.getFont(attributeSet);
            }
            Font font = super.getFont(attributeSet);
            if (this.bJapaneseFontExists && !font.canDisplay('\u4e9c')) {
                if (this.sJapaneseFontName == null) {
                    this.findJapaneseFont();
                }
                if (this.sJapaneseFontName != null) {
                    font = this.getFont(this.sJapaneseFontName, font.getStyle(), font.getSize());
                }
            }
            return font;
        }

        void findJapaneseFont() {
            this.bJapaneseFontExists = false;
            Font font = null;
            V2CBaseFont v2CBaseFont = V2CBaseFont.getBaseFont("ThreadDefault");
            if (v2CBaseFont == null) {
                v2CBaseFont = V2CBaseFont.getDefaultBaseFont();
            }
            if (v2CBaseFont != null) {
                font = v2CBaseFont.getFont();
            }
            if (font == null) {
                font = V2CBaseFont.findJapanesePhysicalFont();
            }
            if (font != null) {
                this.sJapaneseFontName = font.getFamily();
                this.bJapaneseFontExists = true;
            }
        }
    }

    private static class MyEditorKit
    extends HTMLEditorKit {
        private MyEditorKit() {
        }

        public Document createDefaultDocument() {
            MyStyleSheet myStyleSheet = new MyStyleSheet();
            myStyleSheet.addStyleSheet(this.getStyleSheet());
            HTMLDocument hTMLDocument = new HTMLDocument(myStyleSheet);
            hTMLDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            hTMLDocument.setParser(this.getParser());
            hTMLDocument.setAsynchronousLoadPriority(4);
            hTMLDocument.setTokenThreshold(100);
            return hTMLDocument;
        }
    }
}

