/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.monazilla.v2c.V2CHighlightStyle;
import org.monazilla.v2c.V2CHighlightTableModel;
import org.monazilla.v2c.V2CListTable;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CHighlightTableCellRenderer
extends DefaultTableCellRenderer {
    static final double dItalicAngle = 0.3;
    Color cForeground;
    Color cBackground;
    int iRow;
    int iColumn;
    V2CHighlightStyle vHighlightStyle;
    int nY;
    final boolean bDrawStyleName;
    final boolean bQueryColors;
    final boolean bAlwaysOpaque;
    final boolean bSetTextAAHint;

    public V2CHighlightTableCellRenderer() {
        this.bDrawStyleName = false;
        this.bQueryColors = true;
        this.bAlwaysOpaque = true;
        this.bSetTextAAHint = true;
    }

    public V2CHighlightTableCellRenderer(Color color) {
        this.bDrawStyleName = false;
        this.bQueryColors = false;
        this.cForeground = color;
        this.bAlwaysOpaque = false;
        this.bSetTextAAHint = false;
    }

    public V2CHighlightTableCellRenderer(JTable jTable, Color color, Color color2, boolean bl) {
        this.bDrawStyleName = bl;
        this.bQueryColors = false;
        this.bAlwaysOpaque = true;
        this.bSetTextAAHint = true;
        this.cForeground = color != null ? color : jTable.getForeground();
        this.cBackground = color2 != null ? color2 : jTable.getBackground();
    }

    void setHighlightStyle(V2CHighlightStyle v2CHighlightStyle) {
        this.vHighlightStyle = v2CHighlightStyle;
        this.setOpaque(v2CHighlightStyle != null && v2CHighlightStyle.cBackground != null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.iRow = n;
        this.iColumn = n2;
        boolean bl3 = this.bQueryColors;
        TableModel tableModel = jTable.getModel();
        V2CHighlightStyle v2CHighlightStyle = null;
        if (tableModel instanceof V2CHighlightTableModel) {
            V2CHighlightTableModel v2CHighlightTableModel = (V2CHighlightTableModel)((Object)tableModel);
            this.setHorizontalAlignment(v2CHighlightTableModel.getHorizontalAlignment(n2));
            v2CHighlightStyle = v2CHighlightTableModel.getHighlightStyle(n, n2);
            if (bl3 && !bl) {
                this.setBackground(v2CHighlightTableModel.getDefaultBG(n, n2));
            }
            if (this.bDrawStyleName) {
                String string;
                if (v2CHighlightStyle != null) {
                    string = v2CHighlightStyle.getName();
                    if (string == null) {
                        string = v2CHighlightStyle.isDefined() ? "\uff08\u76f4\u63a5\u6307\u5b9a\uff09" : "";
                    }
                } else {
                    string = "\uff08\u306a\u3057\uff09";
                }
                this.setText(string);
            }
        }
        this.vHighlightStyle = v2CHighlightStyle;
        if (bl3 && !bl) {
            this.setForeground(V2CListTable.cTextFG);
        }
        return this;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        Color color;
        int n2;
        Object object;
        V2CHighlightStyle v2CHighlightStyle = this.vHighlightStyle;
        if (v2CHighlightStyle == null) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.bSetTextAAHint) {
            V2CThreadStyle.setTextAAHint(graphics2D);
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.bAlwaysOpaque || this.isOpaque()) {
            object = v2CHighlightStyle.cBackground;
            graphics.setColor((Color)(object != null ? object : this.getBackground()));
            graphics.fillRect(0, 0, n3, n4);
        }
        if ((object = this.getText()) == null || ((String)object).length() == 0) {
            return;
        }
        graphics.setFont(this.getFont());
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.nY <= 0) {
            n2 = fontMetrics.getAscent();
            int n5 = fontMetrics.getDescent();
            this.nY = insets.top + (n4 - insets.top - insets.bottom + n2 - n5 + 1) / 2;
            if (this.nY <= 0) {
                this.nY = Math.max(n4 - insets.top - insets.bottom, 1);
            }
        }
        n2 = insets.left;
        Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object, graphics);
        int n6 = (int)rectangle2D.getWidth();
        int n7 = (int)rectangle2D.getHeight();
        if (this.getHorizontalAlignment() == 4) {
            int n8 = Math.max(n3 - insets.left - insets.right, 0);
            n2 += n8 - n6;
        }
        if ((color = v2CHighlightStyle.cForeground) == null) {
            color = this.cForeground;
        }
        graphics.setColor(color != null ? color : this.getForeground());
        AffineTransform affineTransform = null;
        AffineTransform affineTransform2 = null;
        boolean bl = v2CHighlightStyle.bItalic;
        if (bl) {
            affineTransform = graphics2D.getTransform();
            affineTransform2 = new AffineTransform(1.0, 0.0, -0.3, 1.0, 0.3 * (double)this.nY - (double)n7 * 0.3 / 2.0, 0.0);
            graphics2D.transform(affineTransform2);
        }
        graphics.drawString((String)object, n2, this.nY);
        if (v2CHighlightStyle.bBold) {
            graphics.drawString((String)object, n2 + 1, this.nY);
        }
        if (bl) {
            graphics2D.setTransform(affineTransform);
        }
        if (v2CHighlightStyle.bStrike) {
            n = this.nY - 2 * fontMetrics.getAscent() / 5;
            graphics.drawLine(n2, n, n2 + n6, n);
        }
        if (v2CHighlightStyle.bUnderline) {
            n = Math.min((int)((double)this.nY + rectangle2D.getY() + (double)n7), n4 - 1);
            graphics.drawLine(n2, n, n2 + n6, n);
        }
    }
}

