/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CTabImage;
import org.monazilla.v2c.V2CTabImageHolder;
import org.monazilla.v2c.V2CTabImageSP;

class V2CIDHighlightItem
implements V2CTabImageHolder {
    static final String sDefHLIDKey = "ID.DefHL";
    static final String sDefHLAuxKey = "Aux.DefHL";
    static final int nHLIDEx = 2;
    final String sID;
    String sID2;
    Color vHighlightColor;
    String vIDAlias;
    long ltCreateTime;
    String sSound;
    int iSoundWeight;
    V2CTabImage vTabImage;
    String sAvatar;
    V2CImageSet vImageSet;
    int nExpireDays;

    static V2CIDHighlightItem getDefault(boolean bl) {
        return V2CIDHighlightItem.createDefault(null, bl);
    }

    static V2CIDHighlightItem createDefault(String string, boolean bl) {
        return new V2CIDHighlightItem(string, bl);
    }

    static V2CIDHighlightItem restoreItem(V2CPackedPropValue v2CPackedPropValue, long l) {
        int n;
        if (v2CPackedPropValue == null) {
            return null;
        }
        long l2 = v2CPackedPropValue.getLong('T');
        int n2 = v2CPackedPropValue.getInt('V', 2);
        if (n2 == 2 && (n = v2CPackedPropValue.getInt('D', 2)) != 2) {
            n2 = n;
        }
        if (n2 == 0) {
            n2 = 2;
        } else if (n2 == -1) {
            n2 = 0;
        }
        if (n2 != 0 && l2 + (long)(n2 * 86400) < l) {
            return null;
        }
        V2CIDHighlightItem v2CIDHighlightItem = new V2CIDHighlightItem(v2CPackedPropValue, l2, n2);
        return v2CIDHighlightItem.isDefined() ? v2CIDHighlightItem : null;
    }

    private V2CIDHighlightItem(String string, boolean bl) {
        this.sID = string;
        this.sID2 = V2CResItem.toIDForDupCheck2(string);
        V2CPackedPropValue v2CPackedPropValue = V2CApp.getUserProperty().getPackedValue(bl ? sDefHLIDKey : sDefHLAuxKey);
        if (v2CPackedPropValue != null) {
            this.vHighlightColor = v2CPackedPropValue.getColor('B');
            this.vIDAlias = v2CPackedPropValue.getString('L');
            int n = v2CPackedPropValue.getInt('V', 2);
            if (n == 0) {
                n = 2;
            } else if (n == -1) {
                n = 0;
            }
            this.nExpireDays = n;
            this.sSound = v2CPackedPropValue.getString('s');
            this.iSoundWeight = v2CPackedPropValue.getIntInRange('w', 0, 9);
            String string2 = v2CPackedPropValue.getString('t');
            if (string2 != null) {
                this.vTabImage = V2CTabImage.createInstance(string2);
            }
            this.sAvatar = v2CPackedPropValue.getString('i');
        } else {
            this.nExpireDays = 2;
        }
    }

    private V2CIDHighlightItem(V2CPackedPropValue v2CPackedPropValue, long l, int n) {
        int n2;
        this.sID = v2CPackedPropValue.getString('I');
        this.sID2 = V2CResItem.toIDForDupCheck2(this.sID);
        this.vHighlightColor = v2CPackedPropValue.getColor('B');
        this.vIDAlias = v2CPackedPropValue.getString('L');
        this.ltCreateTime = l;
        this.nExpireDays = n;
        this.sSound = v2CPackedPropValue.getString('s');
        int n3 = v2CPackedPropValue.getIntInRange('w', 0, 9);
        if (n3 == 0 && (n2 = v2CPackedPropValue.getIntInRange('y', 0, 9)) > 0) {
            n3 = n2;
        }
        this.iSoundWeight = n3;
        String string = v2CPackedPropValue.getString('t');
        if (string != null) {
            this.vTabImage = V2CTabImage.createInstance(string);
        }
        this.sAvatar = v2CPackedPropValue.getString('i');
    }

    V2CPackedPropValue getSaveValue() {
        V2CTabImage v2CTabImage;
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setString('I', this.sID);
        v2CPackedPropValue.setColor('B', this.vHighlightColor);
        v2CPackedPropValue.setString('L', this.vIDAlias);
        v2CPackedPropValue.setLong('T', this.ltCreateTime);
        int n = this.nExpireDays;
        if (n != 2) {
            v2CPackedPropValue.setInt('V', n != 0 ? n : -1);
        }
        if (this.sSound != null) {
            v2CPackedPropValue.setString('s', this.sSound);
            if (this.iSoundWeight > 0) {
                v2CPackedPropValue.setInt('w', this.iSoundWeight);
            }
        }
        if ((v2CTabImage = this.vTabImage) != null) {
            v2CTabImage.setSaveValue(v2CPackedPropValue);
        }
        v2CPackedPropValue.setString('i', this.sAvatar);
        return v2CPackedPropValue;
    }

    void saveAsDefault(boolean bl) {
        if (this.sID != null) {
            return;
        }
        String string = bl ? sDefHLIDKey : sDefHLAuxKey;
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (this.vHighlightColor != null || this.vIDAlias != null && this.vIDAlias.length() > 0 || this.nExpireDays != 2 || this.sSound != null || this.vTabImage != null || this.sAvatar != null) {
            V2CPackedPropValue v2CPackedPropValue = this.getSaveValue();
            v2CPackedPropValue.setString('T', null);
            v2CProperty.putPackedValue(string, v2CPackedPropValue);
        } else {
            v2CProperty.remove(string);
        }
    }

    void setProps(Color color, String string, String string2, int n, V2CTabImageSP v2CTabImageSP, String string3, int n2) {
        this.vHighlightColor = color;
        this.vIDAlias = string != null && string.length() > 0 && !V2CMiscUtil.isEqual(string, this.sID) ? string : null;
        this.sSound = V2CMiscUtil.emptyStringToNull(string2);
        this.iSoundWeight = this.sSound != null ? V2CMiscUtil.restrictRange(0, n, 9) : 0;
        this.vTabImage = V2CTabImage.createInstance(v2CTabImageSP);
        if (!V2CMiscUtil.isEqual(string3 = V2CMiscUtil.emptyStringToNull(string3), this.sAvatar)) {
            this.sAvatar = string3;
            this.vImageSet = null;
        }
        this.nExpireDays = n2;
        this.ltCreateTime = System.currentTimeMillis() / 1000L;
    }

    String getID() {
        return this.sID2;
    }

    String getOriginalID() {
        return this.sID;
    }

    boolean isDefined() {
        return this.sID != null && this.sID.length() > 4 && (this.vHighlightColor != null || this.vIDAlias != null && this.vIDAlias.length() > 0 || this.sSound != null) || this.vTabImage != null || this.sAvatar != null;
    }

    String getSoundName() {
        return this.sSound;
    }

    int getSoundWeight() {
        return this.iSoundWeight;
    }

    void setTabImage() {
    }

    V2CTabImage getTabImageObject() {
        return this.vTabImage;
    }

    public int getTabImageHOffset() {
        V2CTabImage v2CTabImage = this.getTabImageObject();
        return v2CTabImage != null ? v2CTabImage.getTabImageHOffset() : 0;
    }

    public boolean getTabImageRight() {
        V2CTabImage v2CTabImage = this.getTabImageObject();
        return v2CTabImage != null ? v2CTabImage.getTabImageRight() : false;
    }

    public String getTabImageName() {
        V2CTabImage v2CTabImage = this.getTabImageObject();
        return v2CTabImage != null ? v2CTabImage.getTabImageName() : null;
    }

    public V2CImageSet getTabImage() {
        V2CTabImage v2CTabImage = this.getTabImageObject();
        return v2CTabImage != null ? v2CTabImage.getTabImage() : null;
    }

    public boolean isTabImageSet() {
        return this.getTabImageObject() != null;
    }

    String getAvatarName() {
        return this.sAvatar;
    }

    V2CImageSet getImage() {
        if (this.sAvatar == null) {
            return null;
        }
        V2CImageSet v2CImageSet = this.vImageSet;
        if (v2CImageSet != null) {
            return v2CImageSet;
        }
        v2CImageSet = V2CLocalFileHandler.getAvatarImage(this.sAvatar);
        if (v2CImageSet == null) {
            v2CImageSet = V2CLink.getErrorImageSet(false);
        }
        this.vImageSet = v2CImageSet;
        return v2CImageSet;
    }
}

