/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextField;

public class V2CImportMessageFromFileSP
extends JPanel
implements ActionListener {
    static String[] slMessageFileCharsets = new String[]{"windows-31j", "EUC-JP", "Shift_JIS", "UTF-8"};
    JTextField jtfFile;
    JButton jbBrowse;
    JComboBox jcbCharset;
    JTextField jtfEOILine;

    static void createMessageFileCharsets() {
        int n = slMessageFileCharsets.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = slMessageFileCharsets[i];
            if (!Charset.isSupported(string) || ++n2 >= i) continue;
            V2CImportMessageFromFileSP.slMessageFileCharsets[n2] = string;
        }
        if (n2 == n) {
            return;
        }
        String[] stringArray = new String[n2];
        if (n2 == 0) {
            return;
        }
        System.arraycopy(slMessageFileCharsets, 0, stringArray, 0, n2);
        slMessageFileCharsets = stringArray;
    }

    public V2CImportMessageFromFileSP(boolean bl) {
        super(new GridBagLayout());
        if (!bl) {
            this.setBorder(new TitledBorder("\u30d5\u30a1\u30a4\u30eb\u306e\u30a4\u30f3\u30dd\u30fc\u30c8"));
        }
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 10, 1, 0);
        this.add((Component)new JLabel("\u30d5\u30a1\u30a4\u30eb\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jtfFile = new JTextField(v2CProperty.get("WritePanel.MessageImportFile", ""), 30);
        this.jtfFile.setEditable(false);
        this.add((Component)this.jtfFile, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbBrowse = new JButton("\u2026");
        this.jbBrowse.setFocusable(false);
        this.jbBrowse.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.jbBrowse, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(1, 10, 1, 0);
        this.add((Component)new JLabel("\u30a8\u30f3\u30b3\u30fc\u30c9\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jcbCharset = V2CSwingUtil.createComboBox(slMessageFileCharsets);
        this.setCharsetSelection(v2CProperty.get("WritePanel.MessageImportCharset"));
        this.jcbCharset.setFocusable(false);
        this.add((Component)this.jcbCharset, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("\u7d42\u4e86\u884c\uff1a"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jtfEOILine = new V2CTextField(20);
        this.jtfEOILine.setText(v2CProperty.get("WritePanel.MessageImportEOILine", "EOI"));
        this.add((Component)this.jtfEOILine, gridBagConstraints);
    }

    void setCharsetSelection(String string) {
        if (string == null || string.length() == 0) {
            switch (V2CApp.getSystemType()) {
                case 0: {
                    string = "EUC-JP";
                    break;
                }
                case 3: {
                    string = "Shift_JIS";
                    break;
                }
                default: {
                    string = "windows-31j";
                }
            }
        }
        for (int i = 0; i < slMessageFileCharsets.length; ++i) {
            if (!string.equals(slMessageFileCharsets[i])) continue;
            this.jcbCharset.setSelectedIndex(i);
            break;
        }
    }

    boolean showDialog() {
        return V2CSwingUtil.showOKCancelDialog(this, "\u30a4\u30f3\u30dd\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u8a2d\u5b9a");
    }

    boolean postConfig() {
        String string = this.jtfFile.getText();
        if (string == null || string.length() == 0) {
            return false;
        }
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        v2CProperty.put("WritePanel.MessageImportFile", string);
        v2CProperty.put("WritePanel.MessageImportCharset", (String)this.jcbCharset.getSelectedItem());
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        JFileChooser jFileChooser = V2CSwingUtil.createFileChooser();
        String string = this.jtfFile.getText();
        if (string != null && string.length() > 0 && ((File)(object = new File(string))).exists()) {
            jFileChooser.setSelectedFile((File)object);
        }
        object = new TextFilter();
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        jFileChooser.setFileFilter((FileFilter)object);
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.jtfFile.setText(jFileChooser.getSelectedFile().getAbsolutePath());
    }

    static {
        V2CImportMessageFromFileSP.createMessageFileCharsets();
    }

    private static class TextFilter
    extends FileFilter {
        private TextFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string == null || string.length() < 5) {
                return false;
            }
            return string.endsWith(".txt") || string.endsWith(".TXT");
        }

        public String getDescription() {
            return "Text Files (*.txt)";
        }
    }
}

