/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CInputMapConstants;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTextChangeListener;

public class V2CInputMapSP
extends JPanel
implements V2CInputMapConstants,
ActionListener,
ListSelectionListener,
KeyListener,
FocusListener {
    static final String[] slOtherColNames = new String[]{"S", "C", "A", "Key", "Action"};
    static final String[] slMacColNames = new String[]{"S", "O", "C", "Key", "Action"};
    static final String[] slColNames = V2CApp.isMacintosh() ? slMacColNames : slOtherColNames;
    private static int iSelectedTableIndex;
    private static int iSBValue;
    V2CInputMap[] vimlInputMaps;
    V2CInputMap imCurrentInputMap;
    JComboBox jcbComponent;
    JTextField jtfFilter;
    String sLastFilterWords;
    ActionTableModel tmAction;
    JTable jtActions;
    JScrollPane jScrollPane;
    Color cFG;
    JCheckBox jcbShift;
    JCheckBox jcbControl;
    JCheckBox jcbAlt;
    JCheckBox jcbOption;
    JCheckBox jcbCommand;
    JPanel jpKey;
    String sKeyStr;
    int nKeyCode;
    JButton jbSet;
    JButton jbAdd;
    JButton jbClear;
    JLabel jlStatus;
    boolean bChanged;

    public V2CInputMapSP(V2CInputMap[] av2cinputmap) {
        super(new GridBagLayout());
        JLabel jlabel;
        JPanel jpanel1;
        JScrollPane jscrollpane;
        JTable jtable;
        JTextField jtextfield;
        JComboBox jcombobox;
        this.vimlInputMaps = av2cinputmap;
        this.sLastFilterWords = "";
        GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
        gridbagconstraints.insets = new Insets(2, 2, 2, 2);
        this.jcbComponent = jcombobox = V2CSwingUtil.createComboBox(this.vimlInputMaps);
        jcombobox.setFocusable(false);
        jcombobox.setMaximumRowCount(this.vimlInputMaps.length);
        jcombobox.addActionListener(this);
        gridbagconstraints.weightx = 1.0;
        this.add((Component)jcombobox, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.anchor = 13;
        this.jtfFilter = jtextfield = V2CSwingUtil.createTextField(6);
        new FilterListener();
        this.add((Component)jtextfield, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        gridbagconstraints.anchor = 10;
        ++gridbagconstraints.gridy;
        this.tmAction = new ActionTableModel();
        this.jtActions = jtable = new JTable(this.tmAction);
        this.cFG = jtable.getForeground();
        jtable.setSelectionMode(0);
        jtable.setColumnSelectionAllowed(false);
        jtable.getSelectionModel().addListSelectionListener(this);
        Font font = jtable.getFont();
        int i = font.getSize();
        TableColumnModel tablecolumnmodel = jtable.getColumnModel();
        int j = slColNames.length;
        int k = 0;
        while (k < j - 2) {
            tablecolumnmodel.getColumn(k).setPreferredWidth(i);
            ++k;
        }
        tablecolumnmodel.getColumn(j - 2).setPreferredWidth(5 * i);
        tablecolumnmodel.getColumn(j - 1).setPreferredWidth(20 * i);
        tablecolumnmodel.getColumn(j - 1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jtable1, Object obj, boolean flag, boolean flag1, int l, int i1) {
                Component component = super.getTableCellRendererComponent(jtable1, obj, flag, flag1, l, i1);
                component.setForeground(l >= V2CInputMapSP.this.tmAction.nFiltered ? V2CInputMapSP.this.cFG : Color.RED);
                return component;
            }
        });
        this.jScrollPane = jscrollpane = V2CSwingUtil.createScrollPaneForTable(jtable, 200);
        gridbagconstraints.fill = 1;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.weighty = 1.0;
        this.add((Component)jscrollpane, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.weighty = 0.0;
        gridbagconstraints.fill = 0;
        ++gridbagconstraints.gridy;
        JPanel jpanel = new JPanel(new GridBagLayout());
        this.add((Component)jpanel, gridbagconstraints);
        ++gridbagconstraints.gridy;
        GridBagConstraints gridbagconstraints1 = V2CSwingUtil.createGridBagConstraints();
        gridbagconstraints1.insets = new Insets(5, 3, 5, 2);
        this.jcbShift = this.createCheckBox("Shift", jpanel, gridbagconstraints1);
        if (!V2CApp.isMacintosh()) {
            this.jcbControl = this.createCheckBox("Control", jpanel, gridbagconstraints1);
            this.jcbAlt = this.createCheckBox("Alt", jpanel, gridbagconstraints1);
        } else {
            this.jcbOption = this.createCheckBox("Option", jpanel, gridbagconstraints1);
            this.jcbCommand = this.createCheckBox("Command", jpanel, gridbagconstraints1);
        }
        this.jpKey = jpanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (V2CInputMapSP.this.sKeyStr == null) {
                    return;
                }
                int l = g.getFontMetrics().getHeight();
                Insets insets = this.getInsets();
                g.drawString(V2CInputMapSP.this.sKeyStr, insets.left + 1, (this.getHeight() + l) / 2 - insets.bottom);
            }
        };
        jpanel1.setFocusable(true);
        jpanel1.enableInputMethods(false);
        jpanel1.addKeyListener(this);
        jpanel1.addMouseListener(new MouseClickListener());
        jpanel1.addFocusListener(this);
        Dimension dimension = this.jcbShift.getPreferredSize();
        dimension = new Dimension(dimension);
        dimension.width = (int)((float)dimension.width * 1.5f);
        dimension.height = (int)((float)dimension.height * 1.3f);
        jpanel1.setPreferredSize(dimension);
        jpanel1.setMinimumSize(dimension);
        this.setInactiveColor();
        Border border = UIManager.getBorder("TextField.border");
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        jpanel1.setBorder(border);
        jpanel.add((Component)jpanel1, gridbagconstraints1);
        ++gridbagconstraints1.gridx;
        this.jbSet = this.createButton("\u8a2d\u5b9a", jpanel, gridbagconstraints1);
        this.jbAdd = this.createButton("\u8ffd\u52a0", jpanel, gridbagconstraints1);
        this.jbClear = this.createButton("\u524a\u9664", jpanel, gridbagconstraints1);
        this.jlStatus = jlabel = new JLabel("\u8a2d\u5b9a\u7121\u3057");
        this.add((Component)jlabel, gridbagconstraints);
        this.jcbComponent.setSelectedIndex(iSelectedTableIndex);
    }

    private JCheckBox createCheckBox(String s, JPanel jpanel, GridBagConstraints gridbagconstraints) {
        JCheckBox jcheckbox = new JCheckBox(s);
        jcheckbox.setFocusable(false);
        jcheckbox.addActionListener(this);
        jpanel.add((Component)jcheckbox, gridbagconstraints);
        ++gridbagconstraints.gridx;
        return jcheckbox;
    }

    private JButton createButton(String s, JPanel jpanel, GridBagConstraints gridbagconstraints) {
        JButton jbutton = new JButton(s);
        jbutton.setFocusable(false);
        jbutton.addActionListener(this);
        jpanel.add((Component)jbutton, gridbagconstraints);
        ++gridbagconstraints.gridx;
        return jbutton;
    }

    void setInactiveColor() {
        Color color1;
        Color color = UIManager.getColor("TextField.inactiveForeground");
        if (color != null) {
            this.jpKey.setForeground(color);
        }
        if ((color1 = UIManager.getColor("TextField.inactiveBackground")) != null) {
            this.jpKey.setBackground(color1);
        }
    }

    void setActiveColor() {
        Color color1;
        Color color = UIManager.getColor("TextField.foreground");
        if (color != null) {
            this.jpKey.setForeground(color);
        }
        if ((color1 = UIManager.getColor("TextField.background")) != null) {
            this.jpKey.setBackground(color1);
        }
    }

    void setKeyStrokeField(KeyStroke keystroke) {
        if (keystroke != null) {
            int i = keystroke.getModifiers();
            this.jcbShift.setSelected((i & 0x40) != 0);
            if (this.jcbControl != null) {
                this.jcbControl.setSelected((i & 0x80) != 0);
            }
            if (this.jcbAlt != null) {
                this.jcbAlt.setSelected((i & 0x200) != 0);
            }
            if (this.jcbOption != null) {
                this.jcbOption.setSelected((i & 0x200) != 0);
            }
            if (this.jcbCommand != null) {
                this.jcbCommand.setSelected((i & 0x100) != 0);
            }
            this.nKeyCode = keystroke.getKeyCode();
            this.sKeyStr = KeyEvent.getKeyText(this.nKeyCode);
        } else {
            this.jcbShift.setSelected(false);
            if (this.jcbControl != null) {
                this.jcbControl.setSelected(false);
            }
            if (this.jcbAlt != null) {
                this.jcbAlt.setSelected(false);
            }
            if (this.jcbOption != null) {
                this.jcbOption.setSelected(false);
            }
            if (this.jcbCommand != null) {
                this.jcbCommand.setSelected(false);
            }
            this.nKeyCode = -1;
            this.sKeyStr = null;
        }
        this.jpKey.repaint();
        this.updateStatus();
    }

    void inputMapSelectionChanged() {
        int i = this.jcbComponent.getSelectedIndex();
        if (i < 0 || i >= slInputMapName.length) {
            return;
        }
        this.imCurrentInputMap = this.vimlInputMaps[i];
        this.setKeyStrokeField(null);
        this.jbAdd.setEnabled(!this.imCurrentInputMap.isGlobal());
        this.tmAction.setActions(V2CAction.getInputActionsToConfigure(i));
    }

    private KeyStroke getCurrentKeyStroke() {
        if (this.nKeyCode < 0) {
            return null;
        }
        int i = 0;
        if (this.jcbShift.isSelected()) {
            i |= 0x40;
        }
        if (this.jcbControl != null && this.jcbControl.isSelected()) {
            i |= 0x80;
        }
        if (this.jcbAlt != null && this.jcbAlt.isSelected()) {
            i |= 0x200;
        }
        if (this.jcbOption != null && this.jcbOption.isSelected()) {
            i |= 0x200;
        }
        if (this.jcbCommand != null && this.jcbCommand.isSelected()) {
            i |= 0x100;
        }
        return KeyStroke.getKeyStroke(this.nKeyCode, i);
    }

    void updateStatus() {
        KeyStroke[] akeystroke;
        KeyStroke keystroke = this.getCurrentKeyStroke();
        String s = "\u8a2d\u5b9a\u7121\u3057";
        if (keystroke != null && (akeystroke = this.imCurrentInputMap.keys()) != null) {
            for (int i = 0; i < akeystroke.length; ++i) {
                V2CAbstractAction v2cabstractaction;
                if (!keystroke.equals(akeystroke[i])) continue;
                Object obj = this.imCurrentInputMap.get(keystroke);
                if (!(obj instanceof String) || (v2cabstractaction = V2CAction.getAction((String)obj)) == null) break;
                s = v2cabstractaction.toString();
                if (!this.imCurrentInputMap.getName().equals("Write") || !(v2cabstractaction instanceof V2CAction.OpenWritePanel)) break;
                s = "\u66f8\u304d\u8fbc\u307f\u6b04\u3092\u9589\u3058\u308b";
                break;
            }
        }
        this.jlStatus.setText(s);
    }

    void setKeyStroke(boolean flag) {
        KeyStroke keystroke1;
        KeyStroke keystroke = this.getCurrentKeyStroke();
        if (keystroke == null) {
            return;
        }
        int i = this.jtActions.getSelectedRow();
        if (i < 0) {
            return;
        }
        V2CAbstractAction v2cabstractaction = this.tmAction.getAction(i);
        if (v2cabstractaction == null) {
            return;
        }
        KeyStroke[] akeystroke = this.imCurrentInputMap.keys();
        if (akeystroke != null) {
            int j = 0;
            while (j < akeystroke.length) {
                if (keystroke.equals(akeystroke[j])) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ++j;
            }
        }
        if (!flag && (keystroke1 = this.tmAction.getKeyStroke(i)) != null) {
            this.imCurrentInputMap.remove(keystroke1);
        }
        if (this.imCurrentInputMap.isGlobal()) {
            v2cabstractaction.setAcceleratorKeyStroke(keystroke);
        }
        this.imCurrentInputMap.put(keystroke, v2cabstractaction.getName());
        this.tmAction.keyStrokeChanged(i, keystroke, flag);
        this.bChanged = true;
    }

    void clearKeyStroke() {
        KeyStroke keystroke;
        int i = this.jtActions.getSelectedRow();
        if (i < 0) {
            return;
        }
        V2CAbstractAction v2cabstractaction = this.tmAction.getAction(i);
        if (v2cabstractaction == null) {
            return;
        }
        if (this.imCurrentInputMap.isGlobal()) {
            v2cabstractaction.setAcceleratorKeyStroke(null);
        }
        if ((keystroke = this.tmAction.getKeyStroke(i)) != null) {
            this.imCurrentInputMap.remove(keystroke);
        }
        this.tmAction.clearKeyStroke(i);
        this.bChanged = true;
        this.setKeyStrokeField(null);
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
        keyevent.consume();
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
        keyevent.consume();
        int i = keyevent.getKeyCode();
        if (i == 0) {
            return;
        }
        if (i == 18 || i == 65406 || i == 20 || i == 144 || i == 17 || i == 16 || i == 157) {
            return;
        }
        this.nKeyCode = i;
        this.sKeyStr = V2CInputMap.getKeyText(i);
        this.updateStatus();
        this.jpKey.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
        keyevent.consume();
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj == this.jcbComponent) {
            this.inputMapSelectionChanged();
        } else if (obj == this.jbSet) {
            this.setKeyStroke(false);
        } else if (obj == this.jbAdd) {
            this.setKeyStroke(true);
        } else if (obj == this.jbClear) {
            this.clearKeyStroke();
        } else if (obj instanceof JCheckBox) {
            this.updateStatus();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listselectionevent) {
        int i = this.jtActions.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.setKeyStrokeField(this.tmAction.getKeyStroke(i));
    }

    @Override
    public void focusGained(FocusEvent focusevent) {
        this.setActiveColor();
    }

    @Override
    public void focusLost(FocusEvent focusevent) {
        this.setInactiveColor();
    }

    boolean showDialog() {
        this.initScroll();
        V2CSwingUtil.showDialogWithClose(this, null, "\u30ad\u30fc\u30d0\u30a4\u30f3\u30c9\u306e\u8a2d\u5b9a");
        this.saveScroll();
        return this.bChanged;
    }

    void saveScroll() {
        JScrollBar jscrollbar;
        int j = this.jcbComponent.getSelectedIndex();
        if (j >= 0 && j < slInputMapName.length) {
            iSelectedTableIndex = j;
        }
        if ((jscrollbar = this.jScrollPane.getVerticalScrollBar()) != null) {
            iSBValue = jscrollbar.getValue();
        }
    }

    void initScroll() {
        int i = iSBValue;
        if (i > 0) {
            this.scrollLater(i);
        }
    }

    private void scrollLater(final int iv) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar jscrollbar = V2CInputMapSP.this.jScrollPane.getVerticalScrollBar();
                if (jscrollbar != null) {
                    jscrollbar.setValue(iv);
                }
            }
        });
    }

    private class ActionTableModel
    extends AbstractTableModel {
        int nColumns = slColNames.length;
        V2CAbstractAction[] vlAbstractActions;
        ArrayList vActions = new ArrayList();
        boolean bGlobal;
        boolean bWrite;
        int nFiltered;

        void filterActions() {
            this.setActions(this.vlAbstractActions);
            V2CInputMapSP.this.scrollLater(0);
        }

        void setActions(V2CAbstractAction[] av2cabstractaction) {
            Object obj;
            this.vlAbstractActions = av2cabstractaction;
            try {
                this.bGlobal = V2CInputMapSP.this.imCurrentInputMap.isGlobal();
                this.bWrite = V2CInputMapSP.this.imCurrentInputMap.getName().equals("Write");
                this.vActions.clear();
                if (av2cabstractaction == null || av2cabstractaction.length == 0) {
                    return;
                }
            }
            finally {
                this.fireTableDataChanged();
            }
            String s = V2CMiscUtil.normalizeCase(V2CInputMapSP.this.sLastFilterWords);
            ArrayList<Object[]> arraylist = new ArrayList<Object[]>();
            int i = 0;
            while (i < av2cabstractaction.length) {
                V2CAbstractAction v2cabstractaction = av2cabstractaction[i];
                Object[] aobj = new Object[this.nColumns + 1];
                aobj[this.nColumns - 1] = v2cabstractaction;
                obj = V2CMiscUtil.normalizeCase(v2cabstractaction.toString());
                if (s.length() > 0 && ((String)obj).indexOf(s) >= 0) {
                    arraylist.add(aobj);
                } else {
                    this.vActions.add(aobj);
                }
                ++i;
            }
            this.nFiltered = arraylist.size();
            this.vActions.addAll(0, arraylist);
            KeyStroke[] akeystroke = V2CInputMapSP.this.imCurrentInputMap.keys();
            if (akeystroke != null) {
                int j = 0;
                while (j < akeystroke.length) {
                    String s1 = (String)V2CInputMapSP.this.imCurrentInputMap.get(akeystroke[j]);
                    if (s1 != null && (obj = V2CAction.getAction(s1)) != null) {
                        for (int k = this.vActions.size() - 1; k >= 0; --k) {
                            if (((Object[])this.vActions.get(k))[this.nColumns - 1] != obj) continue;
                            this.setKeyStroke(k, akeystroke[j], true);
                            break;
                        }
                    }
                    ++j;
                }
            }
        }

        private void setKeyStroke(int i, KeyStroke keystroke, boolean flag) {
            if (keystroke == null) {
                return;
            }
            Object[] aobj = (Object[])this.vActions.get(i);
            if (flag && aobj[this.nColumns] != null) {
                Object obj = aobj[this.nColumns - 1];
                aobj = new Object[this.nColumns + 1];
                this.vActions.add(i + 1, aobj);
                aobj[this.nColumns - 1] = obj;
                if (i < this.nFiltered) {
                    ++this.nFiltered;
                }
            } else {
                int j = 0;
                while (j < this.nColumns - 1) {
                    aobj[j] = null;
                    ++j;
                }
            }
            aobj[this.nColumns] = keystroke;
            int k = keystroke.getModifiers();
            if ((k & 0x40) != 0) {
                aobj[0] = "S";
            }
            if (!V2CApp.isMacintosh()) {
                if ((k & 0x80) != 0) {
                    aobj[1] = "C";
                }
                if ((k & 0x200) != 0) {
                    aobj[2] = "A";
                }
            } else {
                if ((k & 0x200) != 0) {
                    aobj[1] = "O";
                }
                if ((k & 0x100) != 0) {
                    aobj[2] = "C";
                }
            }
            aobj[this.nColumns - 2] = KeyEvent.getKeyText(keystroke.getKeyCode());
        }

        void keyStrokeChanged(int i, KeyStroke keystroke, boolean flag) {
            int j = this.vActions.size();
            this.setKeyStroke(i, keystroke, flag);
            if (this.vActions.size() == j) {
                this.fireTableRowsUpdated(i, i);
            } else if (this.vActions.size() == j + 1) {
                this.fireTableRowsInserted(i + 1, i + 1);
            }
        }

        void clearKeyStroke(int i) {
            Object[] aobj = (Object[])this.vActions.get(i);
            aobj[this.nColumns] = null;
            int j = 0;
            while (j < this.nColumns - 1) {
                aobj[j] = null;
                ++j;
            }
            V2CAbstractAction v2cabstractaction = (V2CAbstractAction)aobj[this.nColumns - 1];
            boolean flag = false;
            if (i > 0) {
                Object[] aobj1 = (Object[])this.vActions.get(i - 1);
                boolean bl = flag = v2cabstractaction == aobj1[this.nColumns - 1];
            }
            if (!flag && i < this.vActions.size() - 1) {
                Object[] aobj2 = (Object[])this.vActions.get(i + 1);
                boolean bl = flag = v2cabstractaction == aobj2[this.nColumns - 1];
            }
            if (flag) {
                this.vActions.remove(i);
                if (i < this.nFiltered) {
                    --this.nFiltered;
                }
                this.fireTableRowsDeleted(i, i);
            } else {
                this.fireTableRowsUpdated(i, i);
            }
        }

        V2CAbstractAction getAction(int i) {
            if (i < 0 || i >= this.vActions.size()) {
                return null;
            }
            return (V2CAbstractAction)((Object[])this.vActions.get(i))[this.nColumns - 1];
        }

        KeyStroke getKeyStroke(int i) {
            if (i < 0 || i >= this.vActions.size()) {
                return null;
            }
            return (KeyStroke)((Object[])this.vActions.get(i))[this.nColumns];
        }

        @Override
        public int getRowCount() {
            return this.vActions.size();
        }

        @Override
        public int getColumnCount() {
            return this.nColumns;
        }

        @Override
        public String getColumnName(int i) {
            return slColNames[i];
        }

        @Override
        public Object getValueAt(int i, int j) {
            Object obj = ((Object[])this.vActions.get(i))[j];
            if (!this.bWrite && !this.bGlobal || j < this.nColumns - 1) {
                return obj;
            }
            if (this.bGlobal) {
                String s;
                if (obj instanceof V2CAbstractAction && (s = ((V2CAbstractAction)obj).getName()) != null && s.startsWith("ThreadPanel")) {
                    return String.valueOf(obj.toString()) + " [\u30ec\u30b9\u8868\u793a\u6b04]";
                }
            } else if (this.bWrite && obj instanceof V2CAction.OpenWritePanel) {
                return "\u66f8\u304d\u8fbc\u307f\u6b04\u3092\u9589\u3058\u308b";
            }
            return obj;
        }

        private ActionTableModel() {
        }
    }

    private class FilterListener
    extends V2CTextChangeListener {
        @Override
        public void changedUpdate(DocumentEvent documentevent) {
            if (this.isComposing()) {
                return;
            }
            V2CInputMapSP.this.sLastFilterWords = V2CInputMapSP.this.jtfFilter.getText();
            V2CInputMapSP.this.tmAction.filterActions();
        }

        FilterListener() {
            super(V2CInputMapSP.this.jtfFilter);
        }
    }

    private class MouseClickListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseevent) {
            V2CInputMapSP.this.jpKey.requestFocusInWindow();
        }

        private MouseClickListener() {
        }
    }
}

