/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class V2CJPConverter {
    private static final int SS2 = 142;
    private static final int SS3 = 143;
    static final String sMS932 = "MS932";
    static final String sEUCJP = "EUC-JP";
    static final String sISO88591 = "ISO-8859-1";
    private static final char[] clMS2U = new char[65536];
    private static final char[] cl1stByte = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\ufffd', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\ufffd', '\uff61', '\uff62', '\uff63', '\uff64', '\uff65', '\uff66', '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b', '\uff6c', '\uff6d', '\uff6e', '\uff6f', '\uff70', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff76', '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff85', '\uff86', '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e', '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff95', '\uff96', '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9d', '\uff9e', '\uff9f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\ufffd', '\ufffd', '\ufffd'};
    private static final char[] clMS932DupTrans = new char[]{'\ueeef', '\ueef0', '\ueef1', '\ueef2', '\ueef3', '\ueef4', '\ueef5', '\ueef6', '\ueef7', '\ueef8', '\u8754', '\u8755', '\u8756', '\u8757', '\u8758', '\u8759', '\u875a', '\u875b', '\u875c', '\u875d', '\u81ca', '\ueefa', '\ueefb', '\ueefc', '\u878a', '\u8782', '\u8784', '\u81e6', '\ued40', '\ued41', '\ued42', '\ued43', '\ued44', '\ued45', '\ued46', '\ued47', '\ued48', '\ued49', '\ued4a', '\ued4b', '\ued4c', '\ued4d', '\ued4e', '\ued4f', '\ued50', '\ued51', '\ued52', '\ued53', '\ued54', '\ued55', '\ued56', '\ued57', '\ued58', '\ued59', '\ued5a', '\ued5b', '\ued5c', '\ued5d', '\ued5e', '\ued5f', '\ued60', '\ued61', '\ued62', '\u0000', '\ued63', '\ued64', '\ued65', '\ued66', '\ued67', '\ued68', '\ued69', '\ued6a', '\ued6b', '\ued6c', '\ued6d', '\ued6e', '\ued6f', '\ued70', '\ued71', '\ued72', '\ued73', '\ued74', '\ued75', '\ued76', '\ued77', '\ued78', '\ued79', '\ued7a', '\ued7b', '\ued7c', '\ued7d', '\ued7e', '\ued80', '\ued81', '\ued82', '\ued83', '\ued84', '\ued85', '\ued86', '\ued87', '\ued88', '\ued89', '\ued8a', '\ued8b', '\ued8c', '\ued8d', '\ued8e', '\ued8f', '\ued90', '\ued91', '\ued92', '\ued93', '\ued94', '\ued95', '\ued96', '\ued97', '\ued98', '\ued99', '\ued9a', '\ued9b', '\ued9c', '\ued9d', '\ued9e', '\ued9f', '\ueda0', '\ueda1', '\ueda2', '\ueda3', '\ueda4', '\ueda5', '\ueda6', '\ueda7', '\ueda8', '\ueda9', '\uedaa', '\uedab', '\uedac', '\uedad', '\uedae', '\uedaf', '\uedb0', '\uedb1', '\uedb2', '\uedb3', '\uedb4', '\uedb5', '\uedb6', '\uedb7', '\uedb8', '\uedb9', '\uedba', '\uedbb', '\uedbc', '\uedbd', '\uedbe', '\uedbf', '\uedc0', '\uedc1', '\uedc2', '\uedc3', '\uedc4', '\uedc5', '\uedc6', '\uedc7', '\uedc8', '\uedc9', '\uedca', '\uedcb', '\uedcc', '\uedcd', '\uedce', '\uedcf', '\uedd0', '\uedd1', '\uedd2', '\uedd3', '\uedd4', '\uedd5', '\uedd6', '\uedd7', '\uedd8', '\uedd9', '\uedda', '\ueddb', '\ueddc', '\ueddd', '\uedde', '\ueddf', '\uede0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\uede1', '\uede2', '\uede3', '\uede4', '\uede5', '\uede6', '\uede7', '\uede8', '\uede9', '\uedea', '\uedeb', '\uedec', '\ueded', '\uedee', '\uedef', '\uedf0', '\uedf1', '\uedf2', '\uedf3', '\uedf4', '\uedf5', '\uedf6', '\uedf7', '\uedf8', '\uedf9', '\uedfa', '\uedfb', '\uedfc', '\uee40', '\uee41', '\uee42', '\uee43', '\uee44', '\uee45', '\uee46', '\uee47', '\uee48', '\uee49', '\uee4a', '\uee4b', '\uee4c', '\uee4d', '\uee4e', '\uee4f', '\uee50', '\uee51', '\uee52', '\uee53', '\uee54', '\uee55', '\uee56', '\uee57', '\uee58', '\uee59', '\uee5a', '\uee5b', '\uee5c', '\uee5d', '\uee5e', '\uee5f', '\uee60', '\uee61', '\uee62', '\u0000', '\uee63', '\uee64', '\uee65', '\uee66', '\uee67', '\uee68', '\uee69', '\uee6a', '\uee6b', '\uee6c', '\uee6d', '\uee6e', '\uee6f', '\uee70', '\uee71', '\uee72', '\uee73', '\uee74', '\uee75', '\uee76', '\uee77', '\uee78', '\uee79', '\uee7a', '\uee7b', '\uee7c', '\uee7d', '\uee7e', '\uee80', '\uee81', '\uee82', '\uee83', '\uee84', '\uee85', '\uee86', '\uee87', '\uee88', '\uee89', '\uee8a', '\uee8b', '\uee8c', '\uee8d', '\uee8e', '\uee8f', '\uee90', '\uee91', '\uee92', '\uee93', '\uee94', '\uee95', '\uee96', '\uee97', '\uee98', '\uee99', '\uee9a', '\uee9b', '\uee9c', '\uee9d', '\uee9e', '\uee9f', '\ueea0', '\ueea1', '\ueea2', '\ueea3', '\ueea4', '\ueea5', '\ueea6', '\ueea7', '\ueea8', '\ueea9', '\ueeaa', '\ueeab', '\ueeac', '\ueead', '\ueeae', '\ueeaf', '\ueeb0', '\ueeb1', '\ueeb2', '\ueeb3', '\ueeb4', '\ueeb5', '\ueeb6', '\ueeb7', '\ueeb8', '\ueeb9', '\ueeba', '\ueebb', '\ueebc', '\ueebd', '\ueebe', '\ueebf', '\ueec0', '\ueec1', '\ueec2', '\ueec3', '\ueec4', '\ueec5', '\ueec6', '\ueec7', '\ueec8', '\ueec9', '\ueeca', '\ueecb', '\ueecc', '\ueecd', '\ueece', '\ueecf', '\ueed0', '\ueed1', '\ueed2', '\ueed3', '\ueed4', '\ueed5', '\ueed6', '\ueed7', '\ueed8', '\ueed9', '\ueeda', '\ueedb', '\ueedc', '\ueedd', '\ueede', '\ueedf', '\ueee0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\ueee1', '\ueee2', '\ueee3', '\ueee4', '\ueee5', '\ueee6', '\ueee7', '\ueee8', '\ueee9', '\ueeea', '\ueeeb', '\ueeec'};

    static void replaceAtBackquote(char[] cArray) {
        int n;
        if (cArray == null || (n = V2CJPConverter.getCharLength(cArray)) < 0) {
            return;
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] != '\uff20' || cArray[i + 1] != '\uff40') continue;
            cArray[i] = 44;
            for (int j = i + 2; j < n2; ++j) {
                cArray[j - 1] = cArray[j];
            }
            --n2;
        }
        if (n2 < n - 1) {
            V2CJPConverter.setCharLength(cArray, n2 + 1);
        }
    }

    static void setCharLength(char[] cArray, int n) {
        cArray[cArray.length - 2] = (char)(n >> 16 & 0xFFFF);
        cArray[cArray.length - 1] = (char)(n & 0xFFFF);
    }

    static int getCharLength(char[] cArray) {
        int n;
        if (cArray == null || (n = cArray.length) < 2) {
            return -1;
        }
        int n2 = cArray[n - 2] << 16 | cArray[n - 1];
        return n2 >= 0 && n2 <= n - 2 ? n2 : -1;
    }

    private static char checkMS2U(int n, int n2) {
        char c = '\u0001';
        if ((n >= 129 && n < 160 || n >= 224 && n < 253) && n2 >= 64 && n2 < 253 && n2 != 127) {
            byte[] byArray = new byte[]{(byte)n, (byte)n2};
            String string = null;
            try {
                string = new String(byArray, sMS932);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (string.length() == 1) {
                c = string.charAt(0);
            }
        }
        V2CJPConverter.clMS2U[n | n2 << 8] = c;
        return c;
    }

    private static String createMS932String(byte[] byArray, int n, int n2) {
        return (String)V2CJPConverter.createMS932CharObject(byArray, n, n2, true);
    }

    private static Object createMS932CharObject(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray == null) {
            return null;
        }
        int n3 = n + n2;
        if (byArray.length < n + n2) {
            return null;
        }
        if (n2 == 0) {
            return bl ? "" : (Object)new char[2];
        }
        char[] cArray = new char[bl ? n2 : n2 + 2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            int n7;
            char c;
            if ((c = cl1stByte[n7 = byArray[n4++] & 0xFF]) != '\uffff') {
                cArray[n5++] = c;
                continue;
            }
            if (n4 >= n3) {
                cArray[n5++] = 65533;
                break;
            }
            if ((n6 = byArray[n4++] & 0xFF) >= 64 && n6 < 253 && n6 != 127) {
                char c2 = clMS2U[n7 | n6 << 8];
                if (c2 > '\u0001') {
                    cArray[n5++] = c2;
                    continue;
                }
                if (c2 == '\u0001') {
                    cArray[n5++] = 65533;
                    --n4;
                    continue;
                }
                c2 = V2CJPConverter.checkMS2U(n7, n6);
                if (c2 > '\u0001') {
                    cArray[n5++] = c2;
                    continue;
                }
                if (c2 != '\u0001') continue;
                cArray[n5++] = 65533;
                --n4;
                continue;
            }
            cArray[n5++] = 65533;
            --n4;
        }
        if (bl) {
            return new String(cArray, 0, n5);
        }
        if (n5 > n2) {
            char[] cArray2 = new char[n5 + 2];
            System.arraycopy(cArray, 0, cArray2, 0, n5);
            cArray = cArray2;
        }
        V2CJPConverter.setCharLength(cArray, n5);
        return cArray;
    }

    private static String createCP51232String(byte[] byArray, int n, int n2) {
        return (String)V2CJPConverter.createCP51232CharObject(byArray, n, n2, true);
    }

    private static Object createCP51232CharObject(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray == null) {
            return null;
        }
        int n3 = n + n2;
        if (byArray.length < n + n2) {
            return null;
        }
        if (n2 == 0) {
            return bl ? "" : (Object)new char[2];
        }
        char[] cArray = new char[bl ? n2 : n2 + 2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            int n7;
            int n8;
            if ((n8 = byArray[n4++] & 0xFF) < 128) {
                cArray[n5++] = cl1stByte[n8];
                continue;
            }
            if (n8 == 142) {
                if (n4 >= n3) {
                    cArray[n5++] = 65533;
                    break;
                }
                if ((n7 = byArray[n4++] & 0xFF) >= 161 && n7 < 255) {
                    n6 = cl1stByte[n7];
                    if (n6 != 65535) {
                        cArray[n5++] = n6;
                        continue;
                    }
                    cArray[n5++] = 65533;
                    continue;
                }
                cArray[n5++] = 65533;
                continue;
            }
            if (n8 == 143) {
                if (n4 >= n3 - 1) {
                    cArray[n5++] = 65533;
                    break;
                }
                n4 += 2;
                cArray[n5++] = 65533;
                continue;
            }
            if (n4 >= n3) {
                cArray[n5++] = 65533;
                break;
            }
            n7 = (byArray[n4++] & 0xFF) - 160;
            if ((n8 -= 160) < 1 || n8 == 95) {
                cArray[n5++] = 65533;
                continue;
            }
            if (n7 >= 1 && n7 < 95) {
                int n9;
                if (n8 <= 62) {
                    if (n8 % 2 == 1) {
                        n6 = (n8 + 257) / 2;
                        n9 = n7 < 64 ? n7 + 63 : n7 + 64;
                    } else {
                        n6 = (n8 + 256) / 2;
                        n9 = n7 + 158;
                    }
                } else if (n8 % 2 == 1) {
                    n6 = (n8 + 385) / 2;
                    n9 = n7 < 64 ? n7 + 63 : n7 + 64;
                } else {
                    n6 = (n8 + 384) / 2;
                    n9 = n7 + 158;
                }
                char c = clMS2U[n6 | n9 << 8];
                if (c > '\u0001') {
                    cArray[n5++] = c;
                    continue;
                }
                if (c == '\u0001') {
                    cArray[n5++] = 65533;
                    continue;
                }
                c = V2CJPConverter.checkMS2U(n6, n9);
                if (c > '\u0001') {
                    cArray[n5++] = c;
                    continue;
                }
                if (c != '\u0001') continue;
                cArray[n5++] = 65533;
                continue;
            }
            cArray[n5++] = 65533;
        }
        if (bl) {
            return new String(cArray, 0, n5);
        }
        if (n5 > n2) {
            char[] cArray2 = new char[n5 + 2];
            System.arraycopy(cArray, 0, cArray2, 0, n5);
            cArray = cArray2;
        }
        V2CJPConverter.setCharLength(cArray, n5);
        return cArray;
    }

    private static byte[] getCP51232Bytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(sMS932);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while (n < n3) {
            int n4;
            if ((n4 = byArray[n++] & 0xFF) < 128) {
                byArray2[n2++] = (byte)n4;
                continue;
            }
            if (n4 >= 160 && n4 < 224) {
                byArray2[n2++] = -114;
                byArray2[n2++] = (byte)n4;
                continue;
            }
            if (n4 >= 129 && n4 < 253) {
                if (n >= n3) break;
                int n5 = byArray[n++] & 0xFF;
                if (n4 >= 240) {
                    int n6 = (n4 << 8 | n5) - 64064;
                    int n7 = 0;
                    if (n6 >= 0 && n6 < clMS932DupTrans.length) {
                        n7 = clMS932DupTrans[n6];
                    }
                    if (n7 > 0) {
                        n4 = n7 >> 8 & 0xFF;
                        n5 = n7 & 0xFF;
                    } else {
                        byArray2[n2++] = 63;
                        continue;
                    }
                }
                n4 = n4 < 160 ? (n4 - 128) * 2 : (n4 - 192) * 2;
                if (n5 >= 64 && n5 < 127) {
                    --n4;
                    n5 -= 63;
                } else if (n5 >= 128 && n5 < 159) {
                    --n4;
                    n5 -= 64;
                } else if (n5 >= 159 && n5 < 253) {
                    n5 -= 158;
                } else {
                    byArray2[n2++] = 63;
                    continue;
                }
                byArray2[n2++] = (byte)(n4 + 160);
                byArray2[n2++] = (byte)(n5 + 160);
                continue;
            }
            byArray2[n2++] = 63;
        }
        if (n2 < byArray2.length) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    static char[] createCharArray(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        char[] cArray = new char[n + 2];
        if (n > 0) {
            string.getChars(0, n, cArray, 0);
        }
        V2CJPConverter.setCharLength(cArray, n);
        return cArray;
    }

    static char[] createCharArray(byte[] byArray, int n, int n2, String string) {
        if (sMS932.equals(string)) {
            return (char[])V2CJPConverter.createMS932CharObject(byArray, n, n2, false);
        }
        if (sEUCJP.equals(string)) {
            return (char[])V2CJPConverter.createCP51232CharObject(byArray, n, n2, false);
        }
        try {
            String string2 = new String(byArray, n, n2, string);
            int n3 = string2.length();
            char[] cArray = new char[n3 + 2];
            string2.getChars(0, n3, cArray, 0);
            V2CJPConverter.setCharLength(cArray, n3);
            return cArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static String createString(byte[] byArray, String string) {
        return byArray != null ? V2CJPConverter.createString(byArray, 0, byArray.length, string) : "";
    }

    static String createString(byte[] byArray, int n, int n2, String string) {
        if (sMS932.equals(string)) {
            return V2CJPConverter.createMS932String(byArray, n, n2);
        }
        if (sEUCJP.equals(string)) {
            return V2CJPConverter.createCP51232String(byArray, n, n2);
        }
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static byte[] getBytes(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (sEUCJP.equals(string2)) {
            return V2CJPConverter.getCP51232Bytes(string);
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    static String convertCP51232ToISO88591(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = V2CJPConverter.getCP51232Bytes(string);
        if (byArray == null) {
            return string;
        }
        try {
            return new String(byArray, sISO88591);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static String convertISO88591ToCP51232(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(sISO88591);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray != null ? V2CJPConverter.createCP51232String(byArray, 0, byArray.length) : string;
    }

    static boolean checkCharsetConversion(String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = V2CJPConverter.replaceWaveDash(string, string2);
        byte[] byArray = V2CJPConverter.getBytes(string3, string2);
        if (byArray == null) {
            return false;
        }
        String string4 = V2CJPConverter.createString(byArray, string2);
        return string4 != null && string4.equals(string3);
    }

    static String replaceWaveDash(String string, String string2) {
        return string2.equals(sMS932) || string2.equals(sEUCJP) ? V2CJPConverter.replaceWaveDash(string) : string;
    }

    static String replaceWaveDash(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c == '\u00a5') {
                n2 = 92;
            } else if (c == '\u301c') {
                n2 = 65374;
            } else if (c == '\u203e') {
                n2 = 65507;
            } else if (c == '\u2014') {
                n2 = 8213;
            } else if (c == '\u2016') {
                n2 = 8741;
            } else {
                if (c != '\u2212') continue;
                n2 = 65293;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string);
            }
            stringBuffer.setCharAt(i, (char)n2);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    static String urlEncode(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            if (sEUCJP.equals(string2)) {
                byte[] byArray = V2CJPConverter.getCP51232Bytes(string);
                string = new String(byArray, sISO88591);
                string2 = sISO88591;
            }
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    static String urlDecode(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }
}

