/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import org.monazilla.v2c.V2CKeywordItem;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;

public abstract class V2CKeyword {
    V2CProperty vpOwner;
    final ArrayList alItems = new ArrayList();
    String sKey;

    public V2CKeyword(V2CProperty v2CProperty) {
        this(v2CProperty, null, null);
    }

    public V2CKeyword(V2CProperty v2CProperty, String string, Object clazz) {
        if (v2CProperty == null) {
            return;
        }
        this.vpOwner = v2CProperty;
        if (clazz == null) {
            clazz = this.getClass();
        }
        v2CProperty.putTransient(clazz, this);
        if (string == null) {
            string = this.getSaveKeyString();
        }
        this.sKey = string;
        this.restore();
    }

    abstract V2CKeywordItem createItem(V2CPackedPropValue var1);

    abstract String getSaveKeyString();

    private void restore() {
        if (this.vpOwner == null || this.sKey == null) {
            return;
        }
        V2CPackedPropValue[] v2CPackedPropValueArray = this.vpOwner.getPackedValueArray(this.sKey, 'W');
        if (v2CPackedPropValueArray == null) {
            return;
        }
        int n = (int)(System.currentTimeMillis() / 60000L);
        for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
            V2CKeywordItem v2CKeywordItem = this.createItem(v2CPackedPropValueArray[i]);
            if (!v2CKeywordItem.isValid() || v2CKeywordItem.isExpired(n, -1)) continue;
            this.alItems.add(v2CKeywordItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void checkAppliedTimeChanged(int n) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.alItems;
        synchronized (arrayList2) {
            int n2 = arrayList.size();
            if (n2 == 0) {
                return;
            }
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                V2CKeywordItem v2CKeywordItem = this.get(i);
                if (!v2CKeywordItem.checkAppliedTimeChange(n)) continue;
                bl = true;
            }
            if (bl) {
                this.requestSave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void checkExpiration(int n, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.alItems;
        synchronized (arrayList2) {
            int n3 = arrayList.size();
            if (n3 == 0) {
                return;
            }
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                V2CKeywordItem v2CKeywordItem = this.get(i);
                if (!v2CKeywordItem.checkExpiration(n, n2)) continue;
                bl = true;
            }
            if (bl) {
                this.requestSave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestSave() {
        if (this.vpOwner == null) {
            return;
        }
        ArrayList arrayList = this.alItems;
        ArrayList<V2CPackedPropValue> arrayList2 = new ArrayList<V2CPackedPropValue>();
        ArrayList arrayList3 = arrayList;
        synchronized (arrayList3) {
            for (int i = 0; i < arrayList.size(); ++i) {
                V2CPackedPropValue v2CPackedPropValue = this.get(i).getSaveValue();
                if (v2CPackedPropValue == null) continue;
                arrayList2.add(v2CPackedPropValue);
            }
        }
        this.vpOwner.putPackedValueArray(this.getSaveKeyString(), arrayList2.toArray(new V2CPackedPropValue[arrayList2.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V2CKeywordItem get(int n) {
        ArrayList arrayList = this.alItems;
        synchronized (arrayList) {
            return (V2CKeywordItem)this.alItems.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        ArrayList arrayList = this.alItems;
        synchronized (arrayList) {
            this.alItems.clear();
            this.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        ArrayList arrayList = this.alItems;
        synchronized (arrayList) {
            return this.alItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(Object object) {
        boolean bl;
        ArrayList arrayList = this.alItems;
        synchronized (arrayList) {
            bl = this.alItems.add(object);
        }
        this.requestSave();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object remove(int n) {
        Object e;
        ArrayList arrayList = this.alItems;
        synchronized (arrayList) {
            e = this.alItems.remove(n);
        }
        this.requestSave();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean move(int n, boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.alItems;
        synchronized (arrayList2) {
            if (bl && n <= 0 || !bl && n >= arrayList.size() - 1) {
                return false;
            }
            int n2 = bl ? n - 1 : n + 1;
            Object e = arrayList.get(n);
            arrayList.set(n, arrayList.get(n2));
            arrayList.set(n2, e);
        }
        this.requestSave();
        return true;
    }
}

