/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMiscUtil2;
import org.monazilla.v2c.V2CMovieUtil;
import org.monazilla.v2c.V2CNGUrl;
import org.monazilla.v2c.V2CResTextSegment;
import org.monazilla.v2c.V2CShortURLUtil;
import org.monazilla.v2c.V2CURLHolder;

public final class V2CLinkTextSegment
extends V2CResTextSegment
implements V2CURLHolder {
    private static final HashSet hsWrongURLs = new HashSet();
    String sURL;
    V2CLink vlLink;
    Object oKey;
    int nLastCheckTime;
    boolean bSuppressAutoDL;
    boolean bTypeChecked;
    boolean bImage;
    boolean bMovie;
    short shShortURL;
    short shNGURL;

    public V2CLinkTextSegment(int n, char[] cArray, int n2, int n3) {
        super(n, cArray, n2, n3, 8);
    }

    public V2CLinkTextSegment(int n, char[] cArray, int n2, int n3, String string, boolean bl) {
        super(n, cArray, n2, n3, 8);
        this.bSuppressAutoDL = bl;
        this.parseURL(string);
    }

    void setLink(V2CLink v2CLink) {
        V2CLink v2CLink2 = this.vlLink;
        this.vlLink = v2CLink;
        if (v2CLink != v2CLink2) {
            this.oKey = v2CLink != null ? v2CLink.getThumbnailKey() : null;
        }
    }

    void checkThumbnailKey() {
        if (this.vlLink != null && this.oKey == null) {
            this.oKey = this.vlLink.getThumbnailKey();
        }
    }

    public boolean parseURL() {
        return this.parseURL(new String(this.clMsg, this.iSegmentStart, this.nLength));
    }

    public boolean parseURL(boolean bl, int n, int n2) {
        String string;
        if (!bl) {
            return this.parseURL();
        }
        StringBuffer stringBuffer = new StringBuffer(this.nLength + n2 * 4);
        stringBuffer.append(this.clMsg, this.iSegmentStart, n - this.iSegmentStart);
        stringBuffer.append("xn--");
        try {
            string = V2CMiscUtil2.toPunycode(new String(this.clMsg, n, n2));
        }
        catch (Exception exception) {
            return false;
        }
        if (string == null) {
            return false;
        }
        stringBuffer.append(string);
        stringBuffer.append(this.clMsg, n + n2, this.nLength - (n + n2 - this.iSegmentStart));
        return this.parseURL(stringBuffer.toString());
    }

    private boolean parseURL(String string) {
        int n;
        char c = string.charAt(0);
        if (c != 'h') {
            if (c == 't') {
                string = string.charAt(1) == 't' ? "h" + string : "ht" + string;
            } else if (c == 'w') {
                string = "http://" + string;
            } else if (c == '@') {
                string = "http://twitter.com/" + string.substring(1);
            } else if (c == '#') {
                string = "http://twitter.com/#search?q=" + V2CJPConverter.urlEncode(string, "UTF-8");
            } else if (c == '\uff03') {
                string = "http://twitter.com/#search?q=%23" + V2CJPConverter.urlEncode(string.substring(1), "UTF-8");
            }
        }
        if (string.length() > 14 && string.charAt(13) == '/' && string.startsWith("http://ime.nu")) {
            string = "http://" + string.substring(14);
        }
        if (c == 'f') {
            n = 6;
        } else {
            int n2 = n = string.charAt(4) == ':' ? 7 : 8;
        }
        if (string.length() <= n) {
            return false;
        }
        return this.setURLString(string);
    }

    boolean setURLString(String string) {
        String string2;
        this.sURL = string2 = V2CMiscUtil.replaceURLEscapes(string);
        try {
            new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.sURL = null;
            if (!hsWrongURLs.contains(string)) {
                V2CMiscUtil.printMalformedURLException(malformedURLException);
                hsWrongURLs.add(string);
            }
            return false;
        }
        this.setLink(V2CLink.getFromHistory(string2));
        return true;
    }

    public String getURLString() {
        return this.sURL;
    }

    boolean isHTTP() {
        String string = this.sURL;
        return string != null && string.toLowerCase().startsWith("http");
    }

    V2CLink getLink(int n) {
        if (this.sURL != null && V2CLink.changedSince(this.nLastCheckTime)) {
            this.setLink(V2CLink.getFromHistory(this.sURL));
            this.nLastCheckTime = n;
        }
        return this.vlLink;
    }

    public V2CLink getLink(boolean bl) {
        if (bl && this.sURL != null) {
            this.setLink(V2CLink.getFromHistory(this.sURL));
        }
        return this.vlLink;
    }

    V2CLink getLinkForNGFile() {
        V2CLink v2CLink = this.vlLink;
        return v2CLink != null ? v2CLink : V2CLink.getLinkForNGFile(this.sURL);
    }

    V2CLink getLinkOrCreate(boolean bl) {
        if (this.vlLink == null && this.sURL != null) {
            this.setLink(V2CLink.getLinkOrCreate0(this.sURL, bl));
        }
        return this.vlLink;
    }

    void addToNGFile(String string) {
        V2CLink v2CLink = this.getLinkForNGFile();
        if (v2CLink != null) {
            v2CLink.addToNGFile(string);
        }
    }

    void deleteLinkCache() {
        V2CLink v2CLink = this.vlLink;
        this.setLink(null);
        if (v2CLink != null) {
            v2CLink.deleteHistory();
        }
    }

    void disableLink() {
        if (this.vlLink == null) {
            if (this.sURL == null) {
                return;
            }
            this.setLink(V2CLink.getLinkOrCreate0(this.sURL, false));
        }
        if (this.vlLink != null) {
            this.vlLink.disable();
        }
    }

    boolean getSuppressAutoDL() {
        return this.bSuppressAutoDL;
    }

    void resetLinkTypeCheck() {
        this.bTypeChecked = false;
        this.bMovie = false;
        this.bImage = false;
        this.shNGURL = 0;
    }

    private synchronized void checkType() {
        if (this.bTypeChecked) {
            if (V2CShortURLUtil.isValid(this.shShortURL)) {
                return;
            }
            this.shShortURL = V2CShortURLUtil.getChangeCount();
            this.resetLinkTypeCheck();
        }
        this.bTypeChecked = true;
        String string = V2CShortURLUtil.expandTCo(this.sURL);
        if (string != null) {
            if (V2CMovieUtil.isMovieURL(string)) {
                this.bMovie = true;
            }
            if (V2CMiscUtil.checkImageLink(string)) {
                this.bImage = true;
            }
            this.shNGURL = V2CNGUrl.isNG(string);
        }
    }

    boolean isMovieLink() {
        this.checkType();
        return this.bMovie;
    }

    boolean isImageLink() {
        this.checkType();
        return this.bImage;
    }

    boolean isNGURL() {
        this.checkType();
        short s = this.shNGURL;
        if (!V2CNGUrl.isValid(s)) {
            this.shNGURL = s = V2CNGUrl.isNG(V2CShortURLUtil.expandTCo(this.sURL));
        }
        return (s & 0x8000) != 0;
    }
}

