/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLogSearcher;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadList;
import org.monazilla.v2c.V2CThreadOpenRequest;

public class V2CLogSearchResultList
extends V2CThreadList {
    private static final int DATE_EQUAL = 0;
    private static final int DATE_BEFORE = -1;
    private static final int DATE_AFTER = 1;
    private static final int DATE_NODATE = -2;
    final V2CLogSearcher vLogSearcher;
    boolean bIsOK;
    Vector vResults = new Vector();
    volatile boolean bFinished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void openResultList(V2CLogSearcher v2CLogSearcher, boolean bl) {
        V2CLogSearchResultList v2CLogSearchResultList;
        HashMap hashMap = hmThreadList;
        synchronized (hashMap) {
            V2CThreadList v2CThreadList = V2CLogSearchResultList.getThreadList(v2CLogSearcher);
            if (v2CThreadList instanceof V2CLogSearchResultList) {
                v2CLogSearchResultList = (V2CLogSearchResultList)v2CThreadList;
            } else {
                v2CLogSearchResultList = new V2CLogSearchResultList(v2CLogSearcher);
                if (!v2CLogSearchResultList.bIsOK) {
                    return;
                }
                V2CLogSearchResultList.putThreadList(v2CLogSearcher, v2CLogSearchResultList);
            }
        }
        v2CLogSearchResultList.openThreadList(v2CLogSearcher.getTitleString(), V2CLogSearcher.getIcon(), false, bl);
    }

    public V2CLogSearchResultList(V2CLogSearcher v2CLogSearcher) {
        this.vLogSearcher = v2CLogSearcher;
        this.bIsOK = true;
    }

    public String getTitleString() {
        return this.vLogSearcher.getTitleString();
    }

    public Icon getIcon() {
        return V2CLogSearcher.getIcon();
    }

    public Icon getDefaultIcon() {
        return V2CLogSearcher.getIcon();
    }

    Object getItem() {
        return this.vLogSearcher;
    }

    boolean displayList(boolean bl) {
        if (this.bFinished) {
            return true;
        }
        V2CLogSearcher v2CLogSearcher = this.vLogSearcher;
        if (v2CLogSearcher.getSearchInBoard()) {
            V2CBoardItem[] v2CBoardItemArray = v2CLogSearcher.getBoardList();
            for (int i = 0; i < v2CBoardItemArray.length; ++i) {
                if (this.searchInBoard(v2CBoardItemArray[i])) continue;
                this.bFinished = true;
                return false;
            }
        } else {
            this.searchInThreadArray(v2CLogSearcher.getThreadList());
        }
        this.bFinished = true;
        return true;
    }

    void openSelectedThreads(boolean bl, final boolean bl2, final boolean bl3) {
        final V2CThreadItem[] v2CThreadItemArray = this.getSelectedThreads();
        if (v2CThreadItemArray == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = true;
                for (int i = 0; i < v2CThreadItemArray.length; ++i) {
                    V2CThreadItem v2CThreadItem = v2CThreadItemArray[i];
                    if (v2CThreadItem == null) continue;
                    V2CThreadOpenRequest v2CThreadOpenRequest = null;
                    int[] nArray = V2CLogSearchResultList.this.vLogSearcher.search(v2CThreadItem, true);
                    if (nArray != null && nArray.length > 0) {
                        v2CThreadOpenRequest = new V2CThreadOpenRequest();
                        v2CThreadOpenRequest.setResNumsToDisplay(nArray);
                        v2CThreadOpenRequest.setLogSearcher(V2CLogSearchResultList.this.vLogSearcher);
                    }
                    if (bl3) {
                        if (v2CThreadOpenRequest == null) {
                            v2CThreadOpenRequest = new V2CThreadOpenRequest();
                        }
                        v2CThreadOpenRequest.setOpenBackground(true);
                    }
                    v2CThreadItem.open(false, !bl || bl2, v2CThreadOpenRequest);
                    bl = false;
                }
            }
        });
    }

    void listAllThread() {
    }

    boolean searchInBoard(V2CBoardItem v2CBoardItem) {
        V2CThreadItem[] v2CThreadItemArray = v2CBoardItem.getBoardHashMap().getThreads(false);
        if (v2CThreadItemArray == null) {
            return true;
        }
        return this.searchInThreadArray(v2CThreadItemArray);
    }

    boolean searchInThreadArray(V2CThreadItem[] v2CThreadItemArray) {
        this.psProgState.setBounds(0, v2CThreadItemArray.length);
        for (int i = 0; i < v2CThreadItemArray.length; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (this.bDetouched) {
                Thread.currentThread().interrupt();
                return false;
            }
            this.psProgState.setValue(i);
            V2CThreadItem v2CThreadItem = v2CThreadItemArray[i];
            if (this.vLogSearcher.search(v2CThreadItem, false) == null) continue;
            final Object[] objectArray = this.createThreadListRowArray(v2CThreadItem);
            this.vResults.add(v2CThreadItem);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        V2CLogSearchResultList.this.vtlTableModel.addThread(objectArray);
                    }
                });
                continue;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }
}

