/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CFixedSizePanel;
import org.monazilla.v2c.V2CMemoItem;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CWritePanel;

public class V2CMemoSelector
implements ActionListener {
    static ImageIcon vPrevIcon;
    static ImageIcon vNextIcon;
    static ImageIcon vPrevRolloverIcon;
    static ImageIcon vNextRolloverIcon;
    final V2CWritePanel vWritePanel;
    final JPanel jPanel;
    final JComboBox jcbMemo;
    JButton jbPrev;
    JButton jbNext;
    int iSelectedIndex;

    private static void createIcons() {
        if (vPrevIcon != null) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] nArray = new int[]{2, 11, 11};
        int[] nArray2 = new int[]{9, 13, 4};
        graphics2D.setColor(new Color(0x7F7F7F7F, true));
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setColor(Color.BLACK);
        graphics2D.translate(0, -1);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.dispose();
        vPrevIcon = new ImageIcon(bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D2.setTransform(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 16.0f, 0.0f));
        graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D2.dispose();
        vNextIcon = new ImageIcon(bufferedImage2);
        BufferedImage bufferedImage3 = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D3 = (Graphics2D)bufferedImage3.getGraphics();
        graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D3.setColor(new Color(0x7FBFBFBF, true));
        graphics2D3.fillOval(0, 0, 16, 16);
        graphics2D3.setColor(new Color(0x7F7F7F7F, true));
        graphics2D3.fillPolygon(nArray, nArray2, 3);
        graphics2D3.setColor(Color.BLACK);
        graphics2D3.translate(0, -1);
        graphics2D3.fillPolygon(nArray, nArray2, 3);
        graphics2D3.dispose();
        vPrevRolloverIcon = new ImageIcon(bufferedImage3);
        BufferedImage bufferedImage4 = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D4 = (Graphics2D)bufferedImage4.getGraphics();
        graphics2D4.setTransform(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 16.0f, 0.0f));
        graphics2D4.drawImage((Image)bufferedImage3, 0, 0, null);
        graphics2D4.dispose();
        vNextRolloverIcon = new ImageIcon(bufferedImage4);
        if (V2CApp.isMacintosh()) {
            vPrevIcon = vPrevRolloverIcon;
            vNextIcon = vNextRolloverIcon;
            vPrevRolloverIcon = null;
            vNextRolloverIcon = null;
        }
    }

    private static DefaultComboBoxModel createComboBoxModel() {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        defaultComboBoxModel.addElement("\u30b9\u30ec\u6bce");
        V2CMemoItem[] v2CMemoItemArray = V2CMemoItem.restore();
        for (int i = 0; i < v2CMemoItemArray.length; ++i) {
            defaultComboBoxModel.addElement(v2CMemoItemArray[i]);
        }
        return defaultComboBoxModel;
    }

    static V2CMemoItem getMemo(int n) {
        if (--n < 0) {
            return null;
        }
        V2CMemoItem[] v2CMemoItemArray = V2CMemoItem.restore();
        if (n >= v2CMemoItemArray.length) {
            n = 0;
        }
        return v2CMemoItemArray[n];
    }

    public V2CMemoSelector(V2CWritePanel v2CWritePanel, int n) {
        JButton jButton;
        JButton jButton2;
        JComboBox jComboBox;
        V2CFixedSizePanel v2CFixedSizePanel = new V2CFixedSizePanel();
        this.jPanel = v2CFixedSizePanel;
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.jcbMemo = jComboBox = V2CSwingUtil.createComboBox(V2CMemoSelector.createComboBoxModel());
        jComboBox.setFocusable(false);
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        v2CFixedSizePanel.add((Component)jComboBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        this.vWritePanel = v2CWritePanel;
        this.iSelectedIndex = n = V2CMiscUtil.restrictRange(0, n, V2CMemoItem.getMemoCount());
        jComboBox.setSelectedIndex(n);
        jComboBox.addActionListener(this);
        V2CMemoSelector.createIcons();
        Dimension dimension = new Dimension(20, 20);
        this.jbPrev = jButton2 = new JButton(vPrevIcon);
        jButton2.setRolloverIcon(vPrevRolloverIcon);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        jButton2.setContentAreaFilled(false);
        jButton2.setBorderPainted(false);
        jButton2.setFocusable(false);
        jButton2.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        v2CFixedSizePanel.add((Component)jButton2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbNext = jButton = new JButton(vNextIcon);
        jButton.setRolloverIcon(vNextRolloverIcon);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        v2CFixedSizePanel.add((Component)jButton, gridBagConstraints);
    }

    JComponent getComponent() {
        return this.jPanel;
    }

    void selectMemo(int n) {
        V2CMemoItem v2CMemoItem = V2CMemoSelector.getMemo(n);
        if (v2CMemoItem != null) {
            this.jcbMemo.setSelectedItem(v2CMemoItem);
        }
    }

    void selectNext(boolean bl) {
        int n = V2CMemoItem.getMemoCount();
        if (n <= 0) {
            return;
        }
        ++n;
        int n2 = this.jcbMemo.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        this.jcbMemo.setSelectedIndex((n2 + (bl ? 1 : n - 1)) % n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jcbMemo) {
            int n = this.jcbMemo.getSelectedIndex();
            if (n == this.iSelectedIndex) {
                return;
            }
            this.iSelectedIndex = n;
            Object e = this.jcbMemo.getItemAt(n);
            V2CMemoItem v2CMemoItem = e instanceof V2CMemoItem ? (V2CMemoItem)e : null;
            this.vWritePanel.memoSelectionChanged(v2CMemoItem);
        } else if (object == this.jbPrev) {
            this.selectNext(false);
        } else if (object == this.jbNext) {
            this.selectNext(true);
        }
    }
}

