/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.monazilla.v2c.V2CAbstractMiniSearch;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CMiniSearch
extends V2CAbstractMiniSearch {
    static final Icon icFind = V2CSwingUtil.getItemIcon("Find");

    public V2CMiniSearch(int n) {
        super(n, new GridBagLayout());
        this.setOpaque(false);
        this.nWidth = V2CMain.getUserProperty().getInt(this.sWidthKey, 110);
        GridBagConstraints gridBagConstraints = V2CSwingUtil.createGridBagConstraints();
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        JLabel jLabel = new JLabel(icFind);
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        jLabel.addMouseListener(new IconClickListener());
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = V2CSwingUtil.isSynthLaF() ? new Insets(0, 0, 1, 0) : insets;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jtfSearchWords, gridBagConstraints);
    }

    int getMinimumWidth() {
        return 40;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(this.nWidth, dimension.height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    class IconClickListener
    extends MouseAdapter {
        IconClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            String string;
            if (V2CMiniSearch.this.iType == 0) {
                string = "TF";
            } else if (V2CMiniSearch.this.iType == 1 || V2CMiniSearch.this.iType == 3) {
                string = "LF";
            } else if (V2CMiniSearch.this.iType == 2) {
                string = "DF";
            } else {
                return;
            }
            if (mouseEvent.getClickCount() > 1) {
                mouseEvent = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), 1, mouseEvent.isPopupTrigger());
            }
            String string2 = V2CMouseClickManager.checkClickAction(string, mouseEvent);
            System.out.println(string2);
            if (string2 == null) {
                return;
            }
            if (string2.equals("fF")) {
                V2CMiniSearch.this.filter();
            } else if (string2.equals("fD")) {
                V2CMiniSearch.this.resetDisplay();
            } else if (string2.equals("fC")) {
                V2CMiniSearch.this.clear(null);
            } else if (string2.equals("fN")) {
                V2CMiniSearch.this.findNext(true);
            } else if (string2.equals("fP")) {
                V2CMiniSearch.this.findNext(false);
            }
        }
    }
}

