/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.mac.V2CMacApplicationHandler;

public abstract class V2CMouseExitListener
implements MouseInputListener,
MouseWheelListener {
    JComponent jcParent;
    boolean bDragged;
    boolean bButtonDown;
    Component cmpTarget;

    public V2CMouseExitListener() {
        this(null);
    }

    public V2CMouseExitListener(JComponent jComponent) {
        this.jcParent = jComponent;
    }

    void addListeners(JComponent jComponent) {
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
        jComponent.addMouseWheelListener(this);
    }

    void setParent(JComponent jComponent) {
        this.jcParent = jComponent;
    }

    abstract void doExitAction(MouseEvent var1);

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    boolean isOutside(MouseEvent mouseEvent) {
        Point point;
        if (V2CApp.isMacintosh()) {
            point = V2CMacApplicationHandler.getMouseLocationOnScreen();
            SwingUtilities.convertPointFromScreen(point, mouseEvent.getComponent());
        } else {
            point = mouseEvent.getPoint();
        }
        Dimension dimension = mouseEvent.getComponent().getSize();
        return point.x <= 0 || point.y <= 0 || point.x >= dimension.width || point.y >= dimension.height;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.bButtonDown && this.isOutside(mouseEvent)) {
            this.doExitAction(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.bButtonDown = true;
        this.bDragged = false;
        this.redispatchMouseEvent(mouseEvent, true, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.bButtonDown = false;
        this.redispatchMouseEvent(mouseEvent, false, false);
        this.cmpTarget = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.bDragged = true;
        this.redispatchMouseEvent(mouseEvent, false, true);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, true, true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, false);
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        if (this.jcParent == null) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (bl || this.cmpTarget == null) {
            this.cmpTarget = V2CMouseExitListener.getDeepestComponentAt(this.jcParent, point.x, point.y, bl2);
        }
        if (this.cmpTarget == null) {
            return;
        }
        Point point2 = SwingUtilities.convertPoint(this.jcParent, point, this.cmpTarget);
        this.cmpTarget.dispatchEvent(new MouseEvent(this.cmpTarget, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)point2.getX(), (int)point2.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
    }

    static Component getDeepestComponentAt(Component component, int n, int n2, boolean bl) {
        if (!component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                EventListener[] eventListenerArray;
                Component component2 = componentArray[i];
                if (component2 == null || !component2.isVisible()) continue;
                Point point = component2.getLocation();
                if ((component2 = component2 instanceof Container ? V2CMouseExitListener.getDeepestComponentAt(component2, n - point.x, n2 - point.y, bl) : component2.getComponentAt(n - point.x, n2 - point.y)) == null || !component2.isVisible() || (eventListenerArray = bl ? component2.getMouseMotionListeners() : component2.getMouseListeners()).length <= 0) continue;
                return component2;
            }
        }
        return component;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.jcParent == null) {
            return;
        }
        Point point = mouseWheelEvent.getPoint();
        Component component = SwingUtilities.getDeepestComponentAt(this.jcParent, (int)point.getX(), (int)point.getY());
        if (component == null) {
            return;
        }
        Point point2 = SwingUtilities.convertPoint(this.jcParent, point, component);
        component.dispatchEvent(new MouseWheelEvent(component, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (int)point2.getX(), (int)point2.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
    }
}

