/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.EventQueue;
import java.awt.Point;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CFullPageYTPanel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMovieSP;
import org.monazilla.v2c.V2CNVPanel;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CYTPanel;

public class V2CMovieUtil {
    private static HashMap hmProps = new HashMap();
    private static final Pattern pNVID = Pattern.compile("[A-Za-z\\d]{3,}");
    private static final Pattern pPreYT = Pattern.compile("https?://(?:\\w+\\.)?youtube.com/(?:(?:watch)?\\?(?:\\w+=[^&]*&)*v=|v/)");
    private static final String sPreNormalNV = "http://www.nicovideo.jp/watch/";
    private static final String sPreShortNV = "http://nico.ms/";
    private static final String sPreLiveNV = "http://live.nicovideo.jp/watch/";
    static final String sPreSeigaNV = "http://seiga.nicovideo.jp/";

    static void setMovie() {
        V2CMovieSP v2CMovieSP = V2CMovieUtil.createMovieSP();
        if (!v2CMovieSP.showDialog()) {
            return;
        }
        V2CMovieUtil.postConfigMovie(v2CMovieSP);
    }

    static V2CMovieSP createMovieSP() {
        return new V2CMovieSP(V2CYTPanel.nFMT);
    }

    static void postConfigMovie(V2CMovieSP v2CMovieSP) {
        V2CYTPanel.setUseFMT(v2CMovieSP.getFMT());
        V2CNVPanel.setSmallOffsets(v2CMovieSP.getSmallOffsets());
    }

    static boolean isMovieURL(String string) {
        return V2CMovieUtil.isYTURL(string) || V2CMovieUtil.isNVURL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerTitle(String string, String string2) {
        HashMap hashMap = hmProps;
        synchronized (hashMap) {
            hmProps.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getTitle(String string) {
        HashMap hashMap = hmProps;
        synchronized (hashMap) {
            return (String)hmProps.get(string);
        }
    }

    static String getPopupString(String string) {
        String string2 = null;
        String string3 = null;
        int n = V2CMovieUtil.getYTPrefix(string);
        if (n > 0) {
            string2 = "Youtube";
            string3 = V2CYTPanel.extractID(string, n, true);
        } else {
            n = V2CMovieUtil.getNVPrefix(string);
            if (n > 0) {
                string2 = V2CMovieUtil.isNVSeiga(string) ? "\u30cb\u30b3\u30cb\u30b3\u9759\u753b" : "\u30cb\u30b3\u30cb\u30b3\u52d5\u753b";
                string3 = V2CNVPanel.extractID(string, n, true);
            }
        }
        if (string2 == null || string3 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\u2605 ");
        stringBuffer.append(string2);
        String string4 = V2CMovieUtil.getTitle(string3);
        if (string4 != null) {
            stringBuffer.append('\n');
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    private static boolean isNVURL(String string) {
        int n = V2CMovieUtil.getNVPrefix(string);
        return n > 0 && n < string.length();
    }

    static boolean isNVSeiga(String string) {
        return string.startsWith(sPreSeigaNV) && string.length() > 26;
    }

    static int getNVPrefix(String string) {
        if (string == null) {
            return -1;
        }
        if (string.startsWith(sPreNormalNV)) {
            return pNVID.matcher(string.substring(sPreNormalNV.length())).lookingAt() ? sPreNormalNV.length() : -1;
        }
        if (string.startsWith(sPreShortNV)) {
            return pNVID.matcher(string.substring(sPreShortNV.length())).lookingAt() ? sPreShortNV.length() : -1;
        }
        if (string.startsWith(sPreLiveNV)) {
            return pNVID.matcher(string.substring(sPreLiveNV.length())).lookingAt() ? sPreLiveNV.length() : -1;
        }
        if (string.startsWith(sPreSeigaNV)) {
            int n = sPreSeigaNV.length();
            if (string.regionMatches(n, "watch/", 0, 6)) {
                return pNVID.matcher(string.substring(n += 6)).lookingAt() ? n : -1;
            }
            if (string.regionMatches(n, "bbs/", 0, 4)) {
                return pNVID.matcher(string.substring(n += 4)).lookingAt() ? n : -1;
            }
        }
        return -1;
    }

    private static boolean isYTURL(String string) {
        int n = V2CMovieUtil.getYTPrefix(string);
        return n > 0 && n < string.length();
    }

    static int getYTPrefix(String string) {
        if (string == null) {
            return -1;
        }
        if (string.startsWith("http://youtu.be/")) {
            return 16;
        }
        Matcher matcher = pPreYT.matcher(string);
        return matcher.lookingAt() ? matcher.end() : -1;
    }

    public static boolean tryPopupLater(URL uRL, Point point) {
        if (uRL == null) {
            return false;
        }
        final String string = uRL.toExternalForm();
        if (!V2CMovieUtil.isMovieURL(string)) {
            return false;
        }
        final Point point2 = point != null ? point : V2CSwingUtil.getMouseLocationOnScreen(null);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                V2CMovieUtil.popup(string, point2);
            }
        });
        return true;
    }

    static void popup(String string, Point point) {
        V2CMain.saveCurrentState();
        int n = V2CMovieUtil.getYTPrefix(string);
        if (n > 0) {
            V2CFullPageYTPanel.popup(string, n, point);
            return;
        }
        n = V2CMovieUtil.getNVPrefix(string);
        if (n > 0) {
            V2CNVPanel.popup(string, n, point);
            return;
        }
    }
}

