/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.monazilla.v2c.V2CIDHideList;
import org.monazilla.v2c.V2CKeywordUtil;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNGItem;
import org.monazilla.v2c.V2CNGWordMatrix;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CResHideList;
import org.monazilla.v2c.V2CResItem;

public class V2CNGIDItem
implements V2CNGItem {
    static final SimpleDateFormat dFormat = new SimpleDateFormat("yyyy/MM/dd");
    V2CResHideList rhlParent;
    boolean bActive;
    int iWeight;
    int nMaxRecDepth;
    boolean bTransparent;
    int nDate;
    long lDate;
    String sDate;
    String sLabel;
    String sID;
    String sID2;

    public V2CNGIDItem(V2CResHideList v2CResHideList, String string) {
        String string2;
        this.rhlParent = v2CResHideList;
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.indexOf(9);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        } else {
            string2 = null;
        }
        int n2 = 0;
        int n3 = string.indexOf(58);
        if (n3 >= 0) {
            int n4;
            boolean bl = false;
            block7: for (n4 = 0; n4 < n3; ++n4) {
                char c = string.charAt(n4);
                if (c >= '0' && c <= '9') {
                    int n5 = c - 48;
                    if (bl) {
                        n5 = -n5;
                        bl = false;
                    }
                    this.iWeight = n5;
                    continue;
                }
                switch (c) {
                    case '#': {
                        n2 <<= 1;
                        continue block7;
                    }
                    case '$': {
                        n2 = (n2 << 1) + 1;
                        continue block7;
                    }
                    case 'A': {
                        this.bActive = true;
                        continue block7;
                    }
                    case 'T': {
                        this.bTransparent = true;
                        continue block7;
                    }
                    case '-': {
                        bl = true;
                    }
                }
            }
            this.nMaxRecDepth = n2 - 1;
            n4 = string.indexOf(58, n3 + 1);
            if (n4 >= 0) {
                this.nDate = V2CMiscUtil.parseInt(string, n3 + 1, n4, 0);
                string = string.substring(n4 + 1);
            } else {
                string = string.substring(n3 + 1);
            }
            if (string2 != null) {
                if (string2.length() > 2 && string2.charAt(0) == ':' && string2.charAt(1) == 'L' && string2.indexOf(9) < 0) {
                    this.sLabel = string2.substring(2);
                } else {
                    V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue(string2);
                    this.sLabel = v2CPackedPropValue.getString('L');
                }
            }
        }
        this.lDate = (long)this.nDate * 86400000L + V2CResItem.ltTimeOffset;
        this.sDate = dFormat.format(new Date(this.lDate));
        this.sID = string;
        this.sID2 = V2CResItem.toIDForDupCheck2(string);
    }

    public V2CNGIDItem(V2CResHideList v2CResHideList, long l, String string, boolean bl) {
        this(v2CResHideList, l, string, bl, 0, null);
    }

    public V2CNGIDItem(V2CResHideList v2CResHideList, long l, String string, boolean bl, int n) {
        this(v2CResHideList, l, string, bl, 0, null);
    }

    public V2CNGIDItem(V2CResHideList v2CResHideList, long l, String string, boolean bl, int n, String string2) {
        this.rhlParent = v2CResHideList;
        this.lDate = l;
        this.nDate = V2CMiscUtil.calcNDate(l);
        this.sDate = dFormat.format(new Date((long)this.nDate * 86400000L + V2CResItem.ltTimeOffset));
        this.sID = string;
        this.sID2 = V2CResItem.toIDForDupCheck2(string);
        if (string2 != null && (string2.length() == 0 || string2.equals(string))) {
            string2 = null;
        }
        this.sLabel = string2;
        this.bTransparent = bl;
        if (n != 0) {
            this.iWeight = V2CMiscUtil.restrictRange(-9, n, 9);
        }
        this.nMaxRecDepth = -1;
        this.bActive = true;
    }

    void getSaveString(StringBuffer stringBuffer) {
        int n;
        if (this.bActive) {
            stringBuffer.append('A');
        }
        if (this.bTransparent) {
            stringBuffer.append('T');
        }
        if (this.iWeight != 0) {
            stringBuffer.append(this.iWeight);
        }
        if ((n = this.nMaxRecDepth + 1) > 0) {
            boolean bl = false;
            int n2 = 64;
            for (int i = 6; i >= 0; --i) {
                if ((n & n2) != 0) {
                    bl = true;
                    stringBuffer.append('$');
                } else if (bl) {
                    stringBuffer.append('#');
                }
                n2 >>>= 1;
            }
        }
        stringBuffer.append(':');
        stringBuffer.append(this.nDate);
        stringBuffer.append(':');
        stringBuffer.append(this.sID);
        String string = this.sLabel;
        if (string != null && string.length() > 0 && !string.equals(this.sID)) {
            stringBuffer.append("\t:L");
            stringBuffer.append(V2CMiscUtil.escapeComma(string));
        }
    }

    public String getReasonString() {
        String string;
        String string2 = this.sID;
        V2CIDHideList v2CIDHideList = (V2CIDHideList)this.rhlParent;
        if (v2CIDHideList != null && (string = v2CIDHideList.getBoardItem().getIDAlias(this.sID2, true)) != null) {
            string2 = string;
        }
        string = this.sLabel;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ID[");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append('(');
            stringBuffer.append(string2);
            stringBuffer.append(')');
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    void setActive(boolean bl) {
        if (this.bActive == bl) {
            return;
        }
        this.bActive = bl;
        this.rhlParent.requestSave();
    }

    boolean isActive() {
        return this.bActive;
    }

    void setWeight0(int n) {
        this.iWeight = V2CMiscUtil.restrictRange(-9, n, 9);
    }

    void setWeight(String string) {
        int n = V2CKeywordUtil.toWeight(string);
        if (this.iWeight == n) {
            return;
        }
        this.iWeight = n;
        this.rhlParent.requestSave();
    }

    boolean setLabel(String string) {
        if ((string = V2CMiscUtil.replaceTab2SP(string)) != null && (string.length() == 0 || string.equals(this.sID))) {
            string = null;
        }
        if (V2CMiscUtil.isEqual(string, this.sLabel)) {
            return false;
        }
        this.sLabel = string;
        this.rhlParent.requestSave();
        return true;
    }

    public int getWeight() {
        return this.iWeight;
    }

    public int getMaxRecDepth() {
        return this.nMaxRecDepth;
    }

    void setMaxRecDepth(int n) {
        if (this.nMaxRecDepth == n) {
            return;
        }
        this.nMaxRecDepth = n;
        this.rhlParent.requestSave();
        if (n > 0) {
            V2CNGWordMatrix.setRecursiveUsed();
        }
    }

    void setTransparent0(boolean bl) {
        this.bTransparent = bl;
    }

    void setTransparent(boolean bl) {
        if (bl == this.bTransparent) {
            return;
        }
        this.bTransparent = bl;
        this.rhlParent.requestSave();
    }

    public boolean isTransparent() {
        return this.bTransparent;
    }

    int getDate() {
        return this.nDate;
    }

    long getLongDate() {
        return this.lDate;
    }

    String getDateString() {
        return this.sDate;
    }

    String getLabel() {
        return this.sLabel;
    }

    String getNGID() {
        return this.sID2;
    }

    String getOriginalNGID() {
        return this.sID;
    }
}

