/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import org.monazilla.v2c.V2CCharSequence;
import org.monazilla.v2c.V2CHTMLString;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CNameKeywordHighlightItem;
import org.monazilla.v2c.V2CNameKeywordHighlightSet;
import org.monazilla.v2c.V2CReplaceStr;
import org.monazilla.v2c.V2CTextSegment;

public final class V2CName
extends V2CHTMLString {
    private static final byte MASK_NEWSNONAME = 1;
    private static final byte MASK_NEGIMA = 2;
    static short shKWChange;
    String sRawName;
    final int iRes;
    byte bNameFlags;
    byte bWeight = (byte)-1;
    int nRepeat = 1;
    String sAvatar;
    byte bSoundWeight = (byte)-1;
    String sSound;
    short shKW;

    static void keywordChanged() {
        shKWChange = (short)(shKWChange + 1);
    }

    public V2CName(String string) {
        super(true);
        this.sRawName = string;
        this.iRes = -1;
        this.breakMessageLines(string, false);
    }

    public V2CName(int n, String string, V2CReplaceStr[] v2CReplaceStrArray) {
        super(true);
        this.iRes = n;
        if (v2CReplaceStrArray != null) {
            V2CCharSequence v2CCharSequence;
            char[] cArray = V2CJPConverter.createCharArray(string);
            V2CCharSequence v2CCharSequence2 = v2CCharSequence = new V2CCharSequence(cArray, 0, V2CJPConverter.getCharLength(cArray));
            int n2 = cArray.length;
            for (int i = 0; i < v2CReplaceStrArray.length; ++i) {
                v2CCharSequence = v2CReplaceStrArray[i].replace(v2CCharSequence, 0);
            }
            if (v2CCharSequence != v2CCharSequence2) {
                string = v2CCharSequence.toString();
            }
        }
        this.breakMessageLines(string, false);
    }

    String getRawName() {
        return this.sRawName;
    }

    void checkNewsNoName(String string, boolean bl) {
        boolean bl2;
        if (!string.startsWith(" </b>")) {
            return;
        }
        boolean bl3 = bl2 = string.length() > 21 && string.charAt(5) == '[' && string.regionMatches(6, "\u2015{}@{}@{}-]<b> ", 0, 15);
        if (bl2) {
            this.bNameFlags = (byte)2;
        }
        if (!bl) {
            return;
        }
        if (!string.endsWith(")<b>") || bl2 && !string.regionMatches(21, " </b>", 0, 5)) {
            return;
        }
        int n = bl2 ? string.indexOf(60, 26) : string.indexOf(60, 5);
        if (string.regionMatches(n + 1, "b></b>(", 0, 7) && string.indexOf(60, n + 8) == string.length() - 3) {
            if (string.charAt(5) == '\u25c6' || string.charAt(n - 1) == '\u3011') {
                return;
            }
        } else if (n == string.length() - 3) {
            if (string.indexOf(40) < 0) {
                return;
            }
        } else {
            return;
        }
        this.bNameFlags = (byte)(bl2 ? 3 : 1);
    }

    boolean isNewsNoName() {
        return (this.bNameFlags & 1) != 0;
    }

    void parse() {
        this.processHTMLTags();
        this.replaceEscapes();
        this.processHTMLTags2();
        this.createNormalTextSegments(false);
        this.checkRedundantNewLineNext();
    }

    void setAvatarName(String string) {
        this.sAvatar = string;
    }

    String getAvatarName() {
        return this.sAvatar;
    }

    String getSoundName() {
        return this.sSound;
    }

    void clearStatus(boolean bl) {
        if (bl) {
            this.shKW = 0;
        } else {
            this.clearWeight();
        }
    }

    private void clearWeight() {
        this.bWeight = (byte)-1;
        this.sAvatar = null;
    }

    int checkNGAndAvatar(V2CNameKeywordHighlightSet v2CNameKeywordHighlightSet) {
        if (this.bWeight >= 0 || v2CNameKeywordHighlightSet == null) {
            return this.bWeight;
        }
        int n = this.checkKeywordHighlightWeight(v2CNameKeywordHighlightSet.getNameKeywordHighlightItemArray(), 0);
        this.bWeight = (byte)n;
        return n;
    }

    synchronized int checkSound(V2CNameKeywordHighlightItem[] v2CNameKeywordHighlightItemArray, V2CNameKeywordHighlightItem[] v2CNameKeywordHighlightItemArray2) {
        if (this.shKW > shKWChange || v2CNameKeywordHighlightItemArray == null) {
            return this.bSoundWeight;
        }
        int n = this.checkKeywordHighlight(v2CNameKeywordHighlightItemArray, null, v2CNameKeywordHighlightItemArray2);
        this.bSoundWeight = (byte)n;
        this.shKW = (short)(shKWChange + 1);
        return n;
    }

    void postCheckKeywordHighlight(String string, boolean bl) {
        if (bl) {
            this.sSound = string;
        } else {
            this.setAvatarName(string);
        }
    }

    void resetHighlight() {
        if (this.bHighlightChecked) {
            this.resetHighlight0();
        }
    }

    void checkHighlight(V2CNameKeywordHighlightSet v2CNameKeywordHighlightSet) {
        if (this.bHighlightChecked) {
            return;
        }
        this.bHighlightChecked = true;
        this.applyKeywordHighlight(v2CNameKeywordHighlightSet.getNameKeywordHighlightItemArray());
        ArrayList arrayList = this.alKeywords;
        if (arrayList == null) {
            return;
        }
        if (arrayList.size() == 0) {
            this.alKeywords = null;
            return;
        }
        this.setContainKeyword();
    }

    boolean containsTrip() {
        char[] cArray = this.clMsg;
        for (int i = this.nMsgLength - 1; i >= 0; --i) {
            if (cArray[i] != '\u25c6') continue;
            return true;
        }
        return false;
    }

    void inc() {
        ++this.nRepeat;
    }

    void setRepeat(int n) {
        this.nRepeat = n;
    }

    String toStringForNumberCheck() {
        int n = this.nTextSegment;
        V2CTextSegment[] v2CTextSegmentArray = this.vlTextSegment;
        for (int i = 0; i < n; ++i) {
            V2CTextSegment v2CTextSegment = v2CTextSegmentArray[i];
            if (v2CTextSegment.getType() != 0x800000 || v2CTextSegment.getSubType() != -2) continue;
            return new String(this.clMsg, 0, v2CTextSegment.getSegmentStartIndex());
        }
        return this.toString();
    }

    String toStringWONegima() {
        String string = this.toString();
        return (this.bNameFlags & 2) != 0 ? string.substring(14) : string;
    }
}

