/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.swing.JTextField;

public class V2CNumLimitTextField
extends JTextField {
    static Color cWarning = Color.YELLOW;
    static Color cOver = Color.RED;
    String sFormat;
    String sDenom;
    int nWarn;
    int nError;

    V2CNumLimitTextField(int n, int n2, int n3) {
        char[] cArray = new char[n * 2 + 3];
        Arrays.fill(cArray, '0');
        cArray[0] = 47;
        this.sFormat = new String(cArray);
        if (n2 > 0) {
            this.nWarn = n2;
            this.nError = n3;
        } else {
            Arrays.fill(cArray, 0, n, '-');
            this.sDenom = new String(cArray, 0, n);
        }
        this.setHorizontalAlignment(4);
        this.setEditable(false);
        this.setFocusable(false);
        this.setNumber(0);
    }

    void setNumber(int n) {
        String string = n + "/";
        string = this.nWarn > 0 ? string + this.nError : string + this.sDenom;
        this.setText(string);
        Color color = null;
        if (this.nWarn > 0) {
            if (n > this.nError) {
                color = cOver;
            } else if (n > this.nWarn) {
                color = cWarning;
            }
        }
        this.setBackground(color);
    }

    public Dimension getPreferredSize() {
        this.setPreferredSize(null);
        Dimension dimension = super.getPreferredSize();
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return dimension;
        }
        Font font = graphics2D.getFont();
        if (font == null) {
            return dimension;
        }
        Rectangle2D rectangle2D = font.getStringBounds(this.sFormat, graphics2D.getFontRenderContext());
        dimension.width = (int)rectangle2D.getWidth();
        this.setPreferredSize(dimension);
        return dimension;
    }
}

