/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CPackedPropValue {
    private static final int KEY_MIN = 33;
    private static final int KEY_MAX = 126;
    private boolean[] blOptions = new boolean[127];
    private String[] slOptions = new String[127];
    private char cLast;

    static V2CPackedPropValue[] createPackedValueArray(String string) {
        return V2CPackedPropValue.createPackedValueArray(string, '\u0000');
    }

    static V2CPackedPropValue[] createPackedValueArray(String string, char c) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = V2CMiscUtil.split(string);
        if (stringArray == null) {
            return null;
        }
        V2CPackedPropValue[] v2CPackedPropValueArray = new V2CPackedPropValue[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            v2CPackedPropValueArray[i] = new V2CPackedPropValue(stringArray[i], c);
        }
        return v2CPackedPropValueArray;
    }

    static String createArraySaveString(V2CPackedPropValue[] v2CPackedPropValueArray) {
        if (v2CPackedPropValueArray == null || v2CPackedPropValueArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
            V2CPackedPropValue v2CPackedPropValue = v2CPackedPropValueArray[i];
            if (v2CPackedPropValue == null) continue;
            stringBuffer.append(V2CMiscUtil.escapeComma(v2CPackedPropValue.getSaveString()));
            stringBuffer.append(',');
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public V2CPackedPropValue() {
    }

    public V2CPackedPropValue(char c) {
        this.cLast = c;
    }

    public V2CPackedPropValue(String string) {
        this(string, '\u0000');
    }

    public V2CPackedPropValue(String string, char c) {
        this.restore(string, c);
    }

    void importFrom(V2CPackedPropValue v2CPackedPropValue) {
        if (v2CPackedPropValue == null) {
            return;
        }
        for (char c = '!'; c <= '~'; c = (char)(c + '\u0001')) {
            String string;
            if (v2CPackedPropValue.getBoolean(c)) {
                this.setBoolean(c, true);
            }
            if ((string = v2CPackedPropValue.getString(c)) == null) continue;
            this.setString(c, string);
        }
    }

    boolean getBoolean(char c) {
        return c >= '!' && c <= '~' && this.blOptions[c];
    }

    void setBoolean(char c, boolean bl) {
        if (c >= '!' && c <= '~') {
            this.blOptions[c] = bl;
        }
    }

    String getString(char c) {
        return c >= '!' && c <= '~' ? this.slOptions[c] : null;
    }

    void setString(char c, String string) {
        if (c >= '!' && c <= '~') {
            this.slOptions[c] = string;
        }
    }

    void setMultiLineString(char c, String string) {
        this.setString(c, V2CMiscUtil.escapeNewLine(string));
    }

    String getMultiLineString(char c) {
        return V2CMiscUtil.restoreNewLine(this.getString(c));
    }

    char getChar(char c) {
        String string = this.getString(c);
        return string != null && string.length() == 1 ? string.charAt(0) : (char)'\u0000';
    }

    void setChar(char c, char c2) {
        if (c2 != '\u0000') {
            this.setString(c, new String(new char[]{c2}));
        }
    }

    int getIntInRangeIfExists(char c, int n, int n2) {
        int n3 = this.getInt(c);
        return n3 != 0 ? V2CMiscUtil.restrictRange(n, n3, n2) : 0;
    }

    int getIntInRangeIfExists(char c, int n, int n2, int n3) {
        int n4 = this.getInt(c, Integer.MIN_VALUE);
        return n4 != Integer.MIN_VALUE ? V2CMiscUtil.restrictRange(n2, n4, n3) : n;
    }

    int getIntInRange(char c, int n, int n2, int n3) {
        return V2CMiscUtil.restrictRange(n2, this.getInt(c, n), n3);
    }

    int getIntInRange(char c, int n, int n2) {
        return V2CMiscUtil.restrictRange(n, this.getInt(c), n2);
    }

    int getIntGE(char c, int n) {
        int n2 = this.getInt(c);
        return n2 >= n ? n2 : n;
    }

    int getInt(char c) {
        return this.getInt(c, 0);
    }

    int getInt(char c, int n) {
        String string = this.getString(c);
        return string != null ? V2CMiscUtil.parseInt(string) : n;
    }

    void setInt(char c, int n) {
        this.setString(c, String.valueOf(n));
    }

    int[] getIntArray(char c, int n) {
        int[] nArray = this.getIntArrayUpTo(c, n);
        return nArray != null && nArray.length == n ? nArray : null;
    }

    int[] getIntArrayUpTo(char c, int n) {
        return V2CMiscUtil.parseSeparatedNumbers(this.getString(c), n, ';', false);
    }

    void setIntArray(char c, int[] nArray) {
        if (nArray == null) {
            this.setString(c, null);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(String.valueOf(nArray[i]));
            stringBuffer.append(';');
        }
        this.setString(c, stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : null);
    }

    Point getPoint(char c) {
        int[] nArray = this.getIntArray(c, 2);
        return nArray != null ? new Point(nArray[0], nArray[1]) : null;
    }

    void setPoint(char c, Point point) {
        int[] nArray;
        if (point != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = point.x;
            nArray = nArray2;
            nArray2[1] = point.y;
        } else {
            nArray = null;
        }
        this.setIntArray(c, nArray);
    }

    Rectangle getRectangle(char c) {
        int[] nArray = this.getIntArray(c, 4);
        return nArray != null ? new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]) : null;
    }

    void setRectangle(char c, Rectangle rectangle) {
        int[] nArray;
        if (rectangle != null) {
            int[] nArray2 = new int[4];
            nArray2[0] = rectangle.x;
            nArray2[1] = rectangle.y;
            nArray2[2] = rectangle.width;
            nArray = nArray2;
            nArray2[3] = rectangle.height;
        } else {
            nArray = null;
        }
        this.setIntArray(c, nArray);
    }

    long getLong(char c) {
        String string = this.getString(c);
        if (string != null) {
            return V2CMiscUtil.parseLong(string);
        }
        return 0L;
    }

    void setLong(char c, long l) {
        this.setString(c, String.valueOf(l));
    }

    long[] getLongArray(char c, int n) {
        long[] lArray = this.getLongArrayUpTo(c, n);
        return lArray != null && lArray.length == n ? lArray : null;
    }

    long[] getLongArrayUpTo(char c, int n) {
        return V2CMiscUtil.parseSeparatedLongs(this.getString(c), n, ';', false);
    }

    void setLongArray(char c, long[] lArray) {
        if (lArray == null) {
            this.setString(c, null);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(String.valueOf(lArray[i]));
            stringBuffer.append(';');
        }
        this.setString(c, stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : null);
    }

    void setFloat(char c, float f) {
        this.setString(c, String.valueOf(f));
    }

    float getFloat(char c) {
        String string = this.getString(c);
        if (string != null) {
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    Color[] getColorArray(char c) {
        String string = this.getString(c);
        if (string == null) {
            return null;
        }
        String[] stringArray = V2CMiscUtil.split(string, ';', false);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = V2CSwingUtil.parseColorString(stringArray[i]);
        }
        return colorArray;
    }

    void setColorArray(char c, Color[] colorArray) {
        if (colorArray == null) {
            this.setString(c, null);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            if (color != null) {
                stringBuffer.append(V2CSwingUtil.colorToString(color));
            }
            stringBuffer.append(';');
        }
        this.setString(c, stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : null);
    }

    Color getColor(char c) {
        return V2CSwingUtil.parseColorString(this.getString(c));
    }

    Color getColor(char c, Color color) {
        Color color2 = this.getColor(c);
        return color2 != null ? color2 : color;
    }

    void setColor(char c, Color color) {
        this.setString(c, color != null ? V2CSwingUtil.colorToString(color) : null);
    }

    String getSaveString() {
        String string;
        int n;
        int n2;
        char c = this.cLast;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 33; n2 <= 126; ++n2) {
            if (!this.blOptions[n2]) continue;
            stringBuffer.append((char)n2);
        }
        stringBuffer.append(':');
        n2 = stringBuffer.length();
        boolean bl = false;
        for (n = '!'; n <= 126; ++n) {
            String string2;
            if (n == c || (string2 = this.slOptions[n]) == null) continue;
            stringBuffer.append((char)n);
            stringBuffer.append(string2);
            stringBuffer.append('\t');
            bl = true;
        }
        if (c != '\u0000' && (string = this.slOptions[c]) != null) {
            stringBuffer.append(c);
            stringBuffer.append(string);
            bl = false;
        }
        if ((n = stringBuffer.length()) == n2 || bl) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString();
    }

    private void restore(String string, char c) {
        char c2;
        int n;
        if (string == null || string.length() == 0) {
            return;
        }
        int n2 = string.length();
        int n3 = string.indexOf(58);
        if (n3 < 0) {
            n3 = n2;
        }
        for (n = 0; n < n3; ++n) {
            c2 = string.charAt(n);
            if (c2 < '!' || c2 > '~') continue;
            this.blOptions[c2] = true;
        }
        if (++n3 >= n2) {
            return;
        }
        n = n3;
        while (n < n2) {
            c2 = string.charAt(n++);
            int n4 = c != '\u0000' && c2 == c ? -1 : string.indexOf(9, n);
            if (n4 < 0) {
                n4 = n2;
            }
            if (c2 >= '!' && c2 <= '~') {
                this.slOptions[c2] = string.substring(n, n4);
            }
            n = n4 + 1;
        }
    }
}

