/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CDnDTree;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabbedPane;
import org.monazilla.v2c.V2CThreadStyle;
import org.monazilla.v2c.V2CWebBrowserUtil;

public class V2CPopupLabel
extends JLabel
implements ActionListener,
MouseWheelListener {
    private static V2CPopupLabel vPopupLabel;
    static Component cmpOwner;
    static MouseInputListener milExitListener;
    Reference refWindow;
    Color cBorderColor = V2CThreadStyle.getDefaultForeground();
    boolean bHeavyweight;
    boolean bHideRequest;
    Rectangle rBounds;
    boolean bPressed;
    boolean bShrinked;
    final Timer tHideTimer;
    DragGestureRecognizer dgRecognizer;
    V2CDnDTree vDnDTree;

    static V2CPopupLabel getInstance() {
        return V2CPopupLabel.getInstance(true);
    }

    static V2CPopupLabel getInstance(boolean bl) {
        if (bl && vPopupLabel == null) {
            vPopupLabel = new V2CPopupLabel();
        }
        return vPopupLabel;
    }

    static void hideAll() {
        V2CPopupLabel v2CPopupLabel = V2CPopupLabel.getInstance(false);
        if (v2CPopupLabel != null) {
            v2CPopupLabel.setLabelVisible(false);
        }
    }

    static Component getOwner() {
        return cmpOwner;
    }

    static void setExitListener(MouseInputListener mouseInputListener) {
        V2CPopupLabel v2CPopupLabel = V2CPopupLabel.getInstance(true);
        MouseInputListener mouseInputListener2 = milExitListener;
        if (mouseInputListener2 != null) {
            v2CPopupLabel.removeMouseListener(mouseInputListener2);
            v2CPopupLabel.removeMouseMotionListener(mouseInputListener2);
        }
        milExitListener = mouseInputListener;
        if (mouseInputListener != null) {
            v2CPopupLabel.addMouseListener(mouseInputListener);
            v2CPopupLabel.addMouseMotionListener(mouseInputListener);
        }
    }

    public V2CPopupLabel() {
        this.setBorder(BorderFactory.createLineBorder(this.cBorderColor, 1));
        this.setOpaque(true);
        this.setBackground(new Color(255, 255, 200));
        TempMouseListener tempMouseListener = new TempMouseListener();
        this.addMouseListener(tempMouseListener);
        this.addMouseMotionListener(tempMouseListener);
        this.addMouseWheelListener(this);
        this.tHideTimer = new Timer(10000, this);
        this.tHideTimer.setRepeats(false);
    }

    JWindow getWindow() {
        return this.getWindow(false, null);
    }

    JWindow getWindow(Window window) {
        return this.getWindow(true, window);
    }

    JWindow getWindow(boolean bl, Window window) {
        JWindow jWindow;
        JWindow jWindow2 = jWindow = this.refWindow != null ? (JWindow)this.refWindow.get() : null;
        if (bl) {
            if (jWindow != null && jWindow.getOwner() != window) {
                jWindow.dispose();
                jWindow = null;
            }
            if (jWindow == null) {
                WeakReference<JWindow> weakReference;
                jWindow = new JWindow(window);
                this.refWindow = weakReference = new WeakReference<JWindow>(jWindow);
            }
        }
        return jWindow;
    }

    private void setVisible0(boolean bl) {
        final JWindow jWindow = this.getWindow();
        if (this.bHeavyweight) {
            if (jWindow != null) {
                if (bl) {
                    this.bHideRequest = false;
                    jWindow.setVisible(true);
                } else {
                    this.bHideRequest = true;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (V2CPopupLabel.this.bHideRequest) {
                                V2CPopupLabel.this.bHideRequest = false;
                                jWindow.setVisible(false);
                            }
                        }
                    });
                }
            }
        } else {
            if (bl && jWindow != null && jWindow.isVisible()) {
                this.bHideRequest = false;
                jWindow.setVisible(false);
            }
            this.setVisible(bl);
        }
    }

    static JLayeredPane getLayeredPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getLayeredPane();
        }
        if (window instanceof JWindow) {
            return ((JWindow)window).getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getLayeredPane();
        }
        return null;
    }

    void dragDropEnd() {
        this.bPressed = false;
        this.setLabelVisible(false);
    }

    private void setLabelVisible(boolean bl) {
        if (this.bPressed) {
            return;
        }
        if (this.tHideTimer.isRunning()) {
            this.tHideTimer.stop();
        }
        if (bl) {
            V2CDnDTree v2CDnDTree;
            V2CDnDTree v2CDnDTree2 = cmpOwner instanceof V2CDnDTree ? (V2CDnDTree)cmpOwner : null;
            if (v2CDnDTree2 != (v2CDnDTree = this.vDnDTree)) {
                this.vDnDTree = v2CDnDTree2;
                if (v2CDnDTree2 != null) {
                    if (this.dgRecognizer == null) {
                        this.dgRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, v2CDnDTree2);
                    } else {
                        if (v2CDnDTree != null) {
                            this.dgRecognizer.removeDragGestureListener(v2CDnDTree);
                        }
                        try {
                            this.dgRecognizer.addDragGestureListener(v2CDnDTree2);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    this.dgRecognizer.removeDragGestureListener(v2CDnDTree);
                }
            }
            Container container = this.getParent();
            Window window = SwingUtilities.getWindowAncestor(cmpOwner);
            Window window2 = SwingUtilities.getWindowAncestor(this);
            if (this.bHeavyweight) {
                Rectangle rectangle;
                JWindow jWindow = this.getWindow(window);
                if (window2 != jWindow) {
                    boolean bl2 = this.isVisible();
                    if (container != null) {
                        rectangle = this.getBounds();
                        container.remove(this);
                        if (bl2 && window2 instanceof Window) {
                            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                    }
                    if (!bl2) {
                        this.setVisible(true);
                    }
                    jWindow.getContentPane().add((Component)this, "Center");
                }
                jWindow.pack();
                if (this.rBounds != null) {
                    Rectangle rectangle2 = this.rBounds;
                    rectangle = V2CSwingUtil.getScreenBoundsAt(rectangle2.x, rectangle2.y);
                    if (rectangle2.x < rectangle.x) {
                        rectangle2.x = rectangle.x;
                    }
                    if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                        rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
                    }
                    jWindow.setBounds(rectangle2);
                }
            } else {
                Serializable serializable;
                boolean bl3;
                boolean bl4 = bl3 = window != window2;
                if (bl3 && container != null) {
                    serializable = this.getBounds();
                    container.remove(this);
                    if (this.isVisible() && window2 instanceof Window) {
                        container.repaint(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                    }
                }
                if (this.rBounds != null) {
                    this.setBounds(this.rBounds);
                }
                if (bl3 && (serializable = V2CPopupLabel.getLayeredPane(window)) != null) {
                    ((Container)serializable).add((Component)this, JLayeredPane.POPUP_LAYER);
                }
            }
        }
        this.setVisible0(bl);
        if (bl) {
            this.tHideTimer.start();
        } else {
            cmpOwner = null;
        }
    }

    void showLabel(Component component) {
        if (this.bShrinked) {
            this.bShrinked = false;
            this.setSize(this.getPreferredSize());
        }
        if (component == cmpOwner) {
            this.setLabelVisible(true);
        }
    }

    void hideLabel(Component component) {
        if (component == cmpOwner) {
            this.setLabelVisible(false);
        }
    }

    void setVisible(Component component, boolean bl) {
        if (bl) {
            this.showLabel(component);
        } else {
            this.hideLabel(component);
        }
    }

    void setParameters(Component component, Rectangle rectangle, Object object) {
        Rectangle rectangle2;
        Rectangle rectangle3;
        Component component2;
        Container container;
        Object object2;
        Serializable serializable;
        boolean bl;
        cmpOwner = component;
        Window window = SwingUtilities.getWindowAncestor(component);
        JLayeredPane jLayeredPane = V2CPopupLabel.getLayeredPane(window);
        Point point = SwingUtilities.convertPoint(component, rectangle.x, rectangle.y, jLayeredPane);
        rectangle.x = point.x - 1;
        rectangle.y = point.y - 1;
        rectangle.width += 2;
        rectangle.height += 2;
        boolean bl2 = bl = rectangle.x < 0 || rectangle.x + rectangle.width > jLayeredPane.getWidth();
        if (!bl && window == V2CMain.v2cMain && V2CWebBrowserUtil.hasJDICBeenUsed() && ((Component)(serializable = V2CMain.getDisplayPane())).isShowing() && (object2 = ((V2CTabbedPane)serializable).getSelectedPanel()) instanceof Component && (container = (component2 = (Component)object2).getParent()) != null && rectangle.intersects(rectangle3 = SwingUtilities.convertRectangle(container, rectangle2 = component2.getBounds(), jLayeredPane))) {
            bl = true;
        }
        this.bHeavyweight = bl;
        this.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        if (bl) {
            serializable = new Point(rectangle.x, rectangle.y);
            SwingUtilities.convertPointToScreen((Point)serializable, jLayeredPane);
            rectangle.x = ((Point)serializable).x;
            rectangle.y = ((Point)serializable).y;
        }
        this.rBounds = rectangle;
        if (object instanceof JLabel) {
            serializable = (JLabel)object;
            this.setText(((JLabel)serializable).getText());
            this.setFont(((Component)serializable).getFont());
            object2 = V2CThreadStyle.getDefaultForeground();
            this.setForeground((Color)object2);
            this.setBackground(V2CThreadStyle.getDefaultBackground());
            if (!this.cBorderColor.equals(object2)) {
                this.cBorderColor = object2;
                this.setBorder(BorderFactory.createLineBorder((Color)object2, 1));
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Point point;
        if (this.isVisible() && !this.bPressed && (point = V2CSwingUtil.getMouseLocation(this)) != null && !this.contains(point)) {
            this.setLabelVisible(false);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (cmpOwner == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(cmpOwner);
        if (window == null) {
            return;
        }
        Point point = mouseWheelEvent.getPoint();
        Container container = V2CSwingUtil.getContentPane(window);
        Point point2 = SwingUtilities.convertPoint(mouseWheelEvent.getComponent(), point, container);
        Component component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y);
        if (component != null) {
            component.dispatchEvent(new MouseWheelEvent(component, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (int)point2.getX(), (int)point2.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
        }
        this.setLabelVisible(false);
    }

    private class TempMouseListener
    extends MouseInputAdapter {
        boolean bIgnore;

        private TempMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.redispatchMouseEvent(mouseEvent, false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            V2CPopupLabel.this.bPressed = true;
            this.redispatchMouseEvent(mouseEvent, true);
            V2CPopupLabel.this.bShrinked = true;
            if (V2CPopupLabel.this.bHeavyweight) {
                JWindow jWindow = V2CPopupLabel.this.getWindow();
                if (jWindow != null) {
                    jWindow.setSize(0, 0);
                }
            } else {
                V2CPopupLabel.this.setSize(0, 0);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            V2CPopupLabel.this.bPressed = false;
            this.redispatchMouseEvent(mouseEvent, false);
            V2CPopupLabel.this.setLabelVisible(false);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!V2CPopupLabel.this.bPressed) {
                V2CPopupLabel.this.setLabelVisible(false);
            }
        }

        private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl) {
            Point point;
            if (cmpOwner == null) {
                return;
            }
            if (bl) {
                Rectangle rectangle;
                point = mouseEvent.getPoint();
                Point point2 = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, cmpOwner);
                Container container = cmpOwner.getParent();
                this.bIgnore = container instanceof JViewport ? !(rectangle = ((JViewport)container).getViewRect()).contains(point2) : true;
            }
            if (this.bIgnore) {
                return;
            }
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), cmpOwner);
            int n = mouseEvent.getClickCount();
            if (V2CApp.javaVersionLessThan(1, 5) && n == 0 && mouseEvent.getID() == 502) {
                n = 1;
            }
            cmpOwner.dispatchEvent(new MouseEvent(cmpOwner, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)point.getX(), (int)point.getY(), n, mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }
    }
}

