/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CMiscUtil;

public class V2CRSSEntry {
    static Pattern pDZ = Pattern.compile("\\dZ$");
    static Pattern pTZ = Pattern.compile("([+-][01]\\d):(\\d0)$");
    static SimpleDateFormat sdfDCDate0 = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat sdfDCDate1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    static SimpleDateFormat sdfDCDate2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    static SimpleDateFormat sdfDCDate3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    static SimpleDateFormat sdfDCDate20 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss");
    String sTitle;
    String sURL;
    String sSubject;
    Date dDate;
    String sOther;
    boolean bNew;

    void setTitle(String string) {
        this.sTitle = string;
    }

    String getTitle() {
        return this.sTitle;
    }

    void setURL(String string) {
        this.sURL = string;
    }

    String getURLString() {
        return this.sURL;
    }

    void setSubject(String string) {
        this.sSubject = string;
    }

    String getSubject() {
        return this.sSubject;
    }

    void setDate(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = 0;
        Matcher matcher = pDZ.matcher(string);
        if (matcher.find()) {
            string = string.substring(0, string.length() - 1);
        } else {
            Matcher matcher2 = pTZ.matcher(string);
            if (matcher2.find()) {
                n2 = (V2CMiscUtil.parseInt(matcher2.group(1)) * 60 + V2CMiscUtil.parseInt(matcher2.group(2)) - 540) * 60000;
                string = string.substring(0, matcher2.start());
            }
        }
        int n3 = string.length();
        Date date = null;
        if (n3 >= 10 && string.charAt(4) == '-') {
            if (n3 == 10) {
                try {
                    date = sdfDCDate0.parse(string);
                }
                catch (ParseException parseException) {}
            } else if (n3 == 16) {
                try {
                    date = sdfDCDate1.parse(string);
                }
                catch (ParseException parseException) {}
            } else if (n3 == 19) {
                try {
                    date = sdfDCDate2.parse(string);
                }
                catch (ParseException parseException) {}
            } else if (n3 == 23) {
                try {
                    date = sdfDCDate3.parse(string);
                }
                catch (ParseException parseException) {}
            }
        } else {
            try {
                date = sdfDCDate20.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return;
        }
        if (n2 != 0) {
            date.setTime(date.getTime() - (long)n2);
        }
        this.dDate = date;
        if (n3 < 22) {
            return;
        }
        char c = string.charAt(19);
        if (c == '+') {
            n = 1;
        } else if (c == '-') {
            n = -1;
        } else {
            return;
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string.substring(20, 22));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n4 == 9 || n4 < -11 || n4 > 11) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.dDate);
        calendar.add(10, 9 - n * n4);
        this.dDate = calendar.getTime();
    }

    Date getDate() {
        return this.dDate;
    }

    void setOther(String string) {
        this.sOther = string;
    }

    String getOther() {
        return this.sOther;
    }

    void setNew(boolean bl) {
        this.bNew = bl;
    }

    boolean isNew() {
        return this.bNew;
    }
}

