/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CListTable;
import org.monazilla.v2c.V2CListTableModel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProgressBar;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CRSSEntry;
import org.monazilla.v2c.V2CRSSItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadListHistory;
import org.monazilla.v2c.V2CThreadListPane;

public class V2CRSSEntryList
extends V2CListTable {
    static final String sKeyPrefix = "RSSEntryList.";
    static final String sColumnWidthKeyPrefix = "RSSEntryList.ColumnWidth_";
    static final String[][] slColumnLabel = new String[][]{{"No.", "NUMBER"}, {"Subject", "SUBJECT"}, {"Title", "TITLE"}, {"Date", "DATE"}, {"Other", "OTHER"}};
    static final int TITLE = 2;
    static int[] nlColWidth = new int[slColumnLabel.length];
    static HashMap hmRSSItemList = new HashMap();
    V2CRSSItem vRSSItem;
    RSSTableModel rssTableModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fontSizeChanged(Font font, int n) {
        HashMap hashMap = hmRSSItemList;
        synchronized (hashMap) {
            Iterator iterator = hmRSSItemList.values().iterator();
            while (iterator.hasNext()) {
                V2CRSSEntryList v2CRSSEntryList = (V2CRSSEntryList)iterator.next();
                v2CRSSEntryList.setFont(font);
                v2CRSSEntryList.setRowHeight(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setBGColor() {
        HashMap hashMap = hmRSSItemList;
        synchronized (hashMap) {
            Iterator iterator = hmRSSItemList.values().iterator();
            while (iterator.hasNext()) {
                V2CRSSEntryList v2CRSSEntryList = (V2CRSSEntryList)iterator.next();
                v2CRSSEntryList.setBackground(cOddBG);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CRSSEntryList getRSSEntryList(V2CRSSItem v2CRSSItem) {
        HashMap hashMap = hmRSSItemList;
        synchronized (hashMap) {
            return (V2CRSSEntryList)hmRSSItemList.get(v2CRSSItem);
        }
    }

    static void openRSSBG(V2CRSSItem v2CRSSItem, boolean bl) {
        V2CRSSEntryList.openRSS(v2CRSSItem, bl, true, true, false);
    }

    static void openRSS(V2CRSSItem v2CRSSItem, boolean bl, boolean bl2) {
        V2CRSSEntryList.openRSS(v2CRSSItem, bl, bl2, false, false);
    }

    static void openRSS(V2CRSSItem v2CRSSItem, boolean bl, boolean bl2, boolean bl3) {
        V2CRSSEntryList.openRSS(v2CRSSItem, bl, bl2, false, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openRSS(V2CRSSItem v2CRSSItem, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        V2CRSSEntryList v2CRSSEntryList;
        HashMap hashMap = hmRSSItemList;
        synchronized (hashMap) {
            v2CRSSEntryList = (V2CRSSEntryList)hmRSSItemList.get(v2CRSSItem);
            if (v2CRSSEntryList == null) {
                v2CRSSEntryList = new V2CRSSEntryList(v2CRSSItem);
                hmRSSItemList.put(v2CRSSItem, v2CRSSEntryList);
            }
        }
        if (bl4) {
            v2CRSSEntryList.setLocked(true);
        }
        v2CRSSEntryList.openRSSItemList(bl, bl2, bl2 && bl3);
    }

    static void saveProperties() {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        for (int i = 0; i < slColumnLabel.length; ++i) {
            v2CProperty.putInt(sColumnWidthKeyPrefix + slColumnLabel[i][1], nlColWidth[i]);
        }
    }

    public V2CRSSEntryList(V2CRSSItem v2CRSSItem) {
        this.vRSSItem = v2CRSSItem;
        this.setSelectionMode(0);
        this.rssTableModel = new RSSTableModel();
        this.setModel(this.rssTableModel);
        this.dTCRenderer = new ListRenderer();
        this.setColumnState();
        this.vGestureMap = V2CGestureMap.getGestureMap("ThreadList");
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableHeaderListener tableHeaderListener = new TableHeaderListener();
        jTableHeader.addMouseListener(tableHeaderListener);
        jTableHeader.addMouseMotionListener(tableHeaderListener);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.addMouseMotionListener(popupListener);
        this.addMouseWheelListener(this);
    }

    public String getSaveTabString() {
        String string = this.vRSSItem.getURLString();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(5 + string.length());
        stringBuffer.append('R');
        if (this.bTabLocked) {
            stringBuffer.append('l');
        }
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getTitleString() {
        return this.vRSSItem.getName();
    }

    public Icon getIcon() {
        return V2CRSSItem.getIcon();
    }

    public void detouch() {
        this.rememberColumnWidths();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        HashMap hashMap = hmRSSItemList;
        synchronized (hashMap) {
            if (hmRSSItemList.containsKey(this.vRSSItem)) {
                hmRSSItemList.remove(this.vRSSItem);
            }
        }
        if (this.bUpdating) {
            this.psProgState.stop();
        }
        return true;
    }

    public V2CProgressState getProgressState() {
        return this.psProgState;
    }

    public Icon getDefaultIcon() {
        return V2CRSSItem.getIcon();
    }

    public boolean canLock() {
        return true;
    }

    Object getItem() {
        return this.vRSSItem;
    }

    void setColumnWidths() {
        this.setColumnState(false);
    }

    void setColumnState() {
        this.setColumnState(true);
    }

    void setColumnState(boolean bl) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = nlColWidth[i];
            tableColumnModel.getColumn(i).setPreferredWidth(n2);
            if (!bl) continue;
            tableColumnModel.getColumn(i).setCellRenderer(this.dTCRenderer);
        }
    }

    synchronized boolean setUpdating(boolean bl) {
        if (bl && this.bUpdating) {
            return false;
        }
        this.bUpdating = bl;
        this.psProgState.setInProgress(this.bUpdating);
        if (this.bUpdating) {
            V2CProgressBar.setState(this, this.psProgState);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                V2CMain.getTablePane().repaintTab(V2CRSSEntryList.this);
                V2CThreadListHistory.entryChanged();
            }
        });
        return this.bUpdating;
    }

    void openRSSItemList(boolean bl, boolean bl2, boolean bl3) {
        V2CThreadListPane v2CThreadListPane = V2CMain.getTablePane();
        int n = v2CThreadListPane.indexOfPanel(this);
        int n2 = v2CThreadListPane.getSelectedIndex();
        if (n < 0) {
            if (bl2 || v2CThreadListPane.getPanelCount() == 0) {
                n = v2CThreadListPane.addPanel(this);
            } else {
                n = Math.max(n2, 0);
                n = v2CThreadListPane.setPanelAt(n, this);
            }
        }
        if (!bl3) {
            v2CThreadListPane.setSelectedIndex(n);
            V2CMain.showTablePane(false);
        }
        V2CThreadListHistory.moveToHistoryTop(this.vRSSItem);
        this.openList(bl);
    }

    void openList(final boolean bl) {
        if (!this.setUpdating(true)) {
            System.out.println("already updating !");
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                V2CRSSEntryList.this.psProgState.setThread();
                try {
                    V2CRSSEntryList.this.displayList(bl);
                    V2CSwingUtil.armRequestFocus(V2CRSSEntryList.this);
                    Object var2_1 = null;
                    V2CRSSEntryList.this.setUpdating(false);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    V2CRSSEntryList.this.setUpdating(false);
                    throw throwable;
                }
                V2CMemoryGauge.update();
            }
        };
        thread.start();
    }

    boolean displayList(boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = null;
        if (bl && V2CMain.isOnlineMode()) {
            arrayList = new ArrayList();
            Thread thread = new Thread(){

                public void run() {
                    ArrayList arrayList2 = V2CRSSEntryList.this.vRSSItem.getAndParse();
                    if (arrayList2 != null) {
                        int n = arrayList2.size();
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(arrayList2.get(i));
                        }
                    }
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
                V2CHttpUtil.threadInterrupted(thread);
                return false;
            }
            if (arrayList.size() > 0) {
                arrayList2 = arrayList;
            }
        } else {
            arrayList2 = this.vRSSItem.parseLocal();
        }
        if (arrayList2 == null) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.rssTableModel.setNewList(arrayList2);
            this.scrollToRow(0);
            this.indicateSortColumn(-1);
        } else {
            arrayList = arrayList2;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    V2CRSSEntryList.this.rssTableModel.setNewList(arrayList);
                    V2CRSSEntryList.this.scrollToRow(0);
                    V2CRSSEntryList.this.indicateSortColumn(-1);
                }
            });
        }
        V2CMain.setMessage(this.vRSSItem.getName() + ": " + arrayList2.size());
        return true;
    }

    V2CRSSEntry getSelectedEntry() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.rssTableModel.getRSSEntry(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void openSelectedLink(boolean bl, boolean bl2, boolean bl3) {
        String string;
        if (bl2) {
            if (!bl3) return;
            string = bl ? "WN" : "WC";
        } else {
            string = "EX";
        }
        this.openSelectedLink(string);
    }

    void openSelectedLink(String string) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        V2CBoardItem v2CBoardItem;
        Matcher matcher;
        if (string == null) {
            return;
        }
        V2CRSSEntry v2CRSSEntry = this.getSelectedEntry();
        if (v2CRSSEntry == null) {
            return;
        }
        String string2 = v2CRSSEntry.getURLString();
        if (string2 == null) {
            return;
        }
        if (this.vRSSItem.getURLString().indexOf(".sitepedia.jp/") > 0 && (matcher = Pattern.compile("\\?thread=([-_.!~*a-zA-Z0-9/@+$,%]+/\\d{9,10}/)", 2).matcher(string2)).find()) {
            string2 = "http://" + matcher.group(1);
        }
        if (string.equals("EX")) {
            V2CMiscUtil.openLinkOutside(string2);
            return;
        }
        matcher = Pattern.compile("http://www\\.2nn\\.jp(/[-\\w]+/)(\\d{9,10})/").matcher(string2);
        if (matcher.matches() && (v2CBoardItem = V2CBBS.get2chBBS().findBoardByDirName(matcher.group(1))) != null) {
            string2 = v2CBoardItem.createThreadURLStringK(matcher.group(2));
        }
        if (string.equals("WC")) {
            bl3 = false;
            bl2 = true;
            bl = true;
        } else if (string.equals("WN")) {
            bl3 = true;
            bl2 = true;
            bl = true;
        } else {
            return;
        }
        V2CMiscUtil.openUnknownLink(string2, bl3, true, bl2, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        boolean bl = false;
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            int n = tableColumnModel.getColumn(i).getWidth();
            if (nlColWidth[i] == n) continue;
            V2CRSSEntryList.nlColWidth[i] = tableColumnModel.getColumn(i).getWidth();
            bl = true;
        }
        if (bl) {
            HashMap hashMap = hmRSSItemList;
            synchronized (hashMap) {
                Iterator iterator = hmRSSItemList.values().iterator();
                while (iterator.hasNext()) {
                    V2CRSSEntryList v2CRSSEntryList = (V2CRSSEntryList)iterator.next();
                    if (v2CRSSEntryList == this) continue;
                    v2CRSSEntryList.setColumnState(false);
                }
            }
        }
    }

    String getRowURLString(int n) {
        V2CRSSEntry v2CRSSEntry = this.rssTableModel.getRSSEntry(n);
        return v2CRSSEntry != null ? v2CRSSEntry.getURLString() : null;
    }

    String getPanelURLString() {
        return this.vRSSItem.getURLString();
    }

    void showPopup(MouseEvent mouseEvent, Point point) {
        int n = this.rowAtPoint(point);
        if (n < 0) {
            return;
        }
        if (mouseEvent != null) {
            mouseEvent.consume();
        }
        this.changeSelection(n, 0, false, false);
        JPopupMenu jPopupMenu = V2CMain.getPopupMenu("RSSEntryList");
        if (jPopupMenu == null) {
            return;
        }
        V2CPopupListener.showPopup(jPopupMenu, mouseEvent, this, point.x, point.y);
    }

    void doSortColumn(int n) {
        this.rssTableModel.sort(n);
    }

    int getTitleColumnIndex() {
        return 2;
    }

    V2CListTableModel getListTableModel() {
        return this.rssTableModel;
    }

    static {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        for (int i = 0; i < slColumnLabel.length; ++i) {
            V2CRSSEntryList.nlColWidth[i] = v2CProperty.getInt(sColumnWidthKeyPrefix + slColumnLabel[i][1]);
        }
    }

    private class ListRenderer
    extends V2CListTable.ListItemRenderer {
        private ListRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(n2 == 0 || n2 == 3 ? 4 : 2);
            if (!bl) {
                this.setForeground(V2CListTable.cTextFG);
                V2CRSSEntry v2CRSSEntry = V2CRSSEntryList.this.rssTableModel.getRSSEntry(n);
                if ((V2CListTable.bApplyNIBGToAllColumn || n2 == 0) && v2CRSSEntry != null && v2CRSSEntry.isNew()) {
                    this.setBackground(V2CListTable.cNewItemBG);
                } else {
                    this.setBackground(n % 2 == 0 ? V2CListTable.cOddBG : V2CListTable.cEvenBG);
                }
            }
            return this;
        }
    }

    private static class RSSTableModel
    extends V2CListTableModel {
        private RSSTableModel() {
        }

        String getTitle(int n) {
            return (String)this.getValueAt(n, 2);
        }

        public int getColumnCount() {
            return 5;
        }

        String getRealColumnName(int n) {
            return slColumnLabel[n][0];
        }

        public Object getValueAt(int n, int n2) {
            if (this.olTemp == null) {
                return null;
            }
            Object[] objectArray = (Object[])this.olTemp[n];
            if (objectArray == null) {
                return null;
            }
            return objectArray[n2];
        }

        V2CRSSEntry getRSSEntry(int n) {
            Object object = this.getValueAt(n, 5);
            return (V2CRSSEntry)object;
        }

        void sort(int n) {
            if (this.olTemp == null) {
                return;
            }
            this.bAscending = n == this.nColSort ? !this.bAscending : false;
            this.nColSort = n;
            Arrays.sort(this.olTemp, 0, this.getRowCount(), this);
            this.fireTableDataChanged();
        }

        public int compare(Object object, Object object2) {
            int n;
            String string = (String)((Object[])object)[this.nColSort];
            String string2 = (String)((Object[])object2)[this.nColSort];
            if (string == null) {
                n = string2 == null ? 0 : -1;
            } else if (string2 == null) {
                n = 1;
            } else {
                n = string.length() - string2.length();
                if (n == 0) {
                    n = this.nColSort == 2 ? string.compareToIgnoreCase(string2) : string.compareTo(string2);
                }
            }
            return this.bAscending ? n : -n;
        }
    }

    private class TableHeaderListener
    extends MouseInputAdapter {
        int nDragCount;

        private TableHeaderListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ++this.nDragCount;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.nDragCount = 0;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                if (mouseEvent.getClickCount() == 1 && this.nDragCount < 2 && mouseEvent.getButton() == 1) {
                    V2CRSSEntryList.this.sortColumn(V2CRSSEntryList.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX()));
                } else {
                    V2CRSSEntryList.this.rememberColumnWidths();
                }
            }
        }
    }

    private class PopupListener
    extends V2CListTable.TitlePopupListener {
        private PopupListener() {
        }

        boolean isActiveColumn(int n) {
            return n >= 0;
        }

        void doClickAction(MouseEvent mouseEvent, int n, int n2) {
            String string = V2CMouseClickManager.checkClickAction("E", mouseEvent);
            V2CRSSEntryList.this.openSelectedLink(string);
        }
    }
}

