/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CReplayController
extends JPanel
implements ActionListener,
MouseWheelListener {
    private static final Color cNormal = new Color(8900331);
    private static final Color cPaused = new Color(10025880);
    private static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
    final V2CThreadPanel vThreadPanel;
    JButton jbStart;
    JButton jbPause;
    JButton jbStop;
    JToggleButton jtbOneLineMode;
    JLabel jlTimeIndicator;
    long lTime;
    JButton jbSet;
    JButton jbClose;

    public V2CReplayController(V2CThreadPanel v2CThreadPanel, long l) {
        super(new GridBagLayout());
        JLabel jLabel;
        this.vThreadPanel = v2CThreadPanel;
        if (V2CApp.isMacintosh()) {
            this.setOpaque(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        Insets insets = new Insets(2, 7, 2, 7);
        this.jbStart = this.createButton("arstart", insets, gridBagConstraints);
        this.jbPause = this.createButton("arpause", insets, gridBagConstraints);
        this.jbStop = this.createButton("arstop", insets, gridBagConstraints);
        Insets insets2 = new Insets(2, 2, 2, 2);
        this.jtbOneLineMode = this.createToggleButton("ar1lmode", v2CThreadPanel.isOneLineMode(), insets2, gridBagConstraints);
        this.jlTimeIndicator = jLabel = new JLabel("00:00:00");
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        jLabel.setOpaque(true);
        jLabel.addMouseWheelListener(this);
        this.setTime(l);
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jbSet = this.createButton("arset", insets2, gridBagConstraints);
        this.jbClose = this.createButton("arclose", insets2, gridBagConstraints);
    }

    private JButton createButton(String string, Insets insets, GridBagConstraints gridBagConstraints) {
        JButton jButton = new JButton(V2CSwingUtil.getSystemIcon(string));
        jButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(jButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(jButton);
        }
        jButton.setMargin(insets);
        jButton.addActionListener(this);
        this.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jButton;
    }

    private JToggleButton createToggleButton(String string, boolean bl, Insets insets, GridBagConstraints gridBagConstraints) {
        JToggleButton jToggleButton = new JToggleButton(V2CSwingUtil.getSystemIcon(string));
        jToggleButton.setFocusable(false);
        if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(jToggleButton);
            V2CMacQuaquaSupport.setSquareButtonStyle(jToggleButton);
        }
        if (bl) {
            jToggleButton.setSelected(bl);
        }
        jToggleButton.setMargin(insets);
        jToggleButton.addActionListener(this);
        this.add((Component)jToggleButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        return jToggleButton;
    }

    boolean isOneLineMode() {
        return this.jtbOneLineMode.isSelected();
    }

    void setOneLineMode(boolean bl) {
        this.jtbOneLineMode.setSelected(bl);
    }

    void setMode(V2CReplayController v2CReplayController) {
        if (v2CReplayController != null) {
            this.jtbOneLineMode.setSelected(v2CReplayController.jtbOneLineMode.isSelected());
        }
    }

    long getTime() {
        return this.lTime;
    }

    void setTime(long l) {
        l -= l % 1000L;
        this.lTime = l;
        String string = sdfTime.format(new Date(l));
        if (!string.equals(this.jlTimeIndicator.getText())) {
            this.jlTimeIndicator.setText(string);
        }
    }

    void started() {
        this.setIndicatorColor(cNormal);
    }

    void stopped() {
        this.setIndicatorColor(null);
    }

    void paused() {
        this.setIndicatorColor(cPaused);
    }

    void setIndicatorColor(Color color) {
        this.jlTimeIndicator.setBackground(color);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jbStart) {
            this.vThreadPanel.startReplay(true);
        } else if (object == this.jbPause) {
            this.vThreadPanel.togglePauseReplay();
        } else if (object == this.jbStop) {
            this.vThreadPanel.stopReplay(true);
        } else if (object == this.jtbOneLineMode) {
            this.vThreadPanel.setOneLineMode(this.jtbOneLineMode.isSelected());
        } else if (object == this.jbSet) {
            this.vThreadPanel.setReplay();
        } else if (object == this.jbClose) {
            this.vThreadPanel.hideReplayController(true);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.vThreadPanel.isReplaying()) {
            return;
        }
        long l = this.lTime;
        if (l <= 0L) {
            l = this.vThreadPanel.replayCurrentTime();
            if (l <= 0L) {
                return;
            }
            this.lTime = l;
        }
        this.setTime(l + (long)(mouseWheelEvent.getWheelRotation() * 1000));
    }
}

