/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.monazilla.v2c.V2CDnDTree;
import org.monazilla.v2c.V2CExtCommand;
import org.monazilla.v2c.V2CQuickImageSaveEntry;
import org.monazilla.v2c.V2CShortPhraseItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTreeFolder;

public class V2CSPTree
extends V2CDnDTree {
    static void checkDuplicatedMnemonic(final DefaultMutableTreeNode defaultMutableTreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                V2CSPTree.checkDuplicatedMnemonic0(defaultMutableTreeNode);
            }
        });
    }

    private static void checkDuplicatedMnemonic0(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        int n = defaultMutableTreeNode2.getChildCount();
        if (n <= 1) {
            return;
        }
        boolean[] blArray = new boolean[90];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
            Object object = defaultMutableTreeNode3.getUserObject();
            char c = '\u0000';
            if (object instanceof V2CTreeFolder) {
                c = ((V2CTreeFolder)object).getMnemonic();
            } else if (object instanceof V2CQuickImageSaveEntry) {
                c = ((V2CQuickImageSaveEntry)object).getMnemonic();
            } else if (object instanceof V2CShortPhraseItem) {
                c = ((V2CShortPhraseItem)object).getMnemonic();
            }
            if (c <= '\u0000' || c >= blArray.length) continue;
            if (blArray[c]) {
                V2CSwingUtil.showWarningMessage("\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8\uff08" + c + "\uff09\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                return;
            }
            blArray[c] = true;
        }
    }

    public V2CSPTree(TreeModel treeModel) {
        super(treeModel, true, true);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultTreeSelectionModel);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null || treePath.getPathCount() <= 1) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof V2CQuickImageSaveEntry) {
            return ((V2CQuickImageSaveEntry)object).getToolTipText();
        }
        if (object instanceof V2CExtCommand) {
            return ((V2CExtCommand)object).getToolTipText();
        }
        return null;
    }

    Enumeration getNodeEnumeration() {
        return ((DefaultMutableTreeNode)this.getModel().getRoot()).preorderEnumeration();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        super.drop(dropTargetDropEvent);
        V2CSPTree.checkDuplicatedMnemonic(this.mtnDraggedNode);
    }

    DefaultMutableTreeNode copyNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof V2CTreeFolder) {
            object = new V2CTreeFolder((V2CTreeFolder)object);
            bl = true;
        } else if (object instanceof V2CQuickImageSaveEntry) {
            object = new V2CQuickImageSaveEntry((V2CQuickImageSaveEntry)object);
        } else if (object instanceof V2CShortPhraseItem) {
            object = new V2CShortPhraseItem((V2CShortPhraseItem)object);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object, bl);
        if (defaultMutableTreeNode.getAllowsChildren()) {
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                defaultMutableTreeNode2.add(this.copyNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)));
            }
        }
        return defaultMutableTreeNode2;
    }
}

