/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CSSColor;
import org.monazilla.v2c.V2CSSDistance;
import org.monazilla.v2c.V2CStyleSheet;

public class V2CSSTextShadow {
    final V2CSSDistance ssdXOffset;
    final V2CSSDistance ssdYOffset;
    final Color cColor;
    int nXOffset;
    int nYOffset;
    private static final Pattern pLength = Pattern.compile("(-?\\d+[\\w.]+|0)(?:\\s+|$)");

    static V2CSSTextShadow parse(String string) {
        Matcher matcher = pLength.matcher(string);
        V2CSSDistance[] v2CSSDistanceArray = new V2CSSDistance[2];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (!matcher.find(n) || matcher.start() != n) {
                return null;
            }
            n = matcher.end();
            V2CSSDistance v2CSSDistance = V2CSSDistance.parse(matcher.group(1));
            if (v2CSSDistance == null) {
                return null;
            }
            v2CSSDistanceArray[n2++] = v2CSSDistance;
        }
        if (n2 != 2) {
            return null;
        }
        V2CSSColor v2CSSColor = null;
        if (n < string.length()) {
            v2CSSColor = V2CSSColor.parseColor(string.substring(n));
        }
        return new V2CSSTextShadow(v2CSSDistanceArray[0], v2CSSDistanceArray[1], v2CSSColor);
    }

    private V2CSSTextShadow(V2CSSDistance v2CSSDistance, V2CSSDistance v2CSSDistance2, V2CSSColor v2CSSColor) {
        this.ssdXOffset = v2CSSDistance;
        this.ssdYOffset = v2CSSDistance2;
        this.cColor = v2CSSColor != null ? v2CSSColor.getColor() : Color.BLACK;
    }

    private V2CSSTextShadow(V2CSSTextShadow v2CSSTextShadow) {
        this.ssdXOffset = v2CSSTextShadow.ssdXOffset;
        this.ssdYOffset = v2CSSTextShadow.ssdYOffset;
        this.cColor = v2CSSTextShadow.cColor;
    }

    void calcOffsets(V2CStyleSheet v2CStyleSheet) {
        this.nXOffset = (int)v2CStyleSheet.getValue(this.ssdXOffset);
        this.nYOffset = (int)v2CStyleSheet.getValue(this.ssdYOffset);
    }

    V2CSSTextShadow duplicate(V2CStyleSheet v2CStyleSheet) {
        V2CSSTextShadow v2CSSTextShadow = new V2CSSTextShadow(this);
        v2CSSTextShadow.calcOffsets(v2CStyleSheet);
        return v2CSSTextShadow;
    }
}

