/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CLinkTextSegment;
import org.monazilla.v2c.V2CMiscUtil;

public final class V2CScriptLink {
    private String sURL;
    private URL vURL;
    private Reference refLinkTextSegment;

    V2CScriptLink(V2CLinkTextSegment v2CLinkTextSegment) {
        this.sURL = v2CLinkTextSegment.getURLString();
        this.refLinkTextSegment = new WeakReference<V2CLinkTextSegment>(v2CLinkTextSegment);
    }

    V2CScriptLink(String string) {
        this.sURL = string;
    }

    V2CScriptLink(URL uRL) {
        this.vURL = uRL;
    }

    public URL getUrl() {
        return this.getURL();
    }

    public URL getURL() {
        if (this.vURL != null) {
            return this.vURL;
        }
        if (this.sURL == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(this.sURL);
        }
        catch (MalformedURLException malformedURLException) {
            this.sURL = null;
        }
        this.vURL = uRL;
        return uRL;
    }

    public boolean getType_IMAGE() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return this.checkType_IMAGE();
            }

            private boolean checkType_IMAGE() {
                Object object;
                Reference reference = V2CScriptLink.this.refLinkTextSegment;
                if (reference != null && (object = (V2CLinkTextSegment)reference.get()) != null) {
                    return ((V2CLinkTextSegment)object).isImageLink();
                }
                object = V2CScriptLink.this.getURL();
                return object != null ? V2CMiscUtil.checkImageLink(((URL)object).toString()) : false;
            }
        });
    }

    public File getImageCacheFile() {
        URL uRL = this.getURL();
        if (uRL == null) {
            return null;
        }
        final V2CLink v2CLink = V2CLink.getFromHistory(uRL);
        if (v2CLink == null) {
            return null;
        }
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return v2CLink.getImageFile();
            }
        });
    }

    public String toString() {
        URL uRL = this.getURL();
        return uRL != null ? uRL.toString() : null;
    }
}

