/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.AWTPermission;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CEvalScript;
import org.monazilla.v2c.V2CExtCommand;
import org.monazilla.v2c.V2CGetDatScript;
import org.monazilla.v2c.V2CImageCacheScript;
import org.monazilla.v2c.V2CJSE6Util;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMenuScript;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPostScript;
import org.monazilla.v2c.V2CProxyScript;
import org.monazilla.v2c.V2CResCheckScript;
import org.monazilla.v2c.V2CRuntimePermission;
import org.monazilla.v2c.V2CScriptApp;
import org.monazilla.v2c.V2CScriptClassLoader;
import org.monazilla.v2c.V2CScriptConsole;
import org.monazilla.v2c.V2CScriptSP;
import org.monazilla.v2c.V2CScriptTLBSContext;
import org.monazilla.v2c.V2CScriptThread;
import org.monazilla.v2c.V2CSubjectScript;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CSystemScript;
import org.monazilla.v2c.V2CThreadUpdateScript;

public class V2CScriptUtil {
    private static final String sJavaScript = "JavaScript";
    private static AccessControlContext vDefaultAccessControlContext;
    private static AccessControlContext vAllAccessControlContext;
    private static boolean bSecurityManagerInstalled;
    private static boolean bSecurityManagerInstallFailed;
    private static boolean bSOMJ;
    private static boolean bSOMJChecked;

    static void printMessage(String s) {
        V2CScriptConsole.appendText(String.valueOf(s) + '\n');
        V2CMain.setMessage(V2CMiscUtil.replaceChar(s, '\n', ' '));
    }

    private static void checkSOMJ(Permissions permissions) {
        if (!bSOMJChecked) {
            try {
                Class.forName("sun.org.mozilla.javascript.DefiningClassLoader");
                bSOMJ = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bSOMJChecked = true;
        }
        if (bSOMJ) {
            permissions.add(new RuntimePermission("createClassLoader"));
            permissions.add(new RuntimePermission("accessClassInPackage.sun.org.mozilla.*"));
        }
    }

    private static synchronized boolean checkSecurityManager() {
        if (bSecurityManagerInstallFailed) {
            return false;
        }
        if (bSecurityManagerInstalled) {
            return true;
        }
        boolean flag = false;
        bSecurityManagerInstallFailed = true;
        try {
            Policy.setPolicy(new AllPermissionPolicy());
            Method method = System.class.getMethod("setSecurityManager", SecurityManager.class);
            method.invoke(null, new SecurityManager());
            flag = true;
            bSecurityManagerInstallFailed = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bSecurityManagerInstalled = flag;
        if (!flag) {
            V2CSwingUtil.showErrorMessage("SecurityManager\u306e\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        return flag;
    }

    private static void addAccessEventQueuePermission(Permissions permissions) {
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 7)) {
            permissions.add(new AWTPermission("accessEventQueue"));
        }
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 8)) {
            permissions.add(new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.objects"));
        }
    }

    private static void addDefaultPropertyPermissions(Permissions permissions) {
        String[] as = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.version", "os.arch", "file.encoding", "file.separator", "path.separator", "line.separator", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name"};
        int i = 0;
        while (i < as.length) {
            permissions.add(new PropertyPermission(as[i], "read"));
            ++i;
        }
    }

    private static void addPermission(Permissions permissions, Permission permission, SecurityManager securitymanager) {
        if (securitymanager != null) {
            try {
                securitymanager.checkPermission(permission);
            }
            catch (SecurityException securityexception) {
                return;
            }
        }
        permissions.add(permission);
    }

    static AccessControlContext createAccessControlContext(String s) {
        return V2CScriptUtil.createAccessControlContext(s, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AccessControlContext createAccessControlContext(String s, SecurityManager securitymanager) {
        int i;
        if (s == null || (i = s.length()) == 0) {
            AccessControlContext accesscontrolcontext1;
            AccessControlContext accesscontrolcontext = vDefaultAccessControlContext;
            if (accesscontrolcontext != null) {
                return accesscontrolcontext;
            }
            Permissions permissions1 = new Permissions();
            V2CScriptUtil.checkSOMJ(permissions1);
            V2CScriptUtil.addAccessEventQueuePermission(permissions1);
            V2CScriptUtil.addDefaultPropertyPermissions(permissions1);
            vDefaultAccessControlContext = accesscontrolcontext1 = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions1)});
            return accesscontrolcontext1;
        }
        if (i == 1 && s.charAt(0) == 'A') {
            AccessControlContext accesscontrolcontext2 = vAllAccessControlContext;
            if (accesscontrolcontext2 != null && securitymanager == null) {
                return accesscontrolcontext2;
            }
            Permissions permissions2 = new Permissions();
            V2CScriptUtil.checkSOMJ(permissions2);
            V2CScriptUtil.addAccessEventQueuePermission(permissions2);
            V2CScriptUtil.addPermission(permissions2, new PropertyPermission("*", "read"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new FilePermission("<<ALL FILES>>", "read,write,execute,delete"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new V2CRuntimePermission("changeFavorite"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new V2CRuntimePermission("changeProperty"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new RuntimePermission("accessClassInPackage.com.sun.javafx.geom.BaseBounds"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new RuntimePermission("exitVM"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new SocketPermission("*", "connect"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new AWTPermission("accessClipboard"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new AWTPermission("showWindowWithoutWarningBanner"), securitymanager);
            V2CScriptUtil.addPermission(permissions2, new AWTPermission("setWindowAlwaysOnTop"), securitymanager);
            accesscontrolcontext2 = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions2)});
            if (securitymanager != null) return accesscontrolcontext2;
            vAllAccessControlContext = accesscontrolcontext2;
            return accesscontrolcontext2;
        }
        Permissions permissions = new Permissions();
        V2CScriptUtil.checkSOMJ(permissions);
        V2CScriptUtil.addAccessEventQueuePermission(permissions);
        boolean flag = false;
        boolean flag1 = false;
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            if (c == 'A') {
                return null;
            }
            if (c <= 'A' || c > 'Z') return null;
            if (c == 'F') {
                StringBuffer stringbuffer = new StringBuffer();
                int j1 = j + 1;
                while (j1 < i) {
                    char c4 = s.charAt(j1);
                    if (c4 >= 'A' && c4 <= 'Z') break;
                    if (c4 == 'r') {
                        stringbuffer.append("read,");
                    } else if (c4 == 'w') {
                        stringbuffer.append("write,");
                    } else if (c4 == 'x') {
                        stringbuffer.append("execute,");
                    } else {
                        if (c4 != 'd') return null;
                        stringbuffer.append("delete,");
                    }
                    ++j1;
                }
                j = j1 - 1;
                j1 = stringbuffer.length();
                String s1 = j1 > 0 ? stringbuffer.substring(0, j1 - 1) : "read,write,execute,delete";
                V2CScriptUtil.addPermission(permissions, new FilePermission("<<ALL FILES>>", s1), securitymanager);
            } else if (c == 'P') {
                V2CScriptUtil.addPermission(permissions, new PropertyPermission("*", "read"), securitymanager);
                flag = true;
            } else if (c == 'R') {
                char c1;
                int k;
                for (k = j + 1; k < i && ((c1 = s.charAt(k)) < 'A' || c1 > 'Z'); ++k) {
                    if (c1 != 'x') {
                        return null;
                    }
                    V2CScriptUtil.addPermission(permissions, new RuntimePermission("exitVM"), securitymanager);
                }
                if (j == k - 1) {
                    V2CScriptUtil.addPermission(permissions, new RuntimePermission("exitVM"), securitymanager);
                } else {
                    j = k - 1;
                }
            } else if (c == 'S') {
                V2CScriptUtil.addPermission(permissions, new SocketPermission("*", "connect"), securitymanager);
            } else if (c == 'T') {
                int l = j + 1;
                while (l < i) {
                    char c2 = s.charAt(l);
                    if (c2 >= 'A' && c2 <= 'Z') break;
                    if (c2 == 'c') {
                        V2CScriptUtil.addPermission(permissions, new AWTPermission("accessClipboard"), securitymanager);
                    } else if (c2 == 't') {
                        V2CScriptUtil.addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securitymanager);
                    } else {
                        if (c2 != 'w') return null;
                        V2CScriptUtil.addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securitymanager);
                    }
                    ++l;
                }
                if (j == l - 1) {
                    V2CScriptUtil.addPermission(permissions, new AWTPermission("accessClipboard"), securitymanager);
                    V2CScriptUtil.addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securitymanager);
                    V2CScriptUtil.addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securitymanager);
                } else {
                    j = l - 1;
                }
            } else {
                if (c != 'V') return null;
                int i1 = j + 1;
                while (i1 < i) {
                    char c3 = s.charAt(i1);
                    if (c3 >= 'A' && c3 <= 'Z') break;
                    if (c3 == 'f') {
                        V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securitymanager);
                    } else {
                        if (c3 != 'p') return null;
                        V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeProperty"), securitymanager);
                    }
                    ++i1;
                }
                if (j == i1 - 1) {
                    V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securitymanager);
                    V2CScriptUtil.addPermission(permissions, new V2CRuntimePermission("changeProperty"), securitymanager);
                } else {
                    j = i1 - 1;
                }
            }
            ++j;
        }
        if (flag) return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        V2CScriptUtil.addDefaultPropertyPermissions(permissions);
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private static V2CEvalScript createEvalScript(V2CExtCommand v2cextcommand, String s, ActionEvent actionevent, boolean flag, boolean flag1, boolean flag2) {
        V2CScriptClassLoader v2cscriptclassloader;
        String s5;
        File file;
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c\u306b\u306fJRE6\u4ee5\u4e0a\u304c\u5fc5\u8981\u3067\u3059\u3002");
            return null;
        }
        if (!V2CScriptUtil.checkSecurityManager()) {
            return null;
        }
        String s1 = v2cextcommand.getCommand();
        Matcher matcher = Pattern.compile("\\$(?:SCRIPT|\\{SCRIPT(?:\\[([-/\\w]+)\\])?(?::(\\p{Alpha}*))?\\})\\s+").matcher(s1);
        if (!matcher.lookingAt()) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            return null;
        }
        String s2 = null;
        if (matcher.groupCount() >= 1) {
            s2 = matcher.group(1);
        }
        if (s2 == null) {
            s2 = sJavaScript;
        }
        s1 = s1.substring(matcher.end());
        String s3 = s2;
        Matcher matcher1 = Pattern.compile("(<?[-\\w.\\\\/]+>?)\\s*").matcher(s1);
        if (!matcher1.lookingAt()) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return null;
        }
        String s4 = matcher1.group(1);
        int i = s4.length();
        if (i > 2 && s4.charAt(0) == '<' && s4.charAt(i - 1) == '>') {
            file = null;
            s5 = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/" + s4.substring(1, i - 1));
        } else {
            file = V2CLocalFileHandler.getScriptFile(s4);
            if (file == null) {
                V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                return null;
            }
            if (!file.isFile()) {
                V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                return null;
            }
            s5 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
        }
        if (s5 == null || s5.length() <= 1) {
            V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u304c\u7a7a\u3067\u3059\u3002");
            return null;
        }
        if (s5.charAt(0) == '\ufeff') {
            if (s5.length() == 1) {
                V2CSwingUtil.showErrorMessage("\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u304c\u7a7a\u3067\u3059\u3002");
                return null;
            }
            s5 = s5.substring(1);
        }
        if (s != null) {
            s5 = String.valueOf(s5) + s;
        }
        if ((v2cscriptclassloader = V2CScriptClassLoader.getInstance()) == null) {
            V2CSwingUtil.showErrorMessage("\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return null;
        }
        AccessControlContext accesscontrolcontext = V2CScriptUtil.createAccessControlContext(matcher.group(2));
        if (accesscontrolcontext == null) {
            V2CSwingUtil.showErrorMessage("\u30d1\u30fc\u30df\u30c3\u30b7\u30e7\u30f3\u306e\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002\n\n" + matcher.group(2));
            return null;
        }
        V2CScriptApp v2cscriptapp = new V2CScriptApp(file, s1.substring(matcher1.end()), v2cextcommand, actionevent, flag, flag1, flag2);
        return new V2CEvalScript(s3, s5, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
    }

    static void execScript(V2CExtCommand v2cextcommand, ActionEvent actionevent, boolean flag, boolean flag1, boolean flag2) {
        V2CEvalScript v2cevalscript = V2CScriptUtil.createEvalScript(v2cextcommand, null, actionevent, flag, flag1, flag2);
        if (v2cevalscript == null) {
            return;
        }
        Thread thread = new Thread(v2cevalscript);
        thread.start();
    }

    static Object evalScriptFunction(V2CExtCommand v2cextcommand, ActionEvent actionevent, String s, Object[] aobj) {
        V2CEvalScript v2cevalscript = V2CScriptUtil.createEvalScript(v2cextcommand, null, actionevent, false, false, false);
        if (v2cevalscript == null) {
            return null;
        }
        v2cevalscript.setInvokeFunction(s, aobj);
        v2cevalscript.run();
        return v2cevalscript.getResult();
    }

    static void redirectURL(V2CEvalScript v2cevalscript, URL url) {
        v2cevalscript.redirectURL(url);
        Thread thread = new Thread(v2cevalscript);
        thread.start();
    }

    static void formSubmitted(V2CEvalScript v2cevalscript, URL url, String s, String s1) {
        v2cevalscript.formSubmitted(url, s, s1);
        Thread thread = new Thread(v2cevalscript);
        thread.start();
    }

    static boolean startResCheckScript() {
        AccessControlContext accesscontrolcontext;
        V2CScriptClassLoader v2cscriptclassloader;
        String s;
        File file;
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("V2CScriptUtil.startResCheckScript");
        }
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            return false;
        }
        if (!V2CScriptUtil.checkSecurityManager()) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("SecurityManager OK");
        }
        if (!(file = V2CLocalFileHandler.getSystemScriptFile("rescheck.js")).isFile()) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("ResCheckScriptFile OK");
        }
        if ((s = V2CLocalFileHandler.restoreFromFile(file, "UTF-8")) == null || s.length() <= 1) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("Read OK");
        }
        if (s.charAt(0) == '\ufeff') {
            if (s.length() == 1) {
                return false;
            }
            s = s.substring(1);
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("Read2 OK");
        }
        if ((v2cscriptclassloader = V2CScriptClassLoader.getInstance()) == null) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("ClassLoader OK");
        }
        if ((accesscontrolcontext = V2CScriptUtil.createAccessControlContext(V2CSystemScript.getPermissionString("rescheck.js"))) == null) {
            return false;
        }
        if (V2CResCheckScript.bPrintDebugInfo) {
            System.out.println("AccessControlContext OK");
        }
        return V2CResCheckScript.startScript(s, v2cscriptclassloader, accesscontrolcontext);
    }

    static V2CSystemScript createSystemScript(String s) {
        V2CScriptClassLoader v2cscriptclassloader;
        if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            return null;
        }
        if (!V2CScriptUtil.checkSecurityManager()) {
            return null;
        }
        File file = V2CLocalFileHandler.getSystemScriptFile(s);
        if (!file.isFile()) {
            return null;
        }
        String s1 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
        if (s1 == null || s1.length() <= 1) {
            return null;
        }
        if (s1.charAt(0) == '\ufeff') {
            if (s1.length() == 1) {
                return null;
            }
            s1 = s1.substring(1);
        }
        if ((v2cscriptclassloader = V2CScriptClassLoader.getInstance()) == null) {
            return null;
        }
        AccessControlContext accesscontrolcontext = V2CScriptUtil.createAccessControlContext(V2CSystemScript.getPermissionString(s));
        if (accesscontrolcontext == null) {
            return null;
        }
        if (s.equals("subject.js")) {
            return V2CSubjectScript.createSubjectScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        if (s.equals("imgcache.js")) {
            return V2CImageCacheScript.createImageCacheScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        if (s.equals("menu.js")) {
            return V2CMenuScript.createMenuScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        if (s.equals("getdat.js")) {
            return V2CGetDatScript.createGetDatScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        if (s.equals("threadld.js")) {
            return V2CThreadUpdateScript.createThreadUpdateScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        if (s.equals("post.js")) {
            return V2CPostScript.createPostScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        if (s.equals("proxy.js")) {
            return V2CProxyScript.createProxyScript(s1, v2cscriptclassloader, accesscontrolcontext);
        }
        return null;
    }

    static V2CScriptSP createScriptSP() {
        return new V2CScriptSP(new String[]{"subject.js", "rescheck.js", "imgcache.js", "menu.js", "getdat.js", "threadld.js", "post.js", "proxy.js"});
    }

    static boolean getThreadsForTLBS(V2CExtCommand v2cextcommand, ArrayList arraylist, V2CScriptTLBSContext v2cscripttlbscontext) {
        String s = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/tlbsft.js");
        if (s == null) {
            return false;
        }
        V2CEvalScript v2cevalscript = V2CScriptUtil.createEvalScript(v2cextcommand, s, null, false, false, false);
        if (v2cevalscript == null) {
            return false;
        }
        v2cevalscript.run();
        PrivilegedExceptionAction privilegedexceptionaction = v2cevalscript.vPrivilegedExceptionAction;
        if (privilegedexceptionaction == null) {
            return false;
        }
        V2CJSE6Util.setInvokeFunction(privilegedexceptionaction, "_v2c_getThreads", new Object[]{v2cscripttlbscontext});
        Object obj = V2CScriptUtil.execPEA(privilegedexceptionaction, v2cevalscript.vScriptApp, v2cevalscript.vScriptClassLoader, v2cevalscript.vAccessControlContext);
        if (v2cscripttlbscontext.getSkip()) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List list = (List)obj;
        int i = list.size();
        int j = 0;
        while (j < i) {
            Object obj1 = list.get(j);
            if (!(obj1 instanceof V2CScriptThread)) {
                return false;
            }
            arraylist.add(((V2CScriptThread)obj1).getThreadItem());
            ++j;
        }
        return true;
    }

    static Object execPEA(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp, V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext) {
        Object obj;
        String s;
        block6: {
            s = null;
            Thread thread = Thread.currentThread();
            ClassLoader classloader = thread.getContextClassLoader();
            thread.setContextClassLoader(v2cscriptclassloader);
            obj = null;
            try {
                try {
                    obj = AccessController.doPrivileged(privilegedexceptionaction, accesscontrolcontext);
                }
                catch (PrivilegedActionException privilegedactionexception) {
                    s = "\u30b9\u30af\u30ea\u30d7\u30c8\u5b9f\u884c\u30a8\u30e9\u30fc\uff1a " + privilegedactionexception.getException().getMessage();
                    thread.setContextClassLoader(classloader);
                    V2CMain.endTempMessage(v2cscriptapp);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                thread.setContextClassLoader(classloader);
                V2CMain.endTempMessage(v2cscriptapp);
                throw throwable;
            }
            thread.setContextClassLoader(classloader);
            V2CMain.endTempMessage(v2cscriptapp);
        }
        if (s != null) {
            V2CScriptUtil.setErrorMessage(s);
        }
        return obj;
    }

    static void setErrorMessage(String s) {
        if (s == null) {
            return;
        }
        V2CScriptConsole.appendText(String.valueOf(s) + '\n');
        V2CMain.setErrorMessage(s);
        System.out.println(s);
    }

    private static class AllPermissionPolicy
    extends Policy {
        final Permissions vPermissions;

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            return this.vPermissions;
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain protectiondomain) {
            return this.vPermissions;
        }

        @Override
        public void refresh() {
        }

        AllPermissionPolicy() {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            this.vPermissions = permissions;
        }
    }
}

