/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.monazilla.v2c.V2CAbstractMiniSearch;
import org.monazilla.v2c.V2CAction;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CFindPanel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CToolBarSP;

public class V2CSearchHistoryItem {
    private static final String sConfKey = "Search.Conf";
    private static final String sHistKey = "Search.History";
    private static final ArrayList alHistoryItems = new ArrayList();
    private static final int nDefMaxEntry = 20;
    static int nMaxEntry;
    static int nMaxSaveEntry;
    final String sSearchWord;
    final boolean bMigemo;
    final boolean bRegExp;
    final boolean bCaseSensitive;
    final boolean bAnd;
    final boolean bOr;
    final boolean bMark;
    private static final int MAX_DISPCHARS = 20;

    static void setHistoryNum(V2CToolBarSP v2CToolBarSP) {
        int n = V2CMiscUtil.restrictRange(0, v2CToolBarSP.getHistoryNum(), 100);
        int n2 = V2CMiscUtil.restrictRange(0, v2CToolBarSP.getHistorySaveNum(), 100);
        if (n == nMaxEntry && n2 == nMaxSaveEntry) {
            return;
        }
        int n3 = nMaxEntry;
        nMaxEntry = n;
        nMaxSaveEntry = n2;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (n != 20 || n2 != 20) {
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            if (n != 20) {
                v2CPackedPropValue.setInt('n', n);
            }
            if (n2 != 20) {
                v2CPackedPropValue.setInt('s', n2);
            }
            v2CProperty.putPackedValue(sConfKey, v2CPackedPropValue);
        } else {
            v2CProperty.remove(sConfKey);
        }
        if (n < n3) {
            V2CSearchHistoryItem.checkHistoryNum();
            V2CMain.clearMenus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkHistoryNum() {
        ArrayList arrayList;
        int n = 0;
        ArrayList arrayList2 = arrayList = alHistoryItems;
        synchronized (arrayList2) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                V2CSearchHistoryItem v2CSearchHistoryItem = (V2CSearchHistoryItem)arrayList.get(i);
                if (v2CSearchHistoryItem.bMark) continue;
                if (n >= nMaxEntry) {
                    for (int j = n2 - 1; j >= i; --j) {
                        arrayList.remove(j);
                    }
                    break;
                }
                ++n;
            }
        }
    }

    static void restoreHistory() {
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(sHistKey, 'W');
        if (v2CPackedPropValueArray == null) {
            return;
        }
        for (int i = v2CPackedPropValueArray.length - 1; i >= 0; --i) {
            V2CPackedPropValue v2CPackedPropValue = v2CPackedPropValueArray[i];
            String string = v2CPackedPropValue.getString('W');
            if (string == null || string.length() == 0) continue;
            V2CSearchHistoryItem v2CSearchHistoryItem = new V2CSearchHistoryItem(string, v2CPackedPropValue.getBoolean('J'), v2CPackedPropValue.getBoolean('R'), v2CPackedPropValue.getBoolean('C'), v2CPackedPropValue.getBoolean('a'), v2CPackedPropValue.getBoolean('o'), v2CPackedPropValue.getBoolean('m'));
            V2CSearchHistoryItem.add(v2CSearchHistoryItem, false);
        }
    }

    static void saveHistory() {
        int n = 0;
        ArrayList arrayList = alHistoryItems;
        ArrayList<V2CPackedPropValue> arrayList2 = new ArrayList<V2CPackedPropValue>();
        for (int i = 0; i < arrayList.size(); ++i) {
            V2CSearchHistoryItem v2CSearchHistoryItem = (V2CSearchHistoryItem)arrayList.get(i);
            if (v2CSearchHistoryItem.sSearchWord.length() == 0) continue;
            if (!v2CSearchHistoryItem.bMark) {
                if (n >= nMaxSaveEntry) break;
                ++n;
            }
            V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
            v2CPackedPropValue.setBoolean('J', v2CSearchHistoryItem.bMigemo);
            v2CPackedPropValue.setBoolean('R', v2CSearchHistoryItem.bRegExp);
            v2CPackedPropValue.setBoolean('C', v2CSearchHistoryItem.bCaseSensitive);
            v2CPackedPropValue.setBoolean('a', v2CSearchHistoryItem.bAnd);
            v2CPackedPropValue.setBoolean('o', v2CSearchHistoryItem.bOr);
            v2CPackedPropValue.setBoolean('m', v2CSearchHistoryItem.bMark);
            v2CPackedPropValue.setString('W', v2CSearchHistoryItem.sSearchWord);
            arrayList2.add(v2CPackedPropValue);
        }
        V2CApp.getUserProperty().putPackedValueArray(sHistKey, arrayList2.toArray(new V2CPackedPropValue[arrayList2.size()]));
    }

    static void add(V2CAbstractMiniSearch v2CAbstractMiniSearch) {
        V2CSearchHistoryItem.add(v2CAbstractMiniSearch.getStringForSave(), v2CAbstractMiniSearch.isMigemo(), v2CAbstractMiniSearch.isRegExp(), v2CAbstractMiniSearch.isCaseSensitive(), v2CAbstractMiniSearch.isAnd(), v2CAbstractMiniSearch.isOr());
    }

    static void add(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        V2CSearchHistoryItem v2CSearchHistoryItem = new V2CSearchHistoryItem(string, bl, bl2, bl3, bl4, bl5);
        V2CSearchHistoryItem.add(v2CSearchHistoryItem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(V2CSearchHistoryItem v2CSearchHistoryItem, boolean bl) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alHistoryItems;
        synchronized (arrayList2) {
            boolean bl2 = v2CSearchHistoryItem.bMark;
            int n = -1;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                V2CSearchHistoryItem v2CSearchHistoryItem2 = (V2CSearchHistoryItem)arrayList.get(i);
                boolean bl3 = v2CSearchHistoryItem2.bMark;
                if (n < 0 && !bl3) {
                    n = i;
                }
                if (!v2CSearchHistoryItem.equals(v2CSearchHistoryItem2)) continue;
                if (bl2) {
                    v2CSearchHistoryItem2 = v2CSearchHistoryItem;
                }
                int n4 = n3 = v2CSearchHistoryItem2.bMark ? 0 : Math.max(n, 0);
                if (i > n3 || bl2 && !bl3 && i == 0) {
                    arrayList.remove(i);
                    arrayList.add(n3, v2CSearchHistoryItem2);
                }
                if (bl) {
                    V2CMain.clearMenus();
                }
                return;
            }
            if (n < 0) {
                n = n2;
            }
            arrayList.add(bl2 ? 0 : n, v2CSearchHistoryItem);
            V2CSearchHistoryItem.checkHistoryNum();
        }
        if (bl) {
            V2CMain.clearMenus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(V2CSearchHistoryItem v2CSearchHistoryItem) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = alHistoryItems;
        synchronized (arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                V2CSearchHistoryItem v2CSearchHistoryItem2 = (V2CSearchHistoryItem)arrayList.get(i);
                if (!v2CSearchHistoryItem.equals(v2CSearchHistoryItem2)) continue;
                arrayList.remove(i);
                V2CMain.clearMenus();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNormalItems() {
        ArrayList arrayList;
        boolean bl = false;
        ArrayList arrayList2 = arrayList = alHistoryItems;
        synchronized (arrayList2) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                V2CSearchHistoryItem v2CSearchHistoryItem = (V2CSearchHistoryItem)arrayList.get(i);
                if (v2CSearchHistoryItem.bMark) continue;
                arrayList.remove(i);
                bl = true;
            }
        }
        if (bl) {
            V2CMain.clearMenus();
        }
    }

    static void addSearchHistoryWithMark(Component component) {
        Container container;
        V2CSearchHistoryItem v2CSearchHistoryItem = null;
        if (component instanceof V2CAbstractMiniSearch) {
            V2CAbstractMiniSearch v2CAbstractMiniSearch = (V2CAbstractMiniSearch)component;
            v2CSearchHistoryItem = new V2CSearchHistoryItem(v2CAbstractMiniSearch.getStringForSave(), v2CAbstractMiniSearch.isMigemo(), v2CAbstractMiniSearch.isRegExp(), v2CAbstractMiniSearch.isCaseSensitive(), v2CAbstractMiniSearch.isAnd(), v2CAbstractMiniSearch.isOr(), true);
        } else if (component instanceof JTextField && (container = ((JTextField)component).getParent()) instanceof V2CFindPanel) {
            v2CSearchHistoryItem = ((V2CFindPanel)container).getCondition(true);
        }
        if (v2CSearchHistoryItem != null) {
            V2CSearchHistoryItem.add(v2CSearchHistoryItem, true);
        }
    }

    static void deleteSearchHistory(Component component) {
        Container container;
        V2CSearchHistoryItem v2CSearchHistoryItem = null;
        if (component instanceof V2CAbstractMiniSearch) {
            V2CAbstractMiniSearch v2CAbstractMiniSearch = (V2CAbstractMiniSearch)component;
            v2CSearchHistoryItem = new V2CSearchHistoryItem(v2CAbstractMiniSearch.getStringForSave(), v2CAbstractMiniSearch.isMigemo(), v2CAbstractMiniSearch.isRegExp(), v2CAbstractMiniSearch.isCaseSensitive(), v2CAbstractMiniSearch.isAnd(), v2CAbstractMiniSearch.isOr());
        } else if (component instanceof JTextField && (container = ((JTextField)component).getParent()) instanceof V2CFindPanel) {
            v2CSearchHistoryItem = ((V2CFindPanel)container).getCondition(false);
        }
        if (v2CSearchHistoryItem != null) {
            V2CSearchHistoryItem.remove(v2CSearchHistoryItem);
        }
    }

    static void deleteNormalSearchHistory() {
        V2CSearchHistoryItem.removeNormalItems();
    }

    static void addHistoryItems(JPopupMenu jPopupMenu) {
        ArrayList arrayList = alHistoryItems;
        for (int i = 0; i < arrayList.size(); ++i) {
            V2CSearchHistoryItem v2CSearchHistoryItem = (V2CSearchHistoryItem)arrayList.get(i);
            jPopupMenu.add(new SHMenuItem(v2CSearchHistoryItem));
        }
    }

    public V2CSearchHistoryItem(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(string, bl, bl2, bl3, bl4, bl5, false);
    }

    public V2CSearchHistoryItem(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.sSearchWord = string != null ? string : "";
        this.bMigemo = bl;
        this.bRegExp = bl2;
        this.bCaseSensitive = bl3;
        this.bAnd = bl4;
        this.bOr = !bl4 && bl5;
        this.bMark = bl6;
    }

    public int hashCode() {
        return this.sSearchWord.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof V2CSearchHistoryItem)) {
            return false;
        }
        V2CSearchHistoryItem v2CSearchHistoryItem = (V2CSearchHistoryItem)object;
        return this.sSearchWord.equals(v2CSearchHistoryItem.sSearchWord) && this.bRegExp == v2CSearchHistoryItem.bRegExp && this.bCaseSensitive == v2CSearchHistoryItem.bCaseSensitive && this.bAnd == v2CSearchHistoryItem.bAnd && this.bOr == v2CSearchHistoryItem.bOr;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bMark) {
            stringBuffer.append("* ");
        }
        if ((string = this.sSearchWord) == null) {
            string = "(None)";
        } else if (string.length() > 20) {
            string = string.substring(0, 19) + "...";
        }
        stringBuffer.append(string);
        stringBuffer.append(" [");
        boolean bl = this.bMigemo;
        if (bl) {
            stringBuffer.append('M');
        }
        if (!bl) {
            if (this.bRegExp) {
                stringBuffer.append('R');
            }
            if (this.bCaseSensitive) {
                stringBuffer.append('C');
            }
            if (this.bAnd) {
                stringBuffer.append('A');
            }
            if (this.bOr) {
                stringBuffer.append('O');
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        V2CPackedPropValue v2CPackedPropValue = V2CMain.getUserProperty().getPackedValue(sConfKey);
        if (v2CPackedPropValue != null) {
            nMaxEntry = v2CPackedPropValue.getIntInRange('n', 20, 0, 100);
            nMaxSaveEntry = v2CPackedPropValue.getIntInRange('s', 20, 0, 100);
        } else {
            nMaxSaveEntry = 20;
            nMaxEntry = 20;
        }
        V2CSearchHistoryItem.restoreHistory();
    }

    private static class SHMenuItem
    extends JMenuItem
    implements ActionListener {
        V2CSearchHistoryItem vSearchHistoryItem;

        SHMenuItem(V2CSearchHistoryItem v2CSearchHistoryItem) {
            this.vSearchHistoryItem = v2CSearchHistoryItem;
            this.setText(v2CSearchHistoryItem.toString());
            this.addActionListener(this);
        }

        boolean isNormal() {
            return !this.vSearchHistoryItem.bMark;
        }

        void setSearchHistoryItem(V2CSearchHistoryItem v2CSearchHistoryItem) {
            if (this.vSearchHistoryItem.bMark != v2CSearchHistoryItem.bMark) {
                this.setText(v2CSearchHistoryItem.toString());
            }
            this.vSearchHistoryItem = v2CSearchHistoryItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = V2CAction.getInvoker(actionEvent);
            if (component instanceof V2CAbstractMiniSearch) {
                V2CAbstractMiniSearch v2CAbstractMiniSearch = (V2CAbstractMiniSearch)component;
                boolean bl = this.vSearchHistoryItem.bMigemo;
                v2CAbstractMiniSearch.setMigemo(bl);
                if (!bl) {
                    v2CAbstractMiniSearch.setRegExp(this.vSearchHistoryItem.bRegExp);
                    v2CAbstractMiniSearch.setCaseSensitive(this.vSearchHistoryItem.bCaseSensitive);
                    v2CAbstractMiniSearch.setAnd(this.vSearchHistoryItem.bAnd);
                    v2CAbstractMiniSearch.setOr(this.vSearchHistoryItem.bOr);
                }
                v2CAbstractMiniSearch.setString(this.vSearchHistoryItem.sSearchWord, false);
            } else if (component instanceof JTextField) {
                Container container = ((JTextField)component).getParent();
                if (container instanceof V2CFindPanel) {
                    ((V2CFindPanel)container).fillCondition(this.vSearchHistoryItem);
                } else {
                    ((JTextField)component).setText(this.vSearchHistoryItem.sSearchWord);
                }
            }
        }
    }
}

