/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.monazilla.v2c.V2CCustomTabbedPane;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CTabListPMListener
extends MouseAdapter {
    final boolean bMacScrollTabButton;
    final V2CCustomTabbedPane vCustomTabbedPane;

    public V2CTabListPMListener(V2CCustomTabbedPane v2CCustomTabbedPane, boolean bl) {
        this.vCustomTabbedPane = v2CCustomTabbedPane;
        this.bMacScrollTabButton = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.bMacScrollTabButton && mouseEvent.isPopupTrigger()) {
            this.popupTabMenu(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.bMacScrollTabButton && mouseEvent.isPopupTrigger()) {
            this.popupTabMenu(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.bMacScrollTabButton && V2CSwingUtil.isSimpleClick(mouseEvent)) {
            this.popupTabMenu(mouseEvent);
        }
    }

    void popupTabMenu(MouseEvent mouseEvent) {
        V2CCustomTabbedPane v2CCustomTabbedPane = this.vCustomTabbedPane;
        Window window = SwingUtilities.getWindowAncestor(v2CCustomTabbedPane);
        if (!(window instanceof JFrame)) {
            return;
        }
        JFrame jFrame = (JFrame)window;
        JLayeredPane jLayeredPane = jFrame.getLayeredPane();
        int n = v2CCustomTabbedPane.getTabCount();
        if (n <= 0) {
            return;
        }
        V2CPanel[] v2CPanelArray = new V2CPanel[n];
        for (int i = 0; i < n; ++i) {
            v2CPanelArray[i] = v2CCustomTabbedPane.getPanelAt(i);
        }
        JComboBox<V2CPanel> jComboBox = new JComboBox<V2CPanel>(v2CPanelArray);
        jComboBox.setLightWeightPopupEnabled(false);
        jComboBox.setRenderer(new TabMenuRenderer());
        int n2 = v2CCustomTabbedPane.getSelectedIndex();
        if (n2 >= 0) {
            jComboBox.setSelectedIndex(n2);
        }
        jComboBox.setMaximumRowCount(20);
        JPanel jPanel = new JPanel(null);
        TabMenuListener tabMenuListener = new TabMenuListener(jComboBox, jPanel, jLayeredPane);
        jComboBox.addPopupMenuListener(tabMenuListener);
        jComboBox.addActionListener(tabMenuListener);
        Dimension dimension = jComboBox.getPreferredSize();
        int n3 = Math.min(dimension.width, 400);
        jComboBox.setBounds(-n3, -dimension.height, n3, dimension.height);
        jPanel.add(jComboBox);
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), jLayeredPane);
        jPanel.setBounds(point.x, point.y, 0, 0);
        jLayeredPane.add((Component)jPanel, JLayeredPane.PALETTE_LAYER);
        jComboBox.showPopup();
    }

    private static class TabMenuRenderer
    extends DefaultListCellRenderer {
        static final ImageIcon icBlank = V2CSwingUtil.getSystemIcon("Blank");

        private TabMenuRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = null;
            Icon icon = null;
            if (object instanceof V2CPanel) {
                V2CPanel v2CPanel = (V2CPanel)object;
                string = v2CPanel.getTitleString();
                icon = v2CPanel.getIcon();
            }
            this.setText(string != null ? string : "\u540d\u79f0\u672a\u8a2d\u5b9a");
            this.setIcon(icon != null ? icon : icBlank);
            return this;
        }
    }

    private class TabMenuListener
    implements ActionListener,
    PopupMenuListener {
        JComboBox jComboBox;
        JLayeredPane jLayeredPane;
        JPanel jPanel;

        TabMenuListener(JComboBox jComboBox, JPanel jPanel, JLayeredPane jLayeredPane) {
            this.jComboBox = jComboBox;
            this.jPanel = jPanel;
            this.jLayeredPane = jLayeredPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.jComboBox.getSelectedIndex();
            if (n >= 0) {
                V2CTabListPMListener.this.vCustomTabbedPane.setSelectedIndex(n);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.jLayeredPane.remove(this.jPanel);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

