/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Graphics2D;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CCharSequence;
import org.monazilla.v2c.V2CFont;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CThreadItem;

public class V2CTextSegment
implements CharSequence,
Cloneable {
    private static final int NORMAL = 0;
    private static final int RESLINK = 1;
    private static final int IDLINK = 2;
    private static final int LINK = 3;
    private static final int THUMBNAILIMAGE = 4;
    private static final int RESNUM = 5;
    private static final int REFCOUNT = 6;
    private static final int USERNAME = 7;
    private static final int NAME = 8;
    private static final int MAIL = 9;
    private static final int TIME = 10;
    private static final int STOCK = 11;
    private static final int IDLABEL = 12;
    private static final int ID = 13;
    private static final int IDNUM = 14;
    private static final int POSTDEVICE = 15;
    private static final int PROFILE = 16;
    private static final int MISC = 17;
    private static final int AUX = 18;
    private static final int SPACE = 19;
    private static final int NGREASON = 20;
    private static final int SKINTAG = 21;
    private static final int IMAGE = 22;
    private static final int HTMLTAG = 23;
    private static final int SNSAVATAR = 24;
    private static final int BR = 25;
    private static final int THUMBNAIL = 26;
    private static final int RESNOTE = 27;
    private static final int INNERRES = 28;
    private static final int AVATAR = 29;
    private static final int MESSAGE = 30;
    static final int MASK_NORMAL = 1;
    static final int MASK_RESLINK = 2;
    static final int MASK_IDLINK = 4;
    static final int MASK_LINK = 8;
    static final int MASK_THUMBNAILIMAGE = 16;
    static final int MASK_RESNUM = 32;
    static final int MASK_REFCOUNT = 64;
    static final int MASK_USERNAME = 128;
    static final int MASK_NAME = 256;
    static final int MASK_MAIL = 512;
    static final int MASK_TIME = 1024;
    static final int MASK_STOCK = 2048;
    static final int MASK_IDLABEL = 4096;
    static final int MASK_ID = 8192;
    static final int MASK_IDNUM = 16384;
    static final int MASK_POSTDEVICE = 32768;
    static final int MASK_PROFILE = 65536;
    static final int MASK_MISC = 131072;
    static final int MASK_AUX = 262144;
    static final int MASK_SPACE = 524288;
    static final int MASK_NGREASON = 0x100000;
    static final int MASK_SKINTAG = 0x200000;
    static final int MASK_IMAGE = 0x400000;
    static final int MASK_HTMLTAG = 0x800000;
    static final int MASK_SNSAVATAR = 0x1000000;
    static final int MASK_BR = 0x2000000;
    static final int MASK_THUMBNAIL = 0x4000000;
    static final int MASK_RESNOTE = 0x8000000;
    static final int MASK_INNERRES = 0x10000000;
    static final int MASK_AVATAR = 0x20000000;
    static final int MASK_MESSAGE = 0x40000000;
    static final short MISC_RESCHECKBOX = 2;
    static final short MISC_YUTAI = 3;
    static final short MISC_PROTECTED = 4;
    static final short MISC_SOURCE = 6;
    static final short MISC_PLACE = 7;
    static final short MISC_INREPLYTO = 8;
    static final short MISC_RETWEETEDBY = 9;
    static final short MISC_CONTRIBUTORS = 10;
    static final short MISC_IDAVATAR = 11;
    static final short MISC_AUXAVATAR = 12;
    static final short MISC_DUMMY = 13;
    static final short SKINTAG_BBSNAME = 1;
    static final short SKINTAG_BOARDNAME = 2;
    static final short SKINTAG_THREADNAME = 3;
    static final short SKINTAG_ALLRESCOUNT = 4;
    static final short SKINTAG_GETRESCOUNT = 5;
    static final short SKINTAG_NEWRESCOUNT = 6;
    static final short SKINTAG_NEWDISPRESCOUNT = 7;
    static final short SKINTAG_SIZE = 8;
    static final short SKINTAG_SIZEKB = 9;
    static final short SKINTAG_SEPARATORTEXT = 10;
    static final short TAG_COMMENT = 1;
    static final short TAG_BOLD = 2;
    static final short TAG_ITALIC = 3;
    static final short TAG_UNDERLINE = 4;
    static final short TAG_STRIKE = 5;
    static final short TAG_FONT = 6;
    static final short TAG_UNORDEREDLIST = 7;
    static final short TAG_HR = 8;
    static final short TAG_P = 9;
    static final short TAG_BLOCKQUOTE = 10;
    static final short TAG_VIRTUAL = 1024;
    static final short TAG_FONT0 = 1025;
    static final short TAG_BG = 1026;
    static final short AVATAR_SSSP = 0;
    static final short AVATAR_NAME = 1;
    static final int MASK_NORMALSPACE = 524289;
    char[] clMsg;
    int iSegmentStart;
    int nLength;
    int nType;
    short nSubType;
    boolean bNewLine;
    private int[] nlResLinkNum;
    boolean bRTL;
    boolean bHidden;
    boolean bContainKeyword;

    protected V2CTextSegment() {
    }

    public V2CTextSegment(int n, int n2) {
        this(null, n, n, n2);
    }

    public V2CTextSegment(char[] cArray, int n, int n2, int n3) {
        this.clMsg = cArray;
        this.iSegmentStart = n;
        this.nLength = n2 - n;
        this.nType = n3;
    }

    boolean isHTMLString() {
        return true;
    }

    V2CSSFont[] getFonts() {
        return null;
    }

    Color getColor() {
        return null;
    }

    V2CTextSegment splitMessageSegment(int n) {
        V2CTextSegment v2CTextSegment;
        int n2 = this.iSegmentStart;
        if (n <= n2) {
            return null;
        }
        int n3 = n2 + this.nLength - n;
        if (n3 < 0 || n3 == 0 && !this.bNewLine) {
            return null;
        }
        try {
            v2CTextSegment = (V2CTextSegment)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        this.nLength = n - n2;
        v2CTextSegment.iSegmentStart = n;
        v2CTextSegment.nLength -= this.nLength;
        this.bNewLine = false;
        return v2CTextSegment;
    }

    int getType() {
        return this.nType;
    }

    int getSubType() {
        return this.nSubType;
    }

    void setSubType(short s) {
        this.nSubType = s;
    }

    void setResLinkNumber(int[] nArray) {
        this.nlResLinkNum = nArray;
    }

    int[] getResLinkNumber() {
        return this.nlResLinkNum;
    }

    int[] getResLinkNumber(int n) {
        int n2 = 0;
        if (this.nlResLinkNum == null) {
            return null;
        }
        for (int i = 0; i < this.nlResLinkNum.length; ++i) {
            if (this.nlResLinkNum[i] >= n) continue;
            if (n2 < i) {
                this.nlResLinkNum[n2] = this.nlResLinkNum[i];
            }
            ++n2;
        }
        if (n2 == 0) {
            this.nlResLinkNum = null;
        } else if (n2 < this.nlResLinkNum.length) {
            int[] nArray = new int[n2];
            System.arraycopy(this.nlResLinkNum, 0, nArray, 0, n2);
            this.nlResLinkNum = nArray;
        }
        return this.nlResLinkNum;
    }

    String getLinkID() {
        if (this.nType != 4) {
            return null;
        }
        return new String(this.clMsg, this.iSegmentStart + 3, this.nLength - 3);
    }

    CharSequence getTextToDraw(V2CResItem v2CResItem, V2CThreadItem v2CThreadItem) {
        switch (this.nType) {
            case 32: {
                int n;
                String string = v2CResItem.getResNumToDraw();
                if (V2CAbstractThreadPanel.bRNZeroPadding && (n = V2CAbstractThreadPanel.nMinResNumColumns) > 1) {
                    switch (n - string.length()) {
                        case 1: {
                            string = '0' + string;
                            break;
                        }
                        case 2: {
                            string = "00" + string;
                            break;
                        }
                        case 3: {
                            string = "000" + string;
                            break;
                        }
                        case 4: {
                            string = "0000" + string;
                        }
                    }
                }
                return string;
            }
            case 64: {
                return v2CResItem.getRefCountString();
            }
            case 128: {
                String string = v2CResItem.getUserName();
                return string != null ? '@' + string : null;
            }
            case 256: {
                return v2CResItem.getNameToDraw();
            }
            case 512: {
                return v2CResItem.getMailToDraw();
            }
            case 1024: {
                return v2CResItem.getTimeString(this.nSubType);
            }
            case 2048: {
                return v2CResItem.getStockString();
            }
            case 4096: {
                return v2CResItem.getIDLabel();
            }
            case 8192: {
                String string;
                String string2;
                V2CBoardItem v2CBoardItem;
                if (v2CThreadItem != null && (v2CBoardItem = v2CThreadItem.getBoardItem()).hasIDHLEntry(true) && (string2 = v2CResItem.getIDForDupCheck2()) != null && string2.length() > 1 && (string = v2CBoardItem.getIDAlias(string2, true)) != null) {
                    return string;
                }
                return v2CResItem.getID();
            }
            case 16384: {
                return v2CResItem.getIDNum();
            }
            case 32768: {
                return v2CResItem.getPostDeviceToDraw();
            }
            case 65536: {
                return v2CResItem.getBePointToDraw();
            }
            case 131072: {
                switch (this.nSubType) {
                    case 3: {
                        return v2CResItem.getYutai();
                    }
                    case 6: {
                        return v2CResItem.getSource();
                    }
                    case 7: {
                        return v2CResItem.getPlaceName();
                    }
                    case 8: {
                        return v2CResItem.getInReplyToName();
                    }
                    case 9: {
                        return v2CResItem.getRetweetName();
                    }
                    case 10: {
                        return v2CResItem.getContributorName();
                    }
                }
                return this.getString();
            }
            case 262144: {
                String string;
                String string3 = v2CResItem.getAuxString();
                if (string3 != null && string3.length() > 1 && v2CThreadItem != null && (string = v2CThreadItem.getBoardItem().getIDAlias(string3, false)) != null) {
                    return string;
                }
                return string3;
            }
            case 0x100000: {
                return v2CResItem.getNGReasonString();
            }
            case 0x2000000: {
                return "";
            }
            case 0x40000000: {
                return v2CResItem;
            }
        }
        return this.getString();
    }

    CharSequence getString() {
        return this;
    }

    void setCharArray(char[] cArray) {
        this.clMsg = cArray;
    }

    void setSegmentStartIndex(int n) {
        this.iSegmentStart = n;
    }

    int getSegmentStartIndex() {
        return this.iSegmentStart;
    }

    int getSegmentEndIndex() {
        return this.iSegmentStart + this.nLength;
    }

    boolean trimHead(int n) {
        if (n >= this.nLength) {
            return false;
        }
        this.nLength -= n;
        this.iSegmentStart += n;
        return true;
    }

    void forceSetLength(int n) {
        this.nLength = n;
    }

    boolean setLength(int n) {
        if (n <= 0 || n >= this.nLength) {
            return false;
        }
        this.nLength = n;
        this.bNewLine = false;
        return true;
    }

    void setNewLineNext(boolean bl) {
        this.bNewLine = bl;
    }

    boolean newLineNext() {
        return this.bNewLine;
    }

    void setHidden(boolean bl) {
        this.bHidden = bl;
    }

    boolean isHidden() {
        return this.bHidden;
    }

    void setContainKeyword(boolean bl) {
        this.bContainKeyword = bl;
    }

    boolean containsKeyword() {
        return this.bContainKeyword;
    }

    void setRTL(boolean bl) {
        this.bRTL = bl;
    }

    boolean isRTL() {
        return this.bRTL;
    }

    void drawString(Graphics2D graphics2D, V2CSSFont[] v2CSSFontArray, int n, int n2, int n3, int n4) {
        V2CFont.drawString(graphics2D, v2CSSFontArray, 0, this.clMsg, n, n2, this.iSegmentStart, n3, n4);
    }

    void drawString(Graphics2D graphics2D, V2CSSFont[] v2CSSFontArray, int n, int n2, float f, int n3) {
        V2CFont.drawString(graphics2D, v2CSSFontArray, 0, new String(this.clMsg, n + this.iSegmentStart, n2 - n), 0, n2 - n, f, n3);
    }

    public int length() {
        return this.nLength;
    }

    public char charAt(int n) {
        return this.clMsg[n + this.iSegmentStart];
    }

    public CharSequence subSequence(int n, int n2) {
        return new V2CCharSequence(this.clMsg, n + this.iSegmentStart, n2 + this.iSegmentStart);
    }

    public String toString() {
        char[] cArray = this.clMsg;
        return cArray != null ? new String(this.clMsg, this.iSegmentStart, this.nLength) : "";
    }
}

