/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import org.monazilla.v2c.V2CAllLogList;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CClassStateSaver;
import org.monazilla.v2c.V2CCoveredComboBox;
import org.monazilla.v2c.V2CExtCommand;
import org.monazilla.v2c.V2CFavoritePanel;
import org.monazilla.v2c.V2CHistory;
import org.monazilla.v2c.V2CHistorySP;
import org.monazilla.v2c.V2CImageCacheList;
import org.monazilla.v2c.V2CListTable;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CLogSearcher;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CRSSEntryList;
import org.monazilla.v2c.V2CRSSItem;
import org.monazilla.v2c.V2CRSSTreeModel;
import org.monazilla.v2c.V2CResNoteList;
import org.monazilla.v2c.V2CSaveFile;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabbedPane;
import org.monazilla.v2c.V2CTextMarkerList;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadList;
import org.monazilla.v2c.V2CThreadListByScript;
import org.monazilla.v2c.V2CThreadListPane;
import org.monazilla.v2c.V2CThreadTabList;
import org.monazilla.v2c.V2CThreadViewHistory;
import org.monazilla.v2c.V2CThreadViewPane;
import org.monazilla.v2c.V2CWebSearchItem;

public class V2CThreadListHistory
extends V2CHistory {
    static final String sHistFile = "listhist.txt";
    static final String sKeyPrefix = "ThreadListHistory.";
    static final String sShowBBSNameKey = "ThreadListHistory.ShowBBSName";
    static final String sUpdateOnSelectionKey = "ThreadListHistory.UpdateOnSelection";
    static final String sMaxSaveNumberKey = "ThreadListHistory.MaxSaveNumber";
    static final String sWidthKey = "ThreadListHistory.Width";
    static final String sNewTabWithSimpleClickKey = "ThreadListHistory.NewTabWithSimpleClick";
    static final String sConfKey = "ThreadListHistory.Conf";
    static ClassStateSaver classStateSaver = new ClassStateSaver(600);
    static int nMaxHist;
    static int nMaxRowCount;
    static V2CThreadListHistory vThreadListHistory;
    static boolean bUpdateOnSelection;
    static boolean bShowBBSName;
    static boolean bNewTabWithSimpleClick;
    static boolean bShowAllLogList;
    static boolean bShowImageCacheList;
    static Object oAutoUpdateCheck;
    static Icon icAutoUpdateCheck;
    int nChangeCount = 1;

    static void configHistory() {
        V2CHistorySP v2CHistorySP = V2CThreadListHistory.createHistorySP();
        if (v2CHistorySP.showDialog()) {
            V2CThreadListHistory.postConfigHistory(v2CHistorySP);
        }
    }

    static V2CHistorySP createHistorySP() {
        int n = vThreadListHistory != null ? vThreadListHistory.getFixedWidth() : 0;
        return new V2CHistorySP(bShowBBSName, bUpdateOnSelection, bNewTabWithSimpleClick, nMaxHist, n);
    }

    static void postConfigHistory(V2CHistorySP v2CHistorySP) {
        V2CThreadListHistory.setShowBBSName(v2CHistorySP.getShowBBSName());
        V2CThreadListHistory.setUpdateOnSelection(v2CHistorySP.getUpdateOnSelection());
        V2CThreadListHistory.setNewTabWithSimpleClick(v2CHistorySP.getNewTabWithSimpleClick());
        V2CThreadListHistory.setHistoryMaxSaveNumber(v2CHistorySP.getMaxSaveNum());
        if (vThreadListHistory != null) {
            vThreadListHistory.setComponentSize(sWidthKey, v2CHistorySP.getFixedWidth());
        }
        boolean bl = v2CHistorySP.getShowAllLogList();
        boolean bl2 = v2CHistorySP.getShowImageCacheList();
        if (bl != bShowAllLogList || bl2 != bShowImageCacheList) {
            bShowAllLogList = bl;
            bShowImageCacheList = bl2;
            V2CProperty v2CProperty = V2CApp.getUserProperty();
            if (bl || bl2) {
                V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
                v2CPackedPropValue.setBoolean('A', bl);
                v2CPackedPropValue.setBoolean('I', bl2);
                v2CProperty.putPackedValue(sConfKey, v2CPackedPropValue);
            } else {
                v2CProperty.remove(sConfKey);
            }
            if (vThreadListHistory != null) {
                if (!bl) {
                    vThreadListHistory.removeItem(V2CAllLogList.oHistoryKey);
                }
                if (!bl2) {
                    vThreadListHistory.removeItem(V2CImageCacheList.oHistoryKey);
                }
            }
        }
    }

    static void setNewTabWithSimpleClick(boolean bl) {
        if (V2CApp.setBooleanUserProperty(sNewTabWithSimpleClickKey, bNewTabWithSimpleClick, bl, false)) {
            bNewTabWithSimpleClick = bl;
        }
    }

    static void setShowBBSName(boolean bl) {
        if (bl == bShowBBSName) {
            return;
        }
        bShowBBSName = bl;
        if (bl) {
            V2CMain.getUserProperty().remove(sShowBBSNameKey);
        } else {
            V2CMain.getUserProperty().putBoolean(sShowBBSNameKey, false);
        }
        if (vThreadListHistory != null) {
            vThreadListHistory.revalidate();
            vThreadListHistory.repaint();
        }
    }

    static void setUpdateOnSelection(boolean bl) {
        if (bl == bUpdateOnSelection) {
            return;
        }
        bUpdateOnSelection = bl;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (bl) {
            v2CProperty.put(sUpdateOnSelectionKey, "B");
        } else {
            v2CProperty.remove(sUpdateOnSelectionKey);
        }
    }

    static void setHistoryMaxSaveNumber(int n) {
        if (n < 0 || n == nMaxHist) {
            return;
        }
        if (n < nMaxHist) {
            classStateSaver.requestSave(false);
        }
        nMaxHist = n;
        V2CMain.getUserProperty().putInt(sMaxSaveNumberKey, n);
    }

    static V2CThreadListHistory getInstance() {
        JComboBox jComboBox;
        if (vThreadListHistory != null) {
            return vThreadListHistory;
        }
        Component component = V2CThreadListHistory.createThreadListHistory();
        if (component instanceof V2CThreadListHistory) {
            return (V2CThreadListHistory)component;
        }
        if (component instanceof V2CCoveredComboBox && (jComboBox = ((V2CCoveredComboBox)component).jComboBox) instanceof V2CThreadListHistory) {
            return (V2CThreadListHistory)jComboBox;
        }
        return null;
    }

    static Component createThreadListHistory() {
        V2CThreadListHistory v2CThreadListHistory;
        if (vThreadListHistory != null) {
            return null;
        }
        vThreadListHistory = v2CThreadListHistory = new V2CThreadListHistory();
        return V2CThreadListHistory.createHistory(v2CThreadListHistory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Vector restoreHistory() {
        String string;
        HashSet<Object> hashSet = new HashSet<Object>();
        Vector<Object> vector = new Vector<Object>();
        BufferedReader bufferedReader = V2CLocalFileHandler.getUserSaveFileReader(sHistFile);
        if (bufferedReader == null) {
            return vector;
        }
        try {
            try {}
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                Object var8_9 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                return vector;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            V2CLocalFileHandler.closeReader(bufferedReader);
            throw throwable;
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.charAt(0) == '#') continue;
            Object object = null;
            char c = string.charAt(0);
            if (c == ' ') {
                object = V2CFavoritePanel.getFavoritePanel(string.substring(1));
            } else if (c == 'R') {
                object = V2CRSSTreeModel.getRSSItem(string.substring(1));
            } else if (bShowAllLogList && c == 'A' && string.length() == 1) {
                object = V2CAllLogList.oHistoryKey;
            } else if (bShowImageCacheList && c == 'I' && string.length() == 1) {
                object = V2CImageCacheList.oHistoryKey;
            } else {
                V2CBoardItem v2CBoardItem = V2CBoardItem.getBoardItem(string);
                if (v2CBoardItem != null && v2CBoardItem.isActive()) {
                    object = v2CBoardItem;
                }
            }
            if (object == null || hashSet.contains(object)) continue;
            hashSet.add(object);
            vector.add(object);
        }
        Object var8_8 = null;
        V2CLocalFileHandler.closeReader(bufferedReader);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void saveHistory() {
        V2CSaveFile v2CSaveFile;
        block16: {
            if (vThreadListHistory == null) {
                return;
            }
            v2CSaveFile = new V2CSaveFile(sHistFile);
            BufferedWriter bufferedWriter = v2CSaveFile.getWriter();
            if (bufferedWriter == null) {
                return;
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            int n = Math.min(vThreadListHistory.getItemCount(), nMaxHist);
            try {
                try {
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        Object e = vThreadListHistory.getItemAt(i);
                        if (e instanceof V2CBoardItem) {
                            String string;
                            object = (V2CBoardItem)e;
                            if (!((V2CBoardItem)object).getSaveHistory() || (string = ((V2CBoardItem)object).getURLString()) == null || string.length() == 0 || hashSet.contains(string)) continue;
                            bufferedWriter.write(string);
                            hashSet.add(string);
                        } else if (e instanceof V2CFavoritePanel) {
                            object = ((V2CFavoritePanel)e).getFavoriteName();
                            if (object == null || hashSet.contains(object = ' ' + (String)object)) continue;
                            bufferedWriter.write((String)object);
                            hashSet.add(object);
                        } else if (e instanceof V2CRSSItem) {
                            object = ((V2CRSSItem)e).getURLString();
                            if (object == null || ((String)object).length() == 0 || hashSet.contains(object = 'R' + (String)object)) continue;
                            bufferedWriter.write((String)object);
                            hashSet.add(object);
                        } else if (bShowAllLogList && e == V2CAllLogList.oHistoryKey) {
                            object = "A";
                            if (hashSet.contains(object)) continue;
                            bufferedWriter.write((String)object);
                            hashSet.add(object);
                        } else if (bShowImageCacheList && e == V2CImageCacheList.oHistoryKey) {
                            object = "I";
                            if (hashSet.contains(object)) continue;
                            bufferedWriter.write((String)object);
                            hashSet.add(object);
                        }
                        bufferedWriter.newLine();
                    }
                    v2CSaveFile.setOK();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    Object var9_10 = null;
                    V2CLocalFileHandler.closeWriter(bufferedWriter);
                    break block16;
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                V2CLocalFileHandler.closeWriter(bufferedWriter);
                throw throwable;
            }
            V2CLocalFileHandler.closeWriter(bufferedWriter);
        }
        v2CSaveFile.replaceTmpFile();
    }

    static void requestSave() {
        classStateSaver.requestSave(false);
    }

    static void resetAutoUpdateCheckIcon() {
        V2CThreadListHistory.setAutoUpdateCheckIcon(null, null);
    }

    static void setAutoUpdateCheckIcon(Object object, Icon icon) {
        Object object2 = oAutoUpdateCheck;
        oAutoUpdateCheck = object;
        icAutoUpdateCheck = icon;
        if (vThreadListHistory != null) {
            vThreadListHistory.autoUpdateCheckIconUpdated(object2);
        }
    }

    static void moveToHistoryTop(Object object) {
        if (vThreadListHistory == null) {
            return;
        }
        if (!(object instanceof V2CBoardItem || object instanceof V2CFavoritePanel || object instanceof V2CRSSItem || object instanceof V2CLogSearcher || object instanceof V2CThreadViewHistory || object instanceof V2CThreadViewPane || object instanceof V2CWebSearchItem || object instanceof V2CExtCommand || object == V2CAllLogList.oHistoryKey || object == V2CImageCacheList.oHistoryKey || object == V2CTextMarkerList.oHistoryKey || object == V2CResNoteList.oHistoryKey || object instanceof String)) {
            return;
        }
        vThreadListHistory.doMoveToHistoryTop(object);
    }

    static void entryChanged() {
        if (vThreadListHistory != null) {
            vThreadListHistory.repaint();
        }
    }

    static synchronized void deleteFromHistory(V2CFavoritePanel v2CFavoritePanel) {
        if (vThreadListHistory != null) {
            vThreadListHistory.doDeleteFromHistory(v2CFavoritePanel);
        }
    }

    static V2CBoardItem getTopBoardItem() {
        return vThreadListHistory != null ? vThreadListHistory.getTopBoard() : null;
    }

    static void openTopItem(ActionEvent actionEvent) {
        if (vThreadListHistory != null && vThreadListHistory.getItemCount() > 0) {
            vThreadListHistory.openItem(0, actionEvent, true);
        }
    }

    static V2CThreadListHistory getInstance(boolean bl) {
        if (bl && vThreadListHistory == null) {
            V2CThreadListHistory.createThreadListHistory();
        }
        return vThreadListHistory;
    }

    static void resetFont() {
        if (vThreadListHistory != null) {
            vThreadListHistory.setFont(null);
        }
    }

    public V2CThreadListHistory() {
        super(V2CThreadListHistory.restoreHistory(), "ThreadListHistory");
        this.nFixedWidth = V2CMain.getUserProperty().getInt(sWidthKey);
        this.setFocusable(false);
        if (this.getMaximumRowCount() < nMaxRowCount) {
            this.setMaximumRowCount(nMaxRowCount);
        }
        this.setRenderer(new ListRenderer());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                V2CThreadListPane v2CThreadListPane;
                if (!V2CThreadListHistory.this.bActionEnabled) {
                    return;
                }
                int n = V2CThreadListHistory.this.getRealSelectedIndex();
                if (n < 0) {
                    return;
                }
                if (n == 0 && (v2CThreadListPane = V2CMain.getTablePane()).getPanelCount() > 0) {
                    v2CThreadListPane.requestFocusToPanel(false);
                    return;
                }
                V2CThreadListHistory.this.openItem(n, actionEvent, false);
            }
        });
        ++this.nChangeCount;
    }

    int getChangeCount() {
        return this.nChangeCount;
    }

    void doMoveToHistoryTop(Object object) {
        if (object == null) {
            return;
        }
        Object var2_2 = null;
        int n = this.getItemCount();
        if (n > 0) {
            var2_2 = this.getItemAt(0);
            if (object == var2_2) {
                return;
            }
            if (!(var2_2 instanceof V2CWebSearchItem || !bShowAllLogList && var2_2 == V2CAllLogList.oHistoryKey || !bShowImageCacheList && var2_2 == V2CImageCacheList.oHistoryKey || var2_2 == V2CTextMarkerList.oHistoryKey || var2_2 == V2CResNoteList.oHistoryKey || var2_2 instanceof String)) {
                var2_2 = null;
            }
        }
        this.bActionEnabled = false;
        this.removeItem(object);
        if (this.getItemCount() == n && object instanceof V2CBoardItem) {
            ++this.nChangeCount;
        }
        this.insertItemAt(object, 0);
        this.setSelectedIndex(0);
        if (var2_2 != null) {
            this.removeItem(var2_2);
        }
        this.bActionEnabled = true;
        classStateSaver.requestSave(false);
    }

    private int indexOf(V2CFavoritePanel v2CFavoritePanel) {
        if (v2CFavoritePanel == null) {
            return -1;
        }
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (this.getItemAt(i) != v2CFavoritePanel) continue;
            return i;
        }
        return -1;
    }

    void doDeleteFromHistory(V2CFavoritePanel v2CFavoritePanel) {
        int n = this.indexOf(v2CFavoritePanel);
        if (n < 0) {
            return;
        }
        if (n > 0 || this.getItemCount() == 1) {
            this.removeItemAt(n);
        } else {
            this.bActionEnabled = false;
            this.setSelectedIndex(-1);
            this.removeItemAt(0);
            this.setSelectedIndex(0);
            this.bActionEnabled = true;
        }
        classStateSaver.requestSave(false);
    }

    void clearHistory(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("S")) {
            for (int i = this.getItemCount() - 1; i >= 0; --i) {
                Object e = this.getItemAt(i);
                if (!(e instanceof V2CLogSearcher) && !(e instanceof V2CWebSearchItem)) continue;
                this.removeItemAt(i);
            }
        } else if (string.equals("A")) {
            if (!this.askClearHistory("\u30b9\u30ec\u4e00\u89a7")) {
                return;
            }
            this.removeAllItems();
            classStateSaver.requestSave(false);
            ++this.nChangeCount;
        }
    }

    void clearHistoryAndRemoveTab() {
        super.clearHistoryAndRemoveTab();
        ++this.nChangeCount;
    }

    V2CTabbedPane getTabbedPane() {
        return V2CMain.vtpTablePane;
    }

    V2CBoardItem getTopBoard() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object e = this.getItemAt(i);
            if (!(e instanceof V2CBoardItem)) continue;
            return (V2CBoardItem)e;
        }
        return null;
    }

    void openItem(int n, ActionEvent actionEvent, boolean bl) {
        boolean bl2;
        if (n >= this.getItemCount()) {
            return;
        }
        Object e = this.getItemAt(n);
        boolean bl3 = bl2 = actionEvent != null && (actionEvent.getModifiers() & 9) != 0;
        if (bNewTabWithSimpleClick) {
            boolean bl4 = bl2 = !bl2;
        }
        if (!bl && bUpdateOnSelection) {
            bl = true;
        }
        if (e instanceof V2CBoardItem) {
            V2CBoardItem v2CBoardItem = (V2CBoardItem)e;
            if (v2CBoardItem.isActive()) {
                v2CBoardItem.open(bl, bl2);
            }
        } else if (e instanceof V2CFavoritePanel) {
            ((V2CFavoritePanel)e).open(bl, bl2);
        } else if (e instanceof V2CLogSearcher) {
            ((V2CLogSearcher)e).open(bl2);
        } else if (e instanceof V2CExtCommand) {
            V2CThreadListByScript.openThreadListByScriptList((V2CExtCommand)e);
        } else if (e instanceof V2CThreadViewHistory) {
            ((V2CThreadViewHistory)e).open(bl2);
        } else if (e instanceof V2CThreadViewPane) {
            V2CThreadTabList.openThreadTabList(false, bl2, false);
        } else if (e instanceof V2CRSSItem) {
            ((V2CRSSItem)e).open(bl, bl2, false);
        } else if (e == V2CAllLogList.oHistoryKey) {
            V2CAllLogList.openAllLogs(bl2);
        } else if (e == V2CImageCacheList.oHistoryKey) {
            V2CImageCacheList.listImageCache(bl2, null, null);
        }
    }

    void autoUpdateCheckIconUpdated(Object object) {
        if (this.getItemCount() == 0) {
            return;
        }
        Object e = this.getItemAt(0);
        if (e == object || e == oAutoUpdateCheck) {
            this.repaint();
        }
    }

    ArrayList getItemList() {
        ArrayList arrayList = new ArrayList();
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getItemAt(i));
        }
        return arrayList;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.nFixedWidth > 0) {
            return dimension;
        }
        return new Dimension(150, dimension.height);
    }

    static {
        nMaxRowCount = 20;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        bShowBBSName = v2CProperty.getBoolean(sShowBBSNameKey, true);
        nMaxHist = v2CProperty.getInt(sMaxSaveNumberKey, 100);
        String string = v2CProperty.get(sUpdateOnSelectionKey);
        bUpdateOnSelection = string != null && string.length() > 0 && string.charAt(0) == 'B';
        bNewTabWithSimpleClick = v2CProperty.getBoolean(sNewTabWithSimpleClickKey);
        V2CPackedPropValue v2CPackedPropValue = v2CProperty.getPackedValue(sConfKey);
        if (v2CPackedPropValue != null) {
            bShowAllLogList = v2CPackedPropValue.getBoolean('A');
            bShowImageCacheList = v2CPackedPropValue.getBoolean('I');
        }
    }

    private static class ListRenderer
    extends V2CHistory.HistoryRenderer
    implements Icon {
        Icon icUpdatingOverlay;
        Icon icOriginal;

        private ListRenderer() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icOriginal.paintIcon(component, graphics, n, n2);
            if (this.icUpdatingOverlay == null) {
                this.icUpdatingOverlay = V2CSwingUtil.getItemIcon("Overlay_U");
            }
            if (this.icUpdatingOverlay != null) {
                this.icUpdatingOverlay.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icOriginal.getIconWidth();
        }

        public int getIconHeight() {
            return this.icOriginal.getIconHeight();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (V2CSwingUtil.isSynthLaF() && V2CHistory.lcDefaultRenderer instanceof JLabel) {
                V2CHistory.lcDefaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                JLabel jLabel = (JLabel)((Object)V2CHistory.lcDefaultRenderer);
                this.setOpaque(n >= 0);
                this.setTextAndIcon(jLabel, jList, object, n, bl, bl2);
                if (bSetFont) {
                    this.checkRendererFont();
                    jLabel.setFont(fFont);
                }
                return jLabel;
            }
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setTextAndIcon(this, jList, object, n, bl, bl2);
            return this;
        }

        void setTextAndIcon(JLabel jLabel, JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            V2CListTable v2CListTable = null;
            Icon icon2 = icon = object == oAutoUpdateCheck ? icAutoUpdateCheck : null;
            if (object instanceof V2CBoardItem) {
                V2CBoardItem v2CBoardItem = (V2CBoardItem)object;
                String string = v2CBoardItem.getName();
                if (bShowBBSName) {
                    sbTextBuffer.setLength(0);
                    sbTextBuffer.append(string);
                    sbTextBuffer.append(" [");
                    sbTextBuffer.append(v2CBoardItem.getBBS().getName(v2CBoardItem));
                    sbTextBuffer.append(']');
                    string = sbTextBuffer.toString();
                }
                jLabel.setText(string);
                if (icon == null) {
                    icon = V2CBoardItem.getIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CFavoritePanel) {
                jLabel.setText(((V2CFavoritePanel)object).getFavoriteName());
                if (icon == null) {
                    icon = ((V2CFavoritePanel)object).getIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CLogSearcher) {
                jLabel.setText(((V2CLogSearcher)object).getTitleString());
                if (icon == null) {
                    icon = V2CLogSearcher.getIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CThreadViewHistory) {
                jLabel.setText(((V2CThreadViewHistory)object).getTitleString());
                if (icon == null) {
                    icon = V2CThreadViewHistory.getDefaultIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CThreadViewPane) {
                jLabel.setText(V2CThreadTabList.getStaticTitleString());
                if (icon == null) {
                    icon = V2CThreadTabList.getStaticDefaultIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CWebSearchItem) {
                jLabel.setText(((V2CWebSearchItem)object).getTitleString());
                if (icon == null) {
                    icon = ((V2CWebSearchItem)object).getIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CExtCommand) {
                jLabel.setText(((V2CExtCommand)object).getLabel());
                if (icon == null) {
                    icon = ((V2CExtCommand)object).getIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object == V2CAllLogList.oHistoryKey) {
                jLabel.setText("\u5168\u65e2\u5f97\u30ed\u30b0");
                if (icon == null) {
                    icon = V2CThreadItem.getDefaultIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CThreadList.getThreadList(object);
                }
            } else if (object instanceof V2CRSSItem) {
                jLabel.setText(((V2CRSSItem)object).getName());
                if (icon == null) {
                    icon = V2CRSSItem.getIcon();
                }
                if (n < 0) {
                    v2CListTable = V2CRSSEntryList.getRSSEntryList((V2CRSSItem)object);
                }
            } else if (object == V2CImageCacheList.oHistoryKey) {
                jLabel.setText("\u753b\u50cf\u30ad\u30e3\u30c3\u30b7\u30e5");
                if (icon == null) {
                    icon = V2CImageCacheList.icDefault;
                }
            } else if (object == V2CTextMarkerList.oHistoryKey) {
                jLabel.setText("\u30de\u30fc\u30ab\u30fc\u4e00\u89a7");
                if (icon == null) {
                    icon = V2CTextMarkerList.icDefault;
                }
            } else if (object == V2CResNoteList.oHistoryKey) {
                jLabel.setText("\u4ed8\u7b8b\u4e00\u89a7");
                if (icon == null) {
                    icon = V2CResNoteList.icDefault;
                }
            } else if (object instanceof String) {
                jLabel.setText((String)object);
            }
            if (icon != null && v2CListTable != null && v2CListTable.isUpdating()) {
                this.icOriginal = icon;
                icon = this;
            }
            jLabel.setIcon(icon);
        }
    }

    static class ClassStateSaver
    extends V2CClassStateSaver {
        ClassStateSaver(int n) {
            super(n);
        }

        public void doSaveState() {
            this.resetTime();
            V2CThreadListHistory.saveHistory();
        }
    }
}

