/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CGalleryEntry;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CSlideShowPanel;

public class V2CThumbnailStrip
extends JPanel {
    private static final Color cMarkerColor = new Color(0xE0E0E0);
    private static final int nThumbnailSpacing = 10;
    V2CSlideShowPanel vSlideShowPanel;
    V2CGalleryEntry gePopupEntry;
    int nLastWidth;
    int iCurrentIndex;

    public V2CThumbnailStrip(V2CSlideShowPanel v2CSlideShowPanel) {
        this.vSlideShowPanel = v2CSlideShowPanel;
        this.addMouseListener(new PopupListener());
        this.addMouseListener(v2CSlideShowPanel);
    }

    V2CLink getLinkOfPopup() {
        return this.gePopupEntry != null ? this.gePopupEntry.getLink() : null;
    }

    void openLinkOutside() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.openLinkOutside();
        }
    }

    void copyLinkLocation() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.copyLinkLocation();
        }
    }

    void disableLink() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.disable();
        }
    }

    void addToNGFile() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.addToNGFile();
        }
    }

    void deleteLinkCache() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.deleteHistory();
        }
    }

    void toggleMosaic() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.toggleMosaic();
            V2CLink v2CLink2 = this.vSlideShowPanel.getCurrentLink();
            if (v2CLink2 != null && v2CLink.createSHA1Value().equals(v2CLink2.createSHA1Value())) {
                this.vSlideShowPanel.repaint();
            }
        }
    }

    void increaseMosaicTileSize(boolean bl) {
        V2CImageSet v2CImageSet;
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null && (v2CImageSet = v2CLink.getLocalImage()) != null) {
            V2CLink v2CLink2;
            if (v2CImageSet.changeBlockSize(bl)) {
                v2CLink.toggleMosaic();
            }
            if ((v2CLink2 = this.vSlideShowPanel.getCurrentLink()) != null && v2CLink.createSHA1Value().equals(v2CLink2.createSHA1Value())) {
                this.vSlideShowPanel.repaint();
            }
        }
    }

    void toggleProtectCache() {
        V2CLink v2CLink = this.getLinkOfPopup();
        if (v2CLink != null) {
            v2CLink.toggleProtectCache();
            this.repaint();
        }
    }

    void saveImage(File file, boolean bl) {
        this.vSlideShowPanel.saveImage(this.getLinkOfPopup(), file, bl);
    }

    void setCurrentIndex(int n) {
        if (n != this.iCurrentIndex) {
            this.iCurrentIndex = n;
            final Rectangle rectangle = this.getRect(n);
            if (rectangle != null) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        V2CThumbnailStrip.this.scrollRectToVisible(rectangle);
                    }
                });
            }
            this.repaint();
        }
    }

    Rectangle getRect(int n) {
        int n2 = 0;
        int n3 = 10;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vSlideShowPanel.getGalleryEntries();
        int n4 = v2CGalleryEntryArray.length;
        for (int i = 0; i <= n; ++i) {
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[i];
            V2CLink v2CLink = v2CGalleryEntry.getLink();
            V2CImageSet v2CImageSet = v2CLink.getValidThumbnail();
            if (v2CImageSet == null) continue;
            n2 = n3 - 10;
            n3 = n2 + v2CImageSet.getWidth() + 20;
        }
        return new Rectangle(n2, 0, n3 - n2, 1);
    }

    int indexAt(Point point) {
        int n = point.x;
        int n2 = point.y;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vSlideShowPanel.getGalleryEntries();
        int n3 = v2CGalleryEntryArray.length;
        for (int i = 0; i < n3; ++i) {
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[i];
            if (!v2CGalleryEntry.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    boolean imageThumbnailUpdated(V2CImageSet v2CImageSet) {
        Graphics graphics = null;
        boolean bl = false;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vSlideShowPanel.getGalleryEntries();
        int n = v2CGalleryEntryArray.length;
        for (int i = 0; i < n; ++i) {
            V2CImageSet v2CImageSet2;
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[i];
            if (!v2CGalleryEntry.isRectSet() || (v2CImageSet2 = v2CGalleryEntry.getValidThumbnail()) != v2CImageSet) continue;
            if (graphics == null) {
                graphics = (Graphics2D)this.getGraphics();
            }
            if (graphics == null) {
                return false;
            }
            Rectangle rectangle = v2CGalleryEntry.getRect();
            graphics.setClip(rectangle);
            V2CAbstractThreadPanel.drawThumbnail((Graphics2D)graphics, rectangle.x, rectangle.y + 1, v2CImageSet2, v2CGalleryEntry.getLink(), 0);
            bl = true;
        }
        if (graphics != null) {
            graphics.dispose();
        }
        return bl;
    }

    void linkStateChanged(V2CLink v2CLink) {
        int n = this.nLastWidth;
        int n2 = this.calcWidth();
        if (n2 != n) {
            this.revalidate();
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.calcWidth(), V2CLink.getMaxThumbnailHeight() + 20);
    }

    public void paintComponent(Graphics graphics) {
        this.draw((Graphics2D)graphics);
    }

    int calcWidth() {
        this.nLastWidth = this.draw(null);
        return this.nLastWidth;
    }

    private int draw(Graphics2D graphics2D) {
        V2CLink v2CLink;
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = graphics2D != null;
        if (bl) {
            graphics2D.setColor(V2CSlideShowPanel.cBG);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle rectangle = this.getVisibleRect();
            n2 = rectangle.x;
            n = n2 + rectangle.width;
            v2CLink = this.vSlideShowPanel.getCurrentLink();
        } else {
            n2 = 0;
            n = Integer.MAX_VALUE;
            v2CLink = null;
        }
        int n3 = 10;
        int n4 = 10;
        boolean bl3 = false;
        V2CGalleryEntry[] v2CGalleryEntryArray = this.vSlideShowPanel.getGalleryEntries();
        int n5 = v2CGalleryEntryArray.length;
        for (int i = 0; i < n5; ++i) {
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[i];
            if (bl3) {
                v2CGalleryEntry.clearRect();
                continue;
            }
            V2CLink v2CLink2 = v2CGalleryEntry.getLink();
            V2CImageSet v2CImageSet = v2CLink2.getValidThumbnail();
            if (v2CImageSet == null) {
                v2CGalleryEntry.clearRect();
                continue;
            }
            int n6 = v2CImageSet.getWidth();
            int n7 = n3 + n6 + 10;
            if (bl) {
                if (n7 < n2) {
                    v2CGalleryEntry.clearRect();
                } else if (n3 > n) {
                    bl3 = true;
                    v2CGalleryEntry.clearRect();
                } else {
                    if (v2CLink2 == v2CLink) {
                        graphics2D.setColor(cMarkerColor);
                        int n8 = n3 + n6 / 2;
                        int n9 = 9;
                        int[] nArray = new int[]{n8 - n9, n8, n8 + n9};
                        int[] nArray2 = new int[]{0, n9, 0};
                        graphics2D.fillPolygon(nArray, nArray2, 3);
                    }
                    Rectangle rectangle = V2CAbstractThreadPanel.drawThumbnail(graphics2D, n3, n4, v2CLink2, 0);
                    v2CGalleryEntry.setRect(rectangle);
                }
            }
            n3 = n7;
        }
        return n3;
    }

    private class PopupListener
    extends V2CPopupListener {
        private PopupListener() {
        }

        JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
            V2CThumbnailStrip.this.gePopupEntry = null;
            int n = V2CThumbnailStrip.this.indexAt(mouseEvent.getPoint());
            if (n < 0) {
                return null;
            }
            V2CGalleryEntry[] v2CGalleryEntryArray = V2CThumbnailStrip.this.vSlideShowPanel.getGalleryEntries();
            if (n >= v2CGalleryEntryArray.length) {
                return null;
            }
            V2CGalleryEntry v2CGalleryEntry = v2CGalleryEntryArray[n];
            V2CLink v2CLink = v2CGalleryEntry.getLink();
            if (v2CLink == null) {
                return null;
            }
            V2CThumbnailStrip.this.gePopupEntry = v2CGalleryEntry;
            v2CLink.setupLinkActions();
            return V2CMain.getPopupMenu("SlideShowImage");
        }
    }
}

