/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class V2CTransferable
implements Transferable {
    private static final HashMap hmFlavors = new HashMap();
    DataFlavor dfValueFlavor;
    Object oValue;
    DataFlavor dfItemFlavor;
    Object oValueItem;
    String vStringValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataFlavor getFlavor(Object object) {
        DataFlavor dataFlavor;
        HashMap hashMap;
        String string;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Class) {
            string = ((Class)object).getName();
        } else {
            return null;
        }
        HashMap hashMap2 = hashMap = hmFlavors;
        synchronized (hashMap2) {
            dataFlavor = (DataFlavor)hashMap.get(object);
            if (dataFlavor == null) {
                try {
                    dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                hashMap.put(object, dataFlavor);
            }
        }
        return dataFlavor;
    }

    static DataFlavor getItemTransferFlavor(Object object) {
        return object != null ? V2CTransferable.getFlavor(object.getClass()) : null;
    }

    public V2CTransferable(Object object) {
        this.oValue = object;
        this.dfValueFlavor = this.getTransferDataFlavor();
    }

    void addItemFlavor(Object object) {
        DataFlavor dataFlavor = V2CTransferable.getItemTransferFlavor(object);
        if (dataFlavor != null && dataFlavor != this.dfValueFlavor) {
            this.oValueItem = object;
            this.dfItemFlavor = dataFlavor;
        }
    }

    void setStringValue(String string) {
        this.vStringValue = string;
    }

    abstract DataFlavor getTransferDataFlavor();

    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
        arrayList.add(this.dfValueFlavor);
        if (this.dfItemFlavor != null) {
            arrayList.add(this.dfItemFlavor);
        }
        if (this.vStringValue != null) {
            arrayList.add(DataFlavor.stringFlavor);
        }
        return arrayList.toArray(new DataFlavor[arrayList.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.dfValueFlavor.equals(dataFlavor) || this.dfItemFlavor != null && this.dfItemFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.dfValueFlavor.equals(dataFlavor)) {
            return this.oValue;
        }
        if (this.dfItemFlavor != null && this.dfItemFlavor.equals(dataFlavor)) {
            return this.oValueItem;
        }
        if (this.vStringValue != null && DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.vStringValue;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

