/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.monazilla.v2c.V2CAbstractMiniSearch;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBoardCategoryItem;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CDnDTree;
import org.monazilla.v2c.V2CFavoriteFolder;
import org.monazilla.v2c.V2CFindPanel;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CKeyPopupMenu;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CPopupLabel;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CRSSItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabbedPane;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadStyle;

abstract class V2CTree
extends V2CDnDTree
implements MouseWheelListener,
FocusListener,
V2CPanel,
V2CKeyPopupMenu {
    static final String sUIManagerTreeFontKey = "Tree.font";
    static final String sKeyPrefix = "Tree.";
    static final String sFontSizeKey = "Tree.FontSize";
    static final String sPopupObscuredLabelKey = "Tree.PopupObscuredLabel";
    static final String sConfKey = "Tree.Conf";
    static Icon icNativeFolder;
    static Icon icNativeDocument;
    static Font fTreeFont;
    static boolean bPopupHiddenLabel;
    static boolean bCloseOtherFolder;
    V2CGestureMap vGestureMap;
    DefaultTreeModel dTreeModel;
    volatile boolean bUpdating;
    final Point pViewPosition = new Point(0, 0);
    static Rectangle rLabelRect;
    static V2CPopupLabel vPopupLabel;
    static final int nPopupLabelMargin = 3;

    static boolean resetFont() {
        Font font;
        Font font2 = fTreeFont;
        int n = V2CApp.getUserProperty().getInt(sFontSizeKey);
        if (n > 0) {
            font = UIManager.getFont(sUIManagerTreeFontKey).deriveFont((float)n);
            if (V2CApp.isMacintosh() && font instanceof UIResource) {
                font = new Font(font.getName(), font.getStyle(), font.getSize());
            }
        } else {
            font = null;
        }
        fTreeFont = font;
        if (font2 != null) {
            return font == null || !font.equals(font2);
        }
        return font != null;
    }

    static void updateDefaultColor() {
        Object[] objectArray = V2CMain.getTrees();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof V2CTree)) continue;
            V2CTree v2CTree = (V2CTree)object;
            v2CTree.setBackground(V2CThreadStyle.getDefaultBackground());
            v2CTree.setTextColors();
        }
    }

    static boolean find(boolean bl) {
        V2CTree v2CTree = V2CTree.getActivePanel();
        if (v2CTree == null) {
            return false;
        }
        return v2CTree.searchTitle(bl);
    }

    static boolean findNext(V2CAbstractMiniSearch v2CAbstractMiniSearch, boolean bl) {
        V2CTree v2CTree = V2CTree.getActivePanel();
        if (v2CTree == null) {
            return false;
        }
        return v2CTree.searchTitle(v2CAbstractMiniSearch, bl);
    }

    static V2CTree getActivePanel() {
        V2CTabbedPane v2CTabbedPane = V2CMain.getDefaultPane("Board");
        if (v2CTabbedPane == null) {
            return null;
        }
        V2CPanel v2CPanel = v2CTabbedPane.getSelectedPanel();
        if (v2CPanel instanceof V2CTree) {
            return (V2CTree)v2CPanel;
        }
        return null;
    }

    static int getFontSize() {
        return V2CApp.getUserProperty().getInt(sFontSizeKey);
    }

    static void setFontSize(int n) {
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        int n2 = v2CProperty.getInt(sFontSizeKey);
        if (n < 0 || n == n2) {
            return;
        }
        if (n > 0) {
            v2CProperty.putInt(sFontSizeKey, n);
        } else {
            v2CProperty.remove(sFontSizeKey);
        }
        V2CTree.fontChanged(true);
    }

    static void fontChanged(boolean bl) {
        if (!V2CTree.resetFont() && !V2CApp.isMacintosh()) {
            return;
        }
        Object[] objectArray = V2CMain.getTrees();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof V2CTree)) continue;
            ((V2CTree)object).setRendererFont(bl);
        }
    }

    static void clearObscuredTitlePopup() {
        V2CTree.hideObscuredTitlePopup();
        rLabelRect = null;
        vPopupLabel = null;
    }

    static void hideObscuredTitlePopup() {
        if (vPopupLabel == null || rLabelRect == null) {
            return;
        }
        rLabelRect = null;
        Component component = V2CPopupLabel.getOwner();
        if (component instanceof V2CTree) {
            vPopupLabel.setVisible(component, false);
        }
    }

    static void setPopupObscuredLabel(boolean bl) {
        if (V2CApp.setBooleanUserProperty(sPopupObscuredLabelKey, bPopupHiddenLabel, bl, true)) {
            bPopupHiddenLabel = bl;
        }
    }

    static void setCloseOtherFolder(boolean bl) {
        if (bl == bCloseOtherFolder) {
            return;
        }
        bCloseOtherFolder = bl;
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (bl) {
            v2CProperty.remove(sConfKey);
        } else {
            v2CProperty.put(sConfKey, "O");
        }
    }

    public V2CTree(DefaultTreeModel defaultTreeModel, boolean bl, boolean bl2) {
        super(defaultTreeModel, bl, bl2);
        this.enableInputMethods(false);
        this.dTreeModel = defaultTreeModel;
        defaultTreeModel.setAsksAllowsChildren(true);
        this.setToggleClickCount(3);
        this.setBackground(V2CThreadStyle.getDefaultBackground());
        this.addFocusListener(this);
        this.addMouseWheelListener(this);
    }

    public void updateUI() {
        KeyStroke keyStroke;
        super.updateUI();
        InputMap inputMap = this.getInputMap(0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(113, 0);
        Object object = inputMap.get(keyStroke2);
        if (object != null && object.equals("startEditing")) {
            inputMap.put(keyStroke2, "none");
        }
        if ((object = inputMap.get(keyStroke = KeyStroke.getKeyStroke(38, 64))) != null && object.equals("selectPreviousExtendSelection")) {
            inputMap.put(keyStroke, "none");
        }
        if ((object = inputMap.get(keyStroke = KeyStroke.getKeyStroke(40, 64))) != null && object.equals("selectNextExtendSelection")) {
            inputMap.put(keyStroke, "none");
        }
    }

    void setTextColors() {
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (!(treeCellRenderer instanceof DefaultTreeCellRenderer)) {
            return;
        }
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
        defaultTreeCellRenderer.setTextNonSelectionColor(V2CThreadStyle.getDefaultForeground());
        defaultTreeCellRenderer.setBackgroundNonSelectionColor(V2CThreadStyle.getDefaultBackground());
    }

    void setRendererFont(boolean bl) {
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (!(treeCellRenderer instanceof DefaultTreeCellRenderer)) {
            return;
        }
        this.setFont(fTreeFont);
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
        defaultTreeCellRenderer.setFont(fTreeFont);
        this.dTreeModel.nodeChanged((TreeNode)this.dTreeModel.getRoot());
        if (bl) {
            this.updateUI();
        }
    }

    public boolean needsScrollPane() {
        return true;
    }

    public Point getViewPosition() {
        return this.pViewPosition;
    }

    public Icon getIcon() {
        return null;
    }

    public void saveState() {
    }

    public String getSaveTabString() {
        return null;
    }

    public void detouch() {
    }

    public boolean close() {
        return true;
    }

    public V2CProgressState getProgressState() {
        return null;
    }

    public Icon getDefaultIcon() {
        return null;
    }

    public boolean canLock() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public void setLocked(boolean bl) {
    }

    public void closeChildPopups() {
    }

    synchronized boolean setUpdating(boolean bl) {
        if (bl && this.bUpdating) {
            return false;
        }
        this.bUpdating = bl;
        return this.bUpdating;
    }

    DefaultMutableTreeNode findNodeWithObject(Object object) {
        if (object == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.dTreeModel.getRoot()).preorderEnumeration();
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        int n = -1;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (object != defaultMutableTreeNode.getUserObject()) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    void find() {
        V2CFindPanel.showFindDialog(this);
    }

    boolean searchTitle(boolean bl) {
        if (!V2CFindPanel.isDefined()) {
            return false;
        }
        boolean bl2 = V2CFindPanel.bRegExp;
        boolean bl3 = V2CFindPanel.bCaseSens;
        Pattern pattern = null;
        String string = null;
        if (bl2) {
            pattern = V2CFindPanel.pFind;
        } else {
            string = V2CFindPanel.sFindC;
        }
        return this.searchTitle(bl, bl2, bl3, pattern, string);
    }

    boolean searchTitle(V2CAbstractMiniSearch v2CAbstractMiniSearch, boolean bl) {
        String string = v2CAbstractMiniSearch.getString();
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl2 = v2CAbstractMiniSearch.isRegExp();
        boolean bl3 = v2CAbstractMiniSearch.isCaseSensitive();
        Pattern pattern = null;
        if (bl2) {
            try {
                if (bl3) {
                    pattern = Pattern.compile(string);
                }
                pattern = Pattern.compile(string, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                V2CSwingUtil.showErrorMessage("\u6b63\u898f\u8868\u73fe\u6587\u6cd5\u30a8\u30e9\u30fc");
                return false;
            }
        } else if (!bl3) {
            string = V2CMiscUtil.normalizeCase(string);
        }
        return this.searchTitle(bl, bl2, bl3, pattern, string);
    }

    boolean searchTitle(boolean bl, boolean bl2, boolean bl3, Pattern pattern, String string) {
        int n;
        int n2;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.dTreeModel.getRoot()).preorderEnumeration();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        int n3 = 0;
        int n4 = -1;
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            arrayList.add(treeNode);
            if (treeNode == defaultMutableTreeNode) {
                n4 = n3;
            }
            ++n3;
        }
        int n5 = arrayList.size();
        if (n5 == 0) {
            return false;
        }
        if (n4 < 0) {
            n4 = bl ? 0 : n5 - 1;
        }
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = null;
        if (bl) {
            n2 = n5 - (n4 + 1);
            if (n2 <= 0) {
                return false;
            }
            defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)arrayList.get(n + n4 + 1);
            }
        } else {
            n2 = n4;
            if (n2 <= 0) {
                return false;
            }
            defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)arrayList.get(n2 - n - 1);
            }
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Matcher matcher = null;
        for (int i = 0; i < n2; ++i) {
            String string2 = null;
            Object object = defaultMutableTreeNodeArray[i].getUserObject();
            if (object instanceof String) {
                string2 = (String)object;
            } else if (object instanceof V2CBoardCategoryItem) {
                string2 = ((V2CBoardCategoryItem)object).getName();
            } else if (object instanceof V2CFavoriteFolder) {
                string2 = ((V2CFavoriteFolder)object).getName();
            } else if (object instanceof V2CBoardItem) {
                string2 = ((V2CBoardItem)object).getName();
            } else if (object instanceof V2CThreadItem) {
                string2 = ((V2CThreadItem)object).getTitle();
            } else if (object instanceof V2CRSSItem) {
                string2 = ((V2CRSSItem)object).getName();
            }
            if (string2 == null) continue;
            if (!bl2 && !bl3) {
                string2 = V2CMiscUtil.normalizeCase(string2);
            }
            if (bl2) {
                if (matcher == null) {
                    matcher = pattern.matcher(string2);
                } else {
                    matcher.reset(string2);
                }
                if (!matcher.find()) continue;
                defaultMutableTreeNode2 = defaultMutableTreeNodeArray[i];
                break;
            }
            if (string2.indexOf(string) < 0) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNodeArray[i];
            break;
        }
        if (defaultMutableTreeNode2 == null) {
            return false;
        }
        TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        return true;
    }

    void expandTreeFolder(TreePath treePath, TreeNode treeNode) {
        Serializable serializable;
        Serializable serializable2;
        int n;
        boolean bl;
        boolean bl2 = bl = !this.isExpanded(treePath);
        if (bl && bCloseOtherFolder) {
            n = treePath.getPathCount();
            serializable2 = treePath.getParentPath();
            Enumeration<TreePath> enumeration = this.getExpandedDescendants((TreePath)serializable2);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    if (serializable.getPathCount() != n) continue;
                    this.setExpandedState((TreePath)serializable, false);
                }
            }
        }
        this.setExpandedState(treePath, bl);
        if (bl && (n = this.getRowForPath(treePath)) >= 0) {
            serializable2 = this.getRowBounds(n);
            int n2 = treeNode.getChildCount();
            if (n2 > 0 && serializable2 != null) {
                serializable = this.getRowBounds(n + n2);
                Rectangle rectangle = this.getVisibleRect();
                rectangle.y = ((Rectangle)serializable2).y;
                rectangle.height = Math.max((serializable != null ? ((Rectangle)serializable).y + ((Rectangle)serializable).height : 0) - ((Rectangle)serializable2).y, 1);
                this.scrollRectToVisible(rectangle);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.vGestureMap.mouseWheelMoved(mouseWheelEvent)) {
            return;
        }
        Container container = this.getParent();
        if (container == null) {
            return;
        }
        Point point = mouseWheelEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this, point, container);
        container.dispatchEvent(new MouseWheelEvent((Component)container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (int)point2.getX(), (int)point2.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
    }

    public void focusGained(FocusEvent focusEvent) {
        V2CTabbedPane.setFocusedPanel(this);
        V2CMain.setFocusedComponentBeforeTree(focusEvent.getOppositeComponent());
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    final void showPopup(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent != null) {
            point = mouseEvent.getPoint();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            if (!this.isPathSelected(treePath)) {
                this.setSelectionPath(treePath);
            }
        } else {
            int n;
            int n2;
            Rectangle rectangle;
            TreePath treePath = this.getSelectionPath();
            if (treePath == null) {
                this.setSelectionRow(0);
                treePath = this.getSelectionPath();
            }
            if ((rectangle = this.getPathBounds(treePath)) != null) {
                n2 = rectangle.x + 1;
                n = rectangle.y + rectangle.height - 1;
            } else {
                n = 1;
                n2 = 1;
            }
            point = new Point(n2, n);
        }
        this.showPopup(mouseEvent, point);
    }

    abstract void showPopup(MouseEvent var1, Point var2);

    public final void showPopupMenuByKB(ActionEvent actionEvent) {
        this.showPopup(null);
    }

    boolean isFavoritePanel() {
        return false;
    }

    boolean checkMoveDestination(TreeNode treeNode, TreeNode treeNode2, int n) {
        if (this.isFavoritePanel()) {
            return super.checkMoveDestination(treeNode, treeNode2, n);
        }
        if (n == 0 || treeNode == treeNode2) {
            return false;
        }
        TreeNode treeNode3 = (TreeNode)this.getModel().getRoot();
        if (treeNode2 == treeNode3) {
            return false;
        }
        boolean bl = ((DefaultMutableTreeNode)treeNode2).getAllowsChildren();
        if (!bl && n == 2) {
            return false;
        }
        TreeNode treeNode4 = treeNode2.getParent();
        if (treeNode4 == null) {
            return false;
        }
        TreeNode treeNode5 = treeNode.getParent();
        if (n == 2 && treeNode5 == treeNode2) {
            return false;
        }
        boolean bl2 = ((DefaultMutableTreeNode)treeNode).getAllowsChildren();
        if (bl2 ? treeNode4 != treeNode3 || n == 2 : treeNode4 == treeNode3 && n != 2) {
            return false;
        }
        if (treeNode5 == treeNode4) {
            int n2 = treeNode5.getIndex(treeNode2);
            if (n == 1) {
                --n2;
            } else if (n == 3) {
                ++n2;
            }
            if (n2 == treeNode5.getIndex(treeNode)) {
                return false;
            }
        }
        return true;
    }

    static {
        V2CTree.resetFont();
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        bPopupHiddenLabel = v2CProperty.getBoolean(sPopupObscuredLabelKey, true);
        V2CPackedPropValue v2CPackedPropValue = v2CProperty.getPackedValue(sConfKey);
        bCloseOtherFolder = v2CPackedPropValue != null ? !v2CPackedPropValue.getBoolean('O') : true;
    }

    static class ItemRenderer
    extends DefaultTreeCellRenderer {
        Color cLabelColor;
        boolean bSelected;

        ItemRenderer() {
        }

        public void paintComponent(Graphics graphics) {
            Color color = this.cLabelColor;
            if (color != null) {
                Icon icon;
                int n = this.bSelected ? ((icon = this.getIcon()) != null ? icon.getIconWidth() + this.getIconTextGap() - 1 : 0) : this.getWidth();
                if (n > 0) {
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, n, this.getHeight());
                }
            }
            super.paintComponent(graphics);
        }
    }

    protected class LabelPopupListener
    extends MouseInputAdapter {
        static final int ONMASK_OPEN = 1024;
        static final int OFFMASK_OPEN = 9152;
        static final int ONMASK_OPENNT = 1088;
        static final int OFFMASK_OPENNT = 9088;
        static final int ONMASK_MIDDLE = 2048;
        static final int OFFMASK_MIDDLE = 8640;
        int nModifiersEx;

        protected LabelPopupListener() {
        }

        boolean checkMask(int n, int n2) {
            return (this.nModifiersEx & (n | n2)) == n;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Serializable serializable;
            Icon icon;
            if (!bPopupHiddenLabel) {
                return;
            }
            Container container = V2CTree.this.getParent();
            if (!(container instanceof JViewport)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            TreePath treePath = V2CTree.this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                rLabelRect = null;
                if (vPopupLabel != null) {
                    vPopupLabel.setVisible(V2CTree.this, false);
                }
                return;
            }
            Rectangle rectangle = V2CTree.this.getPathBounds(treePath);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            TreeCellRenderer treeCellRenderer = V2CTree.this.getCellRenderer();
            treeCellRenderer.getTreeCellRendererComponent(V2CTree.this, defaultMutableTreeNode, false, false, defaultMutableTreeNode.isLeaf(), 0, false);
            if (treeCellRenderer instanceof JLabel && (icon = ((JLabel)(serializable = (JLabel)((Object)treeCellRenderer))).getIcon()) != null) {
                int n = icon.getIconWidth() + ((JLabel)serializable).getIconTextGap();
                rectangle.width -= n;
                rectangle.x += n;
                if (point.x < rectangle.x) {
                    rLabelRect = null;
                    if (vPopupLabel != null) {
                        vPopupLabel.setVisible(V2CTree.this, false);
                    }
                    return;
                }
            }
            serializable = ((JViewport)container).getViewRect();
            ((Rectangle)serializable).x -= 3;
            ((Rectangle)serializable).width += 6;
            ((Rectangle)serializable).y -= 3;
            ((Rectangle)serializable).height += 6;
            if (((Rectangle)serializable).contains(rectangle)) {
                rLabelRect = null;
                if (vPopupLabel != null) {
                    vPopupLabel.setVisible(V2CTree.this, false);
                }
                return;
            }
            if (rLabelRect != null && rLabelRect.equals(rectangle)) {
                return;
            }
            rLabelRect = rectangle;
            if (vPopupLabel == null) {
                vPopupLabel = V2CPopupLabel.getInstance();
            }
            vPopupLabel.setParameters(V2CTree.this, rectangle, treeCellRenderer);
            vPopupLabel.setVisible(V2CTree.this, true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = V2CPopupLabel.getOwner();
            if (!(component instanceof V2CTree)) {
                V2CPopupLabel.hideAll();
            }
        }
    }
}

