/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CMiscUtil;

public final class V2CTrip {
    private static String sLastKey;
    private static String sLastResult;
    private static final byte[] blIP;
    private static final byte[] blPC1L;
    private static final byte[] blPC1R;
    private static final byte[] blLS;
    private static final byte[] blPC2L;
    private static final byte[] blPC2R;
    private static final byte[][] blS;
    private static final byte[] blP;
    private static final byte[] blSaltBytes;
    private static final byte[] blBitRevert;
    private static final long[] llMask;
    private static final int[] ilSMask;
    private static int iSalt;
    private static final int[] ilKL;
    private static final int[] ilKR;
    private static int iCryptResult0;
    private static int iCryptResult1;
    private static final byte[] blResult;
    static Pattern pRawKey;
    private static final byte[] blSalts;

    private static void prepareSalt(byte[] byArray) {
        iSalt = 0;
        for (int i = 1; i >= 0; --i) {
            int n = byArray[i];
            if (n < 46 || n > 122) {
                n = 46;
            }
            n = n <= 57 ? (int)((byte)(n - 46)) : (n < 65 ? (int)((byte)(n - 46)) : (n <= 90 ? (int)((byte)(n - 53)) : (n < 97 ? (int)((byte)(n - 53)) : (int)((byte)(n - 59)))));
            n = (byte)(n & 0x3F);
            iSalt = iSalt << 6 | n;
            V2CTrip.blResult[i] = blSaltBytes[n];
        }
    }

    private static void prepareKeys(long l) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        for (n = 0; n < 28; ++n) {
            if ((l & llMask[blPC1L[n]]) != 0L) {
                n2 |= n4;
            }
            if ((l & llMask[blPC1R[n]]) != 0L) {
                n3 |= n4;
            }
            n4 <<= 1;
        }
        for (n = 0; n < 16; ++n) {
            if (blLS[n] == 0) {
                n2 = n2 >>> 1 | (n2 & 1) << 27;
                n3 = n3 >>> 1 | (n3 & 1) << 27;
            } else {
                n2 = n2 >>> 2 | (n2 & 3) << 26;
                n3 = n3 >>> 2 | (n3 & 3) << 26;
            }
            int n5 = 0;
            int n6 = 0;
            n4 = 1;
            for (int i = 0; i < 24; ++i) {
                if ((n2 & 1 << blPC2L[i]) != 0) {
                    n5 |= n4;
                }
                if ((n3 & 1 << blPC2R[i]) != 0) {
                    n6 |= n4;
                }
                n4 <<= 1;
            }
            V2CTrip.ilKL[15 - n] = n5;
            V2CTrip.ilKR[15 - n] = n6;
        }
    }

    private static void crypt1() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        for (n5 = 25; n5 > 0; --n5) {
            for (n4 = 15; n4 >= 0; --n4) {
                n3 = n6;
                n6 = n7;
                n2 = n7 >>> 31 | n7 << 1 & 0x3E | n7 << 3 & 0xFC0 | n7 << 5 & 0x3F000 | n7 << 7 & 0xFC0000;
                n = n7 >>> 15 & 0x3F | n7 >>> 13 & 0xFC0 | n7 >>> 11 & 0x3F000 | n7 >>> 9 & 0x7C0000 | n7 << 23 & 0x800000;
                int n8 = (n2 ^ n) & iSalt;
                n2 = n2 ^ n8 ^ ilKL[n4];
                n = n ^ n8 ^ ilKR[n4];
                n7 = n3 ^ (ilSMask[n2 & 0x3F] | ilSMask[64 + (n2 >>> 6 & 0x3F)] | ilSMask[128 + (n2 >>> 12 & 0x3F)] | ilSMask[192 + (n2 >>> 18)] | ilSMask[256 + (n & 0x3F)] | ilSMask[320 + (n >>> 6 & 0x3F)] | ilSMask[384 + (n >>> 12 & 0x3F)] | ilSMask[448 + (n >>> 18)]);
            }
            n4 = n7;
            n7 = n6;
            n6 = n4;
        }
        n5 = 0;
        n4 = 0;
        n3 = 1;
        for (n2 = 0; n2 < 32; ++n2) {
            if ((n6 & n3) != 0) {
                n = blIP[n2];
                if (n < 32) {
                    n5 |= 1 << n;
                } else {
                    n4 |= 1 << n - 32;
                }
            }
            if ((n7 & n3) != 0) {
                n = blIP[n2 + 32];
                if (n < 32) {
                    n5 |= 1 << n;
                } else {
                    n4 |= 1 << n - 32;
                }
            }
            n3 <<= 1;
        }
        iCryptResult0 = n5;
        iCryptResult1 = n4;
    }

    private static byte[] crypt(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = Math.min(byArray.length, 8);
        long l = 0L;
        long l2 = 1L;
        for (int i = 0; i < n2; ++i) {
            n = byArray[i];
            l |= (long)(blBitRevert[n >>> 1 & 0x3F] + ((n & 1) << 6)) << 8 * i;
        }
        V2CTrip.prepareKeys(l);
        V2CTrip.prepareSalt(byArray2);
        V2CTrip.crypt1();
        byte[] byArray3 = blResult;
        n = iCryptResult0;
        for (int i = 0; i < 11; ++i) {
            byte by;
            if (i != 5) {
                by = blBitRevert[n & 0x3F];
                n >>>= 6;
            } else {
                int n3 = n;
                n = iCryptResult1;
                by = blBitRevert[n3 + ((n & 0xF) << 2)];
                n >>>= 4;
            }
            byArray3[i + 2] = blSaltBytes[by];
        }
        return byArray3;
    }

    private static byte toSaltByte(byte by) {
        if (by < 12) {
            return (byte)(by + 46);
        }
        if (by < 38) {
            return (byte)(by + 53);
        }
        return (byte)(by + 59);
    }

    static String calc(String string, V2CBoardItem v2CBoardItem) {
        byte[] byArray;
        if (string == null) {
            return null;
        }
        String string2 = v2CBoardItem.getBBS().isJBBSShitarabaBBS() ? "MS932" : v2CBoardItem.getCharsetString();
        if (v2CBoardItem.is2ch() && (byArray = V2CJPConverter.getBytes(string, string2)) != null && byArray.length >= 12) {
            byte by = byArray[0];
            if (by == 35 || by == 36) {
                Matcher matcher;
                if (string.length() >= 17 && by == 35 && (matcher = pRawKey.matcher(string)).matches()) {
                    byte[] byArray2 = V2CMiscUtil.decodeHex(matcher.group(1));
                    for (int i = 0; i < byArray2.length; ++i) {
                        if ((byArray2[i] & 0x7F) != 0) continue;
                        byte[] byArray3 = new byte[i];
                        if (i > 0) {
                            System.arraycopy(byArray2, 0, byArray3, 0, i);
                        }
                        byArray2 = byArray3;
                        break;
                    }
                    return V2CTrip.calc(byArray2, matcher.group(2));
                }
                return "???";
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update(byArray, 0, byArray.length);
                byte[] byArray4 = V2CMiscUtil.encodeBase64(messageDigest.digest());
                for (int i = byArray4.length - 1; i >= 0; --i) {
                    if (byArray4[i] != 43) continue;
                    byArray4[i] = 46;
                }
                return new String(byArray4, 0, 12);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return V2CTrip.calc(string, string2);
    }

    private static synchronized String calc(String string, String string2) {
        String string3;
        byte[] byArray;
        if (string == null) {
            return null;
        }
        if (string.equals(sLastKey)) {
            return sLastResult;
        }
        sLastKey = string;
        sLastResult = null;
        if (string.length() == 0) {
            sLastResult = "jPpg5.obl6";
            return "jPpg5.obl6";
        }
        byte[] byArray2 = V2CJPConverter.getBytes(string, string2);
        if (byArray2 == null) {
            return null;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byte by = byArray2[i];
            if ((by & 0x7F) != 0) continue;
            if (i == 0) {
                sLastResult = "jPpg5.obl6";
                return "jPpg5.obl6";
            }
            byArray = new byte[i];
            System.arraycopy(byArray2, 0, byArray, 0, i);
            byArray2 = byArray;
            break;
        }
        byte[] byArray3 = byArray2;
        if (byArray2.length < 3) {
            byArray3 = V2CJPConverter.getBytes(string + "H.", string2);
        }
        byte[] byArray4 = new byte[]{byArray3[1], byArray3[2]};
        byArray = V2CTrip.crypt(byArray2, byArray4);
        sLastResult = string3 = byArray != null ? new String(byArray, 3, 10) : null;
        return string3;
    }

    static synchronized String calc(byte[] byArray) {
        byte[] byArray2 = blSalts;
        int n = byArray.length;
        int n2 = byArray2[0] = n >= 2 ? byArray[1] : 72;
        byArray2[1] = n >= 3 ? byArray[2] : (n == 2 ? 72 : 46);
        byte[] byArray3 = V2CTrip.crypt(byArray, byArray2);
        return byArray3 != null ? new String(byArray3, 3, 10) : null;
    }

    static synchronized String calc(byte[] byArray, String string) {
        byte[] byArray2;
        byte[] byArray3 = blSalts;
        byArray3[1] = 46;
        byArray3[0] = 46;
        if (string != null) {
            int n = string.length();
            if (n > 0) {
                byArray3[0] = (byte)string.charAt(0);
            }
            if (n > 1) {
                byArray3[1] = (byte)string.charAt(1);
            }
        }
        return (byArray2 = V2CTrip.crypt(byArray, byArray3)) != null ? new String(byArray2, 3, 10) : null;
    }

    static {
        int n;
        int n2;
        blIP = new byte[]{58, 50, 42, 34, 26, 18, 10, 2, 60, 52, 44, 36, 28, 20, 12, 4, 62, 54, 46, 38, 30, 22, 14, 6, 64, 56, 48, 40, 32, 24, 16, 8, 57, 49, 41, 33, 25, 17, 9, 1, 59, 51, 43, 35, 27, 19, 11, 3, 61, 53, 45, 37, 29, 21, 13, 5, 63, 55, 47, 39, 31, 23, 15, 7};
        blPC1L = new byte[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36};
        blPC1R = new byte[]{63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
        blLS = new byte[]{1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
        blPC2L = new byte[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2};
        blPC2R = new byte[]{41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
        blS = new byte[][]{{14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7, 0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8, 4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0, 15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13}, {15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10, 3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5, 0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15, 13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9}, {10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8, 13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1, 13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7, 1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12}, {7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15, 13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9, 10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4, 3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14}, {2, 12, 4, 1, 7, 10, 11, 6, 8, 5, 3, 15, 13, 0, 14, 9, 14, 11, 2, 12, 4, 7, 13, 1, 5, 0, 15, 10, 3, 9, 8, 6, 4, 2, 1, 11, 10, 13, 7, 8, 15, 9, 12, 5, 6, 3, 0, 14, 11, 8, 12, 7, 1, 14, 2, 13, 6, 15, 0, 9, 10, 4, 5, 3}, {12, 1, 10, 15, 9, 2, 6, 8, 0, 13, 3, 4, 14, 7, 5, 11, 10, 15, 4, 2, 7, 12, 9, 5, 6, 1, 13, 14, 0, 11, 3, 8, 9, 14, 15, 5, 2, 8, 12, 3, 7, 0, 4, 10, 1, 13, 11, 6, 4, 3, 2, 12, 9, 5, 15, 10, 11, 14, 1, 7, 6, 0, 8, 13}, {4, 11, 2, 14, 15, 0, 8, 13, 3, 12, 9, 7, 5, 10, 6, 1, 13, 0, 11, 7, 4, 9, 1, 10, 14, 3, 5, 12, 2, 15, 8, 6, 1, 4, 11, 13, 12, 3, 7, 14, 10, 15, 6, 8, 0, 5, 9, 2, 6, 11, 13, 8, 1, 4, 10, 7, 9, 5, 0, 15, 14, 2, 3, 12}, {13, 2, 8, 4, 6, 15, 11, 1, 10, 9, 3, 14, 5, 0, 12, 7, 1, 15, 13, 8, 10, 3, 7, 4, 12, 5, 6, 11, 0, 14, 9, 2, 7, 11, 4, 1, 9, 12, 14, 2, 0, 6, 10, 13, 15, 3, 5, 8, 2, 1, 14, 7, 4, 10, 8, 13, 15, 12, 9, 0, 3, 5, 6, 11}};
        blP = new byte[]{16, 7, 20, 21, 29, 12, 28, 17, 1, 15, 23, 26, 5, 18, 31, 10, 2, 8, 24, 14, 32, 27, 3, 9, 19, 13, 30, 6, 22, 11, 4, 25};
        blSaltBytes = new byte[]{46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        blBitRevert = new byte[64];
        llMask = new long[64];
        ilSMask = new int[512];
        int n3 = 0;
        while (n3 < 64) {
            V2CTrip.llMask[n3] = 1L << n3;
            int n4 = n3++;
            blIP[n4] = (byte)(blIP[n4] - 1);
        }
        n3 = 0;
        while (n3 < 32) {
            int n5 = n3++;
            blP[n5] = (byte)(blP[n5] - 1);
        }
        n3 = 0;
        while (n3 < 28) {
            int n6 = n3;
            blPC1L[n6] = (byte)(blPC1L[n6] - 1);
            int n7 = n3++;
            blPC1R[n7] = (byte)(blPC1R[n7] - 1);
        }
        n3 = 0;
        while (n3 < 24) {
            int n8 = n3;
            blPC2L[n8] = (byte)(blPC2L[n8] - 1);
            int n9 = n3++;
            blPC2R[n9] = (byte)(blPC2R[n9] - 29);
        }
        n3 = 0;
        while (n3 < 16) {
            int n10 = n3++;
            blLS[n10] = (byte)(blLS[n10] - 1);
        }
        byte[] byArray = new byte[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15};
        byte[] byArray2 = new byte[]{0, 32, 16, 48};
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 4; ++n) {
                V2CTrip.blBitRevert[n2 * 4 + n] = (byte)(byArray2[n] + byArray[n2]);
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            n = n2 * 4;
            int n11 = n2 * 64;
            byte[] byArray3 = blS[n2];
            for (int i = 0; i < 64; ++i) {
                int n12 = byArray[byArray3[(i & 0x20) >> 1 | (i & 1) << 5 | (i & 2) << 2 | i & 4 | (i & 8) >> 2 | (i & 0x10) >> 4]] << n;
                int n13 = 0;
                int n14 = 1;
                for (int j = 0; j < 32; ++j) {
                    if ((n12 & 1 << blP[j]) != 0) {
                        n13 |= n14;
                    }
                    n14 <<= 1;
                }
                V2CTrip.ilSMask[n11 + i] = n13;
            }
        }
        ilKL = new int[16];
        ilKR = new int[16];
        blResult = new byte[13];
        pRawKey = Pattern.compile("#(\\p{XDigit}{16})([./\\p{Alnum}]{0,2})");
        blSalts = new byte[2];
    }
}

