/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CJSE6Util;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CReleaseInfo;
import org.monazilla.v2c.V2CSoundUtil;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CTwitterBBS;
import org.monazilla.v2c.V2CTwitterConstants;
import org.monazilla.v2c.V2CTwitterListItem;
import org.monazilla.v2c.V2CTwitterUSConsole;
import org.monazilla.v2c.V2CTwitterUSDispatcher;
import org.monazilla.v2c.V2CTwitterUser;
import org.monazilla.v2c.V2CTwitterUtil;

public class V2CTwitterUserStream
implements Runnable,
V2CTwitterConstants {
    private static final boolean bDebugPrint = V2CReleaseInfo.isEqual(102, 91, 0);
    static final int RET_OFFLINE = 1;
    static final int RET_INTERRUPT = 2;
    static final int RET_SSLERROR = 3;
    static final int RET_DISCONNECT = 4;
    static final int RET_TOOMANYERROR = 5;
    static final int RET_NORMAL = 6;
    static V2CTwitterUserStream vFilterStream;
    static V2CTwitterUserStream vPrevFilterStream;
    private static final int REST_NOTTRIED = 0;
    private static final int REST_TRYING = 1;
    private static final int REST_HOMETRIED = 2;
    private static final int REST_MENTIONTRIED = 4;
    private static final int REST_DMTRIED = 8;
    private static final int REST_TRIED = 14;
    final V2CTwitterUser vTwitterUser;
    final boolean bFilter;
    byte[] blSourceBuffer = new byte[8192];
    int nSourceByte;
    final ArrayList vObjectBuffer = new ArrayList();
    boolean bPaused;
    boolean bDisconnected;
    Thread vStreamThread;
    V2CTwitterUSDispatcher vTwitterUSDispatcher;
    int iRESTState;
    private static long[] vFilterFollow;
    static boolean bCanRestartFilter;
    boolean bDisconnectMessage;

    static void changeUserStream(V2CTwitterUser v2CTwitterUser, boolean bl) {
        V2CThreadPanel v2CThreadPanel = V2CTwitterBBS.getThreadPanelOfType(v2CTwitterUser, 'T');
        if (bl) {
            if (v2CThreadPanel != null) {
                v2CThreadPanel.stopUpdate();
                v2CThreadPanel.startTwitterTimer();
            } else {
                V2CThreadItem v2CThreadItem = V2CTwitterBBS.getThreadOfType(v2CTwitterUser, 'T');
                if (v2CThreadItem != null) {
                    V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
                    v2CThreadOpenRequest.setOpenBackground(true);
                    v2CThreadItem.open(false, true, v2CThreadOpenRequest);
                }
            }
        } else if (v2CThreadPanel != null) {
            v2CThreadPanel.stopTwitterUserStream();
            v2CThreadPanel.startTwitterTimer();
            V2CTwitterUserStream.startNormalRESTUpdate(v2CTwitterUser, 'M');
            if (v2CTwitterUser.getUseDM()) {
                V2CTwitterUserStream.startNormalRESTUpdate(v2CTwitterUser, 'D');
            }
        }
    }

    private static void startNormalRESTUpdate(V2CTwitterUser v2CTwitterUser, char c) {
        V2CThreadPanel v2CThreadPanel = V2CTwitterBBS.getThreadPanelOfType(v2CTwitterUser, c);
        if (v2CThreadPanel != null) {
            v2CThreadPanel.startTwitterTimer();
        }
    }

    static V2CTwitterUserStream start(V2CTwitterUser v2CTwitterUser) {
        if (v2CTwitterUser == null) {
            return null;
        }
        V2CTwitterUserStream v2CTwitterUserStream = new V2CTwitterUserStream(v2CTwitterUser);
        v2CTwitterUserStream.connect();
        return v2CTwitterUserStream;
    }

    private static boolean checkFilterFollow() {
        boolean bl;
        Object object;
        block16: {
            int n;
            V2CTwitterUser[] v2CTwitterUserArray;
            HashSet<Long> hashSet = new HashSet<Long>();
            V2CThreadPanel[] v2CThreadPanelArray = V2CThreadPanel.getOpenThreadPanels();
            for (int i = v2CThreadPanelArray.length - 1; i >= 0; --i) {
                long l;
                v2CTwitterUserArray = v2CThreadPanelArray[i];
                V2CThreadItem v2CThreadItem = v2CTwitterUserArray.getThreadItem();
                if (!V2CTwitterBBS.isUserTLThread(v2CThreadItem) || !V2CTwitterBBS.getUseFilterStream(v2CThreadItem) || (l = V2CTwitterBBS.getThreadConfLong(v2CThreadItem, 'I')) <= 0L) continue;
                hashSet.add(new Long(l));
            }
            HashSet hashSet2 = V2CTwitterUtil.getFilterStreamListIDs();
            v2CTwitterUserArray = V2CTwitterUser.getUsers();
            block1: for (int i = 0; i < v2CTwitterUserArray.length; ++i) {
                V2CTwitterUser v2CTwitterUser = v2CTwitterUserArray[i];
                object = v2CTwitterUser.getLists(true);
                n = ((ArrayList)object).size();
                for (int j = 0; j < n; ++j) {
                    V2CTwitterListItem v2CTwitterListItem = (V2CTwitterListItem)((ArrayList)object).get(j);
                    if (!hashSet2.remove(new Long(v2CTwitterListItem.getID()))) continue;
                    v2CTwitterListItem.getMembers(hashSet);
                    if (hashSet.size() >= 5000) break block1;
                }
            }
            long[] lArray = vFilterFollow;
            int n2 = hashSet.size();
            if (n2 == 0) {
                return false;
            }
            if (n2 >= 5000) {
                n2 = 5000;
            }
            object = new long[n2];
            n = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object[n++] = (Long)iterator.next();
                if (n < n2) continue;
            }
            Arrays.sort((long[])object);
            bl = false;
            if (lArray != null) {
                int n3 = lArray.length;
                if (n2 <= n3) {
                    int n4 = 0;
                    block4: for (int i = 0; i < n2; ++i) {
                        if (n4 >= n3) {
                            bl = true;
                            break;
                        }
                        Object object2 = object[i];
                        while (n4 < n3) {
                            long l = lArray[n4];
                            if (l == object2) {
                                ++n4;
                                continue block4;
                            }
                            if (l > object2) {
                                bl = true;
                                break block16;
                            }
                            ++n4;
                        }
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            vFilterFollow = (long[])object;
        }
        return bl;
    }

    static void startFilterStream() {
        if (V2CTwitterUser.getUsersCount() == 0) {
            bCanRestartFilter = true;
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                V2CTwitterUtil.getListMembers(0);
                bCanRestartFilter = true;
                V2CTwitterUserStream.restartFilter();
                V2CTwitterUtil.getListMembers(1);
                if (V2CTwitterUtil.getListMembers(2)) {
                    try {
                        Thread.sleep(900000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    V2CTwitterUtil.getListMembers(3);
                }
            }
        }).start();
    }

    static void restartFilterLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                V2CTwitterUserStream.restartFilter();
            }
        });
    }

    static void restartFilter() {
        V2CTwitterUser v2CTwitterUser;
        if (!bCanRestartFilter || !V2CTwitterUserStream.checkFilterFollow()) {
            return;
        }
        V2CTwitterUserStream v2CTwitterUserStream = vPrevFilterStream;
        vPrevFilterStream = vFilterStream;
        if (v2CTwitterUserStream != null) {
            v2CTwitterUserStream.disconnect();
        }
        if ((v2CTwitterUser = V2CTwitterUser.getDefaultUser()) == null) {
            return;
        }
        V2CTwitterUserStream v2CTwitterUserStream2 = new V2CTwitterUserStream(v2CTwitterUser, true);
        if (!V2CApp.isQuitting()) {
            vFilterStream = v2CTwitterUserStream2;
            v2CTwitterUserStream2.connect();
        }
    }

    static void stopFilter() {
        V2CTwitterUserStream v2CTwitterUserStream = vFilterStream;
        if (v2CTwitterUserStream != null) {
            vFilterStream = null;
            v2CTwitterUserStream.disconnect();
        }
    }

    private V2CTwitterUserStream(V2CTwitterUser v2CTwitterUser) {
        this(v2CTwitterUser, false);
    }

    private V2CTwitterUserStream(V2CTwitterUser v2CTwitterUser, boolean bl) {
        this.vTwitterUser = v2CTwitterUser;
        this.bFilter = bl;
    }

    void addToConsole(String string, boolean bl) {
        if (string == null) {
            return;
        }
        String string2 = this.vTwitterUser.getUserName();
        if (bl && V2CTwitterBBS.useSystemTray() && V2CApp.javaVersionEqualOrGreaterThan(1, 6) && (V2CTwitterBBS.bNotifyWhenActive || V2CMain.hasFocusInApplication())) {
            V2CJSE6Util.displayTrayMessage("V2C " + (this.bFilter ? "Filter" : "User") + "Stream [" + string2 + ']', string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new SimpleDateFormat("HH:mm:ss").format(new Date()));
        stringBuffer.append(" [");
        stringBuffer.append(string2);
        stringBuffer.append("] ");
        stringBuffer.append(string.replaceAll("\n", "\n\u3000> "));
        stringBuffer.append('\n');
        V2CTwitterUSConsole.appendText(stringBuffer.toString());
        if (bl && V2CSoundUtil.isCompSoundEnabled()) {
            V2CThreadItem v2CThreadItem = V2CTwitterBBS.getThreadOfType(this.vTwitterUser, 'T');
            if (v2CThreadItem != null) {
                String string3 = V2CTwitterBBS.getNewTweetSoundName(v2CThreadItem);
                if (".".equals(string3)) {
                    return;
                }
                if (string3 != null) {
                    V2CSoundUtil.playSoundFile(string3);
                    return;
                }
            }
            V2CSoundUtil.playSound('w');
        }
    }

    V2CTwitterUser getUser() {
        return this.vTwitterUser;
    }

    boolean isFilterStream() {
        return this.bFilter;
    }

    boolean isRESTChecking() {
        return !this.bFilter && (this.iRESTState & 0xE) == 0;
    }

    boolean hasRESTTried() {
        if (this.bFilter) {
            return true;
        }
        int n = this.iRESTState;
        if ((n & 0xE) == 14) {
            return true;
        }
        if (n < 1) {
            this.bPaused = false;
            this.iRESTState = 1;
            int n2 = 0;
            if (this.startRESTUpdate('T')) {
                n2 |= 2;
            }
            if (this.startRESTUpdate('M')) {
                n2 |= 4;
            }
            if (!this.vTwitterUser.getUseDM() || this.startRESTUpdate('D')) {
                n2 |= 8;
            }
            this.iRESTState |= n2;
        }
        return false;
    }

    private boolean startRESTUpdate(char c) {
        V2CThreadItem v2CThreadItem = V2CTwitterBBS.getThreadOfType(this.vTwitterUser, c);
        if (v2CThreadItem == null) {
            return true;
        }
        V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
        v2CThreadOpenRequest.setOpenBackground(true);
        v2CThreadOpenRequest.setTwitterUserStream(this);
        v2CThreadItem.open(true, true, v2CThreadOpenRequest);
        return false;
    }

    void notifySocketTimeout() {
        this.iRESTState = 0;
    }

    void setRESTTried(char c) {
        if (this.bFilter) {
            return;
        }
        if (bDebugPrint) {
            System.out.println("setRESTTried: " + c + "," + this.bPaused);
        }
        if (this.bPaused) {
            this.pause(false);
            if (!this.isRESTChecking()) {
                return;
            }
        }
        int n = this.iRESTState;
        if (c == 'T') {
            n |= 2;
        } else if (c == 'M') {
            n |= 4;
        } else if (c == 'D') {
            n |= 8;
        } else {
            return;
        }
        this.iRESTState = n;
        if (!this.bDisconnected && (n & 0xE) == 14) {
            this.invokeDispatcher(false);
        }
    }

    void connect() {
        Thread thread;
        if (this.bDisconnected) {
            return;
        }
        this.vStreamThread = thread = new Thread(this);
        thread.start();
    }

    void notifyDisconnect() {
        if (this.bDisconnected) {
            return;
        }
        this.bDisconnectMessage = true;
    }

    boolean disconnectReceived() {
        return this.bDisconnectMessage;
    }

    public void run() {
        while (true) {
            HashMap<String, String> hashMap;
            if (this.bFilter) {
                hashMap = new HashMap<String, String>();
                long[] lArray = vFilterFollow;
                if (lArray == null || lArray.length == 0) break;
                if (bDebugPrint) {
                    System.out.println("vFilterFollow.length: " + lArray.length);
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = lArray.length - 1; i >= 0; --i) {
                    stringBuffer.append(lArray[i]);
                    stringBuffer.append(',');
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                if (bDebugPrint) {
                    System.out.println(stringBuffer);
                }
                hashMap.put("follow", V2CHttpUtil.oauthURLEncode(stringBuffer.toString()));
            } else {
                hashMap = null;
            }
            int n = V2CHttpUtil.connectTwitterStream(this, hashMap);
            if (bDebugPrint) {
                System.out.println("nr: " + n);
            }
            if (n == 2) break;
            if (n == 3) {
                V2CSwingUtil.showMessageLater("SSL\u901a\u4fe1\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", "Twitter UserStream \u30a8\u30e9\u30fc", 0);
                break;
            }
            long l = System.currentTimeMillis();
            int n2 = 240 + ((int)l & Short.MAX_VALUE) % 60;
            if (n == 420) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            V2CSwingUtil.showWarningMessage("\u30ed\u30b0\u30a4\u30f3\u56de\u6570\u904e\u591a\uff1a\n\n\u4ed6\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3067" + V2CTwitterUserStream.this.vTwitterUser.getUserName() + "\u304c\nUserStream\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002", "Twitter UserStream");
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                n2 = (int)((long)n2 - (System.currentTimeMillis() - l) / 1000L);
            }
            if (n2 > 0) {
                try {
                    Thread.sleep(n2 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.bDisconnectMessage = false;
        }
        this.vStreamThread = null;
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pause(boolean bl) {
        if (this.bDisconnected) {
            return false;
        }
        if (bDebugPrint) {
            System.out.println("pause: " + bl + "," + this.bPaused);
        }
        if (bl == this.bPaused) {
            return false;
        }
        boolean bl2 = this.isRESTChecking();
        if (bl) {
            if (bl2) {
                return false;
            }
        } else if (!bl2) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = this.vObjectBuffer;
            synchronized (arrayList2) {
                if (arrayList.size() > 0) {
                    this.invokeDispatcher(false);
                }
            }
        }
        this.bPaused = bl;
        return bl;
    }

    void interruptStream() {
        Thread thread = this.vStreamThread;
        if (thread != null) {
            this.vStreamThread = null;
            thread.interrupt();
        }
    }

    void disconnect() {
        if (bDebugPrint) {
            System.out.println("disconnecting...");
        }
        this.bDisconnected = true;
        this.interruptStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean newStreamData(byte[] byArray, int n) {
        int n2;
        V2CTwitterUserStream v2CTwitterUserStream;
        if (bDebugPrint) {
            System.out.println("nb: " + n + ", " + new Date());
        }
        if ((v2CTwitterUserStream = vPrevFilterStream) != null) {
            vPrevFilterStream = null;
            v2CTwitterUserStream.interruptStream();
        }
        if (!V2CMain.isOnlineMode()) {
            if (bDebugPrint) {
                System.out.println("offline: discarding data...");
            }
            return true;
        }
        if (this.bDisconnected) {
            return false;
        }
        boolean bl = this.vStreamThread != null;
        int n3 = this.nSourceByte;
        byte[] byArray2 = this.blSourceBuffer;
        if (n3 + n > byArray2.length) {
            n2 = Math.max(byArray2.length * 2, n3 + n);
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            this.blSourceBuffer = byArray2 = byArray3;
        }
        System.arraycopy(byArray, 0, byArray2, n3, n);
        n3 += n;
        try {
            block26: {
                try {
                    n2 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3 && (n5 = this.skipCRLF(byArray2, n3, n5)) < n3) {
                        int n6;
                        n4 = n5;
                        int n7 = 0;
                        while (n5 < n3) {
                            n6 = byArray2[n5];
                            if (n6 < 48 || n6 > 57) {
                                if (n6 == 13 || n6 == 10) break;
                                System.out.println("bi: " + Integer.toHexString(n6 & 0xFF));
                                n2 = 1;
                                break;
                            }
                            n7 = n7 * 10 + (n6 - 48);
                            ++n5;
                        }
                        if (n5 >= n3) break;
                        if (bDebugPrint) {
                            System.out.println("nbl: " + n7);
                        }
                        if (n7 <= 0) {
                            n2 = 1;
                            break;
                        }
                        if ((n5 = this.skipCRLF(byArray2, n3, n5)) + 1 >= n3) break;
                        if (byArray2[n5] != 123) {
                            if (bDebugPrint) {
                                System.out.println("{: " + Integer.toHexString(byArray2[n5]));
                            }
                            n2 = 1;
                            break;
                        }
                        if (n5 + n7 > n3) break;
                        n4 = n5 + n7;
                        n6 = this.trimTrailingCRLF(byArray2, n5, n4);
                        if (byArray2[n6 - 1] != 125) {
                            if (bDebugPrint) {
                                System.out.println("ip,ip0,ipe: " + n5 + "," + n4 + "," + n6);
                                System.out.println("}: " + Integer.toHexString(byArray2[n6 - 1]));
                            }
                            n2 = 1;
                            break;
                        }
                        String string = new String(byArray2, n5, n6 - n5, "UTF-8");
                        n5 = n4;
                        ArrayList arrayList = this.vObjectBuffer;
                        synchronized (arrayList) {
                            this.vObjectBuffer.add(string);
                        }
                    }
                    if (n2 != 0) {
                        if (bDebugPrint) {
                            System.out.println("Error !");
                        }
                        n3 = 0;
                        break block26;
                    }
                    if (n4 <= 0) break block26;
                    if (n4 < n3) {
                        System.arraycopy(byArray2, n4, byArray2, 0, n3 - n4);
                        n3 -= n4;
                        break block26;
                    }
                    n3 = 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    n3 = 0;
                    Object var16_18 = null;
                    this.nSourceByte = n3;
                }
            }
            Object var16_17 = null;
            this.nSourceByte = n3;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.nSourceByte = n3;
            throw throwable;
        }
        if (!this.bDisconnected && !this.bPaused) {
            this.invokeDispatcher(true);
        }
        return !this.bDisconnected || !this.bDisconnectMessage;
    }

    void invokeDispatcher(boolean bl) {
        V2CTwitterUSDispatcher v2CTwitterUSDispatcher = this.vTwitterUSDispatcher;
        if (bl && v2CTwitterUSDispatcher == null) {
            this.vTwitterUSDispatcher = v2CTwitterUSDispatcher = new V2CTwitterUSDispatcher(this);
        }
        if (v2CTwitterUSDispatcher != null) {
            SwingUtilities.invokeLater(v2CTwitterUSDispatcher);
        }
    }

    private int skipCRLF(byte[] byArray, int n, int n2) {
        for (int i = n2; i < n; ++i) {
            byte by = byArray[i];
            if (by == 13 || by == 10) continue;
            return i;
        }
        return n;
    }

    private int trimTrailingCRLF(byte[] byArray, int n, int n2) {
        for (int i = n2 - 1; i >= n; --i) {
            byte by = byArray[i];
            if (by == 13 || by == 10) continue;
            return i + 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStreamLine() {
        ArrayList arrayList;
        if (this.bPaused) {
            return null;
        }
        ArrayList arrayList2 = arrayList = this.vObjectBuffer;
        synchronized (arrayList2) {
            return arrayList.size() > 0 ? (String)arrayList.remove(0) : null;
        }
    }
}

