/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CTweetItem;
import org.monazilla.v2c.V2CTwitterBBS;

public class V2CUserStateIcon {
    static final int ICON_SIZE = 14;
    static boolean bImageCreated;
    static final BufferedImage[] biFollowState;
    static final BufferedImage[] biProtectedFollowState;
    static BufferedImage biProtected;

    static BufferedImage getStateIcon(V2CResItem v2CResItem, char c, long l) {
        if (!(v2CResItem instanceof V2CTweetItem)) {
            return null;
        }
        V2CTweetItem v2CTweetItem = (V2CTweetItem)v2CResItem;
        return V2CUserStateIcon.getStateIcon(v2CTweetItem.isProtectedUser(), V2CTwitterBBS.getFollowState(v2CTweetItem, c, l));
    }

    private static void createImages() {
        Color[] colorArray = V2CTwitterBBS.clUserStateColor;
        V2CUserStateIcon.biFollowState[0] = null;
        for (int i = 1; i < 4; ++i) {
            V2CUserStateIcon.biFollowState[i] = V2CUserStateIcon.createFollowStateIcon(colorArray[i]);
        }
        BufferedImage bufferedImage = V2CUserStateIcon.createProtectedIcon(colorArray[0]);
        if (bufferedImage != null) {
            V2CUserStateIcon.biProtectedFollowState[0] = bufferedImage;
            for (int i = 1; i < 4; ++i) {
                BufferedImage bufferedImage2;
                BufferedImage bufferedImage3 = biFollowState[i];
                if (bufferedImage3 != null) {
                    bufferedImage2 = new BufferedImage(14, 14, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                    graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.dispose();
                } else {
                    bufferedImage2 = bufferedImage;
                }
                V2CUserStateIcon.biProtectedFollowState[i] = bufferedImage2;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                V2CUserStateIcon.biProtectedFollowState[i] = biFollowState[i];
            }
        }
    }

    private static BufferedImage getStateIcon(boolean bl, int n) {
        if (!bImageCreated) {
            V2CUserStateIcon.createImages();
            bImageCreated = true;
        }
        return (bl ? biProtectedFollowState : biFollowState)[n & 3];
    }

    private static BufferedImage createFollowStateIcon(Color color) {
        if (color == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(14, 14, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.fillRoundRect(1, 1, 12, 13, 6, 6);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static BufferedImage createProtectedIcon(Color color) {
        if (color == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(14, 14, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.fillRect(3, 6, 8, 7);
        graphics2D.drawRoundRect(4, 2, 5, 7, 4, 4);
        graphics2D.dispose();
        return bufferedImage;
    }

    static {
        biFollowState = new BufferedImage[4];
        biProtectedFollowState = new BufferedImage[4];
    }
}

