/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CImageConstants;
import org.monazilla.v2c.V2CImageInfo;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CInputMap;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;

public abstract class V2CAbstractImagePanel
extends JPanel
implements V2CImageConstants,
MouseWheelListener,
V2CPanel {
    static final String sKeyPrefix = "ImagePopup.";
    static final String sMaxWidthKey = "ImagePopup.MaxWidth";
    static final String sMaxHeightKey = "ImagePopup.MaxHeight";
    static final String sSmallMaxWidthKey = "ImagePopup.SmallMaxWidth";
    static final String sSmallMaxHeightKey = "ImagePopup.SmallMaxHeight";
    static final String sHighRenderingQualityKey = "ImagePopup.HighRenderingQuality";
    static final String sRenderingQualityConfKey = "ImagePopup.RenderingQualityConf";
    static final String sAlwaysCenterKey = "ImagePopup.AlwaysCenter";
    static final String sScaleWOShiftKey = "ImagePopup.ScaleWOShift";
    static int nMaxWidth;
    static int nMaxHeight;
    static int nInitialSize;
    static boolean bHighRenderingQuality;
    static boolean bHRQTh;
    static boolean bAlwaysCenter;
    static boolean bScaleWOShift;
    static int nSmallMaxWidth;
    static int nSmallMaxHeight;
    static final V2CGestureMap vGestureMap;
    static Icon icDefault;
    static Icon icStop;
    V2CLink vLink;
    V2CImageSet vImageSet;
    Reference refImageSet;
    boolean bPopup;
    volatile int nWidth;
    volatile int nHeight;
    int nDispWidth;
    int nDispHeight;
    int nViewWidth;
    int nViewHeight;
    int nSize;
    double dScale;
    boolean bSmall;
    boolean bNeedsUpdate;
    boolean bResizing;
    boolean bFocusRequested;
    boolean bFocusRequest;
    int nRotation;
    boolean bMirror;
    long ltLastUpdate;
    Dimension dLastPanelSize;
    volatile boolean bResized;
    boolean bCleared;
    Rectangle rSelRect;
    Rectangle rZoomRect;
    double dZoomScale;
    Component cmpParent;
    int nB1Count;

    static int getMaxWidth() {
        return nMaxWidth;
    }

    static int getMaxHeight() {
        return nMaxHeight;
    }

    static void restoreGeometrySettings() {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        nMaxWidth = v2CProperty.getInt(sMaxWidthKey);
        nMaxHeight = v2CProperty.getInt(sMaxHeightKey);
        if (nMaxWidth == 0 || nMaxHeight == 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (nMaxWidth == 0) {
                nMaxWidth = (int)(dimension.getWidth() * 0.9);
            }
            if (nMaxHeight == 0) {
                nMaxHeight = (int)(dimension.getHeight() * 0.9);
            }
        }
        nSmallMaxWidth = v2CProperty.getInt(sSmallMaxWidthKey, 200);
        nSmallMaxHeight = v2CProperty.getInt(sSmallMaxHeightKey, 100);
    }

    static boolean isHighRenderingQuality() {
        return bHighRenderingQuality;
    }

    static void setQualityAndCenter(boolean bl, boolean bl2, boolean bl3) {
        if (bl != bHighRenderingQuality) {
            bHighRenderingQuality = bl;
        }
        if (bl2 != bHRQTh) {
            bHRQTh = bl2;
        }
        if (bl3 != bAlwaysCenter) {
            bAlwaysCenter = bl3;
        }
    }

    static void setScaleByThumbnailClick(boolean bl) {
        bScaleWOShift = bl;
    }

    static void saveProperties() {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (bHighRenderingQuality) {
            v2CProperty.putBoolean(sHighRenderingQualityKey, true);
        } else {
            v2CProperty.remove(sHighRenderingQualityKey);
        }
        if (bHRQTh) {
            v2CProperty.put(sRenderingQualityConfKey, "t");
        } else {
            v2CProperty.remove(sRenderingQualityConfKey);
        }
        if (bAlwaysCenter) {
            v2CProperty.putBoolean(sAlwaysCenterKey, true);
        } else {
            v2CProperty.remove(sAlwaysCenterKey);
        }
        if (bScaleWOShift) {
            v2CProperty.putBoolean(sScaleWOShiftKey, true);
        } else {
            v2CProperty.remove(sScaleWOShiftKey);
        }
    }

    static void setMaxSizes(int n, int n2, int n3, int n4) {
        if (n <= 0 || n2 <= 0 || n3 <= 0 || n4 <= 0) {
            return;
        }
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        nSmallMaxWidth = n;
        v2CProperty.putInt(sSmallMaxWidthKey, n);
        nSmallMaxHeight = n2;
        v2CProperty.putInt(sSmallMaxHeightKey, n2);
        nMaxWidth = n3;
        v2CProperty.putInt(sMaxWidthKey, n3);
        nMaxHeight = n4;
        v2CProperty.putInt(sMaxHeightKey, n4);
    }

    static int getScaleFromShiftState(boolean bl) {
        return bl ^ bScaleWOShift ? 1 : 2;
    }

    public V2CAbstractImagePanel(V2CLink v2CLink, int n) {
        super(null, false);
        this.reset(v2CLink, n, false);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.enableInputMethods(false);
        V2CInputMap.setKeyBind(this, 0, "ImagePopup");
    }

    boolean grabImageMemory() {
        return true;
    }

    V2CImageSet getImageSet(boolean bl) {
        V2CImageSet v2CImageSet = this.vImageSet;
        if (!bl || this.grabImageMemory() || v2CImageSet != null) {
            return v2CImageSet;
        }
        Reference reference = this.refImageSet;
        if (reference != null) {
            v2CImageSet = (V2CImageSet)reference.get();
            if (v2CImageSet != null) {
                return v2CImageSet;
            }
            this.refImageSet = null;
        }
        this.vImageSet = v2CImageSet = this.vLink.getLocalImage();
        if (v2CImageSet != null) {
            this.refImageSet = new SoftReference<V2CImageSet>(v2CImageSet);
        }
        this.setWidthAndHeight();
        return v2CImageSet;
    }

    void setInitialRotation() {
        V2CImageSet v2CImageSet = this.vImageSet;
        if (v2CImageSet == null) {
            return;
        }
        this.nRotation = v2CImageSet.nRotation;
        this.bMirror = v2CImageSet.bMirror;
        if (this.nRotation % 2 == 0) {
            this.nDispWidth = this.nWidth;
            this.nDispHeight = this.nHeight;
        } else {
            this.nDispWidth = this.nHeight;
            this.nDispHeight = this.nWidth;
        }
    }

    void releaseImageReference() {
        if (!this.grabImageMemory()) {
            this.vImageSet = null;
        }
    }

    void reset(V2CLink v2CLink, int n, boolean bl) {
        this.bCleared = false;
        this.vLink = v2CLink;
        this.nSize = n;
        if (this.grabImageMemory()) {
            this.vImageSet = v2CLink.getLocalImage();
        } else {
            this.vImageSet = null;
            this.refImageSet = null;
        }
        this.setWidthAndHeight();
        if (bl) {
            this.repaint();
        }
    }

    void resetImage(boolean bl) {
        this.vImageSet = null;
        this.refImageSet = null;
        this.setWidthAndHeight();
        if (bl) {
            this.repaint();
        }
    }

    final void setWidthAndHeight() {
        this.bResizing = false;
        this.bResized = false;
        V2CImageSet v2CImageSet = this.getImageSet(false);
        if (v2CImageSet != null) {
            this.nWidth = v2CImageSet.getWidth();
            this.nHeight = v2CImageSet.getHeight();
            this.setInitialRotation();
            this.vLink.createThumbnailBG(false);
        } else {
            this.nHeight = -1;
            this.nDispHeight = -1;
            this.nWidth = -1;
            this.nDispWidth = -1;
        }
    }

    V2CLink getLink() {
        return this.vLink;
    }

    void openLinkOutside() {
        if (this.vLink != null) {
            this.vLink.openLinkOutside();
        }
    }

    void copyLinkLocation() {
        if (this.vLink != null) {
            this.vLink.copyLinkLocation();
        }
    }

    public String getTitleString() {
        return "\u753b\u50cf\u30ad\u30e3\u30c3\u30b7\u30e5";
    }

    public Icon getIcon() {
        return icDefault;
    }

    public void saveState() {
    }

    public Point getViewPosition() {
        return null;
    }

    public String getSaveTabString() {
        return null;
    }

    public void detouch() {
    }

    public boolean close() {
        return true;
    }

    public V2CProgressState getProgressState() {
        return null;
    }

    public Icon getDefaultIcon() {
        return icDefault;
    }

    public boolean canLock() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public void setLocked(boolean bl) {
    }

    public void closeChildPopups() {
    }

    void resizePanel() {
        this.resizePanel(false);
    }

    abstract void resizePanel(boolean var1);

    boolean imageLoaded() {
        return this.nWidth >= 0 && this.nHeight >= 0;
    }

    void setImageScale(int n) {
        if (!this.imageLoaded()) {
            return;
        }
        if (this.nSize == n) {
            return;
        }
        this.nSize = n;
        this.resizePanel();
        this.repaint();
    }

    void zoomImage(double d) {
        if (!this.imageLoaded()) {
            return;
        }
        this.nSize = 10;
        this.dScale *= d;
        this.resizePanel();
        this.repaint();
    }

    void rotateImage(boolean bl) {
        int n;
        if (this.bMirror) {
            bl = !bl;
        }
        this.nRotation = n = (this.nRotation + 4 + (bl ? 1 : -1)) % 4;
        if (n % 2 == 0) {
            this.nDispWidth = this.nWidth;
            this.nDispHeight = this.nHeight;
        } else {
            this.nDispWidth = this.nHeight;
            this.nDispHeight = this.nWidth;
        }
        this.resizePanel();
    }

    void mirrorImage() {
        this.bMirror = !this.bMirror;
        this.repaint();
    }

    void centerImage() {
        if (!this.imageLoaded()) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        int n = 0;
        int n2 = 0;
        if (this.nDispWidth > rectangle.width) {
            n = (this.nDispWidth - rectangle.width) / 2;
        }
        if (this.nDispHeight > rectangle.height) {
            n2 = (this.nDispHeight - rectangle.height) / 2;
        }
        if (n > 0 || n2 > 0) {
            this.scrollRectToVisible(new Rectangle(n, n2, rectangle.width, rectangle.height));
        }
    }

    abstract void saveImage(File var1, boolean var2);

    void saveImage(Component component, File file, V2CThreadItem v2CThreadItem, boolean bl) {
        if (!this.imageLoaded()) {
            return;
        }
        this.vLink.saveImage(component, file, v2CThreadItem, bl);
    }

    void setMosaic(boolean bl) {
        this.vLink.setMosaic(bl);
        V2CImageSet v2CImageSet = this.getImageSet(true);
        if (v2CImageSet != null) {
            v2CImageSet.setMosaic(bl);
        }
        this.repaint();
    }

    void toggleMosaic() {
        boolean bl = this.vLink.toggleMosaic();
        V2CImageSet v2CImageSet = this.getImageSet(true);
        if (v2CImageSet != null) {
            v2CImageSet.setMosaic(bl);
        }
        this.repaint();
    }

    void increaseMosaicTileSize(boolean bl) {
        V2CImageSet v2CImageSet = this.getImageSet(true);
        if (v2CImageSet != null && v2CImageSet.changeBlockSize(bl)) {
            this.vLink.toggleMosaic();
        }
        this.repaint();
    }

    void toggleProtectCache() {
        this.vLink.toggleProtectCache();
        V2CThreadPanel.repaintActivePanel(true);
    }

    void setProtectCache(boolean bl) {
        this.vLink.setProtectCache(bl);
        V2CThreadPanel.repaintActivePanel(true);
    }

    void showImageProperty() {
        if (!this.imageLoaded()) {
            return;
        }
        File file = this.vLink.getImageFile();
        if (file == null) {
            return;
        }
        V2CImageInfo.showPanel(SwingUtilities.getAncestorOfClass(JDialog.class, this), file, this.nWidth, this.nHeight);
    }

    void stopDownloadingLink() {
        if (this.vLink.isChecking()) {
            this.vLink.stopDownloading();
        }
    }

    abstract void showNextImage(boolean var1);

    abstract void disableLink();

    abstract void deleteLinkCache();

    void addToNGFile(boolean bl, ActionEvent actionEvent) {
    }

    boolean resizePanel(Dimension dimension) {
        boolean bl;
        if (this.nWidth <= 1 || this.nHeight <= 1) {
            return false;
        }
        JScrollPane jScrollPane = V2CSwingUtil.getParentScrollPane(this);
        if (jScrollPane == null) {
            return false;
        }
        this.bResized = true;
        this.bResizing = true;
        Insets insets = jScrollPane.getInsets();
        if (dimension == null) {
            this.dLastPanelSize = dimension = jScrollPane.getSize();
        }
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        if (n <= 0 || n2 <= 0) {
            return false;
        }
        double d = 1.0;
        int n3 = this.nDispWidth;
        int n4 = this.nDispHeight;
        switch (this.nSize) {
            case 0: {
                double d2 = (double)nSmallMaxWidth / (double)n3;
                double d3 = (double)nSmallMaxHeight / (double)n4;
                d = Math.min(Math.min(d2, d3), 1.0);
                break;
            }
            case 1: {
                if (n >= n3 && n2 >= n4) break;
                d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
                break;
            }
            case 3: {
                if (n <= n3 || n2 <= n4) break;
                d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
                break;
            }
            case 4: {
                d = Math.min((double)n / (double)n3, (double)n2 / (double)n4);
                break;
            }
            case 10: {
                d = this.dScale;
            }
        }
        if (Math.abs(d - 1.0) < 1.0E-4) {
            d = 1.0;
        }
        n3 = (int)(d * (double)n3);
        n4 = (int)(d * (double)n4);
        this.nViewWidth = n3;
        this.nViewHeight = n4;
        this.dScale = d;
        this.setPreferredSize(new Dimension(this.nViewWidth, this.nViewHeight));
        this.setSize(this.nViewWidth, this.nViewHeight);
        int n5 = UIManager.getInt("ScrollBar.width");
        boolean bl2 = n < n3;
        boolean bl3 = bl = n2 < n4;
        if (bl) {
            n3 += n5;
        }
        if (n < n3) {
            n3 = n;
        }
        if (bl2) {
            n4 += n5;
        }
        if (n2 < n4) {
            n4 = n2;
        }
        Dimension dimension2 = new Dimension(n3 + insets.left + insets.right, n4 + insets.top + insets.bottom);
        jScrollPane.setPreferredSize(dimension2);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.bResizing = false;
        return true;
    }

    void showAnimeController() {
        V2CImageSet v2CImageSet = this.getImageSet(true);
        if (v2CImageSet != null) {
            v2CImageSet.showAnimeController(this, null);
        }
    }

    public void paintComponent(Graphics graphics) {
        JScrollPane jScrollPane;
        Object object;
        if (this.bResizing) {
            return;
        }
        V2CImageSet v2CImageSet = this.getImageSet(true);
        if (!this.grabImageMemory() && v2CImageSet != null) {
            this.vImageSet = v2CImageSet;
        }
        if (!this.bResized && this.nWidth > 0 && this.nHeight > 0) {
            this.bResized = true;
            SwingUtilities.invokeLater(new PanelResizer());
            return;
        }
        if (!(this.nSize != 1 && this.nSize != 3 && this.nSize != 4 || (object = this.dLastPanelSize) == null || (jScrollPane = V2CSwingUtil.getParentScrollPane(this)) == null || jScrollPane.getSize().equals(object))) {
            this.dLastPanelSize = jScrollPane.getSize();
            SwingUtilities.invokeLater(new PanelResizer());
        }
        if (!this.bFocusRequested) {
            this.bFocusRequested = true;
            this.requestFocusInWindow();
        }
        if (v2CImageSet != null && v2CImageSet.isOK() && this.bResized && !this.bCleared) {
            object = (Graphics2D)graphics;
            try {
                int n;
                int n2;
                if (v2CImageSet.needPaintBG() || this.nViewWidth + 1 < this.getWidth() || this.nViewHeight + 1 < this.getHeight()) {
                    super.paintComponent(graphics);
                }
                int n3 = this.nRotation;
                if (this.bMirror) {
                    int n4 = n2 = n3 == 0 || n3 == 2 ? this.nWidth : this.nHeight;
                    if (this.dScale != 1.0) {
                        n2 = (int)((double)n2 * this.dScale);
                    }
                    ((Graphics2D)object).transform(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, n2, 0.0f));
                }
                if (n3 != 0) {
                    n2 = this.nWidth;
                    n = this.nHeight;
                    if (this.dScale != 1.0) {
                        n2 = (int)((double)n2 * this.dScale);
                        n = (int)((double)n * this.dScale);
                    }
                    switch (n3) {
                        case 1: {
                            ((Graphics2D)object).translate(0, n2);
                            ((Graphics2D)object).rotate(-1.5707963267948966);
                            break;
                        }
                        case 2: {
                            ((Graphics2D)object).translate(n2, n);
                            ((Graphics2D)object).rotate(Math.PI);
                            break;
                        }
                        case 3: {
                            ((Graphics2D)object).translate(n, 0);
                            ((Graphics2D)object).rotate(1.5707963267948966);
                        }
                    }
                }
                if (this.dScale == 1.0) {
                    v2CImageSet.draw((Graphics2D)object);
                } else {
                    Object object2 = ((Graphics2D)object).getRenderingHint(RenderingHints.KEY_RENDERING);
                    n = bHighRenderingQuality && this.nSize != 0 ? 1 : 0;
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, n != 0 ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
                    v2CImageSet.draw((Graphics2D)object, 0, 0, this.dScale);
                    ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, object2);
                }
                this.drawSelRects((Graphics2D)object);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            super.paintComponent(graphics);
        }
    }

    void drawSelRects(Graphics2D graphics2D) {
        boolean bl;
        Rectangle rectangle = this.rSelRect;
        Rectangle rectangle2 = this.rZoomRect;
        boolean bl2 = rectangle != null;
        boolean bl3 = bl = rectangle2 != null;
        if (!bl2 && !bl) {
            return;
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setXORMode(Color.WHITE);
        if (bl) {
            graphics2D.draw(rectangle2);
        }
        if (bl2) {
            if (bl) {
                int n;
                int n2 = rectangle.x;
                int n3 = rectangle.y;
                int n4 = rectangle.width;
                int n5 = rectangle.height;
                if (n5 > 2) {
                    if (n2 != rectangle2.x) {
                        graphics2D.drawLine(n2, n3 + 1, n2, n3 + n5 - 1);
                    }
                    if ((n = n2 + n4) != rectangle2.x + rectangle2.width) {
                        graphics2D.drawLine(n, n3 + 1, n, n3 + n5 - 1);
                    }
                }
                if (n4 > 2) {
                    if (n3 != rectangle2.y) {
                        graphics2D.drawLine(n2 + 1, n3, n2 + n4 - 1, n3);
                    }
                    if ((n = n3 + n5) != rectangle2.y + rectangle2.height) {
                        graphics2D.drawLine(n2 + 1, n, n2 + n4 - 1, n);
                    }
                }
            } else {
                graphics2D.draw(rectangle);
            }
        }
    }

    void calcZoomRect(MouseEvent mouseEvent, int n, int n2) {
        double d;
        this.rSelRect = null;
        this.rZoomRect = null;
        Container container = this.getParent();
        if (!(container instanceof JViewport)) {
            return;
        }
        if (!((container = container.getParent()) instanceof JScrollPane)) {
            return;
        }
        JScrollPane jScrollPane = (JScrollPane)container;
        Insets insets = jScrollPane.getInsets();
        int n3 = jScrollPane.getVerticalScrollBar().getPreferredSize().width;
        int n4 = jScrollPane.getHorizontalScrollBar().getPreferredSize().height;
        int n5 = jScrollPane.getWidth() - insets.left - insets.right - n3;
        int n6 = jScrollPane.getHeight() - insets.top - insets.bottom - n4;
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = mouseEvent.getX();
        int n8 = n7 - n;
        if (n8 > 0) {
            n7 = n;
        } else {
            n8 = n8 == 0 ? 1 : -n8;
        }
        int n9 = mouseEvent.getY();
        int n10 = n9 - n2;
        if (n10 > 0) {
            n9 = n2;
        } else {
            n10 = n10 == 0 ? 1 : -n10;
        }
        this.rSelRect = new Rectangle(n7, n9, n8, n10);
        this.dZoomScale = d = Math.min((double)n5 / (double)n8, (double)n6 / (double)n10);
        if (d <= 1.0) {
            return;
        }
        int n11 = (int)((double)n5 / d);
        int n12 = (int)((double)n6 / d);
        int n13 = n7 - (n11 - n8) / 2;
        int n14 = n9 - (n12 - n10) / 2;
        this.rZoomRect = new Rectangle(n13, n14, n11, n12);
    }

    void zoomRegion() {
        Rectangle rectangle = this.rZoomRect;
        if (rectangle == null) {
            return;
        }
        double d = this.dZoomScale;
        this.nSize = 10;
        this.dScale *= d;
        this.resizePanel(true);
        this.scrollRectToVisible(new Rectangle((int)((double)rectangle.x * d), (int)((double)rectangle.y * d), (int)((double)rectangle.width * d), (int)((double)rectangle.height * d)));
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (vGestureMap.mouseWheelMoved(mouseWheelEvent)) {
            return;
        }
        boolean bl = mouseWheelEvent.isShiftDown();
        if (!bl && (V2CApp.isMacintosh() ? mouseWheelEvent.isMetaDown() : mouseWheelEvent.isControlDown())) {
            this.nSize = 10;
            double d = this.dScale;
            if (mouseWheelEvent.getWheelRotation() < 0) {
                if (d >= 1000.0) {
                    return;
                }
                this.dScale = Math.min(d * 1.2, 1000.0);
            } else {
                int n = Math.max(this.nWidth, this.nHeight);
                if (n <= 1 || (double)n * d <= 1.0) {
                    return;
                }
                this.dScale = Math.max(d / 1.2, 1.0 / (double)n);
            }
            this.resizePanel(mouseWheelEvent.isShiftDown());
            this.repaint();
        } else if (!bl && mouseWheelEvent.isAltDown()) {
            this.increaseMosaicTileSize(mouseWheelEvent.getWheelRotation() < 0);
        } else {
            this.doSimpleWheelRotateAction(mouseWheelEvent);
        }
    }

    void doSimpleWheelRotateAction(MouseWheelEvent mouseWheelEvent) {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            Serializable serializable;
            Serializable serializable2;
            if (container != this.cmpParent) {
                this.cmpParent = container;
                serializable2 = container.getParent();
                if (serializable2 instanceof JScrollPane) {
                    serializable = (JScrollPane)serializable2;
                    ((JScrollPane)serializable).getVerticalScrollBar().setUnitIncrement(20);
                    ((JScrollPane)serializable).getHorizontalScrollBar().setUnitIncrement(20);
                }
            }
            serializable2 = mouseWheelEvent.getPoint();
            serializable = SwingUtilities.convertPoint(this, serializable2, container);
            container.dispatchEvent(new MouseWheelEvent((Component)container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (int)((Point)serializable).getX(), (int)((Point)serializable).getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
        }
    }

    void doDoubleClickAction(MouseEvent mouseEvent) {
    }

    void doMiddleClickAction(MouseEvent mouseEvent) {
    }

    static {
        vGestureMap = V2CGestureMap.getGestureMap("ImagePopup");
        icDefault = V2CSwingUtil.getItemIcon("ImageCache");
        icStop = V2CSwingUtil.getItemIcon("Stop");
        V2CAbstractImagePanel.restoreGeometrySettings();
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        bHighRenderingQuality = v2CProperty.getBoolean(sHighRenderingQualityKey);
        String string = v2CProperty.get(sRenderingQualityConfKey);
        bHRQTh = string != null && string.equals("t");
        bAlwaysCenter = v2CProperty.getBoolean(sAlwaysCenterKey);
        bScaleWOShift = v2CProperty.getBoolean(sScaleWOShiftKey);
        V2CMain.imagePopupLoaded();
    }

    class ImageMouseListener
    extends MouseInputAdapter {
        int iX0;
        int iY0;
        int nLastX;
        int nLastY;
        boolean bCursorSet;
        boolean bDragged;
        String sPopupMenuName;
        boolean bRegionSelect;

        ImageMouseListener(String string) {
            this.sPopupMenuName = string;
        }

        void dragAction(MouseEvent mouseEvent, int n, int n2) {
            int n3;
            Rectangle rectangle = V2CAbstractImagePanel.this.getVisibleRect();
            int n4 = rectangle.x - n;
            int n5 = rectangle.y - n2;
            if (n != 0) {
                n3 = V2CAbstractImagePanel.this.nViewWidth - rectangle.width;
                if (n4 > n3) {
                    n4 = n3;
                } else if (n4 < 0) {
                    n4 = 0;
                }
            }
            if (n2 != 0) {
                n3 = V2CAbstractImagePanel.this.nViewHeight - rectangle.height;
                if (n5 > n3) {
                    n5 = n3;
                } else if (n5 < 0) {
                    n5 = 0;
                }
            }
            if (n4 == rectangle.x && n5 == rectangle.y) {
                return;
            }
            rectangle.x = n4;
            rectangle.y = n5;
            V2CAbstractImagePanel.this.scrollRectToVisible(rectangle);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.bDragged = true;
            V2CAbstractImagePanel.this.nB1Count = 0;
            if (vGestureMap.mouseDragged(mouseEvent)) {
                return;
            }
            Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseEvent);
            int n = point.x - this.nLastX;
            int n2 = point.y - this.nLastY;
            this.nLastX = point.x;
            this.nLastY = point.y;
            if (this.bRegionSelect) {
                Graphics2D graphics2D = (Graphics2D)V2CAbstractImagePanel.this.getGraphics();
                graphics2D.setColor(Color.BLACK);
                graphics2D.setXORMode(Color.WHITE);
                V2CAbstractImagePanel.this.drawSelRects(graphics2D);
                V2CAbstractImagePanel.this.calcZoomRect(mouseEvent, this.iX0, this.iY0);
                V2CAbstractImagePanel.this.drawSelRects(graphics2D);
                graphics2D.dispose();
            } else {
                this.dragAction(mouseEvent, n, n2);
                if (!this.bCursorSet) {
                    this.bCursorSet = true;
                    V2CAbstractImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            V2CAbstractImagePanel.this.rSelRect = null;
            V2CAbstractImagePanel.this.rZoomRect = null;
            this.bDragged = false;
            ++V2CAbstractImagePanel.this.nB1Count;
            Point point = mouseEvent.getPoint();
            this.iX0 = point.x;
            this.iY0 = point.y;
            SwingUtilities.convertPointToScreen(point, V2CAbstractImagePanel.this);
            this.nLastX = point.x;
            this.nLastY = point.y;
            boolean bl = mouseEvent.isShiftDown();
            boolean bl2 = V2CApp.isMacintosh() ? mouseEvent.isMetaDown() : mouseEvent.isControlDown();
            boolean bl3 = this.bRegionSelect = !bl && bl2;
            if (vGestureMap.mousePressed(mouseEvent, true)) {
                this.showPopup(mouseEvent);
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (V2CAbstractImagePanel.this.bFocusRequest) {
                V2CAbstractImagePanel.this.requestFocusInWindow();
            }
            if (this.bCursorSet) {
                this.bCursorSet = false;
                V2CAbstractImagePanel.this.setCursor(Cursor.getDefaultCursor());
            }
            if (vGestureMap.mouseReleased(mouseEvent)) {
                this.showPopup(mouseEvent);
                return;
            }
            if (this.bRegionSelect) {
                V2CAbstractImagePanel.this.zoomRegion();
            }
            V2CAbstractImagePanel.this.rSelRect = null;
            V2CAbstractImagePanel.this.rZoomRect = null;
            if (V2CSwingUtil.isSimpleClick(mouseEvent)) {
                V2CAbstractImagePanel.this.doDoubleClickAction(mouseEvent);
            } else if (V2CSwingUtil.isSimpleClick(mouseEvent, 2)) {
                V2CAbstractImagePanel.this.doMiddleClickAction(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (V2CAbstractImagePanel.this.bCleared) {
                return;
            }
            String string = null;
            V2CImageSet v2CImageSet = V2CAbstractImagePanel.this.getImageSet(true);
            string = v2CImageSet != null ? this.sPopupMenuName : (V2CAbstractImagePanel.this.vLink.isChecking() ? "DownloadingImage" : "ViewerNoCache");
            mouseEvent.consume();
            JPopupMenu jPopupMenu = V2CMain.getPopupMenu(string);
            if (jPopupMenu != null) {
                V2CAbstractImagePanel.this.vLink.setupLinkActions();
                V2CPopupListener.showPopup(jPopupMenu, mouseEvent, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class PanelResizer
    implements Runnable {
        PanelResizer() {
        }

        public void run() {
            V2CAbstractImagePanel.this.resizePanel();
        }
    }
}

