/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCustomTabbedPane;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabListPMListener;
import org.monazilla.v2c.V2CTabbedPane;

public class V2CCustomTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final int LEFT_EDGE = 1;
    private static final int RIGHT_EDGE = 2;
    private static final Color cMacUnselectedArea = new Color(0, 0, 0, 63);
    private static final Color cMacTabBorder = new Color(127, 127, 127);
    private static final Color cMacTabLightBorder = new Color(159, 159, 159);
    private static final boolean bLeopard = V2CApp.isMacintosh(5);
    static final Color cLeopardTabBorder = new Color(0x67000000, true);
    static final Color cLeopardTabCorner = new Color(0x57000000, true);
    static final Color cLeopardLightBorder = new Color(0x28FFFFFF, true);
    static final Color cLeopardDarkBorder = new Color(0x7F000000, true);
    private static final boolean bMac;
    private static final boolean bMacScrollTabButton;
    private static ImageIcon imgMacRightArrow;
    private static ImageIcon imgMacDownArrow;
    final boolean bFixTabWidth;
    final int nFixedTabWidth0;
    final int nMaxFixedTabWidth;
    int nFixedTabWidth;
    Color cSelectedBG;
    Color cSelectedFG;
    String sTmpTitle;
    int iSelectedIndex;
    int[] ilIsOnEdge;
    boolean bTabVisibilityChecked;

    public V2CCustomTabbedPaneUI(boolean bl, int n, int n2) {
        this.bFixTabWidth = bl;
        this.nFixedTabWidth0 = n;
        this.nFixedTabWidth = n;
        this.nMaxFixedTabWidth = Math.max(n, n2);
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new CustomLayout();
    }

    protected JButton createScrollButton(int n) {
        if (bMacScrollTabButton) {
            if (imgMacRightArrow == null) {
                imgMacRightArrow = V2CSwingUtil.getSystemImage("mactabra");
            }
            if (imgMacDownArrow == null) {
                imgMacDownArrow = V2CSwingUtil.getSystemImage("mactabda");
            }
            if (n != 5 && n != 1 && n != 3 && n != 7) {
                throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
            }
            return new TabScrollButton(n);
        }
        return super.createScrollButton(n);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.bTabVisibilityChecked = false;
        this.installButtonPopupListener(this.tabPane.getTabLayoutPolicy());
    }

    void tabLayoutPolicyChanged(int n) {
        this.bTabVisibilityChecked = false;
        this.installButtonPopupListener(n);
    }

    void resetTabVisibilityChecked() {
        this.bTabVisibilityChecked = false;
    }

    void installButtonPopupListener(int n) {
        if (n != 1) {
            return;
        }
        int n2 = this.tabPane.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = this.tabPane.getComponent(i);
            if (!(component instanceof UIResource) || !(component instanceof TabScrollButton) && !(component instanceof BasicArrowButton)) continue;
            JButton jButton = (JButton)component;
            if (bMacScrollTabButton) {
                ActionListener[] actionListenerArray = jButton.getActionListeners();
                for (int j = 0; j < actionListenerArray.length; ++j) {
                    jButton.removeActionListener(actionListenerArray[j]);
                }
            }
            jButton.addMouseListener(new V2CTabListPMListener((V2CCustomTabbedPane)this.tabPane, bMacScrollTabButton));
        }
    }

    protected void installDefaults() {
        Color color;
        super.installDefaults();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel != null ? lookAndFeel.getID() : null;
        boolean bl = false;
        if (string != null) {
            if (string.equals("Metal")) {
                bl = true;
                if (V2CApp.javaVersionEqualOrGreaterThan(1, 5) && (color = UIManager.getColor("TabbedPane.unselectedBackground")) != null) {
                    this.tabPane.setBackground(color);
                }
            } else if (string.equals("Nimbus")) {
                bl = true;
                this.highlight = UIManager.getColor("controlHighlight");
                this.lightHighlight = new Color(0x606060);
                this.shadow = UIManager.getColor("controlShadow");
                this.darkShadow = this.lightHighlight;
                this.focus = UIManager.getColor("nimbusFocus");
                this.tabPane.setForeground(UIManager.getColor("controlText"));
                color = UIManager.getColor("background");
                this.tabPane.setBackground(color);
                this.cSelectedBG = new ColorUIResource(191, 206, 219);
            }
        }
        if (!bl) {
            float f;
            float f2;
            this.highlight = SystemColor.controlHighlight;
            this.lightHighlight = SystemColor.controlLtHighlight;
            this.shadow = SystemColor.controlShadow;
            this.darkShadow = SystemColor.controlDkShadow;
            this.focus = new Color(102, 102, 153);
            color = SystemColor.control;
            float f3 = (float)color.getRed() / 255.0f;
            float f4 = (float)Math.sqrt((f3 * f3 + (f2 = (float)color.getGreen() / 255.0f) * f2 + (f = (float)color.getBlue() / 255.0f) * f) / 3.0f);
            if (f4 > 0.84f) {
                float f5 = 0.84f / f4;
                color = new Color(f3 * f5, f2 * f5, f * f5);
            }
            this.tabPane.setForeground(new ColorUIResource(SystemColor.controlText));
            this.tabPane.setBackground(new ColorUIResource(color));
            this.cSelectedBG = color.brighter();
        }
        if (V2CTabbedPane.cSelectedFG != null) {
            this.cSelectedFG = V2CTabbedPane.cSelectedFG;
        }
        if (V2CTabbedPane.cSelectedBG != null) {
            this.cSelectedBG = V2CTabbedPane.cSelectedBG;
        }
        if (bMac) {
            this.textIconGap = 4;
            this.tabInsets = new Insets(2, 5, 2, 5);
            this.tabAreaInsets = new Insets(2, 8, 1, 8);
            this.tabRunOverlay = 0;
            this.contentBorderInsets = new Insets(0, 0, 0, 0);
        } else {
            this.textIconGap = 2;
            this.tabInsets = new Insets(1, 4, 3, 4);
            this.tabAreaInsets = new Insets(2, 2, 1, 2);
            this.tabRunOverlay = 0;
            this.contentBorderInsets = new Insets(2, 2, 3, 3);
        }
        this.tabPane.setOpaque(!bMac);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.cSelectedFG = null;
        this.cSelectedBG = null;
    }

    void checkViewport(int n, Rectangle rectangle) {
        boolean bl = false;
        for (int i = this.tabPane.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.tabPane.getComponent(i);
            if (!(component instanceof JViewport) || !(component instanceof UIResource)) continue;
            JViewport jViewport = (JViewport)component;
            Dimension dimension = jViewport.getView().getSize();
            boolean bl2 = false;
            if (n == 2 || n == 4) {
                if (dimension.height < rectangle.y + rectangle.height) {
                    bl2 = true;
                }
            } else if (dimension.width < rectangle.x + rectangle.width) {
                bl2 = true;
            }
            if (!bl2) continue;
            bl = true;
            jViewport.invalidate();
        }
        if (bl) {
            this.tabPane.validate();
        }
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        if (bMac) {
            this.macPaintTabAreaBackground(graphics, n, n2);
        }
        super.paintTabArea(graphics, n, n2);
        if (!this.bTabVisibilityChecked) {
            this.bTabVisibilityChecked = true;
            if (this.tabPane.getTabLayoutPolicy() == 1 && n2 >= 0) {
                Rectangle rectangle = this.rects[n2];
                boolean bl = false;
                if (n == 2 || n == 4) {
                    if (rectangle.y + rectangle.height > this.tabPane.getHeight()) {
                        bl = true;
                    }
                } else if (rectangle.x + rectangle.width > this.tabPane.getWidth()) {
                    bl = true;
                }
                if (bl) {
                    this.checkViewport(n, rectangle);
                    ((V2CCustomTabbedPane)this.tabPane).sendChangeEventToOthers();
                }
            }
        }
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        if (!bMac || V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            super.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
            return;
        }
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        String string = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = this.tabPane.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    private void macPaintTabAreaBackground(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.tabPane.getTabCount();
        if (n9 <= 0) {
            return;
        }
        boolean bl = this.tabPane.getTabLayoutPolicy() == 1;
        this.iSelectedIndex = this.tabPane.getSelectedIndex();
        this.ilIsOnEdge = new int[n9];
        if (n9 > 0) {
            int n10 = n9;
            for (int i = this.runCount - 1; i >= 0; --i) {
                n8 = n10;
                int n11 = n10 = this.tabRuns[i];
                this.ilIsOnEdge[n11] = this.ilIsOnEdge[n11] | 1;
                int n12 = n8 - 1;
                this.ilIsOnEdge[n12] = this.ilIsOnEdge[n12] | 2;
            }
        }
        Insets insets = this.tabPane.getInsets();
        Dimension dimension = this.tabPane.getSize();
        n8 = bl ? 0 : insets.left;
        int n13 = bl ? 0 : insets.top;
        int n14 = dimension.width - insets.right - n8;
        int n15 = dimension.height - insets.bottom - n13;
        if (bl) {
            Rectangle rectangle = this.rects[n9 - 1];
            if (n == 2 || n == 4) {
                n15 = Math.max(n15, rectangle.y + rectangle.height - n13);
            } else {
                n14 = Math.max(n14, rectangle.x + rectangle.width - n8);
            }
        }
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        switch (n) {
            case 4: {
                if (!bl) {
                    n20 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                    n21 = n15;
                    n17 = n8 + n14;
                    n16 = n17 - n20;
                    n18 = n13;
                    n19 = n18 + n21;
                    break;
                }
            }
            case 2: {
                n20 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n21 = n15;
                n16 = n8;
                n17 = n16 + n20;
                n18 = n13;
                n19 = n18 + n21;
                break;
            }
            case 3: {
                if (!bl) {
                    n20 = n14;
                    n21 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                    n16 = n8;
                    n17 = n16 + n20;
                    n19 = n13 + n15;
                    n18 = n19 - n21;
                    break;
                }
            }
            default: {
                n20 = n14;
                n21 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n16 = n8;
                n17 = n16 + n20;
                n18 = n13;
                n19 = n18 + n21;
            }
        }
        graphics.setColor(cMacUnselectedArea);
        boolean bl2 = false;
        if (n2 >= 0) {
            int n22;
            int n23;
            boolean bl3;
            Rectangle rectangle = this.rects[n2];
            n7 = rectangle.x;
            n6 = n7 + rectangle.width;
            n5 = rectangle.y;
            n4 = n5 + rectangle.height;
            n3 = rectangle.width;
            int n24 = rectangle.height;
            boolean bl4 = bl3 = this.runCount <= 1 || n2 < this.tabRuns[1];
            if (n == 2 || n == 4) {
                if (n == 4) {
                    if (bl3) {
                        n23 = n17 - n7;
                        graphics.setColor(cMacTabBorder);
                        graphics.drawLine(n17 - 1, n18, n17 - 1, n5);
                        graphics.drawLine(n17 - 1, n4, n17 - 1, n19);
                        graphics.setColor(cMacUnselectedArea);
                        bl2 = true;
                    } else {
                        n23 = rectangle.width;
                        if (n6 < n17) {
                            graphics.fillRect(n6, n18, n17 - n6, n21);
                        }
                    }
                    if (n18 < n5) {
                        graphics.fillRect(n7, n18, n23, n5 - n18);
                    }
                    if (n4 < n19) {
                        graphics.fillRect(n7, n4, n23, n19 - n4);
                    }
                    if (n16 < n7) {
                        graphics.fillRect(n16, n18, n7 - n16, n21);
                    }
                } else {
                    if (bl3) {
                        n23 = n16;
                        n22 = n6 - n16;
                        graphics.setColor(cMacTabBorder);
                        graphics.drawLine(n16, n18, n16, n5);
                        graphics.drawLine(n16, n4, n16, n19);
                        graphics.setColor(cMacUnselectedArea);
                        bl2 = true;
                    } else {
                        n23 = n7;
                        n22 = n3;
                        if (n16 < n7) {
                            graphics.fillRect(n16, n18, n7 - n16, n21);
                        }
                    }
                    if (n18 < n5) {
                        graphics.fillRect(n23, n18, n22, n5 - n18);
                    }
                    if (n4 < n19) {
                        graphics.fillRect(n23, n4, n22, n19 - n4);
                    }
                    if (n6 < n17) {
                        graphics.fillRect(n6, n18, n17 - n6, n21);
                    }
                }
            } else if (n == 3) {
                if (bl3) {
                    n23 = n19 - n5;
                    graphics.setColor(cMacTabBorder);
                    graphics.drawLine(n16, n19 - 1, n7, n19 - 1);
                    graphics.drawLine(n6, n19 - 1, n17, n19 - 1);
                    graphics.setColor(cMacUnselectedArea);
                    bl2 = true;
                } else {
                    n23 = rectangle.height;
                    if (n4 < n19) {
                        graphics.fillRect(n16, n4, n20, n19 - n4);
                    }
                }
                if (n16 < n7) {
                    graphics.fillRect(n16, n5, n7 - n16, n23);
                }
                if (n6 < n16 + n20) {
                    graphics.fillRect(n6, n5, n20 - (n6 - n16), n23);
                }
                if (n18 < n5) {
                    graphics.fillRect(n16, n18, n20, n5 - n18);
                }
            } else {
                if (bl3) {
                    n23 = n18;
                    n22 = n4 - n18;
                    if (bLeopard) {
                        graphics.setColor(cLeopardDarkBorder);
                        graphics.drawLine(n16, n18 + 1, n7, n18 + 1);
                        graphics.drawLine(n6, n18 + 1, n17, n18 + 1);
                        graphics.setColor(cLeopardLightBorder);
                        graphics.drawLine(n16, n18, n7, n18);
                        graphics.drawLine(n6, n18, n17, n18);
                    } else {
                        graphics.setColor(cMacTabBorder);
                        graphics.drawLine(n16, n18, n7, n18);
                        graphics.drawLine(n6, n18, n17, n18);
                    }
                    graphics.setColor(cMacUnselectedArea);
                    bl2 = true;
                } else {
                    n23 = n5;
                    n22 = n24;
                    if (n18 < n5) {
                        graphics.fillRect(n16, n18, n20, n5 - n18);
                    }
                }
                if (bl3 && bLeopard && n == 1) {
                    ++n23;
                    --n22;
                }
                if (n16 < n7) {
                    graphics.fillRect(n16, n23, n7 - n16, n22);
                }
                if (n6 < n17) {
                    graphics.fillRect(n6, n23, n17 - n6, n22);
                }
                if (n4 < n19) {
                    graphics.fillRect(n16, n4, n20, n19 - n4);
                }
            }
            n23 = rectangle.x;
            n22 = rectangle.x + rectangle.width - 1;
            int n25 = rectangle.y;
            int n26 = rectangle.y + rectangle.height - 1;
            if (n == 2) {
                --n23;
            } else if (n == 4) {
                ++n22;
            } else if (n == 3) {
                ++n26;
            } else {
                --n25;
            }
            graphics.drawLine(n23, n25, n23, n25);
            graphics.drawLine(n23, n26, n23, n26);
            graphics.drawLine(n22, n25, n22, n25);
            graphics.drawLine(n22, n26, n22, n26);
        } else {
            graphics.fillRect(n16, n18, n20, n21);
        }
        if (n == 2 || n == 4) {
            int n27;
            if (n == 4) {
                n27 = n17 - 1;
                n7 = n16;
                n6 = 0;
            } else {
                n27 = n16;
                n7 = n17 - 1;
                n6 = 1;
            }
            graphics.setColor(cMacTabBorder);
            if (!bl2) {
                graphics.drawLine(n27, n18, n27, n19);
            }
            n5 = n16 + this.getTabAreaInsets((int)n).left + this.tabRunOverlay - n6;
            for (n4 = this.runCount - 1; n4 > 0; --n4) {
                n3 = n5 + n4 * (this.maxTabWidth - this.tabRunOverlay);
                graphics.drawLine(n3, n18, n3, n19);
            }
            graphics.setColor(cMacTabLightBorder);
            graphics.drawLine(n7, n18, n7, n19);
        } else {
            int n28;
            if (n == 3) {
                n28 = n19 - 1;
                n7 = n18;
                n6 = 0;
            } else {
                n28 = n18;
                n7 = n19 - 1;
                n6 = 1;
            }
            graphics.setColor(cMacTabBorder);
            if (!bl2) {
                graphics.drawLine(n16, n28, n17, n28);
            }
            n5 = n18 + this.getTabAreaInsets((int)n).top + this.tabRunOverlay - n6;
            for (n4 = this.runCount - 1; n4 > 0; --n4) {
                n3 = n5 + n4 * (this.maxTabHeight - this.tabRunOverlay);
                graphics.drawLine(n16, n3, n17, n3);
            }
            graphics.setColor(cMacTabLightBorder);
            graphics.drawLine(n16, n7, n17, n7);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bMac) {
            this.macPaintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
            return;
        }
        graphics.setColor(this.lightHighlight);
        int n7 = n3 + 1;
        int n8 = n3 + 2;
        int n9 = n3 + n5 - 1;
        int n10 = n9 - 1;
        int n11 = n4 + 1;
        int n12 = n4 + 2;
        int n13 = n4 + n6 - 1;
        int n14 = n13 - 1;
        switch (n) {
            case 2: {
                graphics.drawLine(n7, n14, n7, n14);
                graphics.drawLine(n3, n12, n3, n14 - 1);
                graphics.drawLine(n7, n11, n7, n11);
                graphics.drawLine(n8, n4, n9, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n8, n14, n9, n14);
                graphics.drawLine(n10, n11, n10, n14);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n8, n13, n9, n13);
                graphics.drawLine(n9, n11, n9, n14);
                break;
            }
            case 4: {
                graphics.drawLine(n3, n4, n10 - 1, n4);
                graphics.drawLine(n3, n12, n3, n14 - 1);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3, n14, n10 - 1, n14);
                graphics.drawLine(n10, n12, n10, n14 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n10, n11, n10, n11);
                graphics.drawLine(n10, n14, n10, n14);
                graphics.drawLine(n9, n12, n9, n14 - 1);
                graphics.drawLine(n3, n13, n10 - 1, n13);
                break;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n14 - 1);
                graphics.drawLine(n7, n14, n7, n14);
                graphics.drawLine(n8, n4, n10 - 1, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n8, n14, n10 - 1, n14);
                graphics.drawLine(n10, n4, n10, n14 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n8, n13, n10 - 1, n13);
                graphics.drawLine(n10, n14, n10, n14);
                graphics.drawLine(n9, n4, n9, n14 - 1);
                break;
            }
            default: {
                graphics.drawLine(n3, n12, n3, n13);
                graphics.drawLine(n7, n11, n7, n11);
                graphics.drawLine(n8, n4, n10 - 1, n4);
                graphics.setColor(this.shadow);
                graphics.drawLine(n10, n12, n10, n13);
                graphics.drawLine(n7, n14, n9, n14);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n9, n12, n9, n13);
                graphics.drawLine(n10, n11, n10, n11);
                graphics.drawLine(n7, n13, n9, n13);
            }
        }
    }

    protected void macPaintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = bLeopard;
        graphics.setColor(cMacTabBorder);
        int n7 = n3 + 1;
        int n8 = n3 + n5 - 1;
        int n9 = n8 - 1;
        int n10 = n4 + 1;
        int n11 = n4 + n6 - 1;
        int n12 = n11 - 1;
        boolean bl3 = this.runCount <= 1 || n2 < this.tabRuns[1];
        int n13 = 0;
        int n14 = 0;
        if (n == 2) {
            n13 = bl3 ? 0 : n7;
        } else if (n == 4) {
            n13 = bl3 ? this.tabPane.getWidth() - this.tabPane.getInsets().right : n8;
        } else if (n == 3) {
            n14 = bl3 ? this.tabPane.getHeight() - this.tabPane.getInsets().bottom : n11;
        } else {
            int n15 = n14 = bl3 ? 0 : n4;
        }
        if (!bl) {
            if ((this.ilIsOnEdge[n2] & 2) != 0 || n2 + 1 != this.iSelectedIndex) {
                if (n == 2) {
                    graphics.drawLine(n13, n11, n8, n11);
                } else if (n == 4) {
                    graphics.drawLine(n3, n11, n13, n11);
                } else if (n == 3) {
                    graphics.drawLine(n8, n4, n8, n14);
                } else if (bl2) {
                    graphics.setColor(cLeopardDarkBorder);
                    graphics.drawLine(n8, n14 + 1, n8, n11);
                    graphics.setColor(cLeopardLightBorder);
                    graphics.drawLine(n8 - 1, n14 + 2, n8 - 1, n11);
                    graphics.drawLine(n8 + 1, n14 + 2, n8 + 1, n11);
                } else {
                    graphics.drawLine(n8, n14, n8, n11);
                }
            }
            return;
        }
        if (!bl3) {
            if (n == 2) {
                --n3;
                --n7;
            } else if (n == 4) {
                ++n8;
                ++n9;
            } else if (n == 3) {
                ++n11;
                ++n12;
            } else {
                --n4;
                --n10;
            }
            graphics.drawLine(n9, n10, n9, n10);
            if (n != 1) {
                graphics.drawLine(n7, n4, n9, n4);
            }
            graphics.drawLine(n7, n10, n7, n10);
            if (n != 2) {
                graphics.drawLine(n3, n10, n3, n12);
            }
            graphics.drawLine(n7, n12, n7, n12);
            if (n != 3) {
                graphics.drawLine(n7, n11, n9, n11);
            }
            graphics.drawLine(n9, n12, n9, n12);
            if (n != 4) {
                graphics.drawLine(n8, n10, n8, n12);
            }
            return;
        }
        if (n == 2) {
            graphics.drawLine(n13, n4, n9, n4);
            graphics.drawLine(n9, n10, n9, n10);
            graphics.drawLine(n8, n10, n8, n12);
            graphics.drawLine(n9, n12, n9, n12);
            graphics.drawLine(n13, n11, n9, n11);
        } else if (n == 4) {
            graphics.drawLine(n13, n4, n7, n4);
            graphics.drawLine(n7, n10, n7, n10);
            graphics.drawLine(n3, n10, n3, n12);
            graphics.drawLine(n7, n12, n7, n12);
            graphics.drawLine(n7, n11, n13, n11);
        } else if (n == 3) {
            graphics.drawLine(n3, n14, n3, n10);
            graphics.drawLine(n7, n10, n7, n10);
            graphics.drawLine(n7, n4, n9, n4);
            graphics.drawLine(n9, n10, n9, n10);
            graphics.drawLine(n8, n10, n8, n14);
        } else if (bl2) {
            graphics.setColor(cLeopardTabBorder);
            graphics.drawLine(n3, n14 + 1, n3, n12 - 1);
            graphics.drawLine(n7 + 1, n11, n9 - 1, n11);
            graphics.drawLine(n8, n14 + 1, n8, n12 - 1);
            graphics.setColor(cLeopardTabCorner);
            graphics.drawLine(n7, n12, n7, n12);
            graphics.drawLine(n7 - 1, n12, n7 - 1, n12);
            graphics.drawLine(n7, n12 + 1, n7, n12 + 1);
            graphics.drawLine(n9, n12, n9, n12);
            graphics.drawLine(n9 + 1, n12, n9 + 1, n12);
            graphics.drawLine(n9, n12 + 1, n9, n12 + 1);
            graphics.setColor(cLeopardLightBorder);
            graphics.drawLine(n7, n11 - 1, n9, n11 - 1);
        } else {
            graphics.drawLine(n3, n14, n3, n12);
            graphics.drawLine(n7, n12, n7, n12);
            graphics.drawLine(n7, n11, n9, n11);
            graphics.drawLine(n9, n12, n9, n12);
            graphics.drawLine(n8, n14, n8, n12);
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bMac) {
            return;
        }
        if (this.cSelectedBG == null) {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            return;
        }
        graphics.setColor(bl ? this.cSelectedBG : this.tabPane.getBackgroundAt(n2));
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 2, n6 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 3, n6 - 1);
                break;
            }
            default: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 3, n6 - 1);
            }
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        if (!this.bFixTabWidth) {
            super.layoutLabel(n, fontMetrics, n2, string, icon, rectangle, rectangle2, rectangle3, bl);
            return;
        }
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        Rectangle rectangle4 = new Rectangle(rectangle);
        rectangle4.x += this.tabInsets.left;
        rectangle4.width -= this.tabInsets.left + this.tabInsets.right;
        this.sTmpTitle = SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle4, rectangle2, rectangle3, this.textIconGap);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        if (this.bFixTabWidth) {
            string = this.sTmpTitle;
        }
        if (bMac) {
            Color color;
            graphics.setFont(font);
            int n3 = this.tabPane.getForegroundAt(n2).getRGB();
            if (n3 == -16777216) {
                color = V2CSwingUtil.cMacTextShadow;
            } else {
                int n4 = n3 >> 17 & 0xFF;
                int n5 = n3 >> 9 & 0xFF;
                int n6 = n3 >> 1 & 0xFF;
                int n7 = 255 - Math.max(Math.max(n4, n5), n6);
                color = new Color(n4 + n7, n5 + n7, n6 + n7, 95);
            }
            graphics.setColor(color);
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent() + 1);
        }
        if (bl && this.cSelectedFG != null) {
            graphics.setFont(font);
            V2CMain.addFontDesktopHints((Graphics2D)graphics);
            graphics.setColor(this.cSelectedFG);
            graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
        } else {
            super.paintText(graphics, n, font, fontMetrics, n2, string, rectangle, bl);
        }
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        if (this.bFixTabWidth) {
            return this.nFixedTabWidth;
        }
        return super.calculateTabWidth(n, n2, fontMetrics);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        super.paintContentBorderTopEdge(graphics, n, -1, n3, n4, n5, n6);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        super.paintContentBorderLeftEdge(graphics, n, -1, n3, n4, n5, n6);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        super.paintContentBorderBottomEdge(graphics, n, -1, n3, n4, n5, n6);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        super.paintContentBorderRightEdge(graphics, n, -1, n3, n4, n5, n6);
    }

    protected boolean shouldRotateTabRuns(int n, int n2) {
        return false;
    }

    void calculateTabWidth(int n, int n2, boolean bl) {
        int n3 = 0;
        if (n2 > 0 && this.bFixTabWidth && (n == 1 || n == 3)) {
            Dimension dimension = this.tabPane.getSize();
            Insets insets = this.tabPane.getInsets();
            Insets insets2 = this.getTabAreaInsets(n);
            int n4 = dimension.width - (insets.left + insets.right + insets2.left + insets2.right);
            if (n4 > 0) {
                int n5 = n4 / n2;
                if (n5 > this.nMaxFixedTabWidth) {
                    n3 = this.nMaxFixedTabWidth;
                } else if (n5 < this.nFixedTabWidth0) {
                    int n6;
                    if (bl && (n6 = n4 / this.nFixedTabWidth0) > 0) {
                        n3 = n4 / n6;
                    }
                } else {
                    n3 = n5;
                }
            }
        }
        this.nFixedTabWidth = n3 > 0 ? n3 : this.nFixedTabWidth0;
    }

    void adjustScrollTabButtonSize(int n) {
        if (!bMacScrollTabButton) {
            return;
        }
        Insets insets = this.tabPane.getInsets();
        int n2 = 0;
        int n3 = 0;
        if (n != 2) {
            if (n == 4) {
                n2 = this.tabPane.getWidth() - insets.right;
            } else if (n == 3) {
                n3 = this.tabPane.getHeight() - insets.bottom;
            }
        }
        int n4 = this.tabPane.getComponentCount();
        for (int i = 0; i < n4; ++i) {
            Component component = this.tabPane.getComponent(i);
            if (component instanceof TabScrollButton) {
                int n5;
                TabScrollButton tabScrollButton = (TabScrollButton)component;
                int n6 = tabScrollButton.iDirection;
                Rectangle rectangle = tabScrollButton.getBounds();
                if (n == 2) {
                    n5 = rectangle.x - n2;
                    if (n5 > 0) {
                        rectangle.x = n2;
                        rectangle.width += n5;
                    }
                } else if (n == 4) {
                    n5 = n2 - (rectangle.x + rectangle.width);
                    if (n5 > 0) {
                        rectangle.width += n5;
                    }
                } else if (n == 3) {
                    n5 = n3 - (rectangle.y + rectangle.height);
                    if (n5 > 0) {
                        rectangle.height += n5;
                    }
                } else {
                    n5 = rectangle.y - n3;
                    if (n5 > 0) {
                        rectangle.y = n3;
                        rectangle.height += n5;
                    }
                }
                tabScrollButton.setBounds(rectangle);
            }
            if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) continue;
            try {
                this.disableCroppedEdge();
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
    }

    private void disableCroppedEdge() throws Exception {
        Class<?> clazz = this.getClass().getSuperclass();
        Field field = clazz.getDeclaredField("tabScroller");
        field.setAccessible(true);
        Object object = field.get(this);
        Class<?> clazz2 = object.getClass();
        Field field2 = clazz2.getField("croppedEdge");
        field2.setAccessible(true);
        Object object2 = field2.get(object);
        Class<?> clazz3 = object2.getClass();
        Method method = clazz3.getMethod("resetParams", null);
        method.setAccessible(true);
        method.invoke(object2, (Object[])null);
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = ((V2CCustomTabbedPane)this.tabPane).getFixedTabHeight();
        return n4 > 0 ? n4 : super.calculateTabHeight(n, n2, n3);
    }

    static {
        bMacScrollTabButton = bMac = V2CApp.isMacintosh();
    }

    private class TabScrollButton
    extends JButton
    implements UIResource {
        final int iDirection;
        int nHeight = 14;

        public TabScrollButton(int n) {
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(false);
            this.iDirection = n;
        }

        public Dimension getPreferredSize() {
            if (this.iDirection == 3 || this.iDirection == 7) {
                return new Dimension(8, this.nHeight);
            }
            return new Dimension(this.nHeight, 8);
        }

        protected void paintComponent(Graphics graphics) {
            int n = V2CCustomTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            graphics.setColor(cMacUnselectedArea);
            if (bLeopard && n == 1) {
                graphics.fillRect(0, 1, n2, n3 - 1);
            } else {
                graphics.fillRect(0, 0, n2, n3);
            }
            int n4 = 0;
            int n5 = 0;
            ImageIcon imageIcon = null;
            if (this.iDirection == 7) {
                n4 = n2 - 6;
                n5 = n3 / 2 - 4;
                imageIcon = imgMacRightArrow;
            } else if (this.iDirection == 3) {
                n4 = -6;
                n5 = n3 / 2 - 4;
                imageIcon = imgMacRightArrow;
            } else if (this.iDirection == 1) {
                n4 = n2 / 2 - 4;
                n5 = n3 - 6;
                imageIcon = imgMacDownArrow;
            } else if (this.iDirection == 5) {
                n4 = n2 / 2 - 4;
                n5 = -6;
                imageIcon = imgMacDownArrow;
            } else {
                return;
            }
            imageIcon.paintIcon(this, graphics, n4, n5);
            if (n == 2) {
                graphics.setColor(cMacTabBorder);
                graphics.drawLine(0, 0, 0, n3);
                graphics.setColor(cMacTabLightBorder);
                graphics.drawLine(n2 - 1, 0, n2 - 1, n3);
            } else if (n == 4) {
                graphics.setColor(cMacTabLightBorder);
                graphics.drawLine(0, 0, 0, n3);
                graphics.setColor(cMacTabBorder);
                graphics.drawLine(n2 - 1, 0, n2 - 1, n3);
            } else if (n == 3) {
                graphics.setColor(cMacTabLightBorder);
                graphics.drawLine(0, 0, n2, 0);
                graphics.setColor(cMacTabBorder);
                graphics.drawLine(0, n3 - 1, n2, n3 - 1);
            } else {
                if (bLeopard) {
                    graphics.setColor(cLeopardLightBorder);
                    graphics.drawLine(0, 0, n2, 0);
                    graphics.setColor(cLeopardDarkBorder);
                    graphics.drawLine(0, 1, n2, 1);
                } else {
                    graphics.setColor(cMacTabBorder);
                    graphics.drawLine(0, 0, n2, 0);
                }
                graphics.setColor(cMacTabLightBorder);
                graphics.drawLine(0, n3 - 1, n2, n3 - 1);
            }
        }
    }

    public class CustomLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public CustomLayout() {
            super(V2CCustomTabbedPaneUI.this);
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            super.calculateTabRects(n, n2);
            int n4 = V2CCustomTabbedPaneUI.this.runCount;
            if (n4 <= 1) {
                return;
            }
            Rectangle[] rectangleArray = V2CCustomTabbedPaneUI.this.rects;
            int[] nArray = V2CCustomTabbedPaneUI.this.tabRuns;
            boolean bl = n == 2 || n == 4;
            int[] nArray2 = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                Rectangle rectangle = rectangleArray[nArray[n4 - n3 - 1]];
                nArray2[n3] = bl ? rectangle.x : rectangle.y;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int n5;
                int n6 = nArray[n3];
                int n7 = nArray[n3 == n4 - 1 ? 0 : n3 + 1];
                int n8 = n7 != 0 ? n7 - 1 : n2 - 1;
                int n9 = nArray2[n3];
                if (bl) {
                    for (n5 = n6; n5 <= n8; ++n5) {
                        rectangleArray[n5].x = n9;
                    }
                    continue;
                }
                for (n5 = n6; n5 <= n8; ++n5) {
                    rectangleArray[n5].y = n9;
                }
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
        }

        protected void rotateTabRuns(int n, int n2) {
        }

        protected void padSelectedTab(int n, int n2) {
        }
    }
}

