/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class V2CLogEvent {
    static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss.SSS");
    final long ltTime = System.currentTimeMillis();
    final int nLevel;
    final String sURL;
    final String sMessage;
    final Object oMessage;
    boolean bSub;
    int iMessageStart;
    int iMessageEnd;

    public V2CLogEvent(int n, String string, String string2, Object object) {
        int n2;
        this.nLevel = n;
        if (string != null && string.startsWith("https://www.googleapis.com/") && (n2 = string.indexOf("key=")) > 0) {
            string = string.substring(0, n2 - 1);
        }
        this.sURL = string;
        this.sMessage = string2;
        this.oMessage = object;
    }

    void reset() {
        this.bSub = false;
        this.iMessageStart = 0;
        this.iMessageEnd = 0;
    }

    void setMessageBound(int n, int n2) {
        this.iMessageStart = n;
        this.iMessageEnd = n2;
    }

    void shiftMessagePos(int n) {
        this.iMessageStart += n;
        this.iMessageEnd += n;
    }

    int getMessageStart() {
        return this.iMessageStart;
    }

    int getMessageEnd() {
        return this.iMessageEnd;
    }

    boolean containdInMessage(int n) {
        return n >= this.iMessageStart && n < this.iMessageEnd;
    }

    int getLevel() {
        return this.nLevel;
    }

    String getTimeString() {
        return sdfTime.format(new Date(this.ltTime));
    }

    String getURLString() {
        return this.sURL;
    }

    String getMessage() {
        return this.sMessage + '\n';
    }

    boolean hasSubMessage() {
        return this.oMessage instanceof String || this.oMessage instanceof Map;
    }

    String getSubMessage() {
        if (this.bSub) {
            return null;
        }
        this.bSub = true;
        if (this.oMessage instanceof String) {
            return (String)this.oMessage;
        }
        if (this.oMessage instanceof Map) {
            StringBuffer stringBuffer = new StringBuffer(1024);
            Map map = (Map)this.oMessage;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (k == null) continue;
                Object v = map.get(k);
                if (v instanceof List) {
                    V2CLogEvent.appendList(stringBuffer, k, (List)v);
                    continue;
                }
                stringBuffer.append("        ");
                stringBuffer.append(k.toString());
                stringBuffer.append(": ");
                if (v != null) {
                    System.out.println(v.getClass());
                    stringBuffer.append(v.toString());
                }
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static void appendList(StringBuffer stringBuffer, Object object, List list) {
        String string = object != null ? object.toString() : null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append("        ");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(": ");
            }
            if (e != null) {
                stringBuffer.append(e.toString());
            }
            stringBuffer.append('\n');
        }
    }
}

