/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;

public class V2CNGExElement {
    boolean bBe;
    boolean bIDExt;
    String sRawWord;
    Matcher mWord;
    String sWord;
    boolean bRegEx;
    boolean bCaseSens;
    boolean bNot;
    char[] clIDExt;
    int[] ilBe;
    String sError;

    static V2CNGExElement restore(V2CPackedPropValue v2CPackedPropValue, boolean bl, boolean bl2) {
        V2CNGExElement v2CNGExElement = new V2CNGExElement(v2CPackedPropValue, bl, bl2);
        return v2CNGExElement.isValid() ? v2CNGExElement : null;
    }

    static V2CNGExElement createElement(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (string == null || string.length() == 0) {
            return null;
        }
        V2CNGExElement v2CNGExElement = new V2CNGExElement(string, bl, bl2, bl3, bl4, bl5);
        return v2CNGExElement.isValid() ? v2CNGExElement : null;
    }

    public V2CNGExElement(V2CPackedPropValue v2CPackedPropValue, boolean bl, boolean bl2) {
        this(v2CPackedPropValue.getString('W'), v2CPackedPropValue.getBoolean('!'), v2CPackedPropValue.getBoolean('R'), v2CPackedPropValue.getBoolean('C'), bl, bl2);
    }

    public V2CNGExElement(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.bIDExt = bl4;
        this.bBe = bl5;
        this.bNot = bl;
        this.bRegEx = bl2;
        this.bCaseSens = bl3;
        this.sRawWord = string;
        if (bl4) {
            this.parseIDExt();
        } else if (bl5) {
            this.parseBe();
        } else {
            this.compileWord();
        }
    }

    boolean isValid() {
        if (this.bIDExt) {
            return this.clIDExt != null;
        }
        if (this.bBe) {
            return this.ilBe != null;
        }
        return this.bRegEx ? this.mWord != null : this.sWord != null;
    }

    private void compileWord() {
        String string = this.sRawWord;
        if (string == null) {
            this.sRawWord = string = "";
        }
        if (this.bRegEx) {
            if (string.length() > 0) {
                try {
                    this.mWord = Pattern.compile(string, this.bCaseSens ? 0 : 2).matcher("");
                }
                catch (Exception exception) {}
            } else {
                this.mWord = null;
            }
        } else {
            this.sWord = string.length() > 0 ? (this.bCaseSens ? string : V2CMiscUtil.normalizeCase(string)) : null;
        }
    }

    boolean parseIDExt() {
        if (!this.bIDExt) {
            return false;
        }
        String string = this.sRawWord;
        if (string == null || string.length() == 0) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            char c = cArray[i];
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z') continue;
            return false;
        }
        this.clIDExt = cArray;
        return true;
    }

    boolean parseBe() {
        int[] nArray;
        if (!this.bBe) {
            return false;
        }
        String[] stringArray = V2CMiscUtil.split(this.sRawWord);
        if (stringArray == null) {
            return true;
        }
        int n = stringArray.length;
        if (n == 1 && stringArray[0].equals("*")) {
            nArray = new int[]{};
        } else {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = V2CMiscUtil.parseInt(stringArray[i]);
                if (n2 <= 0) {
                    this.sError = '\'' + stringArray[i] + "'\u3092BeID\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                    return false;
                }
                nArray[i] = n2;
            }
        }
        this.ilBe = nArray;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkString(CharSequence charSequence, String[] stringArray) {
        if (this.bIDExt || this.bBe) {
            return false;
        }
        if (charSequence == null) {
            charSequence = "";
        }
        if (this.bRegEx) {
            Matcher matcher;
            Matcher matcher2 = matcher = this.mWord;
            synchronized (matcher2) {
                matcher.reset(charSequence);
                return matcher.find() ^ this.bNot;
            }
        }
        String string = stringArray[0];
        if (string == null) {
            stringArray[0] = string = ((Object)charSequence).toString();
        }
        if (!this.bCaseSens) {
            String string2 = stringArray[1];
            if (string2 == null) {
                stringArray[1] = string2 = V2CMiscUtil.normalizeCase(string);
            }
            string = string2;
        }
        return string.indexOf(this.sWord) >= 0 ^ this.bNot;
    }

    boolean checkIDExt(char c) {
        if (!this.bIDExt) {
            return false;
        }
        if (c <= '\u0000') {
            return this.bNot;
        }
        char[] cArray = this.clIDExt;
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (c != cArray[i]) continue;
            return !this.bNot;
        }
        return this.bNot;
    }

    boolean checkBe(int n) {
        if (!this.bBe) {
            return false;
        }
        if (n <= 0) {
            return this.bNot;
        }
        int[] nArray = this.ilBe;
        int n2 = nArray.length;
        if (n2 == 0) {
            return !this.bNot;
        }
        for (int i = 0; i < n2; ++i) {
            if (n != nArray[i]) continue;
            return !this.bNot;
        }
        return this.bNot;
    }

    void addSaveValue(ArrayList arrayList, char c) {
        if (!this.isValid() || this.sRawWord == null || this.sRawWord.length() == 0) {
            return;
        }
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue('W');
        v2CPackedPropValue.setString('K', new String(new char[]{c}));
        v2CPackedPropValue.setBoolean('C', this.bCaseSens);
        v2CPackedPropValue.setBoolean('R', this.bRegEx);
        v2CPackedPropValue.setBoolean('!', this.bNot);
        v2CPackedPropValue.setString('W', this.sRawWord);
        arrayList.add(v2CPackedPropValue);
    }

    void appendDescription(StringBuffer stringBuffer) {
        if (this.bCaseSens || this.bRegEx || this.bNot) {
            stringBuffer.append('[');
            if (this.bNot) {
                stringBuffer.append('!');
            }
            if (this.bRegEx) {
                stringBuffer.append('R');
            }
            if (this.bCaseSens) {
                stringBuffer.append('C');
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(':');
        stringBuffer.append(this.sRawWord);
        stringBuffer.append('\u3001');
    }
}

