/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CThreadItem;

public class V2CReplayList
extends JList {
    ArrayList alRemovedThreads = new ArrayList();

    private static ListModel createThreadListModel(V2CThreadItem[] v2CThreadItemArray) {
        DefaultListModel<V2CThreadItem> defaultListModel = new DefaultListModel<V2CThreadItem>();
        for (int i = 0; i < v2CThreadItemArray.length; ++i) {
            defaultListModel.addElement(v2CThreadItemArray[i]);
        }
        return defaultListModel;
    }

    public V2CReplayList(V2CThreadItem[] v2CThreadItemArray) {
        super(V2CReplayList.createThreadListModel(v2CThreadItemArray));
        this.setVisibleRowCount(10);
        this.setCellRenderer(new ReplayListRenderer());
        this.addMouseListener(new ReplayPopupListener());
    }

    boolean showDialog() {
        int n = JOptionPane.showConfirmDialog(V2CMain.v2cMain, new JScrollPane(this), "\u540c\u671f\u518d\u751f\u30ea\u30b9\u30c8", 2, -1);
        return n == 0;
    }

    ArrayList getRemovedThreads() {
        return this.alRemovedThreads;
    }

    void openSelectedThread() {
        int[] nArray = this.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int n = nArray.length;
        if (n > 1) {
            Arrays.sort(nArray);
        }
        V2CThreadItem[] v2CThreadItemArray = new V2CThreadItem[n];
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < n; ++i) {
            v2CThreadItemArray[i] = (V2CThreadItem)defaultListModel.getElementAt(nArray[i]);
        }
        V2CThreadItem.open(v2CThreadItemArray, false, false);
    }

    void deleteSelectedEntry() {
        int[] nArray = this.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (nArray.length > 1) {
            Arrays.sort(nArray);
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.alRemovedThreads.add(defaultListModel.remove(nArray[i]));
        }
    }

    private static class ReplayListRenderer
    extends DefaultListCellRenderer {
        private ReplayListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.setText(String.valueOf(n + 1) + "   " + ((V2CThreadItem)object).getTitle());
            }
            return this;
        }
    }

    private class ReplayPopupListener
    extends V2CPopupListener {
        ReplayPopupListener() {
            super("ReplayList");
        }

        void setupAction(MouseEvent mouseEvent) {
            int n = V2CReplayList.this.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            if (!V2CReplayList.this.isSelectedIndex(n)) {
                V2CReplayList.this.setSelectedIndex(n);
            }
        }
    }
}

