/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CMain;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class V2CSingleImage {
    static ICC_Profile iccProfileCMYK = null;
    private static final boolean bPrintNodeInfo = false;
    static final int NONE = 0;
    static final int DO_NOT_DISPOSE = 1;
    static final int RESTORE_TO_BG = 2;
    static final int RESTORE_TO_PREV = 3;
    private static final int nMinDelayTime = 30;
    Image iImage;
    Image iScaledImage;
    int nX;
    int nY;
    int nWidth;
    int nHeight;
    boolean bInterlace;
    boolean bTransparent;
    int iDisposalMethod;
    int nDelayTime;
    boolean bThumbnailImageCreated;
    private static float[] flcr = new float[]{-0.05930647f, -0.2515778f, -0.2355781f, -1.10902f, 0.3569998f, -0.1684346f, -0.3115422f, -0.2028333f, 0.5522593f, -0.1587408f, -1.577459f, 0.5184523f, -0.04045399f, 1.983578f, -0.4294166f};
    private static float[] flcg = new float[]{-0.08279894f, -0.3008856f, -0.2810283f, -1.130134f, 0.439294f, -0.2631223f, -0.3974407f, 0.1177769f, 0.718766f, -0.1713256f, 0.5373592f, 0.5986116f, -0.04320273f, 0.7796825f, -0.5170328f};
    private static float[] flcb = new float[]{0.005186297f, 0.05627564f, -0.00546149f, -1.01511f, -0.01877278f, 0.1251009f, 0.1477184f, -1.760302f, -0.2235212f, 0.0558004f, 0.01157604f, -0.1184474f, -7.781947E-4f, 1.884478f, 0.07955397f};
    int nBlockSize;

    public V2CSingleImage(V2CSingleImage v2csingleimage, double d, AffineTransformOp affinetransformop, boolean flag, String s) {
        block28: {
            Image image;
            block19: {
                int i3;
                int l2;
                int j3;
                int k2;
                this.nDelayTime = 500;
                image = v2csingleimage.iImage;
                this.nX = (int)(d * (double)v2csingleimage.nX);
                this.nY = (int)(d * (double)v2csingleimage.nY);
                this.bInterlace = v2csingleimage.bInterlace;
                this.bTransparent = v2csingleimage.bTransparent;
                this.iDisposalMethod = v2csingleimage.iDisposalMethod;
                this.nDelayTime = v2csingleimage.nDelayTime;
                if (!flag) break block19;
                v2csingleimage.setScaledImageCreated(s);
                int i = image.getWidth(null);
                int k = image.getHeight(null);
                if (i <= 0 || k <= 0) {
                    return;
                }
                int i1 = Math.max((int)Math.round(d * (double)i), 1);
                int k1 = Math.max((int)Math.round(d * (double)k), 1);
                this.nWidth = i1;
                this.nHeight = k1;
                int i2 = i * k;
                int[] ai = new int[i2];
                PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, i, k, ai, 0, i);
                try {
                    pixelgrabber.grabPixels();
                }
                catch (InterruptedException interruptedexception) {
                    interruptedexception.printStackTrace();
                }
                if ((pixelgrabber.getStatus() & 0x80) != 0) {
                    System.out.println("image fetch aborted or errored");
                }
                if (d < 0.1) {
                    int k3 = (int)(1.0 - 2.0 * Math.log(d * 10.0) / Math.log(2.0));
                    if (k3 > 14) {
                        k3 = 14;
                    }
                    int l3 = k3 / 2;
                    k2 = 255 >>> 7 - l3;
                    j3 = 8 - (k3 - l3);
                    l2 = 256 >>> 8 - j3;
                    i3 = l2 - 1;
                } else {
                    k2 = 1;
                    j3 = 8;
                    l2 = 256;
                    i3 = 255;
                }
                int[] ai1 = new int[i1 * k1];
                int i4 = 0;
                int j4 = 0;
                while (j4 < k1) {
                    int k4 = j4 * k / k1;
                    int l4 = l2 - ((j4 * k << j3) / k1 & i3);
                    int i5 = (j4 + 1) * k / k1;
                    int j5 = ((j4 + 1) * k << j3) / k1 & i3;
                    int k5 = 0;
                    while (k5 < i1) {
                        int l5 = k5 * i / i1;
                        int i6 = l2 - ((k5 * i << j3) / i1 & i3);
                        int j6 = (k5 + 1) * i / i1;
                        int k6 = ((k5 + 1) * i << j3) / i1 & i3;
                        int l6 = 0;
                        int i7 = 0;
                        int j7 = 0;
                        int k7 = 0;
                        int l7 = 0;
                        int i8 = k4;
                        while (i8 <= i5 && i8 < k) {
                            block23: {
                                int l8;
                                int k8;
                                block21: {
                                    block22: {
                                        block20: {
                                            k8 = i8 * i;
                                            if (i8 != k4) break block20;
                                            l8 = l4;
                                            break block21;
                                        }
                                        if (i8 != i5) break block22;
                                        if (j5 == 0) break block23;
                                        l8 = j5;
                                        break block21;
                                    }
                                    l8 = l2;
                                }
                                int i9 = l5;
                                while (i9 <= j6 && i9 < i) {
                                    block27: {
                                        int k10;
                                        int j10;
                                        int i10;
                                        int l9;
                                        int k9;
                                        block25: {
                                            block26: {
                                                block24: {
                                                    int j9 = ai[k8 + i9];
                                                    k9 = j9 >>> 24;
                                                    l9 = j9 >>> 16 & 0xFF;
                                                    i10 = j9 >>> 8 & 0xFF;
                                                    j10 = j9 & 0xFF;
                                                    if (i9 != l5) break block24;
                                                    k10 = i6;
                                                    break block25;
                                                }
                                                if (i9 != j6) break block26;
                                                if (k6 == 0) break block27;
                                                k10 = k6;
                                                break block25;
                                            }
                                            k10 = l2;
                                        }
                                        if (l8 != l2) {
                                            k10 = k10 * l8 >>> 8;
                                        }
                                        int l10 = k9 * k10;
                                        l7 += k10;
                                        l6 += l10;
                                        i7 += l9 * l10 / k2;
                                        j7 += i10 * l10 / k2;
                                        k7 += j10 * l10 / k2;
                                    }
                                    ++i9;
                                }
                            }
                            ++i8;
                        }
                        int j8 = l6 / k2;
                        if (j8 > 0) {
                            ai1[i4] = l6 / l7 << 24 | (i7 / j8 & 0xFF) << 16 | (j7 / j8 & 0xFF) << 8 | k7 / j8 & 0xFF;
                        }
                        ++i4;
                        ++k5;
                    }
                    ++j4;
                }
                BufferedImage bufferedimage2 = new BufferedImage(i1, k1, 2);
                bufferedimage2.setRGB(0, 0, i1, k1, ai1, 0, i1);
                this.iImage = bufferedimage2;
                break block28;
            }
            if (image instanceof BufferedImage) {
                BufferedImage bufferedimage = (BufferedImage)image;
                ColorModel colormodel = bufferedimage.getColorModel();
                int j1 = bufferedimage.getType();
                int l1 = Math.max((int)Math.round(d * (double)bufferedimage.getWidth()), 1);
                int j2 = Math.max((int)Math.round(d * (double)bufferedimage.getHeight()), 1);
                this.nWidth = l1;
                this.nHeight = j2;
                BufferedImage bufferedimage1 = new BufferedImage(colormodel, colormodel.createCompatibleWritableRaster(l1, j2), colormodel.isAlphaPremultiplied(), null);
                this.iImage = bufferedimage1;
                boolean flag1 = false;
                if (affinetransformop != null) {
                    v2csingleimage.setScaledImageCreated(s);
                    try {
                        affinetransformop.filter(bufferedimage, bufferedimage1);
                        flag1 = true;
                    }
                    catch (ImagingOpException k2) {
                        // empty catch block
                    }
                }
                if (!flag1) {
                    Graphics2D graphics2d1 = (Graphics2D)this.iImage.getGraphics();
                    graphics2d1.drawImage(image, 0, 0, l1, j2, null);
                    graphics2d1.dispose();
                }
            } else {
                int j = Math.max((int)Math.round(d * (double)image.getWidth(null)), 1);
                int l = Math.max((int)Math.round(d * (double)image.getHeight(null)), 1);
                this.nWidth = j;
                this.nHeight = l;
                this.iImage = V2CMain.v2cMain.createImage(j, l);
                Graphics2D graphics2d = (Graphics2D)this.iImage.getGraphics();
                graphics2d.drawImage(image, 0, 0, j, l, null);
                graphics2d.dispose();
            }
        }
    }

    public V2CSingleImage(ImageReader imagereader, Object obj, int i, boolean use_jfif, int jpeg_color_model) throws IOException {
        this.nDelayTime = 500;
        boolean flag2 = true;
        if (obj instanceof File) {
            File file = (File)obj;
            if (use_jfif) {
                BufferedImage bufferedimage;
                block16: {
                    bufferedimage = null;
                    try {
                        bufferedimage = imagereader.read(0);
                    }
                    catch (IIOException iioexception) {
                        WritableRaster raster = (WritableRaster)imagereader.readRaster(0, null);
                        if (raster == null || raster.getNumBands() != 4) {
                            throw iioexception;
                        }
                        if (jpeg_color_model == 2) {
                            V2CSingleImage.convertYcckToCmyk(raster);
                            jpeg_color_model = 1;
                        }
                        if (jpeg_color_model != 1) break block16;
                        V2CSingleImage.convertInvertedColors(raster);
                        if (iccProfileCMYK == null) {
                            iccProfileCMYK = ICC_Profile.getInstance(V2CSingleImage.class.getClassLoader().getResourceAsStream("org/monazilla/v2c/Generic CMYK Profile.icc"));
                        }
                        bufferedimage = V2CSingleImage.convertCmykToRgb(raster, iccProfileCMYK);
                    }
                }
                this.iImage = bufferedimage;
                flag2 = false;
            } else {
                this.iImage = Toolkit.getDefaultToolkit().createImage(file.getPath());
            }
        } else if (obj instanceof byte[]) {
            this.iImage = Toolkit.getDefaultToolkit().createImage((byte[])obj);
        }
        if (this.iImage == null) {
            throw new IOException("createImage failed !");
        }
        if (flag2) {
            MediaTracker mediatracker = new MediaTracker(V2CMain.v2cMain);
            mediatracker.addImage(this.iImage, 0);
            try {
                mediatracker.waitForAll();
            }
            catch (InterruptedException interruptedexception) {
                throw new IOException("image loading interrupted !");
            }
            if (mediatracker.isErrorAny()) {
                throw new IOException("image loading error !");
            }
        }
        this.nWidth = this.iImage.getWidth(null);
        this.nHeight = this.iImage.getHeight(null);
        if (this.nWidth < 0 || this.nHeight < 0) {
            throw new IOException("unknown image geometry !");
        }
        this.nBlockSize = i;
    }

    public V2CSingleImage(ImageReader imagereader, int i, int j) throws IOException {
        this(imagereader.read(i), j);
    }

    public V2CSingleImage(BufferedImage bufferedimage, int i) throws IOException {
        this.nDelayTime = 500;
        this.iImage = bufferedimage;
        this.nWidth = bufferedimage.getWidth();
        this.nHeight = bufferedimage.getHeight();
        if (this.nWidth < 0 || this.nHeight < 0) {
            throw new IOException("(nWidth<0)||(nHeight<0)");
        }
        this.nBlockSize = i;
    }

    void clear() {
        Image image = this.iImage;
        if (image != null) {
            this.iImage = null;
            image.flush();
        }
    }

    void setBlockSize(int i) {
        if (i != this.nBlockSize) {
            this.nBlockSize = i;
            this.iScaledImage = null;
        }
    }

    void createScaledImage() {
        if (this.nBlockSize < 4 || this.iScaledImage != null) {
            return;
        }
        if (this.nWidth <= 1 && this.nHeight <= 1) {
            this.iScaledImage = this.iImage;
            return;
        }
        int i = Math.max(this.nWidth / this.nBlockSize, 1);
        int j = Math.max(this.nHeight / this.nBlockSize, 1);
        Image image = this.iImage;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedimage = (BufferedImage)image;
            ColorModel colormodel = bufferedimage.getColorModel();
            int k = bufferedimage.getType();
            BufferedImage bufferedimage1 = new BufferedImage(colormodel, colormodel.createCompatibleWritableRaster(i, j), colormodel.isAlphaPremultiplied(), null);
            this.iScaledImage = bufferedimage1;
        } else {
            this.iScaledImage = V2CMain.v2cMain.createImage(i, j);
        }
        Graphics g = this.iScaledImage.getGraphics();
        g.drawImage(image, 0, 0, i, j, null);
        g.dispose();
    }

    void computeUnion(Rectangle rectangle) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle.setBounds(this.nX, this.nY, this.nWidth, this.nHeight);
        } else {
            SwingUtilities.computeUnion(this.nX, this.nY, this.nWidth, this.nHeight, rectangle);
        }
    }

    int getWidth() {
        return this.nWidth;
    }

    int getHeight() {
        return this.nHeight;
    }

    boolean needsBuffer(int i, int j) {
        return this.iDisposalMethod == 1 || this.isBGVisible(i, j);
    }

    Image getImage() {
        return this.iImage;
    }

    void setImage(Image image) {
        this.iImage = image;
    }

    int getDelayTime() {
        return this.nDelayTime;
    }

    int getDisposalMethod() {
        return this.iDisposalMethod;
    }

    void setDisposalMethod(int i) {
        this.iDisposalMethod = i;
    }

    boolean shouldClear() {
        return this.iDisposalMethod == 2;
    }

    boolean isBGVisible(int i, int j) {
        return this.bTransparent || this.nX > 0 || this.nY > 0 || this.nWidth < i || this.nHeight < j;
    }

    boolean restoreToPrev() {
        return this.iDisposalMethod == 3;
    }

    void clearRect(Graphics2D graphics2d, int i, int j, double d, Color color) {
        int l;
        int k;
        graphics2d.setColor(color);
        if (d > 0.0 && d != 1.0) {
            i += (int)(d * (double)this.nX);
            j += (int)(d * (double)this.nY);
            k = (int)(d * (double)this.nWidth);
            l = (int)(d * (double)this.nHeight);
        } else {
            i += this.nX;
            j += this.nY;
            k = this.nWidth;
            l = this.nHeight;
        }
        graphics2d.fillRect(i, j, k, l);
    }

    void setScaledImageCreated(String s) {
        this.bThumbnailImageCreated = s != null && s.equalsIgnoreCase("PNG");
    }

    void draw(Graphics2D graphics2d, int i, int j, double d) {
        if (this.bThumbnailImageCreated) {
            this.bThumbnailImageCreated = false;
            if (this.nWidth * this.nHeight > 500000) {
                BufferedImage bufferedimage = new BufferedImage(this.nWidth, this.nHeight, 2);
                Graphics2D graphics2d1 = (Graphics2D)bufferedimage.getGraphics();
                graphics2d1.drawImage(this.iImage, 0, 0, this.nWidth, this.nHeight, null);
                graphics2d1.dispose();
                this.iImage = bufferedimage;
            }
        }
        if (d > 0.0 && d != 1.0) {
            i += (int)(d * (double)this.nX);
            j += (int)(d * (double)this.nY);
            int k = (int)(d * (double)this.nWidth);
            int l = (int)(d * (double)this.nHeight);
            if (this.nBlockSize >= 4) {
                this.createScaledImage();
                graphics2d.drawImage(this.iScaledImage, i, j, k, l, null);
            } else {
                graphics2d.drawImage(this.iImage, i, j, k, l, null);
            }
        } else {
            i += this.nX;
            j += this.nY;
            if (this.nBlockSize >= 4) {
                this.createScaledImage();
                graphics2d.drawImage(this.iScaledImage, i, j, this.nWidth, this.nHeight, null);
            } else {
                graphics2d.drawImage(this.iImage, i, j, null);
            }
        }
    }

    void extractInfo(ImageReader imagereader, int i) {
        IIOMetadata iiometadata = null;
        try {
            iiometadata = imagereader.getImageMetadata(i);
        }
        catch (IOException ioexception) {
            System.out.println(ioexception.getMessage());
        }
        if (iiometadata == null) {
            return;
        }
        String s = iiometadata.getNativeMetadataFormatName();
        if (s == null || s.length() == 0) {
            return;
        }
        Node node = iiometadata.getAsTree(s);
        if (s.indexOf("_gif_") > 0) {
            this.extractGIFInfo(node);
        }
    }

    void extractGIFInfo(Node node) {
        NodeList nodelist = node.getChildNodes();
        if (nodelist == null) {
            return;
        }
        int i = nodelist.getLength();
        int j = 0;
        while (j < i) {
            Node node1 = nodelist.item(j);
            String s = node1.getNodeName();
            if (s != null) {
                NamedNodeMap namednodemap = node1.getAttributes();
                if (s.equals("ImageDescriptor")) {
                    String s1;
                    Node node2 = namednodemap.getNamedItem("imageLeftPosition");
                    if (node2 != null) {
                        try {
                            this.nX = Integer.parseInt(node2.getNodeValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((node2 = namednodemap.getNamedItem("imageTopPosition")) != null) {
                        try {
                            this.nY = Integer.parseInt(node2.getNodeValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((node2 = namednodemap.getNamedItem("interlaceFlag")) != null && (s1 = node2.getNodeValue()) != null && s1.equalsIgnoreCase("TRUE")) {
                        this.bInterlace = true;
                    }
                } else if (s.equals("GraphicControlExtension")) {
                    String s3;
                    String s2;
                    Node node3 = namednodemap.getNamedItem("disposalMethod");
                    if (node3 != null && (s2 = node3.getNodeValue()) != null) {
                        if (s2.equals("none")) {
                            this.iDisposalMethod = 0;
                        } else if (s2.equals("doNotDispose")) {
                            this.iDisposalMethod = 1;
                        } else if (s2.equals("restoreToBackgroundColor")) {
                            this.iDisposalMethod = 2;
                        } else if (s2.equals("restoreToPrevious")) {
                            this.iDisposalMethod = 3;
                        }
                    }
                    if ((node3 = namednodemap.getNamedItem("transparentColorFlag")) != null && (s3 = node3.getNodeValue()) != null && s3.equalsIgnoreCase("TRUE")) {
                        this.bTransparent = true;
                    }
                    if ((node3 = namednodemap.getNamedItem("delayTime")) != null) {
                        int k = 0;
                        try {
                            k = Integer.parseInt(node3.getNodeValue()) * 10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.nDelayTime = k == 0 ? 100 : Math.max(k, 30);
                    }
                }
            }
            ++j;
        }
    }

    public static void convertYcckToCmyk(WritableRaster raster) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * 4;
        int[] pixelRow = new int[stride];
        int h = 0;
        while (h < height) {
            raster.getPixels(0, h, width, 1, pixelRow);
            int x = 0;
            while (x < stride) {
                int y = pixelRow[x];
                int cb = pixelRow[x + 1];
                int cr = pixelRow[x + 2];
                int c = (int)((double)y + 1.402 * (double)cr - 178.956);
                int m = (int)((double)y - 0.34414 * (double)cb - 0.71414 * (double)cr + 135.95984);
                y = (int)((double)y + 1.772 * (double)cb - 226.316);
                if (c < 0) {
                    c = 0;
                } else if (c > 255) {
                    c = 255;
                }
                if (m < 0) {
                    m = 0;
                } else if (m > 255) {
                    m = 255;
                }
                if (y < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                pixelRow[x] = 255 - c;
                pixelRow[x + 1] = 255 - m;
                pixelRow[x + 2] = 255 - y;
                x += 4;
            }
            raster.setPixels(0, h, width, 1, pixelRow);
            ++h;
        }
    }

    public static void convertInvertedColors(WritableRaster raster) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * 4;
        int[] pixelRow = new int[stride];
        int h = 0;
        while (h < height) {
            raster.getPixels(0, h, width, 1, pixelRow);
            int x = 0;
            while (x < stride) {
                pixelRow[x] = 255 - pixelRow[x];
                ++x;
            }
            raster.setPixels(0, h, width, 1, pixelRow);
            ++h;
        }
    }

    public static BufferedImage convertCmykToRgb(Raster cmykRaster, ICC_Profile cmykProfile) throws IOException {
        byte[] profileData;
        if (cmykProfile == null) {
            cmykProfile = ICC_Profile.getInstance(V2CSingleImage.class.getClassLoader().getResourceAsStream("org/monazilla/v2c/Generic CMYK Profile.icc"));
        }
        if (cmykProfile.getProfileClass() != 1 && (profileData = cmykProfile.getData())[64] == 0) {
            V2CSingleImage.intToBigEndian(1835955314, profileData, 12);
            cmykProfile = ICC_Profile.getInstance(profileData);
        }
        ICC_ColorSpace cmykCS = new ICC_ColorSpace(cmykProfile);
        BufferedImage rgbImage = new BufferedImage(cmykRaster.getWidth(), cmykRaster.getHeight(), 1);
        WritableRaster rgbRaster = rgbImage.getRaster();
        ColorSpace rgbCS = rgbImage.getColorModel().getColorSpace();
        ColorConvertOp cmykToRgb = new ColorConvertOp(cmykCS, rgbCS, null);
        cmykToRgb.filter(cmykRaster, rgbRaster);
        return rgbImage;
    }

    static void intToBigEndian(int value, byte[] array, int index) {
        array[index] = (byte)(value >> 24);
        array[index + 1] = (byte)(value >> 16);
        array[index + 2] = (byte)(value >> 8);
        array[index + 3] = (byte)value;
    }
}

