/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Toolkit;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSoundSP;

public class V2CSoundUtil {
    private static final int EXTERNAL_BUFFER_SIZE = 128000;
    private static final String sConfKey = "Sound.Conf";
    private static V2CPackedPropValue ppvSoundConf;
    static final char USE_SOUND = 'a';
    static final char MUTE_SOUND = 'm';
    static final char THREAD_NEWRES = 'r';
    static final char THREAD_NONEWRES = 'n';
    static final char THREAD_ERROR = 'e';
    static final char TWITTER_NEWTWEET = 'w';
    static final char TWITTER_NONEWTWEET = 'o';
    static final char TWITTER_ERROR = 'x';
    static final char BOARD_NEWRES = 'R';
    static final char BOARD_NONEWRES = 'N';
    static final char BOARD_NEWTHREAD = 'T';
    static final char BOARD_ERROR = 'E';
    static final char CHECK_NEWRES = 'C';
    static final char CHECK_NONEWRES = '0';
    static final char WEBSEARCH_NEWTHREAD = 't';

    static {
        V2CProperty v2cproperty = V2CApp.getUserProperty();
        V2CPackedPropValue v2cpackedpropvalue = v2cproperty.getPackedValue(sConfKey);
        if (v2cpackedpropvalue != null) {
            boolean flag = v2cpackedpropvalue.getBoolean('a');
            int i = V2CApp.getLastRelSeqNum();
            if (i > 0 && i < 528) {
                if (flag) {
                    v2cpackedpropvalue.setBoolean('a', false);
                } else {
                    v2cpackedpropvalue.setBoolean('m', true);
                }
                v2cproperty.putPackedValue(sConfKey, v2cpackedpropvalue);
            } else if (flag) {
                v2cpackedpropvalue.setBoolean('a', false);
                v2cproperty.putPackedValue(sConfKey, v2cpackedpropvalue);
            }
        } else {
            v2cpackedpropvalue = new V2CPackedPropValue();
        }
        ppvSoundConf = v2cpackedpropvalue;
    }

    static boolean isCompSoundEnabled() {
        return !ppvSoundConf.getBoolean('m');
    }

    static JPanel getConfPanel() {
        V2CSoundSP v2csoundsp = new V2CSoundSP(V2CSoundUtil.createSoundFileListForSetting());
        return v2csoundsp;
    }

    static void applyChanges(V2CSoundSP soundSP) {
        soundSP.setSoundName(ppvSoundConf);
        V2CApp.getUserProperty().putPackedValue(sConfKey, ppvSoundConf);
    }

    static void setSound() {
        V2CSoundSP v2csoundsp = new V2CSoundSP(V2CSoundUtil.createSoundFileListForSetting());
        if (!v2csoundsp.showDialog()) {
            return;
        }
        v2csoundsp.setSoundName(ppvSoundConf);
        V2CApp.getUserProperty().putPackedValue(sConfKey, ppvSoundConf);
    }

    static boolean isSoundDefined(char c) {
        return V2CSoundUtil.getSoundName(c) != null;
    }

    static String getSoundName(char c) {
        return ppvSoundConf.getString(c);
    }

    static void playSoundFile0(File file) throws Exception {
        AudioInputStream audioinputstream = null;
        Line sourcedataline = null;
        try {
            audioinputstream = AudioSystem.getAudioInputStream(file);
            AudioFormat audioformat = audioinputstream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioformat);
            sourcedataline = (SourceDataLine)AudioSystem.getLine(info);
            sourcedataline.open(audioformat);
            sourcedataline.start();
            int i = 0;
            byte[] abyte0 = new byte[128000];
            while (i >= 0) {
                i = audioinputstream.read(abyte0, 0, abyte0.length);
                if (i <= 0) continue;
                sourcedataline.write(abyte0, 0, i);
            }
            sourcedataline.drain();
        }
        finally {
            if (audioinputstream != null) {
                audioinputstream.close();
            }
            if (sourcedataline != null) {
                sourcedataline.close();
            }
        }
    }

    static void playSound(char c) {
        V2CSoundUtil.playSoundFile(V2CSoundUtil.getSoundName(c));
    }

    static void playSoundFile(String s) {
        if (s == null) {
            return;
        }
        File file = V2CLocalFileHandler.getSoundFile(s);
        if (file != null) {
            V2CSoundUtil.playSoundFile(file);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static void playSoundFile(final File fs) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    V2CSoundUtil.playSoundFile0(fs);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    V2CMain.setErrorMessage(V2CMiscUtil.getMessage(exception));
                }
            }
        };
        thread.start();
    }

    static String[] createSoundFileListForSetting() {
        return V2CSoundUtil.createSoundFileListForSetting("\uff08\u306a\u3057\uff09");
    }

    static String[] createSoundFileListForSetting(String s) {
        String[] as = V2CSoundUtil.createSoundFileList();
        if (s != null) {
            if (as != null) {
                String[] as1 = new String[as.length + 1];
                as1[0] = s;
                System.arraycopy(as, 0, as1, 1, as.length);
                as = as1;
            } else {
                as = new String[]{s};
            }
        } else if (as == null) {
            as = new String[]{};
        }
        return as;
    }

    static String[] createSoundFileList() {
        File file = V2CLocalFileHandler.getSoundDir();
        if (file == null) {
            return null;
        }
        File[] afile = file.listFiles();
        if (afile == null || afile.length == 0) {
            return null;
        }
        String[] as = new String[]{".wav", ".WAV", ".au", ".AU", ".af", ".AF", ".aiff", ".AIFF"};
        HashSet<String> hashset = new HashSet<String>();
        int i = 0;
        while (i < afile.length) {
            File file1 = afile[i];
            String s = file1.getName();
            if (s.indexOf(9) < 0) {
                for (int k = 0; k < as.length; ++k) {
                    if (!s.endsWith(as[k])) continue;
                    hashset.add(s.substring(0, s.length() - as[k].length()));
                    break;
                }
            }
            ++i;
        }
        int j = hashset.size();
        if (j == 0) {
            return null;
        }
        Object[] as1 = hashset.toArray(new String[j]);
        Arrays.sort(as1);
        return as1;
    }
}

