/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CThreadLabelMenu;
import org.monazilla.v2c.V2CThreadLabelSP;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CThreadLabel {
    static final int STYLECOUNT = 10;
    private static final String sLabelsKey = "ThreadLabel.Labels";
    private static V2CThreadLabel[] vlThreadLabel;
    final int iIndex;
    Color cColor;
    String sLabel;
    boolean bProtected;

    static void setThreadLabel() {
        V2CThreadLabelSP v2CThreadLabelSP = V2CThreadLabel.createThreadLabelSP();
        if (v2CThreadLabelSP.showDialog()) {
            V2CThreadLabel.postConfig(v2CThreadLabelSP);
        }
    }

    static V2CThreadLabelSP createThreadLabelSP() {
        V2CThreadLabel[] v2CThreadLabelArray = V2CThreadLabel.getLabels();
        int n = v2CThreadLabelArray.length;
        V2CThreadLabel[] v2CThreadLabelArray2 = new V2CThreadLabel[n];
        for (int i = 0; i < n; ++i) {
            v2CThreadLabelArray2[i] = new V2CThreadLabel(v2CThreadLabelArray[i]);
        }
        return new V2CThreadLabelSP(v2CThreadLabelArray2);
    }

    static void postConfig(V2CThreadLabelSP v2CThreadLabelSP) {
        V2CThreadPanel.setAutoCreateThreadLabel(v2CThreadLabelSP.getACTL());
        V2CThreadLabel[] v2CThreadLabelArray = v2CThreadLabelSP.getResult();
        if (v2CThreadLabelArray == null) {
            return;
        }
        V2CThreadLabelMenu.setLabelChanged();
        vlThreadLabel = v2CThreadLabelArray;
        V2CThreadLabel.saveLabels(v2CThreadLabelArray);
        V2CMain.getDisplayPane().updateAllTabColors();
        V2CMain.v2cMain.repaint();
    }

    static V2CThreadLabel getLabel(int n) {
        return n >= 0 && n < 10 ? V2CThreadLabel.getLabels()[n] : null;
    }

    static V2CThreadLabel[] getLabels() {
        int n;
        V2CThreadLabel[] v2CThreadLabelArray = vlThreadLabel;
        if (v2CThreadLabelArray != null) {
            return v2CThreadLabelArray;
        }
        v2CThreadLabelArray = new V2CThreadLabel[10];
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(sLabelsKey);
        if (v2CPackedPropValueArray != null) {
            n = Math.min(v2CPackedPropValueArray.length, 10);
            for (int i = 0; i < n; ++i) {
                v2CThreadLabelArray[i] = new V2CThreadLabel(i, v2CPackedPropValueArray[i]);
            }
        } else {
            n = 0;
        }
        if (n < 10) {
            String[] stringArray = new String[10];
            stringArray[0] = "\u30c7\u30d5\u30a9\u30eb\u30c8";
            for (int i = Math.max(n, 0); i < 10; ++i) {
                stringArray[i] = "\u540d\u79f0\u672a\u8a2d\u5b9a " + i;
            }
            int[] nArray = new int[]{0xEFEF8F, 15716271, 15708111, 0xEF8FEF, 13610991, 11522031, 0x8FEFEF, 11530191, 13627311, 0xBFBFBF};
            for (int i = n; i < 10; ++i) {
                v2CThreadLabelArray[i] = new V2CThreadLabel(i, new Color(nArray[i]), stringArray[i]);
            }
        }
        vlThreadLabel = v2CThreadLabelArray;
        return v2CThreadLabelArray;
    }

    private static void saveLabels(V2CThreadLabel[] v2CThreadLabelArray) {
        if (v2CThreadLabelArray == null) {
            return;
        }
        int n = v2CThreadLabelArray.length;
        V2CPackedPropValue[] v2CPackedPropValueArray = new V2CPackedPropValue[n];
        for (int i = 0; i < n; ++i) {
            v2CPackedPropValueArray[i] = v2CThreadLabelArray[i].getSaveValue();
        }
        V2CApp.getUserProperty().putPackedValueArray(sLabelsKey, v2CPackedPropValueArray);
    }

    private V2CThreadLabel(int n, V2CPackedPropValue v2CPackedPropValue) {
        this.iIndex = n;
        this.cColor = v2CPackedPropValue.getColor('B');
        String string = v2CPackedPropValue.getString('L');
        this.sLabel = string != null ? string : "\u540d\u79f0\u672a\u8a2d\u5b9a";
        this.bProtected = v2CPackedPropValue.getBoolean('P');
    }

    private V2CThreadLabel(int n, Color color, String string) {
        this.iIndex = n;
        this.cColor = color;
        this.sLabel = string;
    }

    private V2CThreadLabel(V2CThreadLabel v2CThreadLabel) {
        this(v2CThreadLabel.iIndex, v2CThreadLabel.cColor, v2CThreadLabel.sLabel);
        this.bProtected = v2CThreadLabel.bProtected;
    }

    boolean setValues(String string, Color color, boolean bl) {
        string = V2CMiscUtil.replaceTab2SP(string);
        String string2 = this.sLabel;
        Color color2 = this.cColor;
        boolean bl2 = this.bProtected;
        this.cColor = color;
        this.sLabel = string;
        this.bProtected = bl;
        return bl != bl2 || !string.equals(string2) || !(color == null ? color2 == null : color.equals(color2));
    }

    private V2CPackedPropValue getSaveValue() {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setString('L', this.sLabel);
        if (this.cColor != null) {
            v2CPackedPropValue.setColor('B', this.cColor);
        }
        v2CPackedPropValue.setBoolean('P', this.bProtected);
        return v2CPackedPropValue;
    }

    int getIndex() {
        return this.iIndex;
    }

    int getInvIndex() {
        return 10 - this.iIndex;
    }

    Color getColor() {
        return this.cColor;
    }

    String getLabel() {
        return this.sLabel;
    }

    boolean isProtected() {
        return this.bProtected;
    }
}

