/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CGraphSavePanel
extends JPanel {
    private static final String sGraphSaveCondKey = "ThreadGraph.SaveCond";
    JCheckBox jcbCustomSize;
    JFormattedTextField jftfWidth;
    JFormattedTextField jftfHeight;

    public V2CGraphSavePanel() {
        super(new GridBagLayout());
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        this.jcbCustomSize = new JCheckBox("\u30b5\u30a4\u30ba\u3092\u6307\u5b9a\u3059\u308b");
        this.jcbCustomSize.setFocusable(false);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jcbCustomSize, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.jftfWidth = this.createField("   \u5e45\uff1a", numberFormat, gridBagConstraints);
        this.jftfHeight = this.createField("   \u9ad8\u3055\uff1a", numberFormat, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)new JLabel("\uff08\u5e45\u2267200\u3001\u9ad8\u3055\u2267150\uff09"), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.restoreInitialValues();
    }

    private JFormattedTextField createField(String string, NumberFormat numberFormat, GridBagConstraints gridBagConstraints) {
        this.add((Component)new JLabel(string), gridBagConstraints);
        ++gridBagConstraints.gridx;
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormat);
        jFormattedTextField.setHorizontalAlignment(4);
        jFormattedTextField.setColumns(5);
        this.add((Component)jFormattedTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        return jFormattedTextField;
    }

    void restoreInitialValues() {
        boolean bl = false;
        int n = 800;
        int n2 = 600;
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        String string = v2CProperty.get(sGraphSaveCondKey);
        if (string != null && string.length() > 0) {
            String[] stringArray = V2CMiscUtil.split(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() == 0) continue;
                char c = string2.charAt(0);
                if (c == 'T') {
                    bl = true;
                    continue;
                }
                if (c == 'W') {
                    if (string2.length() <= 1) continue;
                    try {
                        n = Integer.parseInt(string2.substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (c != 'H') break;
                if (string2.length() <= 1) continue;
                try {
                    n2 = Integer.parseInt(string2.substring(1));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.jcbCustomSize.setSelected(bl);
        this.jftfWidth.setValue(new Integer(n));
        this.jftfHeight.setValue(new Integer(n2));
    }

    boolean useCustomeSize() {
        return this.jcbCustomSize.isSelected();
    }

    int getGraphWidth() {
        int n = V2CSwingUtil.getInt(this.jftfWidth);
        return Math.min(Math.max(n, 200), 10000);
    }

    int getGraphHeight() {
        int n = V2CSwingUtil.getInt(this.jftfHeight);
        return Math.min(Math.max(n, 150), 10000);
    }

    void saveCondition() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.jcbCustomSize.isSelected()) {
            stringBuffer.append("T,");
        }
        stringBuffer.append('W');
        stringBuffer.append(this.getGraphWidth());
        stringBuffer.append(",H");
        stringBuffer.append(this.getGraphHeight());
        V2CMain.getUserProperty().put(sGraphSaveCondKey, stringBuffer.toString());
    }
}

