/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CImageCache {
    static HashSet hsImages = new HashSet();
    static float[] flBuf = new float[4];
    File fFile;
    String sAbsPath;
    BufferedImage biImage;
    RescaleOp ropRescale;
    boolean bMirror;
    boolean bError;
    ArrayList alClient = new ArrayList();

    static V2CImageCache getFromLocalFile(String string) {
        return V2CImageCache.getFromLocalFile(string, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static V2CImageCache getFromLocalFile(String string, RescaleOp rescaleOp, boolean bl, V2CThreadPanel v2CThreadPanel) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (string2 == null) {
            return null;
        }
        V2CImageCache v2CImageCache = null;
        HashSet hashSet = hsImages;
        synchronized (hashSet) {
            Iterator iterator = hsImages.iterator();
            while (iterator.hasNext()) {
                V2CImageCache v2CImageCache2 = (V2CImageCache)((Reference)iterator.next()).get();
                if (v2CImageCache2 == null) {
                    iterator.remove();
                    continue;
                }
                if (!v2CImageCache2.isEquivalent(string2, rescaleOp, bl)) continue;
                v2CImageCache = v2CImageCache2;
                break;
            }
            if (v2CImageCache != null) {
                return v2CImageCache;
            }
            v2CImageCache = new V2CImageCache(file, rescaleOp, bl, v2CThreadPanel);
            hsImages.add(new WeakReference<V2CImageCache>(v2CImageCache));
        }
        return v2CImageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V2CImageCache(File file, RescaleOp rescaleOp, boolean bl, V2CThreadPanel v2CThreadPanel) {
        if (!file.exists()) {
            this.bError = true;
            return;
        }
        this.fFile = file;
        this.bMirror = bl;
        this.sAbsPath = this.fFile.getAbsolutePath();
        this.ropRescale = rescaleOp;
        ArrayList arrayList = this.alClient;
        synchronized (arrayList) {
            this.alClient.add(v2CThreadPanel);
        }
        this.loadImageBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(V2CThreadPanel v2CThreadPanel) {
        ArrayList arrayList = this.alClient;
        synchronized (arrayList) {
            this.alClient.remove(v2CThreadPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadImage() {
        BufferedImage bufferedImage = null;
        try {
            if (this.fFile != null) {
                bufferedImage = ImageIO.read(this.fFile);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            this.bError = true;
            return;
        }
        if (bufferedImage == null) {
            this.bError = true;
            return;
        }
        if (bufferedImage.getColorModel().getTransparency() != 1) {
            bufferedImage = V2CSwingUtil.convertToCompatibeImage(bufferedImage);
        }
        this.biImage = this.doImageOp(bufferedImage);
        ArrayList arrayList = this.alClient;
        synchronized (arrayList) {
            for (int i = 0; i < this.alClient.size(); ++i) {
                Object e = this.alClient.get(i);
                if (!(e instanceof V2CThreadPanel)) continue;
                ((V2CThreadPanel)e).forceRepaint();
            }
        }
    }

    BufferedImage doImageOp(BufferedImage object) {
        Object object2;
        Object object3;
        Object object4;
        if (this.ropRescale != null) {
            if (((BufferedImage)object).getColorModel() instanceof IndexColorModel) {
                object4 = V2CMain.v2cMain.getGraphicsConfiguration();
                object3 = ((GraphicsConfiguration)object4).createCompatibleImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
                object2 = ((BufferedImage)object3).getGraphics();
                ((Graphics)object2).drawImage((Image)object, 0, 0, null);
                ((Graphics)object2).dispose();
                object = object3;
            }
            try {
                this.ropRescale.filter((BufferedImage)object, (BufferedImage)object);
            }
            catch (Exception exception) {
                V2CMain.setMessage("\u80cc\u666f\u753b\u50cf\u306e\u8272\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        if (this.bMirror) {
            object4 = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f);
            object3 = new AffineTransformOp((AffineTransform)object4, 1);
            object2 = null;
            try {
                object = object2 = ((AffineTransformOp)object3).filter((BufferedImage)object, null);
            }
            catch (Exception exception) {
                try {
                    GraphicsConfiguration graphicsConfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
                    object2 = graphicsConfiguration.createCompatibleImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
                    ((AffineTransformOp)object3).filter((BufferedImage)object, (BufferedImage)object2);
                    object = object2;
                }
                catch (Exception exception2) {
                    V2CMain.setMessage("\u80cc\u666f\u753b\u50cf\u306e\u5de6\u53f3\u53cd\u8ee2\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }
        }
        return object;
    }

    void loadImageBackground() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                V2CImageCache.this.loadImage();
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEquivalent(String string, RescaleOp rescaleOp, boolean bl) {
        if (!string.equals(this.sAbsPath)) {
            return false;
        }
        if (bl != this.bMirror) {
            return false;
        }
        if (rescaleOp == null) {
            return this.ropRescale == null;
        }
        if (this.ropRescale == null) {
            return false;
        }
        float[] fArray = flBuf;
        synchronized (flBuf) {
            float f = rescaleOp.getScaleFactors(flBuf)[0];
            if (f != this.ropRescale.getScaleFactors(flBuf)[0]) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            float f2 = rescaleOp.getOffsets(flBuf)[0];
            if (f2 != this.ropRescale.getOffsets(flBuf)[0]) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return true;
        }
    }

    BufferedImage getImage() {
        return this.biImage;
    }
}

