/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CCheckBoxRenderer;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CImageViewer;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CImageIcon
implements Icon {
    private static int nIconWidth;
    private static int nIconHeight;
    private static int nImageWidth;
    private static int nImageHeight;
    private final V2CLink vLink;
    private final int iSerialNumber;
    private V2CImageSet vImageSet;
    private Object oThumbnaiKey;
    private int nWidth;
    private int nHeight;
    private float fScale;
    private int iDX;
    private int iDY;
    private boolean bImageChecked;
    private int iLoadingPercentage;
    private boolean bTabChecked;
    boolean bSelected;

    static void updateIconSizes() {
        nIconWidth = V2CLink.nViewerIconWidth;
        nIconHeight = V2CLink.nViewerIconHeight;
        nImageWidth = nIconWidth - 2;
        nImageHeight = nIconHeight - 2;
    }

    static int getTabHeight() {
        return nIconHeight + 8;
    }

    static V2CImageIcon createIcon(V2CLink v2CLink, int n) {
        return v2CLink != null ? new V2CImageIcon(v2CLink, n) : null;
    }

    private V2CImageIcon(V2CLink v2CLink, int n) {
        this.vLink = v2CLink;
        this.iSerialNumber = n;
        this.updateThumbnail(false);
    }

    V2CLink getLink() {
        return this.vLink;
    }

    int getSerialNumber() {
        return this.iSerialNumber;
    }

    boolean isChecked() {
        return this.bTabChecked;
    }

    void setChecked(boolean bl) {
        this.bTabChecked = bl;
    }

    void updateThumbnail(boolean bl) {
        int n;
        int n2;
        V2CLink v2CLink = this.vLink;
        V2CImageSet v2CImageSet = v2CLink.getOrCreateThumbnail(bl);
        if (v2CImageSet == this.vImageSet) {
            return;
        }
        this.vImageSet = v2CImageSet;
        this.oThumbnaiKey = v2CLink.getThumbnailKey();
        if (v2CImageSet != null) {
            n2 = v2CImageSet.getWidth();
            n = v2CImageSet.getHeight();
        } else {
            n = 0;
            n2 = 0;
        }
        float f = 0.0f;
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0 && n > 0) {
            f = Math.min(Math.min((float)nImageWidth / (float)n2, (float)nImageHeight / (float)n), 1.0f);
            if ((int)(f * (float)n2) < nImageWidth) {
                n3 = (int)(((float)nImageWidth - f * (float)n2) / 2.0f);
            }
            if ((int)(f * (float)n) < nImageHeight) {
                n4 = (int)(((float)nImageHeight - f * (float)n) / 2.0f);
            }
        }
        this.fScale = f;
        this.iDX = n3 + 1;
        this.iDY = n4 + 1;
    }

    void setSelected(boolean bl) {
        this.bSelected = bl;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Object object;
        Object object2;
        V2CLink v2CLink = this.vLink;
        V2CImageSet v2CImageSet = this.vImageSet;
        if (!this.bImageChecked) {
            this.bImageChecked = true;
            if (v2CImageSet == null && v2CLink.hasImageCache()) {
                this.updateThumbnail(true);
                v2CImageSet = this.vImageSet;
            }
        }
        if (v2CImageSet != null) {
            v2CImageSet.draw((Graphics2D)graphics, n + this.iDX, n2 + this.iDY, this.fScale);
            graphics.setColor(V2CThreadStyle.getDefaultColor(v2CLink.isNewImage() ? 11 : 10));
            graphics.drawRect(n, n2, nIconWidth - 1, nIconHeight - 1);
            if (this.bSelected) {
                graphics.drawRect(n + 1, n2 + 1, nIconWidth - 3, nIconHeight - 3);
            }
            if ((object2 = V2CAbstractThreadPanel.getThumbnailStatusIcon(v2CImageSet.getImageCount() > 1, v2CLink.isProtected())) != null) {
                graphics.drawImage((Image)object2, n + nIconWidth - ((BufferedImage)object2).getWidth(), n2 + nIconHeight - ((BufferedImage)object2).getHeight(), null);
            }
        } else {
            if (v2CLink.isChecking()) {
                if (this.iLoadingPercentage > 0) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(this.iLoadingPercentage);
                    ((StringBuffer)object).append('%');
                    object2 = ((StringBuffer)object).toString();
                } else {
                    object2 = ">>>";
                }
            } else {
                graphics.setColor(v2CLink.getStateBG(false));
                graphics.fillRect(n, n2, nIconWidth, nIconHeight);
                object2 = v2CLink.getShortState();
            }
            graphics.setColor(Color.BLACK);
            object = graphics.getFont();
            graphics.drawString((String)object2, n + 2, n2 + (object != null ? ((Font)object).getSize() : nIconHeight / 2));
        }
        if (component instanceof V2CImageViewer && ((V2CImageViewer)(object2 = (V2CImageViewer)component)).getDrawCheckBox()) {
            object = ((V2CImageViewer)object2).getCheckBoxRenderer();
            ((V2CCheckBoxRenderer)object).paintComponent((Graphics2D)graphics, this.bTabChecked, (Container)object2, n, n2 + nIconHeight);
        }
    }

    public int getIconWidth() {
        return nIconWidth;
    }

    public int getIconHeight() {
        return nIconHeight;
    }

    boolean downloadStateChanged(V2CLink v2CLink) {
        if (v2CLink != this.vLink) {
            return false;
        }
        int n = v2CLink.getLoadingPercentage();
        if (n == this.iLoadingPercentage) {
            return false;
        }
        this.iLoadingPercentage = n;
        return true;
    }

    boolean thumbnailImageUpdated(V2CLink v2CLink) {
        if (v2CLink != this.vLink) {
            return false;
        }
        this.updateThumbnail(true);
        return true;
    }

    String getStateString() {
        V2CLink v2CLink = this.vLink;
        if (v2CLink.isChecking() && this.iLoadingPercentage > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.iLoadingPercentage);
            stringBuffer.append('%');
            return stringBuffer.toString();
        }
        return v2CLink.getShortState();
    }

    V2CImageSet getImageSet() {
        return this.vImageSet;
    }
}

