/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.monazilla.v2c.V2CKeyword;
import org.monazilla.v2c.V2CKeywordUtil;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;

public abstract class V2CKeywordItem {
    V2CKeyword vParent;
    String sRawWord;
    String sWord;
    Pattern pWord;
    boolean bActive;
    boolean bRegEx;
    boolean bCaseSens;
    int iWeight;
    int iTime;
    int iAppliedTime;
    int iExpiration;
    String sExpiration;
    boolean bATChanged;
    Pattern pIncludedURL;
    Pattern pExcludedURL;
    Pattern pIncludedTitle;
    Pattern pExcludedTitle;

    public V2CKeywordItem(V2CKeyword v2CKeyword, String string, boolean bl, boolean bl2) {
        this.vParent = v2CKeyword;
        this.sRawWord = string;
        this.bRegEx = bl;
        this.bCaseSens = bl2;
        this.bActive = true;
        this.iTime = this.iAppliedTime = V2CMiscUtil.currentTimeMins();
        this.compileWord();
    }

    public V2CKeywordItem(V2CKeyword v2CKeyword, V2CPackedPropValue v2CPackedPropValue) {
        this.vParent = v2CKeyword;
        if (v2CPackedPropValue == null) {
            return;
        }
        this.bActive = v2CPackedPropValue.getBoolean('A');
        this.bCaseSens = v2CPackedPropValue.getBoolean('C');
        this.bRegEx = v2CPackedPropValue.getBoolean('R');
        this.sRawWord = v2CPackedPropValue.getString('W');
        this.iWeight = v2CPackedPropValue.getIntInRange('w', -9, 9);
        int n = v2CPackedPropValue.getInt('T');
        if (n <= 0) {
            n = V2CMiscUtil.currentTimeMins();
        }
        this.iTime = n;
        int n2 = v2CPackedPropValue.getInt('A');
        int n3 = this.iAppliedTime = n2 > 0 ? n + n2 : n;
        if (v2CPackedPropValue.getBoolean('V')) {
            this.iExpiration = -1;
        } else {
            int n4 = v2CPackedPropValue.getInt('V');
            if (n4 > 0) {
                this.iExpiration = n4 * 1440;
            } else if (n4 < 0) {
                this.iExpiration = -n4;
            }
        }
        this.compileWord();
        this.pIncludedURL = V2CKeywordItem.compilePattern(v2CPackedPropValue.getString('{'));
        this.pExcludedURL = V2CKeywordItem.compilePattern(v2CPackedPropValue.getString('}'));
        this.pIncludedTitle = V2CKeywordItem.compilePattern(v2CPackedPropValue.getString('['));
        this.pExcludedTitle = V2CKeywordItem.compilePattern(v2CPackedPropValue.getString(']'));
    }

    private static Pattern compilePattern(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return Pattern.compile(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    V2CPackedPropValue getSaveValue() {
        if (this.sRawWord == null || this.sRawWord.length() == 0) {
            return null;
        }
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue('W');
        v2CPackedPropValue.setBoolean('A', this.bActive);
        v2CPackedPropValue.setBoolean('C', this.bCaseSens);
        v2CPackedPropValue.setBoolean('R', this.bRegEx);
        v2CPackedPropValue.setString('W', this.sRawWord);
        if (this.iWeight != 0) {
            v2CPackedPropValue.setInt('w', this.iWeight);
        }
        if (this.iTime > 0) {
            int n;
            v2CPackedPropValue.setInt('T', this.iTime);
            if (this.iAppliedTime > this.iTime) {
                v2CPackedPropValue.setInt('A', this.iAppliedTime - this.iTime);
            }
            if ((n = this.iExpiration) > 0) {
                int n2 = n % 1440;
                v2CPackedPropValue.setInt('V', n2 > 0 ? -n : n / 1440);
            } else if (n < 0) {
                v2CPackedPropValue.setBoolean('V', true);
            }
        }
        V2CKeywordItem.setCondString(v2CPackedPropValue, '{', this.pIncludedURL);
        V2CKeywordItem.setCondString(v2CPackedPropValue, '}', this.pExcludedURL);
        V2CKeywordItem.setCondString(v2CPackedPropValue, '[', this.pIncludedTitle);
        V2CKeywordItem.setCondString(v2CPackedPropValue, ']', this.pExcludedTitle);
        return v2CPackedPropValue;
    }

    private static void setCondString(V2CPackedPropValue v2CPackedPropValue, char c, Pattern pattern) {
        if (pattern != null) {
            v2CPackedPropValue.setString(c, pattern.pattern());
        }
    }

    private void compileWord() {
        if (this.sRawWord == null) {
            this.sRawWord = "";
        }
        if (this.bRegEx) {
            this.pWord = this.sRawWord.length() > 0 ? Pattern.compile(this.sRawWord, this.bCaseSens ? 0 : 2) : null;
        } else {
            this.sWord = this.sRawWord.length() > 0 ? (this.bCaseSens ? this.sRawWord : V2CMiscUtil.normalizeCase(this.sRawWord)) : null;
        }
    }

    boolean isValid() {
        return this.pWord != null || this.sWord != null;
    }

    void setActive(boolean bl) {
        if (this.bActive == bl) {
            return;
        }
        this.bActive = bl;
        if (this.vParent != null) {
            this.vParent.requestSave();
        }
    }

    void setRegEx(boolean bl) {
        if (this.bRegEx == bl) {
            return;
        }
        boolean bl2 = this.bRegEx;
        String string = this.sWord;
        Pattern pattern = this.pWord;
        this.bRegEx = bl;
        try {
            this.compileWord();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.bRegEx = bl2;
            this.sWord = string;
            this.pWord = pattern;
            throw patternSyntaxException;
        }
        if (this.vParent != null) {
            this.vParent.requestSave();
        }
    }

    void setCaseSensitive(boolean bl) {
        if (this.bCaseSens == bl) {
            return;
        }
        boolean bl2 = this.bCaseSens;
        String string = this.sWord;
        Pattern pattern = this.pWord;
        this.bCaseSens = bl;
        try {
            this.compileWord();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.bCaseSens = bl2;
            this.sWord = string;
            this.pWord = pattern;
            throw patternSyntaxException;
        }
        if (this.vParent != null) {
            this.vParent.requestSave();
        }
    }

    void setRawWord(String string) {
        if (string == null) {
            string = "";
        }
        if (this.sRawWord.equals(string)) {
            return;
        }
        String string2 = this.sRawWord;
        String string3 = this.sWord;
        Pattern pattern = this.pWord;
        this.sRawWord = string;
        try {
            this.compileWord();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.sRawWord = string2;
            this.sWord = string3;
            this.pWord = pattern;
            throw patternSyntaxException;
        }
        if (this.vParent != null) {
            this.vParent.requestSave();
        }
    }

    String getRawWord() {
        return this.sRawWord;
    }

    String getWord() {
        return this.sWord;
    }

    Pattern getPattern() {
        return this.pWord;
    }

    boolean isRegEx() {
        return this.bRegEx;
    }

    boolean isCaseSensitive() {
        return this.bCaseSens;
    }

    boolean isActive() {
        return this.bActive;
    }

    long getTime() {
        return (long)this.iTime * 60000L;
    }

    long getAppliedTime() {
        return (long)this.iAppliedTime * 60000L;
    }

    void setWeight(String string) {
        int n = V2CKeywordUtil.toWeight(string);
        if (this.iWeight == n) {
            return;
        }
        this.iWeight = n;
        if (this.vParent != null) {
            this.vParent.requestSave();
        }
    }

    public int getWeight() {
        return this.iWeight;
    }

    String getWeightString() {
        return V2CKeywordUtil.getWeightString(this.iWeight);
    }

    long getExpirationTime(int n) {
        return (long)this.getExpirationMin(n) * 60000L;
    }

    private int getExpirationMin(int n) {
        int n2 = this.iExpiration;
        if (n2 == 0) {
            n2 = n;
        }
        if (n2 <= 0) {
            return 0;
        }
        return (n2 <= 1440 ? this.iTime : this.iAppliedTime) + n2;
    }

    boolean isExpired(int n, int n2) {
        int n3 = this.getExpirationMin(n2);
        return n3 > 0 ? n > n3 : false;
    }

    boolean checkExpiration(int n, int n2) {
        if (!this.bActive || !this.isExpired(n, n2)) {
            return false;
        }
        this.bActive = false;
        return true;
    }

    void setExpiration(int n) {
        this.iExpiration = n;
    }

    void setExpiration(String string) {
        if (string == null) {
            return;
        }
        int n = V2CKeywordUtil.parseExpiration(string);
        if (n < -1) {
            return;
        }
        this.sExpiration = null;
        this.iExpiration = n;
        if (this.vParent != null) {
            this.vParent.requestSave();
        }
    }

    String getExpirationString() {
        String string = this.sExpiration;
        if (string == null) {
            this.sExpiration = string = V2CKeywordUtil.formatExpiration(this.iExpiration);
        }
        return string;
    }

    void setApplied() {
        this.bATChanged = true;
    }

    boolean checkAppliedTimeChange(int n) {
        if (this.bATChanged) {
            this.bATChanged = false;
            if (n > this.iAppliedTime) {
                this.iAppliedTime = n;
                return true;
            }
        }
        return false;
    }

    boolean setApplicationCond(String string, String string2, String string3, String string4) {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        boolean bl = false;
        Pattern pattern4 = this.pIncludedURL;
        if (!V2CMiscUtil.isEqual(string, pattern4 != null ? pattern4.pattern() : "")) {
            if (string.length() > 0) {
                pattern4 = V2CKeywordItem.compilePattern(string);
                if (pattern4 != null) {
                    this.pIncludedURL = pattern4;
                    bl = true;
                } else {
                    V2CMain.setErrorMessage("\u9069\u7528URL\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                }
            } else {
                this.pIncludedURL = null;
                bl = true;
            }
        }
        if (!V2CMiscUtil.isEqual(string2, (pattern3 = this.pExcludedURL) != null ? pattern3.pattern() : "")) {
            if (string2.length() > 0) {
                pattern3 = V2CKeywordItem.compilePattern(string2);
                if (pattern3 != null) {
                    this.pExcludedURL = pattern3;
                    bl = true;
                } else {
                    V2CMain.setErrorMessage("\u9664\u5916URL\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                }
            } else {
                this.pExcludedURL = null;
                bl = true;
            }
        }
        if (!V2CMiscUtil.isEqual(string3, (pattern2 = this.pIncludedTitle) != null ? pattern2.pattern() : "")) {
            if (string3.length() > 0) {
                pattern2 = V2CKeywordItem.compilePattern(string3);
                if (pattern2 != null) {
                    this.pIncludedTitle = pattern2;
                    bl = true;
                } else {
                    V2CMain.setErrorMessage("\u9069\u7528\u30b9\u30ec\u30bf\u30a4\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                }
            } else {
                this.pIncludedTitle = null;
                bl = true;
            }
        }
        if (!V2CMiscUtil.isEqual(string4, (pattern = this.pExcludedTitle) != null ? pattern.pattern() : "")) {
            if (string4.length() > 0) {
                pattern = V2CKeywordItem.compilePattern(string4);
                if (pattern != null) {
                    this.pExcludedTitle = pattern;
                    bl = true;
                } else {
                    V2CMain.setErrorMessage("\u9664\u5916\u30b9\u30ec\u30bf\u30a4\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                }
            } else {
                this.pExcludedTitle = null;
                bl = true;
            }
        }
        if (bl && this.vParent != null) {
            this.vParent.requestSave();
        }
        return bl;
    }

    boolean hasMiscCond() {
        return this.pIncludedURL != null || this.pExcludedURL != null || this.pIncludedTitle != null || this.pExcludedTitle != null;
    }

    boolean checkApply(String string, String string2) {
        Pattern pattern;
        Pattern pattern2;
        if (string != null) {
            pattern2 = this.pIncludedURL;
            if (pattern2 != null && !pattern2.matcher(string).find()) {
                return false;
            }
            pattern = this.pExcludedURL;
            if (pattern != null && pattern.matcher(string).find()) {
                return false;
            }
        }
        if (string2 != null) {
            pattern2 = this.pIncludedTitle;
            if (pattern2 != null && !pattern2.matcher(string2).find()) {
                return false;
            }
            pattern = this.pExcludedTitle;
            if (pattern != null && pattern.matcher(string2).find()) {
                return false;
            }
        }
        return true;
    }

    boolean find(CharSequence charSequence) {
        if (!this.bActive) {
            return false;
        }
        if (this.bRegEx) {
            if (this.pWord == null) {
                return false;
            }
            return this.pWord.matcher(charSequence).find();
        }
        if (this.sWord == null || this.sWord.length() == 0) {
            return false;
        }
        String string = ((Object)charSequence).toString();
        if (!this.bCaseSens) {
            string = V2CMiscUtil.normalizeCase(string);
        }
        return string.indexOf(this.sWord) >= 0;
    }
}

