/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;

public class V2CNumTextField
extends JTextField {
    String sFormat;
    Dimension dPreferredSize;

    public V2CNumTextField(String string) {
        this.sFormat = string;
        this.setHorizontalAlignment(4);
        this.setFocusable(false);
    }

    void setFormat(String string) {
        this.sFormat = string;
        this.dPreferredSize = null;
    }

    public Dimension getPreferredSize() {
        if (this.dPreferredSize == null) {
            this.dPreferredSize = this.calcPreferredSize();
        }
        return this.dPreferredSize;
    }

    public Dimension getMinimumSize() {
        if (this.dPreferredSize == null) {
            this.dPreferredSize = this.calcPreferredSize();
        }
        return this.dPreferredSize;
    }

    void setFormatString(String string) {
        this.sFormat = string;
        this.dPreferredSize = this.calcPreferredSize();
        this.invalidate();
        this.revalidate();
    }

    private Dimension calcPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return dimension2;
        }
        Font font = graphics2D.getFont();
        if (font == null) {
            return dimension2;
        }
        Insets insets = this.getInsets();
        Rectangle2D rectangle2D = font.getStringBounds(this.sFormat, graphics2D.getFontRenderContext());
        dimension2.width = (int)rectangle2D.getWidth() + insets.left + insets.right + 1;
        dimension2.height = (int)rectangle2D.getHeight() + insets.top + insets.bottom;
        return dimension2;
    }

    public void updateUI() {
        this.dPreferredSize = null;
        super.updateUI();
    }
}

